/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.core;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationProcessingOptions {
    private static final Log log = LoggerFactory.make();
    private final Map<Class<?>, Boolean> ignoreAnnotationDefaults = CollectionHelper.newHashMap();
    private final Map<Class<?>, List<Member>> propertyConstraintAnnotationIgnores = CollectionHelper.newHashMap();
    private final Map<Class<?>, Boolean> classConstraintAnnotationIgnores = CollectionHelper.newHashMap();

    public void ignoreAnnotationConstraintForClass(Class<?> clazz, Boolean b) {
        if (b == null) {
            this.ignoreAnnotationDefaults.put(clazz, Boolean.TRUE);
        } else {
            this.ignoreAnnotationDefaults.put(clazz, b);
        }
    }

    public boolean areConstraintAnnotationsIgnored(Class<?> clazz) {
        return this.ignoreAnnotationDefaults.containsKey(clazz) && this.ignoreAnnotationDefaults.get(clazz) != false;
    }

    public void ignorePropertyLevelConstraintAnnotationsOnMember(Member member) {
        Class<?> beanClass = member.getDeclaringClass();
        if (this.propertyConstraintAnnotationIgnores.get(beanClass) == null) {
            ArrayList<Member> tmpList = new ArrayList<Member>();
            tmpList.add(member);
            this.propertyConstraintAnnotationIgnores.put(beanClass, tmpList);
        } else {
            this.propertyConstraintAnnotationIgnores.get(beanClass).add(member);
        }
    }

    public boolean arePropertyLevelConstraintAnnotationsIgnored(Member member) {
        Class<?> clazz = member.getDeclaringClass();
        List<Member> ignoreAnnotationForMembers = this.propertyConstraintAnnotationIgnores.get(clazz);
        boolean ignoreAnnotation = ignoreAnnotationForMembers == null || !ignoreAnnotationForMembers.contains(member) ? this.areConstraintAnnotationsIgnored(clazz) : ignoreAnnotationForMembers.contains(member);
        if (ignoreAnnotation) {
            this.logMessage(member, clazz);
        }
        return ignoreAnnotation;
    }

    public void ignoreClassLevelConstraintAnnotations(Class<?> clazz, boolean b) {
        this.classConstraintAnnotationIgnores.put(clazz, b);
    }

    public boolean areClassLevelConstraintAnnotationsIgnored(Class<?> clazz) {
        boolean ignoreAnnotation = this.classConstraintAnnotationIgnores.containsKey(clazz) ? this.classConstraintAnnotationIgnores.get(clazz).booleanValue() : this.areConstraintAnnotationsIgnored(clazz);
        if (log.isDebugEnabled() && ignoreAnnotation) {
            log.debugf("Class level annotation are getting ignored for %s.", clazz.getName());
        }
        return ignoreAnnotation;
    }

    public void merge(AnnotationProcessingOptions annotationProcessingOptions) {
        this.ignoreAnnotationDefaults.putAll(annotationProcessingOptions.ignoreAnnotationDefaults);
        this.propertyConstraintAnnotationIgnores.putAll(annotationProcessingOptions.propertyConstraintAnnotationIgnores);
        this.classConstraintAnnotationIgnores.putAll(annotationProcessingOptions.classConstraintAnnotationIgnores);
    }

    private void logMessage(Member member, Class<?> clazz) {
        if (log.isDebugEnabled()) {
            String type = member instanceof Field ? "Field" : "Property";
            log.debugf("%s level annotations are getting ignored for %s.%s.", type, clazz.getName(), member.getName());
        }
    }
}

