/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.resourceloading;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.hibernate.validator.resourceloading.ResourceBundleLocator;
import org.jboss.logging.Logger;

public class PlatformResourceBundleLocator
implements ResourceBundleLocator,
org.hibernate.validator.spi.resourceloading.ResourceBundleLocator {
    private static final Logger log = Logger.getLogger((String)PlatformResourceBundleLocator.class.getName());
    private String bundleName;

    public PlatformResourceBundleLocator(String bundleName) {
        this.bundleName = bundleName;
    }

    @Override
    public ResourceBundle getResourceBundle(Locale locale) {
        ResourceBundle rb = null;
        ClassLoader classLoader = GetClassLoader.fromContext();
        if (classLoader != null) {
            rb = this.loadBundle(classLoader, locale, this.bundleName + " not found by thread local classloader");
        }
        if (rb == null) {
            classLoader = GetClassLoader.fromClass(PlatformResourceBundleLocator.class);
            rb = this.loadBundle(classLoader, locale, this.bundleName + " not found by validator classloader");
        }
        if (rb != null) {
            log.debugf("%s found.", (Object)this.bundleName);
        } else {
            log.debugf("%s not found.", (Object)this.bundleName);
        }
        return rb;
    }

    private ResourceBundle loadBundle(ClassLoader classLoader, Locale locale, String message) {
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle(this.bundleName, locale, classLoader);
        }
        catch (MissingResourceException e) {
            log.trace((Object)message);
        }
        return rb;
    }

    private static class GetClassLoader
    implements PrivilegedAction<ClassLoader> {
        private final Class<?> clazz;

        public static ClassLoader fromContext() {
            GetClassLoader action = new GetClassLoader(null);
            if (System.getSecurityManager() != null) {
                return AccessController.doPrivileged(action);
            }
            return action.run();
        }

        public static ClassLoader fromClass(Class<?> clazz) {
            if (clazz == null) {
                throw new IllegalArgumentException("Class is null");
            }
            GetClassLoader action = new GetClassLoader(clazz);
            if (System.getSecurityManager() != null) {
                return AccessController.doPrivileged(action);
            }
            return action.run();
        }

        private GetClassLoader(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public ClassLoader run() {
            if (this.clazz != null) {
                return this.clazz.getClassLoader();
            }
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

