/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import java.util.ArrayList;
import java.util.Iterator;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.ElementDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.validator.internal.engine.ConstraintViolationImpl;
import org.hibernate.validator.internal.engine.MessageInterpolatorContext;
import org.hibernate.validator.internal.engine.ValidationContext;
import org.hibernate.validator.internal.engine.ValueContext;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorManager;
import org.hibernate.validator.internal.engine.path.BeanMetaDataLocator;
import org.hibernate.validator.internal.engine.path.MessageAndPath;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.hibernate.validator.internal.metadata.BeanMetaDataManager;
import org.hibernate.validator.internal.metadata.aggregated.BeanMetaData;

public class StandardValidationContext<T>
extends ValidationContext<T, ConstraintViolation<T>> {
    protected StandardValidationContext(BeanMetaDataManager beanMetaDataManager, ConstraintValidatorManager constraintValidatorManager, Class<T> rootBeanClass, T rootBean, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver, boolean failFast) {
        super(beanMetaDataManager, constraintValidatorManager, rootBeanClass, rootBean, messageInterpolator, constraintValidatorFactory, traversableResolver, failFast);
    }

    @Override
    public <U, V> ConstraintViolation<T> createConstraintViolation(ValueContext<U, V> localContext, MessageAndPath messageAndPath, ConstraintDescriptor<?> descriptor) {
        String messageTemplate = messageAndPath.getMessage();
        String interpolatedMessage = this.messageInterpolator.interpolate(messageTemplate, (MessageInterpolator.Context)new MessageInterpolatorContext(descriptor, localContext.getCurrentValidatedValue()));
        Path path = this.createPathWithElementDescriptors(messageAndPath.getPath());
        return new ConstraintViolationImpl(messageTemplate, interpolatedMessage, this.getRootBeanClass(), this.getRootBean(), localContext.getCurrentBean(), localContext.getCurrentValidatedValue(), path, descriptor, localContext.getElementType());
    }

    private Path createPathWithElementDescriptors(Path path) {
        BeanMetaDataLocator traverser = BeanMetaDataLocator.createBeanMetaDataLocatorForBeanValidation(this.getRootBean(), this.getRootBeanClass(), this.getBeanMetaDataManager());
        Iterator<BeanMetaData<?>> beanMetaDataIterator = traverser.beanMetaDataIterator(path.iterator());
        ArrayList<ElementDescriptor> elementDescriptors = new ArrayList<ElementDescriptor>();
        for (Path.Node node : path) {
            BeanMetaData<?> beanMetaData = beanMetaDataIterator.next();
            if (this.isClassLevelConstraintNode(node.getName())) {
                BeanDescriptor beanDescriptor = beanMetaData.getBeanDescriptor();
                elementDescriptors.add((ElementDescriptor)beanDescriptor);
                continue;
            }
            PropertyDescriptor propertyDescriptor = beanMetaData.getBeanDescriptor().getConstraintsForProperty(node.getName());
            elementDescriptors.add((ElementDescriptor)propertyDescriptor);
        }
        return PathImpl.createCopyWithElementDescriptorsAttached((PathImpl)path, elementDescriptors);
    }

    private boolean isClassLevelConstraintNode(String name) {
        return name == null;
    }
}

