/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import java.lang.annotation.ElementType;
import java.lang.reflect.Type;
import javax.validation.groups.Default;
import org.hibernate.validator.internal.engine.path.PathImpl;

public class ValueContext<T, V> {
    private final T currentBean;
    private final Class<T> currentBeanType;
    private Integer parameterIndex;
    private String parameterName;
    private PathImpl propertyPath;
    private Class<?> currentGroup;
    private V currentValue;
    private ElementType elementType;
    private Type typeOfAnnotatedElement;

    public static <T, V> ValueContext<T, V> getLocalExecutionContext(T value, PathImpl propertyPath) {
        Class<?> rootBeanClass = value.getClass();
        return new ValueContext<T, V>(value, rootBeanClass, propertyPath);
    }

    public static <T, V> ValueContext<T, V> getLocalExecutionContext(T value, PathImpl propertyPath, int parameterIndex, String parameterName) {
        Class<?> rootBeanClass = value.getClass();
        return new ValueContext<T, V>(value, rootBeanClass, propertyPath, parameterIndex, parameterName);
    }

    public static <T, V> ValueContext<T, V> getLocalExecutionContext(T value, Class<T> rootBeanClass, PathImpl propertyPath, int parameterIndex, String parameterName) {
        return new ValueContext<T, V>(value, rootBeanClass, propertyPath, parameterIndex, parameterName);
    }

    public static <T, V> ValueContext<T, V> getLocalExecutionContext(Class<T> type, PathImpl propertyPath) {
        return new ValueContext<Object, V>(null, type, propertyPath);
    }

    protected ValueContext(T currentBean, Class<T> currentBeanType, PathImpl propertyPath) {
        this.currentBean = currentBean;
        this.currentBeanType = currentBeanType;
        this.propertyPath = propertyPath;
    }

    private ValueContext(T currentBean, Class<T> currentBeanType, PathImpl propertyPath, int parameterIndex, String parameterName) {
        this.currentBean = currentBean;
        this.currentBeanType = currentBeanType;
        this.propertyPath = propertyPath;
        this.parameterIndex = parameterIndex;
        this.parameterName = parameterName;
    }

    public final PathImpl getPropertyPath() {
        return this.propertyPath;
    }

    public final Class<?> getCurrentGroup() {
        return this.currentGroup;
    }

    public final T getCurrentBean() {
        return this.currentBean;
    }

    public final Class<T> getCurrentBeanType() {
        return this.currentBeanType;
    }

    public Integer getParameterIndex() {
        return this.parameterIndex;
    }

    public void setParameterIndex(int parameterIndex) {
        this.parameterIndex = parameterIndex;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public final V getCurrentValidatedValue() {
        return this.currentValue;
    }

    public final void setPropertyPath(PathImpl propertyPath) {
        this.propertyPath = propertyPath;
    }

    public final void appendNode(String node) {
        this.propertyPath = PathImpl.createCopy(this.propertyPath);
        this.propertyPath.addNode(node);
    }

    public final void markCurrentPropertyAsIterable() {
        this.propertyPath.makeLeafNodeIterable();
    }

    public final void setKey(Object key) {
        this.propertyPath.setLeafNodeMapKey(key);
    }

    public final void setIndex(Integer index) {
        this.propertyPath.setLeafNodeIndex(index);
    }

    public final void setCurrentGroup(Class<?> currentGroup) {
        this.currentGroup = currentGroup;
    }

    public final void setCurrentValidatedValue(V currentValue) {
        this.currentValue = currentValue;
    }

    public final boolean validatingDefault() {
        return this.getCurrentGroup() != null && this.getCurrentGroup().getName().equals(Default.class.getName());
    }

    public final ElementType getElementType() {
        return this.elementType;
    }

    public final void setElementType(ElementType elementType) {
        this.elementType = elementType;
    }

    public final Type getTypeOfAnnotatedElement() {
        return this.typeOfAnnotatedElement;
    }

    public final void setTypeOfAnnotatedElement(Type typeOfAnnotatedElement) {
        this.typeOfAnnotatedElement = typeOfAnnotatedElement;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ValueContext");
        sb.append("{currentBean=").append(this.currentBean);
        sb.append(", currentBeanType=").append(this.currentBeanType);
        sb.append(", parameterIndex=").append(this.parameterIndex);
        sb.append(", parameterName='").append(this.parameterName).append('\'');
        sb.append(", propertyPath=").append(this.propertyPath);
        sb.append(", currentGroup=").append(this.currentGroup);
        sb.append(", currentValue=").append(this.currentValue);
        sb.append(", elementType=").append((Object)this.elementType);
        sb.append(", typeOfAnnotatedElement=").append(this.typeOfAnnotatedElement);
        sb.append('}');
        return sb.toString();
    }
}

