/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.TypeHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.logging.Messages;
import org.hibernate.validator.internal.util.privilegedactions.ConstructorInstance;
import org.hibernate.validator.internal.util.privilegedactions.GetAnnotationParameter;
import org.hibernate.validator.internal.util.privilegedactions.GetClassLoader;
import org.hibernate.validator.internal.util.privilegedactions.GetConstructor;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredConstructors;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredField;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredFields;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredMethod;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredMethods;
import org.hibernate.validator.internal.util.privilegedactions.GetMethod;
import org.hibernate.validator.internal.util.privilegedactions.GetMethodFromPropertyName;
import org.hibernate.validator.internal.util.privilegedactions.GetMethods;
import org.hibernate.validator.internal.util.privilegedactions.LoadClass;
import org.hibernate.validator.internal.util.privilegedactions.NewInstance;
import org.hibernate.validator.internal.util.privilegedactions.SetAccessibility;

public final class ReflectionHelper {
    private static final Log log = LoggerFactory.make();
    private static String[] PROPERTY_ACCESSOR_PREFIXES = new String[]{"is", "get", "has"};
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER_TYPES;

    private ReflectionHelper() {
    }

    public static ClassLoader getClassLoaderFromContext() {
        return ReflectionHelper.run(GetClassLoader.fromContext());
    }

    public static ClassLoader getClassLoaderFromClass(Class<?> clazz) {
        return ReflectionHelper.run(GetClassLoader.fromClass(clazz));
    }

    public static Class<?> loadClass(String className, Class<?> caller) {
        return (Class)ReflectionHelper.run(LoadClass.action(className, caller));
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... params) {
        return (Constructor)ReflectionHelper.run(GetConstructor.action(clazz, params));
    }

    public static <T> T newInstance(Class<T> clazz, String message) {
        return ReflectionHelper.run(NewInstance.action(clazz, message));
    }

    public static <T> T newConstructorInstance(Constructor<T> constructor, Object ... initArgs) {
        return ReflectionHelper.run(ConstructorInstance.action(constructor, initArgs));
    }

    public static <T> T getAnnotationParameter(Annotation annotation, String parameterName, Class<T> type) {
        return ReflectionHelper.run(GetAnnotationParameter.action(annotation, parameterName, type));
    }

    public static String getPropertyName(Member member) {
        String name = null;
        if (member instanceof Field) {
            name = member.getName();
        }
        if (member instanceof Method) {
            String methodName = member.getName();
            for (String prefix : PROPERTY_ACCESSOR_PREFIXES) {
                if (!methodName.startsWith(prefix)) continue;
                name = Introspector.decapitalize(methodName.substring(prefix.length()));
            }
        }
        return name;
    }

    public static boolean isGetterMethod(Method member) {
        return ReflectionHelper.getPropertyName(member) != null;
    }

    public static boolean propertyExists(Class<?> clazz, String property, ElementType elementType) {
        return ReflectionHelper.getMember(clazz, property, elementType) != null;
    }

    public static Member getMember(Class<?> clazz, String property, ElementType elementType) {
        Contracts.assertNotNull(clazz, Messages.MESSAGES.classCannotBeNull());
        if (property == null || property.length() == 0) {
            throw log.getPropertyNameCannotBeNullOrEmptyException();
        }
        if (!ElementType.FIELD.equals((Object)elementType) && !ElementType.METHOD.equals((Object)elementType)) {
            throw log.getElementTypeHasToBeFieldOrMethodException();
        }
        Member member = null;
        if (ElementType.FIELD.equals((Object)elementType)) {
            member = ReflectionHelper.run(GetDeclaredField.action(clazz, property));
        } else {
            String prefix;
            String methodName = property.substring(0, 1).toUpperCase() + property.substring(1);
            String[] arr$ = PROPERTY_ACCESSOR_PREFIXES;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (member = (Member)ReflectionHelper.run(GetMethod.action(clazz, (prefix = arr$[i$]) + methodName))) == null; ++i$) {
            }
        }
        return member;
    }

    public static Class<?> getType(Member member) {
        Class<?> type = null;
        if (member instanceof Field) {
            type = ((Field)member).getType();
        }
        if (member instanceof Method) {
            type = ((Method)member).getReturnType();
        }
        return type;
    }

    public static Type typeOf(Member member) {
        Type type;
        if (member instanceof Field) {
            type = ((Field)member).getGenericType();
        } else if (member instanceof Method) {
            type = ((Method)member).getGenericReturnType();
        } else if (member instanceof Constructor) {
            type = ((Constructor)member).getDeclaringClass();
        } else {
            throw log.getMemberIsNeitherAFieldNorAMethodException(member);
        }
        if (type instanceof TypeVariable) {
            type = TypeHelper.getErasedType(type);
        }
        return type;
    }

    public static Type typeOf(ExecutableElement executable, int parameterIndex) {
        Type type = executable.getGenericParameterTypes()[parameterIndex];
        if (type instanceof TypeVariable) {
            type = TypeHelper.getErasedType(type);
        }
        return type;
    }

    public static Object getValue(Member member, Object object) {
        Object value = null;
        if (member instanceof Method) {
            Method method = (Method)member;
            try {
                value = method.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw log.getUnableToAccessMemberException(method.getName(), e);
            }
            catch (InvocationTargetException e) {
                throw log.getUnableToAccessMemberException(method.getName(), e);
            }
        }
        if (member instanceof Field) {
            Field field = (Field)member;
            try {
                value = field.get(object);
            }
            catch (IllegalAccessException e) {
                throw log.getUnableToAccessMemberException(field.getName(), e);
            }
        }
        return value;
    }

    public static void setAccessibility(Member member) {
        ReflectionHelper.run(SetAccessibility.action(member));
    }

    public static Type getIndexedType(Type type) {
        Type indexedType = null;
        if (ReflectionHelper.isIterable(type) && type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            indexedType = paramType.getActualTypeArguments()[0];
        } else if (ReflectionHelper.isMap(type) && type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            indexedType = paramType.getActualTypeArguments()[1];
        } else if (TypeHelper.isArray(type)) {
            indexedType = TypeHelper.getComponentType(type);
        }
        return indexedType;
    }

    public static boolean isIterable(Type type) {
        if (type instanceof Class && Iterable.class.isAssignableFrom((Class)type)) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionHelper.isIterable(((ParameterizedType)type).getRawType());
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            return upperBounds.length != 0 && ReflectionHelper.isIterable(upperBounds[0]);
        }
        return false;
    }

    public static boolean isMap(Type type) {
        if (type instanceof Class && Map.class.isAssignableFrom((Class)type)) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionHelper.isMap(((ParameterizedType)type).getRawType());
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            return upperBounds.length != 0 && ReflectionHelper.isMap(upperBounds[0]);
        }
        return false;
    }

    public static boolean isList(Type type) {
        if (type instanceof Class && List.class.isAssignableFrom((Class)type)) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionHelper.isList(((ParameterizedType)type).getRawType());
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            return upperBounds.length != 0 && ReflectionHelper.isList(upperBounds[0]);
        }
        return false;
    }

    public static Object getIndexedValue(Object value, Integer index) {
        Iterator<Object> iter;
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (ReflectionHelper.isIterable(type)) {
            iter = ((Iterable)value).iterator();
        } else if (TypeHelper.isArray(type)) {
            List<Object> arrayList = Arrays.asList(value);
            iter = arrayList.iterator();
        } else {
            return null;
        }
        int i = 0;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (i == index) {
                return o;
            }
            ++i;
        }
        return null;
    }

    public static Object getMappedValue(Object value, Object key) {
        if (!(value instanceof Map)) {
            return null;
        }
        Map map = (Map)value;
        return map.get(key);
    }

    public static Field getDeclaredField(Class<?> clazz, String fieldName) {
        return ReflectionHelper.run(GetDeclaredField.action(clazz, fieldName));
    }

    public static boolean containsDeclaredField(Class<?> clazz, String fieldName) {
        return ReflectionHelper.getDeclaredField(clazz, fieldName) != null;
    }

    public static Field[] getDeclaredFields(Class<?> clazz) {
        return ReflectionHelper.run(GetDeclaredFields.action(clazz));
    }

    public static Method getMethodFromPropertyName(Class<?> clazz, String methodName) {
        return ReflectionHelper.run(GetMethodFromPropertyName.action(clazz, methodName));
    }

    public static boolean containsMethodWithPropertyName(Class<?> clazz, String property) {
        return ReflectionHelper.getMethodFromPropertyName(clazz, property) != null;
    }

    public static Method getMethod(Class<?> clazz, String methodName) {
        return ReflectionHelper.run(GetMethod.action(clazz, methodName));
    }

    public static Method getDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return ReflectionHelper.run(GetDeclaredMethod.action(clazz, methodName, parameterTypes));
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) {
        return ReflectionHelper.run(GetDeclaredMethods.action(clazz));
    }

    public static Method[] getMethods(Class<?> clazz) {
        return ReflectionHelper.run(GetMethods.action(clazz));
    }

    public static Constructor<?>[] getDeclaredConstructors(Class<?> clazz) {
        return ReflectionHelper.run(GetDeclaredConstructors.action(clazz));
    }

    private static <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }

    public static boolean haveSameSignature(ExecutableElement method1, ExecutableElement method2) {
        Contracts.assertValueNotNull(method1, "method1");
        Contracts.assertValueNotNull(method2, "method2");
        return method1.getMember().getName().equals(method2.getMember().getName()) && Arrays.equals(method1.getGenericParameterTypes(), method2.getGenericParameterTypes());
    }

    public static Class<?> boxedType(Class<?> primitiveType) {
        Class<?> wrapperType = PRIMITIVE_TO_WRAPPER_TYPES.get(primitiveType);
        if (wrapperType == null) {
            throw log.getHasToBeAPrimitiveTypeException(primitiveType.getClass());
        }
        return wrapperType;
    }

    public static List<Class<?>> computeClassHierarchy(Class<?> clazz, boolean includeInterfaces) {
        ArrayList classes = new ArrayList();
        ReflectionHelper.computeClassHierarchy(clazz, classes, includeInterfaces);
        return classes;
    }

    private static void computeClassHierarchy(Class<?> clazz, List<Class<?>> classes, boolean includeInterfaces) {
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            if (classes.contains(current)) {
                return;
            }
            classes.add(current);
            if (!includeInterfaces) continue;
            for (Class<?> currentInterface : current.getInterfaces()) {
                ReflectionHelper.computeClassHierarchy(currentInterface, classes, includeInterfaces);
            }
        }
    }

    public static Set<Class<?>> computeAllImplementedInterfaces(Class<?> clazz) {
        HashSet classes = new HashSet();
        ReflectionHelper.computeAllImplementedInterfaces(clazz, classes);
        return classes;
    }

    private static void computeAllImplementedInterfaces(Class<?> clazz, Set<Class<?>> classes) {
        if (clazz == null) {
            return;
        }
        for (Class<?> currentInterface : clazz.getInterfaces()) {
            classes.add(currentInterface);
            ReflectionHelper.computeAllImplementedInterfaces(currentInterface, classes);
        }
    }

    public static Iterator<?> createIteratorForCascadedValue(Type type, Object value) {
        Iterator<Object> iter;
        if (ReflectionHelper.isIterable(type)) {
            iter = ((Iterable)value).iterator();
        } else if (ReflectionHelper.isMap(type)) {
            Map map = (Map)value;
            iter = map.values().iterator();
        } else if (TypeHelper.isArray(type)) {
            List<Object> arrayList = Arrays.asList((Object[])value);
            iter = arrayList.iterator();
        } else {
            ArrayList list = CollectionHelper.newArrayList();
            list.add(value);
            iter = list.iterator();
        }
        return iter;
    }

    static {
        HashMap<Class<Object>, Class<Void>> temp = CollectionHelper.newHashMap(9);
        temp.put(Boolean.TYPE, Boolean.class);
        temp.put(Character.TYPE, Character.class);
        temp.put(Double.TYPE, Double.class);
        temp.put(Float.TYPE, Float.class);
        temp.put(Long.TYPE, Long.class);
        temp.put(Integer.TYPE, Integer.class);
        temp.put(Short.TYPE, Short.class);
        temp.put(Byte.TYPE, Byte.class);
        temp.put(Void.TYPE, Void.TYPE);
        PRIMITIVE_TO_WRAPPER_TYPES = Collections.unmodifiableMap(temp);
    }
}

