/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.cfg.context;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.hibernate.validator.cfg.ConstraintDef;
import org.hibernate.validator.cfg.context.PropertyConstraintMappingContext;
import org.hibernate.validator.internal.cfg.context.ConfiguredConstraint;
import org.hibernate.validator.internal.cfg.context.ConstraintMappingContext;
import org.hibernate.validator.internal.cfg.context.ConstraintMappingContextImplBase;
import org.hibernate.validator.internal.metadata.location.BeanConstraintLocation;
import org.hibernate.validator.internal.metadata.location.ExecutableConstraintLocation;

public final class PropertyConstraintMappingContextImpl
extends ConstraintMappingContextImplBase
implements PropertyConstraintMappingContext {
    private final Member member;

    public PropertyConstraintMappingContextImpl(Class<?> beanClass, Member member, ConstraintMappingContext mapping) {
        super(beanClass, mapping);
        this.member = member;
    }

    @Override
    public PropertyConstraintMappingContext constraint(ConstraintDef<?, ?> definition) {
        if (this.member instanceof Field) {
            this.mapping.addConstraintConfig(ConfiguredConstraint.forProperty(definition, this.member));
        } else {
            this.mapping.addMethodConstraintConfig(ConfiguredConstraint.forReturnValue(definition, (Method)this.member));
        }
        return this;
    }

    @Override
    public PropertyConstraintMappingContext ignoreAnnotations() {
        this.mapping.getAnnotationProcessingOptions().ignorePropertyLevelConstraintAnnotationsOnMember(this.member);
        return this;
    }

    @Override
    public PropertyConstraintMappingContext valid() {
        if (this.member instanceof Field) {
            this.mapping.addCascadeConfig(new BeanConstraintLocation(this.member));
        } else {
            this.mapping.addMethodCascadeConfig(new ExecutableConstraintLocation((Method)this.member));
        }
        return this;
    }
}

