/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.ElementDescriptor;
import javax.validation.metadata.ExecutableDescriptor;
import javax.validation.metadata.ParameterDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.validator.internal.engine.ConstraintViolationImpl;
import org.hibernate.validator.internal.engine.MessageInterpolatorContext;
import org.hibernate.validator.internal.engine.ValidationContext;
import org.hibernate.validator.internal.engine.ValueContext;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorManager;
import org.hibernate.validator.internal.engine.path.BeanMetaDataLocator;
import org.hibernate.validator.internal.engine.path.MessageAndPath;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.hibernate.validator.internal.metadata.BeanMetaDataManager;
import org.hibernate.validator.internal.metadata.aggregated.BeanMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ConstraintMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ExecutableMetaData;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;
import org.hibernate.validator.internal.util.ReflectionHelper;

public class MethodValidationContext<T>
extends ValidationContext<T, ConstraintViolation<T>> {
    private final ExecutableElement method;
    private final Object[] parameterValues;

    protected MethodValidationContext(BeanMetaDataManager beanMetaDataManager, ConstraintValidatorManager constraintValidatorManager, Class<T> rootBeanClass, T rootBean, ExecutableElement method, Object[] parameterValues, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver, boolean failFast) {
        super(beanMetaDataManager, constraintValidatorManager, rootBeanClass, rootBean, messageInterpolator, constraintValidatorFactory, traversableResolver, failFast);
        this.method = method;
        this.parameterValues = parameterValues;
    }

    public ExecutableElement getExecutable() {
        return this.method;
    }

    @Override
    public <U, V> ConstraintViolation<T> createConstraintViolation(ValueContext<U, V> localContext, MessageAndPath messageAndPath, ConstraintDescriptor<?> descriptor) {
        String messageTemplate = messageAndPath.getMessage();
        String interpolatedMessage = this.messageInterpolator.interpolate(messageTemplate, (MessageInterpolator.Context)new MessageInterpolatorContext(descriptor, localContext.getCurrentValidatedValue()));
        Path path = this.createPathWithElementDescriptors(messageAndPath.getPath(), localContext);
        return new ConstraintViolationImpl(messageTemplate, interpolatedMessage, this.getRootBeanClass(), this.getRootBean(), localContext.getCurrentBean(), localContext.getCurrentValidatedValue(), path, descriptor, localContext.getElementType());
    }

    private Path createPathWithElementDescriptors(Path path, ValueContext<?, ?> localContext) {
        ArrayList<ElementDescriptor> elementDescriptors = new ArrayList<ElementDescriptor>();
        ExecutableDescriptor executableDescriptor = this.getMethodDescriptor();
        elementDescriptors.add((ElementDescriptor)this.getMethodDescriptor());
        Object value = null;
        if (this.isReturnValueValidation(localContext)) {
            elementDescriptors.add((ElementDescriptor)executableDescriptor.getReturnValueDescriptor());
            value = localContext.getCurrentBean();
            if (value != null && ReflectionHelper.isIterable(value.getClass())) {
                value = ReflectionHelper.getIndexedValue(value, this.getIterableIndex(path));
            }
        } else if (localContext.getParameterIndex() != null) {
            Integer parameterIndex = localContext.getParameterIndex();
            ParameterDescriptor parameterDescriptor = (ParameterDescriptor)executableDescriptor.getParameterDescriptors().get(parameterIndex);
            elementDescriptors.add((ElementDescriptor)parameterDescriptor);
            value = this.parameterValues[localContext.getParameterIndex()];
            if (value != null && ReflectionHelper.isIterable(value.getClass())) {
                value = ReflectionHelper.getIndexedValue(value, this.getIterableIndex(path));
            }
        }
        if (value != null) {
            this.addDescriptorsForPropertyPart(path, elementDescriptors, value);
        }
        return PathImpl.createCopyWithElementDescriptorsAttached((PathImpl)path, elementDescriptors);
    }

    private void addDescriptorsForPropertyPart(Path path, List<ElementDescriptor> elementDescriptors, Object value) {
        BeanMetaDataLocator traverser = BeanMetaDataLocator.createBeanMetaDataLocatorForBeanValidation(value, value.getClass(), this.getBeanMetaDataManager());
        Iterator<BeanMetaData<?>> beanMetaDataIterator = traverser.beanMetaDataIterator(this.advanceIteratorToCascadedNode(path));
        Iterator<Path.Node> nodeIterator = this.advanceIteratorToCascadedNode(path);
        while (nodeIterator.hasNext()) {
            Path.Node node = nodeIterator.next();
            BeanMetaData<?> beanMetaData = beanMetaDataIterator.next();
            if (this.isClassLevelConstraintNode(node.getName())) {
                BeanDescriptor beanDescriptor = beanMetaData.getBeanDescriptor();
                elementDescriptors.add((ElementDescriptor)beanDescriptor);
                continue;
            }
            PropertyDescriptor propertyDescriptor = beanMetaData.getBeanDescriptor().getConstraintsForProperty(node.getName());
            elementDescriptors.add((ElementDescriptor)propertyDescriptor);
        }
    }

    private Iterator<Path.Node> advanceIteratorToCascadedNode(Path path) {
        Iterator nodeIterator = path.iterator();
        nodeIterator.next();
        nodeIterator.next();
        return nodeIterator;
    }

    private int getIterableIndex(Path path) {
        Iterator nodeIterator = path.iterator();
        nodeIterator.next();
        nodeIterator.next();
        Path.Node node = (Path.Node)nodeIterator.next();
        return node.getIndex();
    }

    private boolean isReturnValueValidation(ValueContext<?, ?> localContext) {
        Iterator<Path.Node> i$ = localContext.getPropertyPath().iterator();
        while (i$.hasNext()) {
            Path.Node node = i$.next();
            if (!node.getName().equals("$retval")) continue;
            return true;
        }
        return false;
    }

    private ExecutableDescriptor getMethodDescriptor() {
        BeanMetaData rootMetaData = this.getBeanMetaDataManager().getBeanMetaData(this.getRootBeanClass());
        ExecutableMetaData methodMetaData = rootMetaData.getMetaDataFor(this.method);
        BeanDescriptor beanDescriptor = rootMetaData.getBeanDescriptor();
        if (methodMetaData.getKind() == ConstraintMetaData.ConstraintMetaDataKind.METHOD) {
            return beanDescriptor.getConstraintsForMethod(this.method.getMember().getName(), (Class[])methodMetaData.getParameterTypes());
        }
        return beanDescriptor.getConstraintsForConstructor((Class[])methodMetaData.getParameterTypes());
    }

    private boolean isClassLevelConstraintNode(String name) {
        return name == null;
    }
}

