/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.validation.BootstrapConfiguration;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.hibernate.validator.internal.util.ResourceLoaderHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.xml.BootstrapConfigurationImpl;
import org.hibernate.validator.internal.xml.PropertyType;
import org.hibernate.validator.internal.xml.ValidationConfigType;
import org.hibernate.validator.internal.xml.XmlParserHelper;

public class ValidationXmlParser {
    private static final Log log = LoggerFactory.make();
    private static final String VALIDATION_XML_FILE = "META-INF/validation.xml";
    private static final ConcurrentMap<String, String> SCHEMAS_BY_VERSION = new ConcurrentHashMap<String, String>(2, 0.75f, 1);
    private XmlParserHelper xmlParserHelper = new XmlParserHelper();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BootstrapConfiguration parseValidationXml() {
        InputStream inputStream = this.getInputStream();
        if (inputStream == null) {
            return new BootstrapConfigurationImpl();
        }
        try {
            String schemaVersion = this.xmlParserHelper.getSchemaVersion(VALIDATION_XML_FILE, inputStream);
            Schema schema = this.getSchema(schemaVersion);
            ValidationConfigType validationConfig = this.unmarshal(inputStream, schema);
            BootstrapConfiguration bootstrapConfiguration = this.createBootstrapConfiguration(validationConfig);
            return bootstrapConfiguration;
        }
        finally {
            this.closeStream(inputStream);
        }
    }

    private InputStream getInputStream() {
        log.debugf("Trying to load %s for XML based Validator configuration.", VALIDATION_XML_FILE);
        InputStream inputStream = ResourceLoaderHelper.getResettableInputStreamForPath(VALIDATION_XML_FILE);
        if (inputStream != null) {
            return inputStream;
        }
        log.debugf("No %s found. Using annotation based configuration only.", VALIDATION_XML_FILE);
        return null;
    }

    private Schema getSchema(String schemaVersion) {
        String schemaResource = (String)SCHEMAS_BY_VERSION.get(schemaVersion);
        if (schemaResource == null) {
            throw log.getUnsupportedSchemaVersionException(VALIDATION_XML_FILE, schemaVersion);
        }
        return this.xmlParserHelper.getSchema(schemaResource);
    }

    private ValidationConfigType unmarshal(InputStream inputStream, Schema schema) {
        log.parsingXMLFile(VALIDATION_XML_FILE);
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ValidationConfigType.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setSchema(schema);
            StreamSource stream = new StreamSource(inputStream);
            JAXBElement root = unmarshaller.unmarshal((Source)stream, ValidationConfigType.class);
            return (ValidationConfigType)root.getValue();
        }
        catch (JAXBException e) {
            throw log.getUnableToParseValidationXmlFileException(VALIDATION_XML_FILE, e);
        }
    }

    private void closeStream(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException io) {
            log.unableToCloseXMLFileInputStream(VALIDATION_XML_FILE);
        }
    }

    private BootstrapConfiguration createBootstrapConfiguration(ValidationConfigType config) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (PropertyType property : config.getProperty()) {
            if (log.isDebugEnabled()) {
                log.debugf("Found property '%s' with value '%s' in validation.xml.", property.getName(), property.getValue());
            }
            properties.put(property.getName(), property.getValue());
        }
        return new BootstrapConfigurationImpl(config.getDefaultProvider(), config.getConstraintValidatorFactory(), config.getMessageInterpolator(), config.getTraversableResolver(), config.getParameterNameProvider(), new HashSet<String>(config.getConstraintMapping()), properties);
    }

    static {
        SCHEMAS_BY_VERSION.put("1.0", "META-INF/validation-configuration-1.0.xsd");
        SCHEMAS_BY_VERSION.put("1.1", "META-INF/validation-configuration-1.1.xsd");
    }
}

