/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.path;

import java.io.Serializable;
import javax.validation.Path;
import javax.validation.metadata.ElementDescriptor;

public class NodeImpl
implements Path.Node,
Serializable {
    private static final long serialVersionUID = 2075466571633860499L;
    public static final String INDEX_OPEN = "[";
    public static final String INDEX_CLOSE = "]";
    private static final String RETURN_VALUE_TO_STRING = "$retval";
    private final String name;
    private final NodeImpl parent;
    private final boolean isIterable;
    private final Integer index;
    private final Object key;
    private final int hashCode;
    private final ElementDescriptor elementDescriptor;
    private String asString;

    public NodeImpl(String name, NodeImpl parent, boolean indexable, Integer index, Object key, ElementDescriptor descriptor) {
        this.name = name;
        this.parent = parent;
        this.index = index;
        this.key = key;
        this.isIterable = indexable;
        this.hashCode = this.buildHashCode();
        this.elementDescriptor = descriptor;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isInIterable() {
        return this.parent != null && this.parent.isIterable();
    }

    public final boolean isIterable() {
        return this.isIterable;
    }

    public final Integer getIndex() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.index;
    }

    public final Object getKey() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.key;
    }

    public final NodeImpl getParent() {
        return this.parent;
    }

    public ElementDescriptor getElementDescriptor() {
        return this.elementDescriptor;
    }

    public String toString() {
        return this.asString();
    }

    public final String asString() {
        if (this.asString == null) {
            this.asString = this.buildToString();
        }
        return this.asString;
    }

    private String buildToString() {
        StringBuilder builder = new StringBuilder();
        if (this.elementDescriptor != null) {
            if (ElementDescriptor.Kind.BEAN.equals((Object)this.elementDescriptor.getKind())) {
                builder.append("");
            } else if (ElementDescriptor.Kind.RETURN_VALUE.equals((Object)this.elementDescriptor.getKind())) {
                builder.append(RETURN_VALUE_TO_STRING);
            } else {
                builder.append(this.getName());
            }
        } else if (this.getName() != null) {
            builder.append(this.getName());
        } else {
            builder.append("");
        }
        if (this.isIterable()) {
            builder.append(INDEX_OPEN);
            if (this.index != null) {
                builder.append(this.index);
            } else if (this.key != null) {
                builder.append(this.key);
            }
            builder.append(INDEX_CLOSE);
        }
        return builder.toString();
    }

    public int buildHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
        result = 31 * result + (this.isIterable ? 1231 : 1237);
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeImpl other = (NodeImpl)obj;
        if (this.index == null ? other.index != null : !this.index.equals(other.index)) {
            return false;
        }
        if (this.isIterable != other.isIterable) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
    }
}

