/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.aggregated;

import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.metadata.ElementDescriptor;
import javax.validation.metadata.GroupConversionDescriptor;
import org.hibernate.validator.internal.metadata.aggregated.AbstractConstraintMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ConstraintMetaData;
import org.hibernate.validator.internal.metadata.aggregated.GroupConversionHelper;
import org.hibernate.validator.internal.metadata.aggregated.MetaDataBuilder;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.PropertyDescriptorImpl;
import org.hibernate.validator.internal.metadata.facets.Cascadable;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedExecutable;
import org.hibernate.validator.internal.metadata.raw.ConstrainedField;
import org.hibernate.validator.internal.metadata.raw.ConstrainedType;
import org.hibernate.validator.internal.util.ReflectionHelper;

public class PropertyMetaData
extends AbstractConstraintMetaData
implements Cascadable {
    private final Member cascadingMember;
    private final ElementType elementType;
    private final GroupConversionHelper groupConversionHelper;

    private PropertyMetaData(String propertyName, Type type, Set<MetaConstraint<?>> constraints, Map<Class<?>, Class<?>> groupConversions, Member cascadingMember) {
        super(propertyName, type, constraints, ConstraintMetaData.ConstraintMetaDataKind.PROPERTY, cascadingMember != null, cascadingMember != null || !constraints.isEmpty());
        this.groupConversionHelper = new GroupConversionHelper(groupConversions);
        if (cascadingMember != null) {
            this.cascadingMember = cascadingMember;
            this.elementType = cascadingMember instanceof Field ? ElementType.FIELD : ElementType.METHOD;
        } else {
            this.cascadingMember = null;
            this.elementType = ElementType.TYPE;
        }
    }

    @Override
    public Object getValue(Object parent) {
        return ReflectionHelper.getValue(this.cascadingMember, parent);
    }

    @Override
    public ElementType getElementType() {
        return this.elementType;
    }

    public Class<?> getRawType() {
        return ReflectionHelper.getType(this.cascadingMember);
    }

    @Override
    public Class<?> convertGroup(Class<?> from) {
        return this.groupConversionHelper.convertGroup(from);
    }

    @Override
    public Set<GroupConversionDescriptor> getGroupConversionDescriptors() {
        return this.groupConversionHelper.asDescriptors();
    }

    @Override
    public PropertyDescriptorImpl asDescriptor(boolean defaultGroupSequenceRedefined, List<Class<?>> defaultGroupSequence) {
        return new PropertyDescriptorImpl(this.getType(), this.getName(), this.asDescriptors(this.getConstraints()), this.isCascading(), defaultGroupSequenceRedefined, defaultGroupSequence, this.getGroupConversionDescriptors());
    }

    @Override
    public ElementDescriptor getDescriptor() {
        return this.asDescriptor(false, Collections.emptyList());
    }

    @Override
    public String toString() {
        return "PropertyMetaData [type=" + this.getType() + ", propertyName=" + this.getName() + ", cascadingMember=[" + this.cascadingMember + "]]";
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public static class Builder
    extends MetaDataBuilder {
        private static final EnumSet<ConstrainedElement.ConstrainedElementKind> SUPPORTED_ELEMENT_KINDS = EnumSet.of(ConstrainedElement.ConstrainedElementKind.TYPE, ConstrainedElement.ConstrainedElementKind.FIELD, ConstrainedElement.ConstrainedElementKind.METHOD);
        private final String propertyName;
        private final Type propertyType;
        private Member cascadingMember;

        public Builder(Class<?> beanClass, ConstrainedField constrainedField, ConstraintHelper constraintHelper) {
            super(beanClass, constraintHelper);
            this.propertyName = ReflectionHelper.getPropertyName(constrainedField.getLocation().getMember());
            this.propertyType = ((Field)constrainedField.getLocation().getMember()).getGenericType();
            this.add(constrainedField);
        }

        public Builder(Class<?> beanClass, ConstrainedType constrainedType, ConstraintHelper constraintHelper) {
            super(beanClass, constraintHelper);
            this.propertyName = null;
            this.propertyType = null;
            this.add(constrainedType);
        }

        public Builder(Class<?> beanClass, ConstrainedExecutable constrainedMethod, ConstraintHelper constraintHelper) {
            super(beanClass, constraintHelper);
            this.propertyName = ReflectionHelper.getPropertyName(constrainedMethod.getLocation().getMember());
            this.propertyType = constrainedMethod.getLocation().typeOfAnnotatedElement();
            this.add(constrainedMethod);
        }

        @Override
        public boolean accepts(ConstrainedElement constrainedElement) {
            if (!SUPPORTED_ELEMENT_KINDS.contains((Object)constrainedElement.getKind())) {
                return false;
            }
            if (constrainedElement.getKind() == ConstrainedElement.ConstrainedElementKind.METHOD && !((ConstrainedExecutable)constrainedElement).isGetterMethod()) {
                return false;
            }
            return this.equals(ReflectionHelper.getPropertyName(constrainedElement.getLocation().getMember()), this.propertyName);
        }

        @Override
        public void add(ConstrainedElement constrainedElement) {
            super.add(constrainedElement);
            if (constrainedElement.isCascading() && this.cascadingMember == null) {
                this.cascadingMember = constrainedElement.getLocation().getMember();
            }
        }

        @Override
        public PropertyMetaData build() {
            return new PropertyMetaData(this.propertyName, this.propertyType, this.adaptOriginsAndImplicitGroups(this.getConstraints()), this.getGroupConversions(), this.cascadingMember);
        }

        private boolean equals(String s1, String s2) {
            return s1 != null && s1.equals(s2) || s1 == null && s2 == null;
        }
    }
}

