/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.cdi.interceptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ElementKind;
import javax.validation.Path;
import javax.validation.Validator;
import org.hibernate.validator.internal.cdi.interceptor.MethodValidated;

@MethodValidated
@Interceptor
public class ValidationInterceptor
implements Serializable {
    private static final long serialVersionUID = 604440259030722151L;
    @Inject
    private Validator validator;

    @AroundInvoke
    public Object validateMethodInvocation(InvocationContext ctx) throws Exception {
        Set violations = this.validator.forExecutables().validateParameters(ctx.getTarget(), ctx.getMethod(), ctx.getParameters(), new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(this.getMessage(ctx.getMethod(), ctx.getParameters(), violations), violations);
        }
        Object result = ctx.proceed();
        violations = this.validator.forExecutables().validateReturnValue(ctx.getTarget(), ctx.getMethod(), result, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(this.getMessage(ctx.getMethod(), ctx.getParameters(), violations), violations);
        }
        return result;
    }

    private String getMessage(Method method, Object[] args, Set<? extends ConstraintViolation<?>> violations) {
        StringBuilder message = new StringBuilder();
        message.append(violations.size());
        message.append(" constraint violation(s) occurred during method invocation.");
        message.append("\nMethod: ");
        message.append(method);
        message.append("\nArgument values: ");
        message.append(Arrays.toString(args));
        message.append("\nConstraint violations: ");
        int i = 1;
        for (ConstraintViolation<?> constraintViolation : violations) {
            Path.Node leafNode = this.getLeafNode(constraintViolation);
            message.append("\n (");
            message.append(i);
            message.append(")");
            message.append(" Kind: ");
            message.append(leafNode.getKind());
            if (leafNode.getKind() == ElementKind.PARAMETER) {
                message.append("\n parameter index: ");
                message.append(((Path.ParameterNode)leafNode.as(Path.ParameterNode.class)).getParameterIndex());
            }
            message.append("\n message: ");
            message.append(constraintViolation.getMessage());
            message.append("\n root bean: ");
            message.append(constraintViolation.getRootBean());
            message.append("\n property path: ");
            message.append(constraintViolation.getPropertyPath());
            message.append("\n constraint: ");
            message.append(constraintViolation.getConstraintDescriptor().getAnnotation());
            ++i;
        }
        return message.toString();
    }

    private Path.Node getLeafNode(ConstraintViolation<?> constraintViolation) {
        Iterator nodes = constraintViolation.getPropertyPath().iterator();
        Path.Node leafNode = null;
        while (nodes.hasNext()) {
            leafNode = (Path.Node)nodes.next();
        }
        return leafNode;
    }
}

