/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.aggregated;

import java.lang.annotation.ElementType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ElementKind;
import javax.validation.metadata.GroupConversionDescriptor;
import javax.validation.metadata.ReturnValueDescriptor;
import org.hibernate.validator.internal.metadata.aggregated.AbstractConstraintMetaData;
import org.hibernate.validator.internal.metadata.aggregated.GroupConversionHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.ReturnValueDescriptorImpl;
import org.hibernate.validator.internal.metadata.facets.Cascadable;
import org.hibernate.validator.internal.metadata.facets.Validatable;

public class ReturnValueMetaData
extends AbstractConstraintMetaData
implements Validatable,
Cascadable {
    public static final String RETURN_VALUE_NODE_NAME = null;
    private final List<Cascadable> cascadables;
    private final GroupConversionHelper groupConversionHelper;

    public ReturnValueMetaData(Type type, Set<MetaConstraint<?>> constraints, boolean isCascading, Map<Class<?>, Class<?>> groupConversions) {
        super(RETURN_VALUE_NODE_NAME, type, constraints, ElementKind.RETURN_VALUE, isCascading, !constraints.isEmpty() || isCascading);
        this.cascadables = Collections.unmodifiableList(isCascading ? Arrays.asList(this) : Collections.emptyList());
        this.groupConversionHelper = new GroupConversionHelper(groupConversions);
    }

    @Override
    public Iterable<Cascadable> getCascadables() {
        return this.cascadables;
    }

    @Override
    public Class<?> convertGroup(Class<?> originalGroup) {
        return this.groupConversionHelper.convertGroup(originalGroup);
    }

    @Override
    public Set<GroupConversionDescriptor> getGroupConversionDescriptors() {
        return this.groupConversionHelper.asDescriptors();
    }

    @Override
    public ElementType getElementType() {
        return ElementType.METHOD;
    }

    @Override
    public Object getValue(Object parent) {
        return parent;
    }

    public ReturnValueDescriptor asDescriptor(boolean defaultGroupSequenceRedefined, List<Class<?>> defaultGroupSequence) {
        return new ReturnValueDescriptorImpl(this.getType(), this.asDescriptors(this.getConstraints()), this.isCascading(), defaultGroupSequenceRedefined, defaultGroupSequence, this.groupConversionHelper.asDescriptors());
    }
}

