/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.raw;

import java.lang.annotation.ElementType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.location.ExecutableConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.AbstractConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedParameter;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ConstrainedExecutable
extends AbstractConstrainedElement {
    private static final Log log = LoggerFactory.make();
    private final List<ConstrainedParameter> parameterMetaData;
    private final boolean hasParameterConstraints;
    private final Set<MetaConstraint<?>> crossParameterConstraints;

    public ConstrainedExecutable(ConfigurationSource source, ExecutableConstraintLocation location, Set<MetaConstraint<?>> returnValueConstraints, boolean isCascading) {
        this(source, location, Collections.emptyList(), Collections.emptySet(), returnValueConstraints, Collections.emptyMap(), isCascading);
    }

    public ConstrainedExecutable(ConfigurationSource source, ExecutableConstraintLocation location, List<ConstrainedParameter> parameterMetaData, Set<MetaConstraint<?>> crossParameterConstraints, Set<MetaConstraint<?>> returnValueConstraints, Map<Class<?>, Class<?>> groupConversions, boolean isCascading) {
        super(source, location.getElementType() == ElementType.CONSTRUCTOR ? ConstrainedElement.ConstrainedElementKind.CONSTRUCTOR : ConstrainedElement.ConstrainedElementKind.METHOD, location, returnValueConstraints, groupConversions, isCascading);
        ExecutableElement executable = location.getExecutableElement();
        if (parameterMetaData.size() != executable.getParameterTypes().length) {
            throw log.getInvalidLengthOfParameterMetaDataListException(executable, executable.getParameterTypes().length, parameterMetaData.size());
        }
        this.crossParameterConstraints = crossParameterConstraints;
        this.parameterMetaData = Collections.unmodifiableList(parameterMetaData);
        boolean bl = this.hasParameterConstraints = this.hasParameterConstraints(parameterMetaData) || !crossParameterConstraints.isEmpty();
        if (this.isConstrained()) {
            ReflectionHelper.setAccessibility(executable.getMember());
        }
    }

    @Override
    public ExecutableConstraintLocation getLocation() {
        return (ExecutableConstraintLocation)super.getLocation();
    }

    public ConstrainedParameter getParameterMetaData(int parameterIndex) {
        if (parameterIndex < 0 || parameterIndex > this.parameterMetaData.size() - 1) {
            throw log.getInvalidMethodParameterIndexException(this.getLocation().getMember().getName(), parameterIndex);
        }
        return this.parameterMetaData.get(parameterIndex);
    }

    public List<ConstrainedParameter> getAllParameterMetaData() {
        return this.parameterMetaData;
    }

    public Set<MetaConstraint<?>> getCrossParameterConstraints() {
        return this.crossParameterConstraints;
    }

    @Override
    public boolean isConstrained() {
        return super.isConstrained() || this.hasParameterConstraints;
    }

    public boolean hasParameterConstraints() {
        return this.hasParameterConstraints;
    }

    public boolean isGetterMethod() {
        return this.getLocation().getExecutableElement().isGetterMethod();
    }

    @Override
    public String toString() {
        return "ConstrainedExecutable [location=" + this.getLocation() + ", parameterMetaData=" + this.parameterMetaData + ", hasParameterConstraints=" + this.hasParameterConstraints + "]";
    }

    private boolean hasParameterConstraints(List<ConstrainedParameter> parameterMetaData) {
        for (ConstrainedParameter oneParameter : parameterMetaData) {
            if (!oneParameter.isConstrained()) continue;
            return true;
        }
        return false;
    }
}

