/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.constraintvalidation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.internal.engine.ValueContext;
import org.hibernate.validator.internal.engine.valuehandling.UnwrapMode;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.StringHelper;
import org.hibernate.validator.internal.util.TypeHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.spi.valuehandling.ValidatedValueUnwrapper;

public class ConstraintValidatorManager {
    private static final Log log = LoggerFactory.make();
    private final ConstraintValidatorFactory defaultConstraintValidatorFactory;
    private ConstraintValidatorFactory leastRecentlyUsedNonDefaultConstraintValidatorFactory;
    private final ConcurrentHashMap<CacheKey, ConstraintValidator<?, ?>> constraintValidatorCache;

    public ConstraintValidatorManager(ConstraintValidatorFactory constraintValidatorFactory) {
        this.defaultConstraintValidatorFactory = constraintValidatorFactory;
        this.constraintValidatorCache = new ConcurrentHashMap();
    }

    public <V, A extends Annotation> ConstraintValidator<A, V> getInitializedValidator(ValueContext<?, V> valueContext, ConstraintDescriptorImpl<A> descriptor, ConstraintValidatorFactory constraintValidatorFactory) {
        Contracts.assertNotNull(valueContext);
        Type typeOfValidatedElement = valueContext.getDeclaredTypeOfValidatedElement();
        Contracts.assertNotNull(typeOfValidatedElement);
        Contracts.assertNotNull(descriptor);
        Contracts.assertNotNull(constraintValidatorFactory);
        UnwrapMode valueUnwrapMode = valueContext.getUnwrapMode();
        CacheKey key = new CacheKey((Annotation)descriptor.getAnnotation(), typeOfValidatedElement, constraintValidatorFactory, valueUnwrapMode);
        Object constraintValidator = this.constraintValidatorCache.get(key);
        if (constraintValidator == null) {
            Class<ConstraintValidator<A, ?>> validatorClass = this.findMatchingValidatorClass(valueContext, descriptor);
            constraintValidator = this.createAndInitializeValidator(constraintValidatorFactory, validatorClass, descriptor);
            this.putInitializedValidator(typeOfValidatedElement, (Annotation)descriptor.getAnnotation(), constraintValidatorFactory, (ConstraintValidator<?, ?>)constraintValidator, valueUnwrapMode);
        } else {
            log.tracef("Constraint validator %s found in cache.", constraintValidator);
        }
        return constraintValidator;
    }

    private void putInitializedValidator(Type validatedValueType, Annotation annotation, ConstraintValidatorFactory constraintFactory, ConstraintValidator<?, ?> constraintValidator, UnwrapMode unwrapMode) {
        if (constraintFactory != this.defaultConstraintValidatorFactory && constraintFactory != this.leastRecentlyUsedNonDefaultConstraintValidatorFactory) {
            this.clearEntriesForFactory(this.leastRecentlyUsedNonDefaultConstraintValidatorFactory);
            this.leastRecentlyUsedNonDefaultConstraintValidatorFactory = constraintFactory;
        }
        CacheKey key = new CacheKey(annotation, validatedValueType, constraintFactory, unwrapMode);
        this.constraintValidatorCache.putIfAbsent(key, constraintValidator);
    }

    private <V, A extends Annotation> ConstraintValidator<A, V> createAndInitializeValidator(ConstraintValidatorFactory constraintFactory, Class<? extends ConstraintValidator<?, ?>> validatorClass, ConstraintDescriptor<A> descriptor) {
        ConstraintValidator constraintValidator = constraintFactory.getInstance(validatorClass);
        if (constraintValidator == null) {
            throw log.getConstraintFactoryMustNotReturnNullException(validatorClass.getName());
        }
        this.initializeConstraint(descriptor, constraintValidator);
        return constraintValidator;
    }

    private void clearEntriesForFactory(ConstraintValidatorFactory constraintFactory) {
        ArrayList<CacheKey> entriesToRemove = new ArrayList<CacheKey>();
        for (Map.Entry<CacheKey, ConstraintValidator<?, ?>> entry : this.constraintValidatorCache.entrySet()) {
            if (entry.getKey().getConstraintFactory() != constraintFactory) continue;
            entriesToRemove.add(entry.getKey());
        }
        for (CacheKey key : entriesToRemove) {
            this.constraintValidatorCache.remove(key);
        }
    }

    public void clear() {
        for (Map.Entry<CacheKey, ConstraintValidator<?, ?>> entry : this.constraintValidatorCache.entrySet()) {
            entry.getKey().getConstraintFactory().releaseInstance(entry.getValue());
        }
        this.constraintValidatorCache.clear();
    }

    public ConstraintValidatorFactory getDefaultConstraintValidatorFactory() {
        return this.defaultConstraintValidatorFactory;
    }

    public int numberOfCachedConstraintValidatorInstances() {
        return this.constraintValidatorCache.size();
    }

    private <A extends Annotation> Class<? extends ConstraintValidator<A, ?>> findMatchingValidatorClass(ValueContext<?, ?> valueContext, ConstraintDescriptorImpl<A> descriptor) {
        List<Type> suitableTypesForWrappedValue;
        Map<Type, Class<ConstraintValidator<A, ?>>> availableValidatorTypes = descriptor.getAvailableValidatorTypes();
        Type typeOfValidatedElement = valueContext.getDeclaredTypeOfValidatedElement();
        List<Type> suitableTypesForValidatedValue = this.findSuitableValidatorTypes(typeOfValidatedElement, availableValidatorTypes);
        this.resolveAssignableTypes(suitableTypesForValidatedValue);
        ValidatedValueUnwrapper validatedValueHandler = valueContext.getValidatedValueHandler();
        if (validatedValueHandler != null) {
            Type unwrappedType = validatedValueHandler.getValidatedValueType(typeOfValidatedElement);
            suitableTypesForWrappedValue = this.findSuitableValidatorTypes(unwrappedType, availableValidatorTypes);
            this.resolveAssignableTypes(suitableTypesForWrappedValue);
        } else {
            suitableTypesForWrappedValue = Collections.emptyList();
        }
        Type suitableType = this.verifyResolveWasUnique(valueContext, descriptor, suitableTypesForValidatedValue, suitableTypesForWrappedValue);
        return availableValidatorTypes.get(suitableType);
    }

    private Type verifyResolveWasUnique(ValueContext<?, ?> valueContext, ConstraintDescriptorImpl<?> descriptor, List<Type> constraintValidatorTypesForValidatedValue, List<Type> constraintValidatorTypesForWrappedValue) {
        TypeResolutionResult typeResolutionResult = this.typeResolutionOutcome(constraintValidatorTypesForValidatedValue, constraintValidatorTypesForWrappedValue, valueContext);
        switch (typeResolutionResult) {
            case VALIDATORS_FOR_VALIDATED_VALUE_AND_WRAPPED_VALUE: {
                throw log.getConstraintValidatorExistsForWrapperAndWrappedValueException(valueContext.getPropertyPath().toString(), descriptor.getAnnotationType().getName(), valueContext.getValidatedValueHandler().getClass().getName());
            }
            case SINGLE_VALIDATOR_FOR_VALIDATED_VALUE: {
                return constraintValidatorTypesForValidatedValue.get(0);
            }
            case MULTIPLE_VALIDATORS_FOR_VALIDATED_VALUE: {
                throw log.getMoreThanOneValidatorFoundForTypeException(this.getValidatedValueTypeForErrorReporting(valueContext), StringHelper.join(constraintValidatorTypesForValidatedValue, ","));
            }
            case SINGLE_VALIDATOR_FOR_WRAPPED_VALUE: {
                return constraintValidatorTypesForWrappedValue.get(0);
            }
            case NO_VALIDATORS: {
                if (descriptor.getConstraintType() == ConstraintDescriptorImpl.ConstraintType.CROSS_PARAMETER) {
                    throw log.getValidatorForCrossParameterConstraintMustEitherValidateObjectOrObjectArrayException(descriptor.getAnnotationType().getName());
                }
                Type typeOfValidatedElement = this.getValidatedValueTypeForErrorReporting(valueContext);
                String validatedValueClassName = typeOfValidatedElement.toString();
                if (typeOfValidatedElement instanceof Class) {
                    Class clazz = (Class)typeOfValidatedElement;
                    validatedValueClassName = clazz.isArray() ? clazz.getComponentType().toString() + "[]" : clazz.getName();
                }
                throw log.getNoValidatorFoundForTypeException(descriptor.getAnnotationType().getName(), validatedValueClassName, valueContext.getPropertyPath().toString());
            }
        }
        return null;
    }

    private Type getValidatedValueTypeForErrorReporting(ValueContext<?, ?> valueContext) {
        Class<?> typeOfValidatedElement = valueContext.getDeclaredTypeOfValidatedElement();
        if (valueContext.getValidatedValueHandler() != null) {
            typeOfValidatedElement = valueContext.getCurrentValidatedValue().getClass();
        }
        return typeOfValidatedElement;
    }

    private TypeResolutionResult typeResolutionOutcome(List<Type> constraintValidatorTypesForValidatedValue, List<Type> constraintValidatorTypesForWrappedValue, ValueContext<?, ?> valueContext) {
        if (UnwrapMode.UNWRAP.equals((Object)valueContext.getUnwrapMode()) && constraintValidatorTypesForWrappedValue.size() == 0) {
            throw log.getNoUnwrapperFoundForTypeException(valueContext.getDeclaredTypeOfValidatedElement().toString());
        }
        if (constraintValidatorTypesForValidatedValue.size() > 0 && constraintValidatorTypesForWrappedValue.size() > 0) {
            switch (valueContext.getUnwrapMode()) {
                case AUTOMATIC: {
                    return TypeResolutionResult.VALIDATORS_FOR_VALIDATED_VALUE_AND_WRAPPED_VALUE;
                }
                case UNWRAP: {
                    return this.getTypeResolutionResultForWrappedValue(constraintValidatorTypesForWrappedValue);
                }
                case SKIP_UNWRAP: {
                    valueContext.setValidatedValueHandler(null);
                    return this.getTypeResolutionResultForValidatedValue(valueContext, constraintValidatorTypesForValidatedValue);
                }
            }
        }
        if (constraintValidatorTypesForWrappedValue.size() == 0) {
            return this.getTypeResolutionResultForValidatedValue(valueContext, constraintValidatorTypesForValidatedValue);
        }
        if (constraintValidatorTypesForValidatedValue.size() == 0) {
            return this.getTypeResolutionResultForWrappedValue(constraintValidatorTypesForWrappedValue);
        }
        return null;
    }

    private TypeResolutionResult getTypeResolutionResultForWrappedValue(List<Type> constraintValidatorTypesForWrappedValue) {
        if (constraintValidatorTypesForWrappedValue.size() == 1) {
            return TypeResolutionResult.SINGLE_VALIDATOR_FOR_WRAPPED_VALUE;
        }
        return TypeResolutionResult.MULTIPLE_VALIDATORS_FOR_WRAPPED_VALUE;
    }

    private TypeResolutionResult getTypeResolutionResultForValidatedValue(ValueContext valueContext, List<Type> constraintValidatorTypesForValidatedValue) {
        if (constraintValidatorTypesForValidatedValue.size() == 0) {
            return TypeResolutionResult.NO_VALIDATORS;
        }
        if (constraintValidatorTypesForValidatedValue.size() == 1) {
            valueContext.setValidatedValueHandler(null);
            return TypeResolutionResult.SINGLE_VALIDATOR_FOR_VALIDATED_VALUE;
        }
        return TypeResolutionResult.MULTIPLE_VALIDATORS_FOR_VALIDATED_VALUE;
    }

    private <A extends Annotation> List<Type> findSuitableValidatorTypes(Type type, Map<Type, Class<? extends ConstraintValidator<A, ?>>> availableValidatorTypes) {
        ArrayList<Type> determinedSuitableTypes = CollectionHelper.newArrayList();
        for (Type validatorType : availableValidatorTypes.keySet()) {
            if (!TypeHelper.isAssignable(validatorType, type) || determinedSuitableTypes.contains(validatorType)) continue;
            determinedSuitableTypes.add(validatorType);
        }
        return determinedSuitableTypes;
    }

    private <A extends Annotation> void initializeConstraint(ConstraintDescriptor<A> descriptor, ConstraintValidator<A, ?> constraintValidator) {
        try {
            constraintValidator.initialize(descriptor.getAnnotation());
        }
        catch (RuntimeException e) {
            throw log.getUnableToInitializeConstraintValidatorException(constraintValidator.getClass().getName(), e);
        }
    }

    private void resolveAssignableTypes(List<Type> assignableTypes) {
        if (assignableTypes.size() == 0 || assignableTypes.size() == 1) {
            return;
        }
        ArrayList<Type> typesToRemove = new ArrayList<Type>();
        do {
            typesToRemove.clear();
            Type type = assignableTypes.get(0);
            for (int i = 1; i < assignableTypes.size(); ++i) {
                if (TypeHelper.isAssignable(type, assignableTypes.get(i))) {
                    typesToRemove.add(type);
                    continue;
                }
                if (!TypeHelper.isAssignable(assignableTypes.get(i), type)) continue;
                typesToRemove.add(assignableTypes.get(i));
            }
            assignableTypes.removeAll(typesToRemove);
        } while (typesToRemove.size() > 0);
    }

    private static enum TypeResolutionResult {
        SINGLE_VALIDATOR_FOR_VALIDATED_VALUE,
        MULTIPLE_VALIDATORS_FOR_VALIDATED_VALUE,
        SINGLE_VALIDATOR_FOR_WRAPPED_VALUE,
        MULTIPLE_VALIDATORS_FOR_WRAPPED_VALUE,
        VALIDATORS_FOR_VALIDATED_VALUE_AND_WRAPPED_VALUE,
        NO_VALIDATORS;

    }

    private static final class CacheKey {
        private final Annotation annotation;
        private final Type validatedType;
        private final ConstraintValidatorFactory constraintFactory;
        private final UnwrapMode unwrapMode;
        private final int hashCode;

        private CacheKey(Annotation annotation, Type validatorType, ConstraintValidatorFactory constraintFactory, UnwrapMode unwrapMode) {
            this.annotation = annotation;
            this.validatedType = validatorType;
            this.constraintFactory = constraintFactory;
            this.unwrapMode = unwrapMode;
            this.hashCode = this.createHashCode();
        }

        public ConstraintValidatorFactory getConstraintFactory() {
            return this.constraintFactory;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.hashCode != cacheKey.hashCode) {
                return false;
            }
            if (!this.annotation.equals(cacheKey.annotation)) {
                return false;
            }
            if (!this.constraintFactory.equals(cacheKey.constraintFactory)) {
                return false;
            }
            if (this.unwrapMode != cacheKey.unwrapMode) {
                return false;
            }
            return this.validatedType.equals(cacheKey.validatedType);
        }

        public int hashCode() {
            return this.hashCode;
        }

        private int createHashCode() {
            int result = this.annotation.hashCode();
            result = 31 * result + this.validatedType.hashCode();
            result = 31 * result + this.constraintFactory.hashCode();
            result = 31 * result + this.unwrapMode.hashCode();
            result = 31 * result + this.hashCode;
            return result;
        }
    }
}

