/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.lucene.internal.builder;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Field;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.hibernate.hql.lucene.internal.logging.Log;
import org.hibernate.hql.lucene.internal.logging.LoggerFactory;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.builtin.DoubleNumericFieldBridge;
import org.hibernate.search.bridge.builtin.FloatNumericFieldBridge;
import org.hibernate.search.bridge.builtin.IntegerNumericFieldBridge;
import org.hibernate.search.bridge.builtin.LongNumericFieldBridge;
import org.hibernate.search.bridge.builtin.impl.TwoWayString2FieldBridgeAdaptor;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.spi.SearchFactoryIntegrator;

public class LucenePropertyHelper
implements PropertyHelper {
    private static final Log log = LoggerFactory.make();
    private final SearchFactoryIntegrator searchFactory;

    public LucenePropertyHelper(SearchFactoryIntegrator searchFactory) {
        this.searchFactory = searchFactory;
    }

    public Object convertToPropertyType(Class<?> entityType, List<String> propertyPath, String value) {
        return this.convertToPropertyType(value, entityType, propertyPath);
    }

    public Object convertToPropertyType(String value, Class<?> entityType, List<String> propertyPath) {
        return this.convertToPropertyType(value, entityType, propertyPath.toArray(new String[propertyPath.size()]));
    }

    public Object convertToPropertyType(String value, Class<?> entityType, String ... propertyPath) {
        FieldBridge bridge = this.getFieldBridge(entityType, propertyPath);
        if (bridge instanceof TwoWayString2FieldBridgeAdaptor) {
            return ((TwoWayString2FieldBridgeAdaptor)bridge).unwrap().stringToObject(value);
        }
        if (bridge instanceof IntegerNumericFieldBridge) {
            return Integer.parseInt(value);
        }
        if (bridge instanceof LongNumericFieldBridge) {
            return Long.parseLong(value);
        }
        if (bridge instanceof FloatNumericFieldBridge) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (bridge instanceof DoubleNumericFieldBridge) {
            return Double.parseDouble(value);
        }
        return value;
    }

    private FieldBridge getFieldBridge(Class<?> type, String ... propertyPath) {
        EntityIndexBinding entityIndexBinding = this.getIndexBinding(type);
        if (this.isIdentifierProperty(entityIndexBinding, propertyPath)) {
            return entityIndexBinding.getDocumentBuilder().getIdBridge();
        }
        PropertyMetadata metadata = this.getLeafTypeMetadata(type, propertyPath).getPropertyMetadataForProperty(propertyPath[propertyPath.length - 1]);
        return ((DocumentFieldMetadata)metadata.getFieldMetadata().iterator().next()).getFieldBridge();
    }

    public boolean exists(Class<?> type, List<String> propertyPath) {
        return this.exists(type, propertyPath.toArray(new String[propertyPath.size()]));
    }

    public boolean exists(Class<?> type, String ... propertyPath) {
        EntityIndexBinding entityIndexBinding = this.getIndexBinding(type);
        if (this.isIdentifierProperty(entityIndexBinding, propertyPath)) {
            return true;
        }
        TypeMetadata metadata = entityIndexBinding.getDocumentBuilder().getMetadata();
        for (int i = 0; i < propertyPath.length - 1; ++i) {
            Set embeddedTypeMetadata = metadata.getEmbeddedTypeMetadata();
            if ((metadata = this.getEmbeddedTypeMetadata(embeddedTypeMetadata, propertyPath[i])) != null) continue;
            return false;
        }
        return metadata.getPropertyMetadataForProperty(propertyPath[propertyPath.length - 1]) != null || this.getEmbeddedTypeMetadata(metadata.getEmbeddedTypeMetadata(), propertyPath[propertyPath.length - 1]) != null;
    }

    public TypeMetadata getLeafTypeMetadata(Class<?> type, String ... propertyPath) {
        EntityIndexBinding entityIndexBinding = this.getIndexBinding(type);
        TypeMetadata leafTypeMetadata = entityIndexBinding.getDocumentBuilder().getMetadata();
        for (int i = 0; i < propertyPath.length; ++i) {
            Set embeddedTypeMetadata = leafTypeMetadata.getEmbeddedTypeMetadata();
            EmbeddedTypeMetadata metadata = this.getEmbeddedTypeMetadata(embeddedTypeMetadata, propertyPath[i]);
            if (metadata == null) continue;
            leafTypeMetadata = metadata;
        }
        return leafTypeMetadata;
    }

    private EmbeddedTypeMetadata getEmbeddedTypeMetadata(Set<EmbeddedTypeMetadata> embeddedTypeMetadata, String name) {
        for (EmbeddedTypeMetadata metadata : embeddedTypeMetadata) {
            if (!metadata.getEmbeddedFieldName().equals(name)) continue;
            return metadata;
        }
        return null;
    }

    public boolean isAnalyzed(Class<?> type, List<String> propertyPath) {
        return this.isAnalyzed(type, propertyPath.toArray(new String[propertyPath.size()]));
    }

    public boolean isAnalyzed(Class<?> type, String ... propertyPath) {
        EntityIndexBinding entityIndexBinding = this.getIndexBinding(type);
        if (this.isIdentifierProperty(entityIndexBinding, propertyPath)) {
            return false;
        }
        TypeMetadata metadata = this.getLeafTypeMetadata(type, propertyPath);
        Field.Index index = ((DocumentFieldMetadata)metadata.getPropertyMetadataForProperty(propertyPath[propertyPath.length - 1]).getFieldMetadata().iterator().next()).getIndex();
        return EnumSet.of(Field.Index.ANALYZED, Field.Index.ANALYZED_NO_NORMS).contains(index);
    }

    public boolean isEmbedded(Class<?> type, List<String> propertyPath) {
        return this.isEmbedded(type, propertyPath.toArray(new String[propertyPath.size()]));
    }

    public boolean isEmbedded(Class<?> type, String ... propertyPath) {
        Set embeddedTypeMetadata;
        if (propertyPath.length == 0) {
            return false;
        }
        EntityIndexBinding entityIndexBinding = this.getIndexBinding(type);
        TypeMetadata metadata = entityIndexBinding.getDocumentBuilder().getMetadata();
        for (int i = 0; i < propertyPath.length && (metadata = this.getEmbeddedTypeMetadata(embeddedTypeMetadata = metadata.getEmbeddedTypeMetadata(), propertyPath[i])) != null; ++i) {
        }
        return metadata != null;
    }

    private boolean isIdentifierProperty(EntityIndexBinding entityIndexBinding, String ... propertyPath) {
        return propertyPath.length == 1 && propertyPath[0].equals(entityIndexBinding.getDocumentBuilder().getIdentifierName());
    }

    private EntityIndexBinding getIndexBinding(Class<?> type) {
        EntityIndexBinding entityIndexBinding = this.searchFactory.getIndexBinding(type);
        if (entityIndexBinding == null) {
            throw log.getNoIndexedEntityException(type.getCanonicalName());
        }
        return entityIndexBinding;
    }
}

