/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.lucene.internal.builder.predicate;

import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.hql.ast.spi.predicate.ComparisonPredicate;
import org.hibernate.hql.ast.spi.predicate.ConjunctionPredicate;
import org.hibernate.hql.ast.spi.predicate.DisjunctionPredicate;
import org.hibernate.hql.ast.spi.predicate.InPredicate;
import org.hibernate.hql.ast.spi.predicate.IsNullPredicate;
import org.hibernate.hql.ast.spi.predicate.LikePredicate;
import org.hibernate.hql.ast.spi.predicate.NegationPredicate;
import org.hibernate.hql.ast.spi.predicate.PredicateFactory;
import org.hibernate.hql.ast.spi.predicate.RangePredicate;
import org.hibernate.hql.ast.spi.predicate.RootPredicate;
import org.hibernate.hql.internal.util.Strings;
import org.hibernate.hql.lucene.internal.builder.LucenePropertyHelper;
import org.hibernate.hql.lucene.internal.builder.predicate.LuceneComparisonPredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.LuceneConjunctionPredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.LuceneDisjunctionPredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.LuceneInPredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.LuceneIsNullPredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.LuceneLikePredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.LuceneNegationPredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.LuceneRangePredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.LuceneRootPredicate;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.QueryContextBuilder;

public class LucenePredicateFactory
implements PredicateFactory<Query> {
    private final QueryContextBuilder queryContextBuilder;
    private final LucenePropertyHelper propertyHelper;
    private QueryBuilder queryBuilder;

    public LucenePredicateFactory(QueryContextBuilder queryContextBuilder, LucenePropertyHelper propertyHelper) {
        this.queryContextBuilder = queryContextBuilder;
        this.propertyHelper = propertyHelper;
    }

    public RootPredicate<Query> getRootPredicate(Class<?> entityType) {
        this.queryBuilder = this.queryContextBuilder.forEntity(entityType).get();
        return new LuceneRootPredicate(this.queryBuilder);
    }

    public ComparisonPredicate<Query> getComparisonPredicate(Class<?> entityType, ComparisonPredicate.Type comparisonType, List<String> propertyPath, Object value) {
        return new LuceneComparisonPredicate(this.queryBuilder, Strings.join(propertyPath, (String)"."), comparisonType, value);
    }

    public InPredicate<Query> getInPredicate(Class<?> entityType, List<String> propertyPath, List<Object> values) {
        return new LuceneInPredicate(this.queryBuilder, Strings.join(propertyPath, (String)"."), values);
    }

    public RangePredicate<Query> getRangePredicate(Class<?> entityType, List<String> propertyPath, Object lowerValue, Object upperValue) {
        return new LuceneRangePredicate(this.queryBuilder, Strings.join(propertyPath, (String)"."), lowerValue, upperValue);
    }

    public NegationPredicate<Query> getNegationPredicate() {
        return new LuceneNegationPredicate(this.queryBuilder);
    }

    public DisjunctionPredicate<Query> getDisjunctionPredicate() {
        return new LuceneDisjunctionPredicate(this.queryBuilder);
    }

    public ConjunctionPredicate<Query> getConjunctionPredicate() {
        return new LuceneConjunctionPredicate(this.queryBuilder);
    }

    public LikePredicate<Query> getLikePredicate(Class<?> entityType, List<String> propertyPath, String patternValue, Character escapeCharacter) {
        return new LuceneLikePredicate(this.queryBuilder, Strings.join(propertyPath, (String)"."), patternValue);
    }

    public IsNullPredicate<Query> getIsNullPredicate(Class<?> entityType, List<String> propertyPath) {
        String nullToken;
        TypeMetadata typeMetadata = this.propertyHelper.getLeafTypeMetadata(entityType, propertyPath.toArray(new String[propertyPath.size()]));
        if (this.propertyHelper.isEmbedded(entityType, propertyPath)) {
            nullToken = ((EmbeddedTypeMetadata)typeMetadata).getEmbeddedNullToken();
        } else {
            PropertyMetadata propertyMetadata = typeMetadata.getPropertyMetadataForProperty(propertyPath.get(propertyPath.size() - 1));
            nullToken = ((DocumentFieldMetadata)propertyMetadata.getFieldMetadata().iterator().next()).indexNullAs();
        }
        return new LuceneIsNullPredicate(this.queryBuilder, Strings.join(propertyPath, (String)"."), nullToken);
    }
}

