/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.lucene.internal.builder;

import java.util.List;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.bridge.builtin.impl.TwoWayString2FieldBridgeAdaptor;

public abstract class LucenePropertyHelper
implements PropertyHelper {
    public Object convertToPropertyType(String entityType, List<String> propertyPath, String value) {
        FieldBridge bridge = this.getFieldBridge(entityType, propertyPath);
        if (bridge instanceof TwoWayString2FieldBridgeAdaptor) {
            return ((TwoWayString2FieldBridgeAdaptor)bridge).unwrap().stringToObject(value);
        }
        if (bridge instanceof NumericFieldBridge) {
            NumericFieldBridge numericBridge = (NumericFieldBridge)bridge;
            switch (numericBridge) {
                case INT_FIELD_BRIDGE: {
                    return Integer.valueOf(value);
                }
                case LONG_FIELD_BRIDGE: {
                    return Long.valueOf(value);
                }
                case FLOAT_FIELD_BRIDGE: {
                    return Float.valueOf(value);
                }
                case DOUBLE_FIELD_BRIDGE: {
                    return Double.valueOf(value);
                }
            }
            return value;
        }
        return value;
    }

    public abstract FieldBridge getFieldBridge(String var1, List<String> var2);
}

