/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.lucene.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.Tree;
import org.hibernate.hql.ast.TypeDescriptor;
import org.hibernate.hql.ast.common.JoinType;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReference;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReferenceSource;
import org.hibernate.hql.ast.origin.hql.resolve.path.PropertyPath;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.QueryResolverDelegate;
import org.hibernate.hql.lucene.internal.ast.HSearchEmbeddedEntityTypeDescriptor;
import org.hibernate.hql.lucene.internal.ast.HSearchIndexedEntityTypeDescriptor;
import org.hibernate.hql.lucene.internal.ast.HSearchPropertyTypeDescriptor;
import org.hibernate.hql.lucene.internal.ast.HSearchTypeDescriptor;
import org.hibernate.hql.lucene.internal.builder.ClassBasedLucenePropertyHelper;
import org.hibernate.hql.lucene.internal.logging.Log;
import org.hibernate.hql.lucene.internal.logging.LoggerFactory;

public class ClassBasedLuceneQueryResolverDelegate
implements QueryResolverDelegate {
    private static final Log log = LoggerFactory.make();
    private final Map<String, String> aliasToEntityType = new HashMap<String, String>();
    private final Map<String, PropertyPath> aliasToPropertyPath = new HashMap<String, PropertyPath>();
    private Status status;
    private final EntityNamesResolver entityNames;
    private final ClassBasedLucenePropertyHelper propertyHelper;
    private Class<?> targetType = null;
    private String alias;

    public ClassBasedLuceneQueryResolverDelegate(ClassBasedLucenePropertyHelper propertyHelper, EntityNamesResolver entityNames) {
        this.entityNames = entityNames;
        this.propertyHelper = propertyHelper;
    }

    public void registerPersisterSpace(Tree entityName, Tree alias) {
        String put = this.aliasToEntityType.put(alias.getText(), entityName.getText());
        if (put != null && !put.equalsIgnoreCase(entityName.getText())) {
            throw new UnsupportedOperationException("Alias reuse currently not supported: alias " + alias.getText() + " already assigned to type " + put);
        }
        Class targetedType = this.entityNames.getClassFromName(entityName.getText());
        if (targetedType == null) {
            throw new IllegalStateException("Unknown entity name " + entityName.getText());
        }
        if (this.targetType != null) {
            throw new IllegalStateException("Can't target multiple types: " + this.targetType + " already selected before " + targetedType);
        }
        this.targetType = targetedType;
    }

    public boolean isUnqualifiedPropertyReference() {
        return true;
    }

    public PathedPropertyReferenceSource normalizeUnqualifiedPropertyReference(Tree property) {
        if (this.aliasToEntityType.containsKey(property.getText())) {
            return this.normalizeQualifiedRoot(property);
        }
        return this.normalizeProperty(new HSearchIndexedEntityTypeDescriptor(this.targetType, this.propertyHelper), Collections.<String>emptyList(), property.getText());
    }

    public boolean isPersisterReferenceAlias() {
        return this.aliasToEntityType.containsKey(this.alias);
    }

    public PathedPropertyReferenceSource normalizeUnqualifiedRoot(Tree identifier382) {
        if (this.aliasToEntityType.containsKey(identifier382.getText())) {
            return this.normalizeQualifiedRoot(identifier382);
        }
        if (this.aliasToPropertyPath.containsKey(identifier382.getText())) {
            PropertyPath propertyPath = this.aliasToPropertyPath.get(identifier382.getText());
            if (propertyPath == null) {
                throw log.getUnknownAliasException(identifier382.getText());
            }
            HSearchTypeDescriptor sourceType = (HSearchTypeDescriptor)((PathedPropertyReferenceSource)propertyPath.getNodes().get(0)).getType();
            List<String> resolveAlias = this.resolveAlias(propertyPath);
            PathedPropertyReference property = new PathedPropertyReference(identifier382.getText(), (TypeDescriptor)new HSearchEmbeddedEntityTypeDescriptor(sourceType.getIndexedEntityType(), resolveAlias, this.propertyHelper), true);
            return property;
        }
        throw log.getUnknownAliasException(identifier382.getText());
    }

    public PathedPropertyReferenceSource normalizeQualifiedRoot(Tree root) {
        String entityNameForAlias = this.aliasToEntityType.get(root.getText());
        if (entityNameForAlias == null) {
            throw log.getUnknownAliasException(root.getText());
        }
        Class entityType = this.entityNames.getClassFromName(entityNameForAlias);
        return new PathedPropertyReference(root.getText(), (TypeDescriptor)new HSearchIndexedEntityTypeDescriptor(entityType, this.propertyHelper), true);
    }

    public PathedPropertyReferenceSource normalizePropertyPathIntermediary(PropertyPath path, Tree propertyName) {
        HSearchTypeDescriptor sourceType = (HSearchTypeDescriptor)path.getLastNode().getType();
        if (!sourceType.hasProperty(propertyName.getText())) {
            throw log.getNoSuchPropertyException(sourceType.toString(), propertyName.getText());
        }
        List<String> newPath = this.resolveAlias(path);
        newPath.add(propertyName.getText());
        PathedPropertyReference property = new PathedPropertyReference(propertyName.getText(), (TypeDescriptor)new HSearchEmbeddedEntityTypeDescriptor(sourceType.getIndexedEntityType(), newPath, this.propertyHelper), false);
        return property;
    }

    public PathedPropertyReferenceSource normalizeIntermediateIndexOperation(PathedPropertyReferenceSource propertyReferenceSource, Tree collectionProperty, Tree selector) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void normalizeTerminalIndexOperation(PathedPropertyReferenceSource propertyReferenceSource, Tree collectionProperty, Tree selector) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public PathedPropertyReferenceSource normalizeUnqualifiedPropertyReferenceSource(Tree identifier394) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public PathedPropertyReferenceSource normalizePropertyPathTerminus(PropertyPath path, Tree propertyNameNode) {
        HSearchTypeDescriptor type = (HSearchTypeDescriptor)path.getLastNode().getType();
        return this.normalizeProperty(type, path.getNodeNamesWithoutAlias(), propertyNameNode.getText());
    }

    private List<String> resolveAlias(PropertyPath path) {
        if (path.getFirstNode().isAlias()) {
            String alias = path.getFirstNode().getName();
            if (this.aliasToEntityType.containsKey(alias)) {
                return path.getNodeNamesWithoutAlias();
            }
            if (this.aliasToPropertyPath.containsKey(alias)) {
                PropertyPath propertyPath = this.aliasToPropertyPath.get(alias);
                List<String> resolvedAlias = this.resolveAlias(propertyPath);
                resolvedAlias.addAll(path.getNodeNamesWithoutAlias());
                return resolvedAlias;
            }
            throw log.getUnknownAliasException(alias);
        }
        return path.getNodeNamesWithoutAlias();
    }

    private PathedPropertyReferenceSource normalizeProperty(HSearchTypeDescriptor type, List<String> path, String propertyName) {
        if (!type.hasProperty(propertyName)) {
            throw log.getNoSuchPropertyException(type.toString(), propertyName);
        }
        if (this.status != Status.DEFINING_SELECT && !type.isEmbedded(propertyName) && type.isAnalyzed(propertyName)) {
            throw log.getQueryOnAnalyzedPropertyNotSupportedException(type.getIndexedEntityType().getCanonicalName(), propertyName);
        }
        if (type.isEmbedded(propertyName)) {
            LinkedList<String> newPath = new LinkedList<String>(path);
            newPath.add(propertyName);
            return new PathedPropertyReference(propertyName, (TypeDescriptor)new HSearchEmbeddedEntityTypeDescriptor(type.getIndexedEntityType(), newPath, this.propertyHelper), false);
        }
        return new PathedPropertyReference(propertyName, (TypeDescriptor)new HSearchPropertyTypeDescriptor(), false);
    }

    public void pushFromStrategy(JoinType joinType, Tree assosiationFetchTree, Tree propertyFetchTree, Tree alias) {
        this.status = Status.DEFINING_FROM;
        this.alias = alias.getText();
    }

    public void pushSelectStrategy() {
        this.status = Status.DEFINING_SELECT;
    }

    public void popStrategy() {
        this.status = null;
        this.alias = null;
    }

    public void propertyPathCompleted(PropertyPath path) {
        if (this.status == Status.DEFINING_SELECT && path.getLastNode().getType() instanceof HSearchEmbeddedEntityTypeDescriptor) {
            HSearchEmbeddedEntityTypeDescriptor type = (HSearchEmbeddedEntityTypeDescriptor)path.getLastNode().getType();
            throw log.getProjectionOfCompleteEmbeddedEntitiesNotSupportedException(type.getIndexedEntityType().getCanonicalName(), path.asStringPathWithoutAlias());
        }
    }

    public void registerJoinAlias(Tree alias, PropertyPath path) {
        if (!path.getNodes().isEmpty() && !this.aliasToPropertyPath.containsKey(alias.getText())) {
            this.aliasToPropertyPath.put(alias.getText(), path);
        }
    }

    private static enum Status {
        DEFINING_SELECT,
        DEFINING_FROM;

    }
}

