/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.lucene.internal.builder;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.lucene.document.DateTools;
import org.hibernate.hql.ParsingException;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.hibernate.hql.internal.util.Strings;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.builtin.NumericEncodingCalendarBridge;
import org.hibernate.search.bridge.builtin.NumericEncodingDateBridge;
import org.hibernate.search.bridge.builtin.StringEncodingCalendarBridge;
import org.hibernate.search.bridge.builtin.StringEncodingDateBridge;
import org.hibernate.search.bridge.util.impl.BridgeAdaptor;
import org.hibernate.search.metadata.NumericFieldSettingsDescriptor;

public abstract class LucenePropertyHelper
implements PropertyHelper {
    public Object convertToBackendType(String entityType, List<String> propertyPath, Object value) {
        return value;
    }

    public Object convertToPropertyType(String entityType, List<String> propertyPath, String value) {
        FieldBridge bridge = this.getFieldBridge(entityType, propertyPath);
        return this.convertToPropertyType(entityType, propertyPath, value, bridge);
    }

    private Object convertToPropertyType(String entityType, List<String> propertyPath, String value, FieldBridge bridge) {
        TwoWayStringBridge twoWayBridge;
        if (bridge instanceof BridgeAdaptor && (twoWayBridge = (TwoWayStringBridge)((BridgeAdaptor)bridge).unwrap(TwoWayStringBridge.class)) != null) {
            return twoWayBridge.stringToObject(value);
        }
        if (bridge instanceof TwoWayStringBridge) {
            return ((TwoWayStringBridge)bridge).stringToObject(value);
        }
        NumericFieldSettingsDescriptor.NumericEncodingType numericEncodingType = this.getNumericEncodingType(entityType, propertyPath);
        if (numericEncodingType != null) {
            return this.convertNumericType(value, numericEncodingType);
        }
        if (bridge instanceof StringEncodingCalendarBridge || bridge instanceof NumericEncodingCalendarBridge) {
            return this.parseCalendar(value);
        }
        if (bridge instanceof StringEncodingDateBridge || bridge instanceof NumericEncodingDateBridge) {
            return this.parseDate(value);
        }
        return value;
    }

    private Calendar parseCalendar(String value) {
        Date date = this.parseDate(value);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    private Object convertNumericType(String value, NumericFieldSettingsDescriptor.NumericEncodingType numericEncodingType) {
        switch (numericEncodingType) {
            case INTEGER: {
                return Integer.valueOf(value);
            }
            case LONG: {
                return Long.valueOf(value);
            }
            case FLOAT: {
                return Float.valueOf(value);
            }
            case DOUBLE: {
                return Double.valueOf(value);
            }
        }
        return value;
    }

    private Date parseDate(String value) {
        try {
            return DateTools.stringToDate((String)value);
        }
        catch (ParseException e) {
            throw new ParsingException((Throwable)e);
        }
    }

    protected String fieldName(List<String> propertyPath) {
        return Strings.join(propertyPath, (String)".");
    }

    public abstract FieldBridge getFieldBridge(String var1, List<String> var2);

    public abstract NumericFieldSettingsDescriptor.NumericEncodingType getNumericEncodingType(String var1, List<String> var2);
}

