// $ANTLR 3.4 org/hibernate/hql/ast/render/QueryRenderer.g 2017-09-18 17:23:34

/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * Copyright (c) 2008-2012, Red Hat Inc. or third-party contributors as
 * indicated by the @author tags or express copyright attribution
 * statements applied by the authors.  All third-party contributions are
 * distributed under license by Red Hat Inc.
 *
 * This copyrighted material is made available to anyone wishing to use, modify,
 * copy, or redistribute it subject to the terms and conditions of the GNU
 * Lesser General Public License, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this distribution; if not, write to:
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301  USA
 *
 * Portions of SQL grammar parsing copyright (C) 2003 by Lubos Vnuk.  All rights
 * reserved.  These portions are distributed under license by Red Hat Inc. and
 * are covered by the above LGPL notice.  If you redistribute this material,
 * with or without modification, you must preserve this copyright notice in its
 * entirety.
 */
package org.hibernate.hql.ast.render;

import org.antlr.runtime.tree.CommonTree;
import org.hibernate.hql.ast.common.JoinType;
import org.hibernate.hql.ast.origin.hql.resolve.path.AggregationPropertyPath;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReferenceSource;
import org.hibernate.hql.ast.spi.QueryRendererDelegate;
import org.hibernate.hql.ast.tree.PropertyPathTree;


import org.antlr.runtime.*;
import org.antlr.runtime.tree.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;


@SuppressWarnings({"all", "warnings", "unchecked"})
public class QueryRenderer extends TreeParser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "A", "ABS", "ALIAS_NAME", "ALIAS_REF", "ALL", "AMPERSAND", "AND", "ANY", "ARROW", "AS", "ASTERISK", "AVG", "B", "BETWEEN", "BETWEEN_LIST", "BIT_LENGTH", "BOTH", "C", "CAST", "CHARACTER_LENGTH", "CHARACTER_LITERAL", "CLASS", "COALESCE", "COLLATE", "COLLECTION_EXPRESSION", "COLON", "COLUMN", "COLUMN_LIST", "COMMA", "CONCAT", "CONST_STRING_VALUE", "COUNT", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "D", "DAY", "DECIMAL_LITERAL", "DELETE", "DISTINCT", "DOT", "DOT_CLASS", "DOUBLE_PIPE", "DYNAMIC_INSTANTIATION", "DYNAMIC_INSTANTIATION_ARG", "E", "ELEMENTS", "ELSE", "END", "ENTITY_NAME", "ENTITY_PERSISTER_REF", "EOL", "EQUALS", "ESCAPE", "ESCAPE_SEQUENCE", "EXCEPT", "EXISTS", "EXPONENT", "EXTRACT", "F", "FALSE", "FETCH", "FILTER", "FLOATING_POINT_LITERAL", "FLOAT_TYPE_SUFFIX", "FROM", "FULL", "FUNCTION", "G", "GREATER", "GREATER_EQUAL", "GROUPING_VALUE", "GROUP_BY", "H", "HAVING", "HEX_DIGIT", "HEX_LITERAL", "HOUR", "I", "IDENTIFIER", "IN", "INDEX", "INDICES", "INNER", "INSERT", "INSERTABILITY_SPEC", "INTEGER_LITERAL", "INTEGER_TYPE_SUFFIX", "INTERSECT", "INTO", "IN_LIST", "IS", "IS_EMPTY", "IS_NOT_EMPTY", "IS_NOT_NULL", "IS_NULL", "J", "JAVA_CONSTANT", "JOIN", "JPA_PARAM", "K", "L", "LEADING", "LEFT", "LEFT_PAREN", "LEFT_SQUARE", "LENGTH", "LESS", "LESS_EQUAL", "LIKE", "LOCATE", "LOWER", "M", "MAX", "MAXELEMENT", "MAXINDEX", "MEMBER_OF", "MIN", "MINELEMENT", "MININDEX", "MINUS", "MINUTE", "MOD", "MONTH", "N", "NAMED_PARAM", "NEW", "NOT", "NOT_BETWEEN", "NOT_EQUAL", "NOT_IN", "NOT_LIKE", "NOT_MEMBER_OF", "NULL", "NULLIF", "O", "OCTAL_ESCAPE", "OCTAL_LITERAL", "OCTET_LENGTH", "ON", "OR", "ORDER_BY", "ORDER_SPEC", "OUTER", "P", "PARAM", "PATH", "PERCENT", "PERSISTER_JOIN", "PERSISTER_SPACE", "PIPE", "PLUS", "POSITION", "PROPERTIES", "PROPERTY_JOIN", "PROPERTY_REFERENCE", "PROP_FETCH", "Q", "QUALIFIED_JOIN", "QUERY", "QUERY_SPEC", "QUOTED_IDENTIFIER", "R", "RIGHT", "RIGHT_PAREN", "RIGHT_SQUARE", "S", "SEARCHED_CASE", "SECOND", "SELECT", "SELECT_FROM", "SELECT_ITEM", "SELECT_LIST", "SEMICOLON", "SET", "SIMPLE_CASE", "SIZE", "SOLIDUS", "SOME", "SORT_SPEC", "SQRT", "STRING_LITERAL", "SUBSTRING", "SUB_QUERY", "SUM", "T", "TABLE", "THEN", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TRAILING", "TRIM", "TRUE", "U", "UNARY_MINUS", "UNARY_PLUS", "UNICODE_ESCAPE", "UNION", "UPDATE", "UPPER", "V", "VECTOR_EXPR", "VERSIONED", "VERSIONED_VALUE", "W", "WHEN", "WHERE", "WITH", "WS", "X", "Y", "YEAR", "Z"
    };

    public static final int EOF=-1;
    public static final int A=4;
    public static final int ABS=5;
    public static final int ALIAS_NAME=6;
    public static final int ALIAS_REF=7;
    public static final int ALL=8;
    public static final int AMPERSAND=9;
    public static final int AND=10;
    public static final int ANY=11;
    public static final int ARROW=12;
    public static final int AS=13;
    public static final int ASTERISK=14;
    public static final int AVG=15;
    public static final int B=16;
    public static final int BETWEEN=17;
    public static final int BETWEEN_LIST=18;
    public static final int BIT_LENGTH=19;
    public static final int BOTH=20;
    public static final int C=21;
    public static final int CAST=22;
    public static final int CHARACTER_LENGTH=23;
    public static final int CHARACTER_LITERAL=24;
    public static final int CLASS=25;
    public static final int COALESCE=26;
    public static final int COLLATE=27;
    public static final int COLLECTION_EXPRESSION=28;
    public static final int COLON=29;
    public static final int COLUMN=30;
    public static final int COLUMN_LIST=31;
    public static final int COMMA=32;
    public static final int CONCAT=33;
    public static final int CONST_STRING_VALUE=34;
    public static final int COUNT=35;
    public static final int CROSS=36;
    public static final int CURRENT_DATE=37;
    public static final int CURRENT_TIME=38;
    public static final int CURRENT_TIMESTAMP=39;
    public static final int D=40;
    public static final int DAY=41;
    public static final int DECIMAL_LITERAL=42;
    public static final int DELETE=43;
    public static final int DISTINCT=44;
    public static final int DOT=45;
    public static final int DOT_CLASS=46;
    public static final int DOUBLE_PIPE=47;
    public static final int DYNAMIC_INSTANTIATION=48;
    public static final int DYNAMIC_INSTANTIATION_ARG=49;
    public static final int E=50;
    public static final int ELEMENTS=51;
    public static final int ELSE=52;
    public static final int END=53;
    public static final int ENTITY_NAME=54;
    public static final int ENTITY_PERSISTER_REF=55;
    public static final int EOL=56;
    public static final int EQUALS=57;
    public static final int ESCAPE=58;
    public static final int ESCAPE_SEQUENCE=59;
    public static final int EXCEPT=60;
    public static final int EXISTS=61;
    public static final int EXPONENT=62;
    public static final int EXTRACT=63;
    public static final int F=64;
    public static final int FALSE=65;
    public static final int FETCH=66;
    public static final int FILTER=67;
    public static final int FLOATING_POINT_LITERAL=68;
    public static final int FLOAT_TYPE_SUFFIX=69;
    public static final int FROM=70;
    public static final int FULL=71;
    public static final int FUNCTION=72;
    public static final int G=73;
    public static final int GREATER=74;
    public static final int GREATER_EQUAL=75;
    public static final int GROUPING_VALUE=76;
    public static final int GROUP_BY=77;
    public static final int H=78;
    public static final int HAVING=79;
    public static final int HEX_DIGIT=80;
    public static final int HEX_LITERAL=81;
    public static final int HOUR=82;
    public static final int I=83;
    public static final int IDENTIFIER=84;
    public static final int IN=85;
    public static final int INDEX=86;
    public static final int INDICES=87;
    public static final int INNER=88;
    public static final int INSERT=89;
    public static final int INSERTABILITY_SPEC=90;
    public static final int INTEGER_LITERAL=91;
    public static final int INTEGER_TYPE_SUFFIX=92;
    public static final int INTERSECT=93;
    public static final int INTO=94;
    public static final int IN_LIST=95;
    public static final int IS=96;
    public static final int IS_EMPTY=97;
    public static final int IS_NOT_EMPTY=98;
    public static final int IS_NOT_NULL=99;
    public static final int IS_NULL=100;
    public static final int J=101;
    public static final int JAVA_CONSTANT=102;
    public static final int JOIN=103;
    public static final int JPA_PARAM=104;
    public static final int K=105;
    public static final int L=106;
    public static final int LEADING=107;
    public static final int LEFT=108;
    public static final int LEFT_PAREN=109;
    public static final int LEFT_SQUARE=110;
    public static final int LENGTH=111;
    public static final int LESS=112;
    public static final int LESS_EQUAL=113;
    public static final int LIKE=114;
    public static final int LOCATE=115;
    public static final int LOWER=116;
    public static final int M=117;
    public static final int MAX=118;
    public static final int MAXELEMENT=119;
    public static final int MAXINDEX=120;
    public static final int MEMBER_OF=121;
    public static final int MIN=122;
    public static final int MINELEMENT=123;
    public static final int MININDEX=124;
    public static final int MINUS=125;
    public static final int MINUTE=126;
    public static final int MOD=127;
    public static final int MONTH=128;
    public static final int N=129;
    public static final int NAMED_PARAM=130;
    public static final int NEW=131;
    public static final int NOT=132;
    public static final int NOT_BETWEEN=133;
    public static final int NOT_EQUAL=134;
    public static final int NOT_IN=135;
    public static final int NOT_LIKE=136;
    public static final int NOT_MEMBER_OF=137;
    public static final int NULL=138;
    public static final int NULLIF=139;
    public static final int O=140;
    public static final int OCTAL_ESCAPE=141;
    public static final int OCTAL_LITERAL=142;
    public static final int OCTET_LENGTH=143;
    public static final int ON=144;
    public static final int OR=145;
    public static final int ORDER_BY=146;
    public static final int ORDER_SPEC=147;
    public static final int OUTER=148;
    public static final int P=149;
    public static final int PARAM=150;
    public static final int PATH=151;
    public static final int PERCENT=152;
    public static final int PERSISTER_JOIN=153;
    public static final int PERSISTER_SPACE=154;
    public static final int PIPE=155;
    public static final int PLUS=156;
    public static final int POSITION=157;
    public static final int PROPERTIES=158;
    public static final int PROPERTY_JOIN=159;
    public static final int PROPERTY_REFERENCE=160;
    public static final int PROP_FETCH=161;
    public static final int Q=162;
    public static final int QUALIFIED_JOIN=163;
    public static final int QUERY=164;
    public static final int QUERY_SPEC=165;
    public static final int QUOTED_IDENTIFIER=166;
    public static final int R=167;
    public static final int RIGHT=168;
    public static final int RIGHT_PAREN=169;
    public static final int RIGHT_SQUARE=170;
    public static final int S=171;
    public static final int SEARCHED_CASE=172;
    public static final int SECOND=173;
    public static final int SELECT=174;
    public static final int SELECT_FROM=175;
    public static final int SELECT_ITEM=176;
    public static final int SELECT_LIST=177;
    public static final int SEMICOLON=178;
    public static final int SET=179;
    public static final int SIMPLE_CASE=180;
    public static final int SIZE=181;
    public static final int SOLIDUS=182;
    public static final int SOME=183;
    public static final int SORT_SPEC=184;
    public static final int SQRT=185;
    public static final int STRING_LITERAL=186;
    public static final int SUBSTRING=187;
    public static final int SUB_QUERY=188;
    public static final int SUM=189;
    public static final int T=190;
    public static final int TABLE=191;
    public static final int THEN=192;
    public static final int TIMEZONE_HOUR=193;
    public static final int TIMEZONE_MINUTE=194;
    public static final int TRAILING=195;
    public static final int TRIM=196;
    public static final int TRUE=197;
    public static final int U=198;
    public static final int UNARY_MINUS=199;
    public static final int UNARY_PLUS=200;
    public static final int UNICODE_ESCAPE=201;
    public static final int UNION=202;
    public static final int UPDATE=203;
    public static final int UPPER=204;
    public static final int V=205;
    public static final int VECTOR_EXPR=206;
    public static final int VERSIONED=207;
    public static final int VERSIONED_VALUE=208;
    public static final int W=209;
    public static final int WHEN=210;
    public static final int WHERE=211;
    public static final int WITH=212;
    public static final int WS=213;
    public static final int X=214;
    public static final int Y=215;
    public static final int YEAR=216;
    public static final int Z=217;

    // delegates
    public TreeParser[] getDelegates() {
        return new TreeParser[] {};
    }

    // delegators


    public QueryRenderer(TreeNodeStream input) {
        this(input, new RecognizerSharedState());
    }
    public QueryRenderer(TreeNodeStream input, RecognizerSharedState state) {
        super(input, state);
    }

protected TreeAdaptor adaptor = new CommonTreeAdaptor();

public void setTreeAdaptor(TreeAdaptor adaptor) {
    this.adaptor = adaptor;
}
public TreeAdaptor getTreeAdaptor() {
    return adaptor;
}
    public String[] getTokenNames() { return QueryRenderer.tokenNames; }
    public String getGrammarFileName() { return "org/hibernate/hql/ast/render/QueryRenderer.g"; }


      private QueryRendererDelegate delegate;

      public QueryRenderer(TreeNodeStream input, QueryRendererDelegate delegate) {
        this(input, new RecognizerSharedState());
        this.delegate = delegate;
      }


    public static class filterStatement_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "filterStatement"
    // org/hibernate/hql/ast/render/QueryRenderer.g:60:1: filterStatement[String collectionRole] : ^( QUERY ^( QUERY_SPEC FILTER ( selectClause )? ( whereClause )? ( groupByClause ( havingClause )? )? ( orderByClause )? ) ) ;
    public final QueryRenderer.filterStatement_return filterStatement(String collectionRole) throws RecognitionException {
        QueryRenderer.filterStatement_return retval = new QueryRenderer.filterStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree QUERY1=null;
        CommonTree QUERY_SPEC2=null;
        CommonTree FILTER3=null;
        QueryRenderer.selectClause_return selectClause4 =null;

        QueryRenderer.whereClause_return whereClause5 =null;

        QueryRenderer.groupByClause_return groupByClause6 =null;

        QueryRenderer.havingClause_return havingClause7 =null;

        QueryRenderer.orderByClause_return orderByClause8 =null;


        CommonTree QUERY1_tree=null;
        CommonTree QUERY_SPEC2_tree=null;
        CommonTree FILTER3_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:61:2: ( ^( QUERY ^( QUERY_SPEC FILTER ( selectClause )? ( whereClause )? ( groupByClause ( havingClause )? )? ( orderByClause )? ) ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:61:4: ^( QUERY ^( QUERY_SPEC FILTER ( selectClause )? ( whereClause )? ( groupByClause ( havingClause )? )? ( orderByClause )? ) )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            QUERY1=(CommonTree)match(input,QUERY,FOLLOW_QUERY_in_filterStatement62); 


            if ( _first_0==null ) _first_0 = QUERY1;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_2 = _last;
            CommonTree _first_2 = null;
            _last = (CommonTree)input.LT(1);
            QUERY_SPEC2=(CommonTree)match(input,QUERY_SPEC,FOLLOW_QUERY_SPEC_in_filterStatement65); 


            if ( _first_1==null ) _first_1 = QUERY_SPEC2;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            FILTER3=(CommonTree)match(input,FILTER,FOLLOW_FILTER_in_filterStatement67); 
             
            if ( _first_2==null ) _first_2 = FILTER3;


            // org/hibernate/hql/ast/render/QueryRenderer.g:62:5: ( selectClause )?
            int alt1=2;
            int LA1_0 = input.LA(1);

            if ( (LA1_0==SELECT) ) {
                alt1=1;
            }
            switch (alt1) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:62:5: selectClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_selectClause_in_filterStatement73);
                    selectClause4=selectClause();

                    state._fsp--;

                     
                    if ( _first_2==null ) _first_2 = selectClause4.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            // org/hibernate/hql/ast/render/QueryRenderer.g:62:19: ( whereClause )?
            int alt2=2;
            int LA2_0 = input.LA(1);

            if ( (LA2_0==WHERE) ) {
                alt2=1;
            }
            switch (alt2) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:62:19: whereClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_whereClause_in_filterStatement76);
                    whereClause5=whereClause();

                    state._fsp--;

                     
                    if ( _first_2==null ) _first_2 = whereClause5.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            // org/hibernate/hql/ast/render/QueryRenderer.g:62:32: ( groupByClause ( havingClause )? )?
            int alt4=2;
            int LA4_0 = input.LA(1);

            if ( (LA4_0==GROUP_BY) ) {
                alt4=1;
            }
            switch (alt4) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:62:34: groupByClause ( havingClause )?
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_groupByClause_in_filterStatement81);
                    groupByClause6=groupByClause();

                    state._fsp--;

                     
                    if ( _first_2==null ) _first_2 = groupByClause6.tree;


                    // org/hibernate/hql/ast/render/QueryRenderer.g:62:48: ( havingClause )?
                    int alt3=2;
                    int LA3_0 = input.LA(1);

                    if ( (LA3_0==HAVING) ) {
                        alt3=1;
                    }
                    switch (alt3) {
                        case 1 :
                            // org/hibernate/hql/ast/render/QueryRenderer.g:62:48: havingClause
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_havingClause_in_filterStatement83);
                            havingClause7=havingClause();

                            state._fsp--;

                             
                            if ( _first_2==null ) _first_2 = havingClause7.tree;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            // org/hibernate/hql/ast/render/QueryRenderer.g:62:64: ( orderByClause )?
            int alt5=2;
            int LA5_0 = input.LA(1);

            if ( (LA5_0==ORDER_BY) ) {
                alt5=1;
            }
            switch (alt5) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:62:64: orderByClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_orderByClause_in_filterStatement88);
                    orderByClause8=orderByClause();

                    state._fsp--;

                     
                    if ( _first_2==null ) _first_2 = orderByClause8.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            match(input, Token.UP, null); 
            _last = _save_last_2;
            }


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "filterStatement"


    public static class statement_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "statement"
    // org/hibernate/hql/ast/render/QueryRenderer.g:65:1: statement : ( updateStatementSet | deleteStatementSet | insertStatementSet | queryStatementSet );
    public final QueryRenderer.statement_return statement() throws RecognitionException {
        QueryRenderer.statement_return retval = new QueryRenderer.statement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        QueryRenderer.updateStatementSet_return updateStatementSet9 =null;

        QueryRenderer.deleteStatementSet_return deleteStatementSet10 =null;

        QueryRenderer.insertStatementSet_return insertStatementSet11 =null;

        QueryRenderer.queryStatementSet_return queryStatementSet12 =null;



        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:66:2: ( updateStatementSet | deleteStatementSet | insertStatementSet | queryStatementSet )
            int alt6=4;
            switch ( input.LA(1) ) {
            case UPDATE:
                {
                alt6=1;
                }
                break;
            case DELETE:
                {
                alt6=2;
                }
                break;
            case INSERT:
                {
                alt6=3;
                }
                break;
            case QUERY:
                {
                alt6=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 6, 0, input);

                throw nvae;

            }

            switch (alt6) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:66:4: updateStatementSet
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_updateStatementSet_in_statement102);
                    updateStatementSet9=updateStatementSet();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = updateStatementSet9.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:67:4: deleteStatementSet
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_deleteStatementSet_in_statement107);
                    deleteStatementSet10=deleteStatementSet();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = deleteStatementSet10.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:68:4: insertStatementSet
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_insertStatementSet_in_statement112);
                    insertStatementSet11=insertStatementSet();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = insertStatementSet11.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:69:4: queryStatementSet
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_queryStatementSet_in_statement117);
                    queryStatementSet12=queryStatementSet();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = queryStatementSet12.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "statement"


    public static class updateStatementSet_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "updateStatementSet"
    // org/hibernate/hql/ast/render/QueryRenderer.g:72:1: updateStatementSet : ( updateStatement )+ ;
    public final QueryRenderer.updateStatementSet_return updateStatementSet() throws RecognitionException {
        QueryRenderer.updateStatementSet_return retval = new QueryRenderer.updateStatementSet_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        QueryRenderer.updateStatement_return updateStatement13 =null;



        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:73:2: ( ( updateStatement )+ )
            // org/hibernate/hql/ast/render/QueryRenderer.g:73:4: ( updateStatement )+
            {
            // org/hibernate/hql/ast/render/QueryRenderer.g:73:4: ( updateStatement )+
            int cnt7=0;
            loop7:
            do {
                int alt7=2;
                int LA7_0 = input.LA(1);

                if ( (LA7_0==UPDATE) ) {
                    alt7=1;
                }


                switch (alt7) {
            	case 1 :
            	    // org/hibernate/hql/ast/render/QueryRenderer.g:73:4: updateStatement
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_updateStatement_in_updateStatementSet128);
            	    updateStatement13=updateStatement();

            	    state._fsp--;

            	     
            	    if ( _first_0==null ) _first_0 = updateStatement13.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt7 >= 1 ) break loop7;
                        EarlyExitException eee =
                            new EarlyExitException(7, input);
                        throw eee;
                }
                cnt7++;
            } while (true);


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "updateStatementSet"


    public static class updateStatement_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "updateStatement"
    // org/hibernate/hql/ast/render/QueryRenderer.g:76:1: updateStatement : ^( UPDATE entityName ^( SET ( assignment )+ ) ( whereClause )? ) ;
    public final QueryRenderer.updateStatement_return updateStatement() throws RecognitionException {
        QueryRenderer.updateStatement_return retval = new QueryRenderer.updateStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree UPDATE14=null;
        CommonTree SET16=null;
        QueryRenderer.entityName_return entityName15 =null;

        QueryRenderer.assignment_return assignment17 =null;

        QueryRenderer.whereClause_return whereClause18 =null;


        CommonTree UPDATE14_tree=null;
        CommonTree SET16_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:77:2: ( ^( UPDATE entityName ^( SET ( assignment )+ ) ( whereClause )? ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:77:4: ^( UPDATE entityName ^( SET ( assignment )+ ) ( whereClause )? )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            UPDATE14=(CommonTree)match(input,UPDATE,FOLLOW_UPDATE_in_updateStatement141); 


            if ( _first_0==null ) _first_0 = UPDATE14;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_entityName_in_updateStatement143);
            entityName15=entityName();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = entityName15.tree;


            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_2 = _last;
            CommonTree _first_2 = null;
            _last = (CommonTree)input.LT(1);
            SET16=(CommonTree)match(input,SET,FOLLOW_SET_in_updateStatement146); 


            if ( _first_1==null ) _first_1 = SET16;
            match(input, Token.DOWN, null); 
            // org/hibernate/hql/ast/render/QueryRenderer.g:77:30: ( assignment )+
            int cnt8=0;
            loop8:
            do {
                int alt8=2;
                int LA8_0 = input.LA(1);

                if ( (LA8_0==EQUALS) ) {
                    alt8=1;
                }


                switch (alt8) {
            	case 1 :
            	    // org/hibernate/hql/ast/render/QueryRenderer.g:77:30: assignment
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_assignment_in_updateStatement148);
            	    assignment17=assignment();

            	    state._fsp--;

            	     
            	    if ( _first_2==null ) _first_2 = assignment17.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt8 >= 1 ) break loop8;
                        EarlyExitException eee =
                            new EarlyExitException(8, input);
                        throw eee;
                }
                cnt8++;
            } while (true);


            match(input, Token.UP, null); 
            _last = _save_last_2;
            }


            // org/hibernate/hql/ast/render/QueryRenderer.g:77:43: ( whereClause )?
            int alt9=2;
            int LA9_0 = input.LA(1);

            if ( (LA9_0==WHERE) ) {
                alt9=1;
            }
            switch (alt9) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:77:43: whereClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_whereClause_in_updateStatement152);
                    whereClause18=whereClause();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = whereClause18.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "updateStatement"


    public static class assignment_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "assignment"
    // org/hibernate/hql/ast/render/QueryRenderer.g:80:1: assignment : ( ^( EQUALS propertyReference valueExpression ) | ^( EQUALS VERSIONED_VALUE STRING_LITERAL ) );
    public final QueryRenderer.assignment_return assignment() throws RecognitionException {
        QueryRenderer.assignment_return retval = new QueryRenderer.assignment_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree EQUALS19=null;
        CommonTree EQUALS22=null;
        CommonTree VERSIONED_VALUE23=null;
        CommonTree STRING_LITERAL24=null;
        QueryRenderer.propertyReference_return propertyReference20 =null;

        QueryRenderer.valueExpression_return valueExpression21 =null;


        CommonTree EQUALS19_tree=null;
        CommonTree EQUALS22_tree=null;
        CommonTree VERSIONED_VALUE23_tree=null;
        CommonTree STRING_LITERAL24_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:81:2: ( ^( EQUALS propertyReference valueExpression ) | ^( EQUALS VERSIONED_VALUE STRING_LITERAL ) )
            int alt10=2;
            int LA10_0 = input.LA(1);

            if ( (LA10_0==EQUALS) ) {
                int LA10_1 = input.LA(2);

                if ( (LA10_1==DOWN) ) {
                    int LA10_2 = input.LA(3);

                    if ( (LA10_2==VERSIONED_VALUE) ) {
                        alt10=2;
                    }
                    else if ( (LA10_2==PROPERTY_REFERENCE) ) {
                        alt10=1;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("", 10, 2, input);

                        throw nvae;

                    }
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 10, 1, input);

                    throw nvae;

                }
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 10, 0, input);

                throw nvae;

            }
            switch (alt10) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:81:4: ^( EQUALS propertyReference valueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    EQUALS19=(CommonTree)match(input,EQUALS,FOLLOW_EQUALS_in_assignment166); 


                    if ( _first_0==null ) _first_0 = EQUALS19;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_propertyReference_in_assignment168);
                    propertyReference20=propertyReference();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = propertyReference20.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_assignment170);
                    valueExpression21=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression21.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:82:4: ^( EQUALS VERSIONED_VALUE STRING_LITERAL )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    EQUALS22=(CommonTree)match(input,EQUALS,FOLLOW_EQUALS_in_assignment177); 


                    if ( _first_0==null ) _first_0 = EQUALS22;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    VERSIONED_VALUE23=(CommonTree)match(input,VERSIONED_VALUE,FOLLOW_VERSIONED_VALUE_in_assignment179); 
                     
                    if ( _first_1==null ) _first_1 = VERSIONED_VALUE23;


                    _last = (CommonTree)input.LT(1);
                    STRING_LITERAL24=(CommonTree)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_assignment181); 
                     
                    if ( _first_1==null ) _first_1 = STRING_LITERAL24;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "assignment"


    public static class deleteStatementSet_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "deleteStatementSet"
    // org/hibernate/hql/ast/render/QueryRenderer.g:85:1: deleteStatementSet : ( deleteStatement )+ ;
    public final QueryRenderer.deleteStatementSet_return deleteStatementSet() throws RecognitionException {
        QueryRenderer.deleteStatementSet_return retval = new QueryRenderer.deleteStatementSet_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        QueryRenderer.deleteStatement_return deleteStatement25 =null;



        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:86:2: ( ( deleteStatement )+ )
            // org/hibernate/hql/ast/render/QueryRenderer.g:86:4: ( deleteStatement )+
            {
            // org/hibernate/hql/ast/render/QueryRenderer.g:86:4: ( deleteStatement )+
            int cnt11=0;
            loop11:
            do {
                int alt11=2;
                int LA11_0 = input.LA(1);

                if ( (LA11_0==DELETE) ) {
                    alt11=1;
                }


                switch (alt11) {
            	case 1 :
            	    // org/hibernate/hql/ast/render/QueryRenderer.g:86:4: deleteStatement
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_deleteStatement_in_deleteStatementSet193);
            	    deleteStatement25=deleteStatement();

            	    state._fsp--;

            	     
            	    if ( _first_0==null ) _first_0 = deleteStatement25.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt11 >= 1 ) break loop11;
                        EarlyExitException eee =
                            new EarlyExitException(11, input);
                        throw eee;
                }
                cnt11++;
            } while (true);


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "deleteStatementSet"


    public static class deleteStatement_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "deleteStatement"
    // org/hibernate/hql/ast/render/QueryRenderer.g:89:1: deleteStatement : ^( DELETE entityName ( whereClause )? ) ;
    public final QueryRenderer.deleteStatement_return deleteStatement() throws RecognitionException {
        QueryRenderer.deleteStatement_return retval = new QueryRenderer.deleteStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree DELETE26=null;
        QueryRenderer.entityName_return entityName27 =null;

        QueryRenderer.whereClause_return whereClause28 =null;


        CommonTree DELETE26_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:90:2: ( ^( DELETE entityName ( whereClause )? ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:90:4: ^( DELETE entityName ( whereClause )? )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            DELETE26=(CommonTree)match(input,DELETE,FOLLOW_DELETE_in_deleteStatement206); 


            if ( _first_0==null ) _first_0 = DELETE26;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_entityName_in_deleteStatement208);
            entityName27=entityName();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = entityName27.tree;


            // org/hibernate/hql/ast/render/QueryRenderer.g:90:24: ( whereClause )?
            int alt12=2;
            int LA12_0 = input.LA(1);

            if ( (LA12_0==WHERE) ) {
                alt12=1;
            }
            switch (alt12) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:90:24: whereClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_whereClause_in_deleteStatement210);
                    whereClause28=whereClause();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = whereClause28.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "deleteStatement"


    public static class insertStatementSet_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "insertStatementSet"
    // org/hibernate/hql/ast/render/QueryRenderer.g:93:1: insertStatementSet : ( insertStatement )+ ;
    public final QueryRenderer.insertStatementSet_return insertStatementSet() throws RecognitionException {
        QueryRenderer.insertStatementSet_return retval = new QueryRenderer.insertStatementSet_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        QueryRenderer.insertStatement_return insertStatement29 =null;



        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:94:2: ( ( insertStatement )+ )
            // org/hibernate/hql/ast/render/QueryRenderer.g:94:4: ( insertStatement )+
            {
            // org/hibernate/hql/ast/render/QueryRenderer.g:94:4: ( insertStatement )+
            int cnt13=0;
            loop13:
            do {
                int alt13=2;
                int LA13_0 = input.LA(1);

                if ( (LA13_0==INSERT) ) {
                    alt13=1;
                }


                switch (alt13) {
            	case 1 :
            	    // org/hibernate/hql/ast/render/QueryRenderer.g:94:4: insertStatement
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_insertStatement_in_insertStatementSet223);
            	    insertStatement29=insertStatement();

            	    state._fsp--;

            	     
            	    if ( _first_0==null ) _first_0 = insertStatement29.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt13 >= 1 ) break loop13;
                        EarlyExitException eee =
                            new EarlyExitException(13, input);
                        throw eee;
                }
                cnt13++;
            } while (true);


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "insertStatementSet"


    public static class insertStatement_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "insertStatement"
    // org/hibernate/hql/ast/render/QueryRenderer.g:97:1: insertStatement : ^( INSERT intoClause queryStatementSet ) ;
    public final QueryRenderer.insertStatement_return insertStatement() throws RecognitionException {
        QueryRenderer.insertStatement_return retval = new QueryRenderer.insertStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree INSERT30=null;
        QueryRenderer.intoClause_return intoClause31 =null;

        QueryRenderer.queryStatementSet_return queryStatementSet32 =null;


        CommonTree INSERT30_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:98:2: ( ^( INSERT intoClause queryStatementSet ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:98:4: ^( INSERT intoClause queryStatementSet )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            INSERT30=(CommonTree)match(input,INSERT,FOLLOW_INSERT_in_insertStatement236); 


            if ( _first_0==null ) _first_0 = INSERT30;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_intoClause_in_insertStatement238);
            intoClause31=intoClause();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = intoClause31.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_queryStatementSet_in_insertStatement240);
            queryStatementSet32=queryStatementSet();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = queryStatementSet32.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "insertStatement"


    public static class intoClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "intoClause"
    // org/hibernate/hql/ast/render/QueryRenderer.g:101:1: intoClause : ^( INTO entityName ^( INSERTABILITY_SPEC ( propertyReference )+ ) ) ;
    public final QueryRenderer.intoClause_return intoClause() throws RecognitionException {
        QueryRenderer.intoClause_return retval = new QueryRenderer.intoClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree INTO33=null;
        CommonTree INSERTABILITY_SPEC35=null;
        QueryRenderer.entityName_return entityName34 =null;

        QueryRenderer.propertyReference_return propertyReference36 =null;


        CommonTree INTO33_tree=null;
        CommonTree INSERTABILITY_SPEC35_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:102:2: ( ^( INTO entityName ^( INSERTABILITY_SPEC ( propertyReference )+ ) ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:102:4: ^( INTO entityName ^( INSERTABILITY_SPEC ( propertyReference )+ ) )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            INTO33=(CommonTree)match(input,INTO,FOLLOW_INTO_in_intoClause253); 


            if ( _first_0==null ) _first_0 = INTO33;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_entityName_in_intoClause255);
            entityName34=entityName();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = entityName34.tree;


            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_2 = _last;
            CommonTree _first_2 = null;
            _last = (CommonTree)input.LT(1);
            INSERTABILITY_SPEC35=(CommonTree)match(input,INSERTABILITY_SPEC,FOLLOW_INSERTABILITY_SPEC_in_intoClause258); 


            if ( _first_1==null ) _first_1 = INSERTABILITY_SPEC35;
            match(input, Token.DOWN, null); 
            // org/hibernate/hql/ast/render/QueryRenderer.g:102:43: ( propertyReference )+
            int cnt14=0;
            loop14:
            do {
                int alt14=2;
                int LA14_0 = input.LA(1);

                if ( (LA14_0==PROPERTY_REFERENCE) ) {
                    alt14=1;
                }


                switch (alt14) {
            	case 1 :
            	    // org/hibernate/hql/ast/render/QueryRenderer.g:102:43: propertyReference
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_propertyReference_in_intoClause260);
            	    propertyReference36=propertyReference();

            	    state._fsp--;

            	     
            	    if ( _first_2==null ) _first_2 = propertyReference36.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt14 >= 1 ) break loop14;
                        EarlyExitException eee =
                            new EarlyExitException(14, input);
                        throw eee;
                }
                cnt14++;
            } while (true);


            match(input, Token.UP, null); 
            _last = _save_last_2;
            }


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "intoClause"


    public static class queryStatementSet_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "queryStatementSet"
    // org/hibernate/hql/ast/render/QueryRenderer.g:105:1: queryStatementSet : ( queryStatement )+ ;
    public final QueryRenderer.queryStatementSet_return queryStatementSet() throws RecognitionException {
        QueryRenderer.queryStatementSet_return retval = new QueryRenderer.queryStatementSet_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        QueryRenderer.queryStatement_return queryStatement37 =null;



        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:106:2: ( ( queryStatement )+ )
            // org/hibernate/hql/ast/render/QueryRenderer.g:106:4: ( queryStatement )+
            {
            // org/hibernate/hql/ast/render/QueryRenderer.g:106:4: ( queryStatement )+
            int cnt15=0;
            loop15:
            do {
                int alt15=2;
                int LA15_0 = input.LA(1);

                if ( (LA15_0==QUERY) ) {
                    alt15=1;
                }


                switch (alt15) {
            	case 1 :
            	    // org/hibernate/hql/ast/render/QueryRenderer.g:106:4: queryStatement
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_queryStatement_in_queryStatementSet276);
            	    queryStatement37=queryStatement();

            	    state._fsp--;

            	     
            	    if ( _first_0==null ) _first_0 = queryStatement37.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt15 >= 1 ) break loop15;
                        EarlyExitException eee =
                            new EarlyExitException(15, input);
                        throw eee;
                }
                cnt15++;
            } while (true);


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "queryStatementSet"


    public static class queryStatement_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "queryStatement"
    // org/hibernate/hql/ast/render/QueryRenderer.g:109:1: queryStatement : ^( QUERY queryExpression ( orderByClause )? ) ;
    public final QueryRenderer.queryStatement_return queryStatement() throws RecognitionException {
        QueryRenderer.queryStatement_return retval = new QueryRenderer.queryStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree QUERY38=null;
        QueryRenderer.queryExpression_return queryExpression39 =null;

        QueryRenderer.orderByClause_return orderByClause40 =null;


        CommonTree QUERY38_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:110:2: ( ^( QUERY queryExpression ( orderByClause )? ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:110:4: ^( QUERY queryExpression ( orderByClause )? )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            QUERY38=(CommonTree)match(input,QUERY,FOLLOW_QUERY_in_queryStatement289); 


            if ( _first_0==null ) _first_0 = QUERY38;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_queryExpression_in_queryStatement291);
            queryExpression39=queryExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = queryExpression39.tree;


            // org/hibernate/hql/ast/render/QueryRenderer.g:110:28: ( orderByClause )?
            int alt16=2;
            int LA16_0 = input.LA(1);

            if ( (LA16_0==ORDER_BY) ) {
                alt16=1;
            }
            switch (alt16) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:110:28: orderByClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_orderByClause_in_queryStatement293);
                    orderByClause40=orderByClause();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = orderByClause40.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "queryStatement"


    public static class queryExpression_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "queryExpression"
    // org/hibernate/hql/ast/render/QueryRenderer.g:113:1: queryExpression : ( ^( UNION ( ALL )? queryExpression queryExpression ) | ^( INTERSECT ( ALL )? queryExpression queryExpression ) | ^( EXCEPT ( ALL )? queryExpression queryExpression ) | querySpec );
    public final QueryRenderer.queryExpression_return queryExpression() throws RecognitionException {
        QueryRenderer.queryExpression_return retval = new QueryRenderer.queryExpression_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree UNION41=null;
        CommonTree ALL42=null;
        CommonTree INTERSECT45=null;
        CommonTree ALL46=null;
        CommonTree EXCEPT49=null;
        CommonTree ALL50=null;
        QueryRenderer.queryExpression_return queryExpression43 =null;

        QueryRenderer.queryExpression_return queryExpression44 =null;

        QueryRenderer.queryExpression_return queryExpression47 =null;

        QueryRenderer.queryExpression_return queryExpression48 =null;

        QueryRenderer.queryExpression_return queryExpression51 =null;

        QueryRenderer.queryExpression_return queryExpression52 =null;

        QueryRenderer.querySpec_return querySpec53 =null;


        CommonTree UNION41_tree=null;
        CommonTree ALL42_tree=null;
        CommonTree INTERSECT45_tree=null;
        CommonTree ALL46_tree=null;
        CommonTree EXCEPT49_tree=null;
        CommonTree ALL50_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:114:2: ( ^( UNION ( ALL )? queryExpression queryExpression ) | ^( INTERSECT ( ALL )? queryExpression queryExpression ) | ^( EXCEPT ( ALL )? queryExpression queryExpression ) | querySpec )
            int alt20=4;
            switch ( input.LA(1) ) {
            case UNION:
                {
                alt20=1;
                }
                break;
            case INTERSECT:
                {
                alt20=2;
                }
                break;
            case EXCEPT:
                {
                alt20=3;
                }
                break;
            case QUERY_SPEC:
                {
                alt20=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 20, 0, input);

                throw nvae;

            }

            switch (alt20) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:114:4: ^( UNION ( ALL )? queryExpression queryExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    UNION41=(CommonTree)match(input,UNION,FOLLOW_UNION_in_queryExpression307); 


                    if ( _first_0==null ) _first_0 = UNION41;
                    match(input, Token.DOWN, null); 
                    // org/hibernate/hql/ast/render/QueryRenderer.g:114:12: ( ALL )?
                    int alt17=2;
                    int LA17_0 = input.LA(1);

                    if ( (LA17_0==ALL) ) {
                        alt17=1;
                    }
                    switch (alt17) {
                        case 1 :
                            // org/hibernate/hql/ast/render/QueryRenderer.g:114:12: ALL
                            {
                            _last = (CommonTree)input.LT(1);
                            ALL42=(CommonTree)match(input,ALL,FOLLOW_ALL_in_queryExpression309); 
                             
                            if ( _first_1==null ) _first_1 = ALL42;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_queryExpression_in_queryExpression312);
                    queryExpression43=queryExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = queryExpression43.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_queryExpression_in_queryExpression314);
                    queryExpression44=queryExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = queryExpression44.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:115:4: ^( INTERSECT ( ALL )? queryExpression queryExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    INTERSECT45=(CommonTree)match(input,INTERSECT,FOLLOW_INTERSECT_in_queryExpression321); 


                    if ( _first_0==null ) _first_0 = INTERSECT45;
                    match(input, Token.DOWN, null); 
                    // org/hibernate/hql/ast/render/QueryRenderer.g:115:16: ( ALL )?
                    int alt18=2;
                    int LA18_0 = input.LA(1);

                    if ( (LA18_0==ALL) ) {
                        alt18=1;
                    }
                    switch (alt18) {
                        case 1 :
                            // org/hibernate/hql/ast/render/QueryRenderer.g:115:16: ALL
                            {
                            _last = (CommonTree)input.LT(1);
                            ALL46=(CommonTree)match(input,ALL,FOLLOW_ALL_in_queryExpression323); 
                             
                            if ( _first_1==null ) _first_1 = ALL46;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_queryExpression_in_queryExpression326);
                    queryExpression47=queryExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = queryExpression47.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_queryExpression_in_queryExpression328);
                    queryExpression48=queryExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = queryExpression48.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:116:4: ^( EXCEPT ( ALL )? queryExpression queryExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    EXCEPT49=(CommonTree)match(input,EXCEPT,FOLLOW_EXCEPT_in_queryExpression335); 


                    if ( _first_0==null ) _first_0 = EXCEPT49;
                    match(input, Token.DOWN, null); 
                    // org/hibernate/hql/ast/render/QueryRenderer.g:116:13: ( ALL )?
                    int alt19=2;
                    int LA19_0 = input.LA(1);

                    if ( (LA19_0==ALL) ) {
                        alt19=1;
                    }
                    switch (alt19) {
                        case 1 :
                            // org/hibernate/hql/ast/render/QueryRenderer.g:116:13: ALL
                            {
                            _last = (CommonTree)input.LT(1);
                            ALL50=(CommonTree)match(input,ALL,FOLLOW_ALL_in_queryExpression337); 
                             
                            if ( _first_1==null ) _first_1 = ALL50;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_queryExpression_in_queryExpression340);
                    queryExpression51=queryExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = queryExpression51.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_queryExpression_in_queryExpression342);
                    queryExpression52=queryExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = queryExpression52.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:117:4: querySpec
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_querySpec_in_queryExpression348);
                    querySpec53=querySpec();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = querySpec53.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "queryExpression"


    public static class querySpec_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "querySpec"
    // org/hibernate/hql/ast/render/QueryRenderer.g:120:1: querySpec : ^( QUERY_SPEC selectFrom ( whereClause )? ( groupByClause )? ( havingClause )? ) ;
    public final QueryRenderer.querySpec_return querySpec() throws RecognitionException {
        QueryRenderer.querySpec_return retval = new QueryRenderer.querySpec_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree QUERY_SPEC54=null;
        QueryRenderer.selectFrom_return selectFrom55 =null;

        QueryRenderer.whereClause_return whereClause56 =null;

        QueryRenderer.groupByClause_return groupByClause57 =null;

        QueryRenderer.havingClause_return havingClause58 =null;


        CommonTree QUERY_SPEC54_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:121:2: ( ^( QUERY_SPEC selectFrom ( whereClause )? ( groupByClause )? ( havingClause )? ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:121:4: ^( QUERY_SPEC selectFrom ( whereClause )? ( groupByClause )? ( havingClause )? )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            QUERY_SPEC54=(CommonTree)match(input,QUERY_SPEC,FOLLOW_QUERY_SPEC_in_querySpec360); 


            if ( _first_0==null ) _first_0 = QUERY_SPEC54;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_selectFrom_in_querySpec362);
            selectFrom55=selectFrom();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = selectFrom55.tree;


            // org/hibernate/hql/ast/render/QueryRenderer.g:121:28: ( whereClause )?
            int alt21=2;
            int LA21_0 = input.LA(1);

            if ( (LA21_0==WHERE) ) {
                alt21=1;
            }
            switch (alt21) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:121:28: whereClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_whereClause_in_querySpec364);
                    whereClause56=whereClause();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = whereClause56.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            // org/hibernate/hql/ast/render/QueryRenderer.g:121:41: ( groupByClause )?
            int alt22=2;
            int LA22_0 = input.LA(1);

            if ( (LA22_0==GROUP_BY) ) {
                alt22=1;
            }
            switch (alt22) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:121:41: groupByClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_groupByClause_in_querySpec367);
                    groupByClause57=groupByClause();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = groupByClause57.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            // org/hibernate/hql/ast/render/QueryRenderer.g:121:56: ( havingClause )?
            int alt23=2;
            int LA23_0 = input.LA(1);

            if ( (LA23_0==HAVING) ) {
                alt23=1;
            }
            switch (alt23) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:121:56: havingClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_havingClause_in_querySpec370);
                    havingClause58=havingClause();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = havingClause58.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "querySpec"


    public static class whereClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "whereClause"
    // org/hibernate/hql/ast/render/QueryRenderer.g:124:1: whereClause : ^( WHERE searchCondition ) ;
    public final QueryRenderer.whereClause_return whereClause() throws RecognitionException {
        QueryRenderer.whereClause_return retval = new QueryRenderer.whereClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree WHERE59=null;
        QueryRenderer.searchCondition_return searchCondition60 =null;


        CommonTree WHERE59_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:125:2: ( ^( WHERE searchCondition ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:125:4: ^( WHERE searchCondition )
            {
             delegate.pushWhereStrategy(); 

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            WHERE59=(CommonTree)match(input,WHERE,FOLLOW_WHERE_in_whereClause386); 


            if ( _first_0==null ) _first_0 = WHERE59;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_searchCondition_in_whereClause388);
            searchCondition60=searchCondition();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = searchCondition60.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


             delegate.popStrategy(); 

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "whereClause"


    public static class groupByClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "groupByClause"
    // org/hibernate/hql/ast/render/QueryRenderer.g:128:1: groupByClause : ^( GROUP_BY ( groupingValue )+ ) ;
    public final QueryRenderer.groupByClause_return groupByClause() throws RecognitionException {
        QueryRenderer.groupByClause_return retval = new QueryRenderer.groupByClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree GROUP_BY61=null;
        QueryRenderer.groupingValue_return groupingValue62 =null;


        CommonTree GROUP_BY61_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:129:2: ( ^( GROUP_BY ( groupingValue )+ ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:129:4: ^( GROUP_BY ( groupingValue )+ )
            {
             delegate.pushGroupByStrategy(); 

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            GROUP_BY61=(CommonTree)match(input,GROUP_BY,FOLLOW_GROUP_BY_in_groupByClause405); 


            if ( _first_0==null ) _first_0 = GROUP_BY61;
            match(input, Token.DOWN, null); 
            // org/hibernate/hql/ast/render/QueryRenderer.g:129:51: ( groupingValue )+
            int cnt24=0;
            loop24:
            do {
                int alt24=2;
                int LA24_0 = input.LA(1);

                if ( (LA24_0==GROUPING_VALUE) ) {
                    alt24=1;
                }


                switch (alt24) {
            	case 1 :
            	    // org/hibernate/hql/ast/render/QueryRenderer.g:129:51: groupingValue
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_groupingValue_in_groupByClause407);
            	    groupingValue62=groupingValue();

            	    state._fsp--;

            	     
            	    if ( _first_1==null ) _first_1 = groupingValue62.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt24 >= 1 ) break loop24;
                        EarlyExitException eee =
                            new EarlyExitException(24, input);
                        throw eee;
                }
                cnt24++;
            } while (true);


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


             delegate.popStrategy(); 

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "groupByClause"


    public static class groupingValue_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "groupingValue"
    // org/hibernate/hql/ast/render/QueryRenderer.g:132:1: groupingValue : ^( GROUPING_VALUE valueExpression ( COLLATE )? ) ;
    public final QueryRenderer.groupingValue_return groupingValue() throws RecognitionException {
        QueryRenderer.groupingValue_return retval = new QueryRenderer.groupingValue_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree GROUPING_VALUE63=null;
        CommonTree COLLATE65=null;
        QueryRenderer.valueExpression_return valueExpression64 =null;


        CommonTree GROUPING_VALUE63_tree=null;
        CommonTree COLLATE65_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:133:2: ( ^( GROUPING_VALUE valueExpression ( COLLATE )? ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:133:4: ^( GROUPING_VALUE valueExpression ( COLLATE )? )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            GROUPING_VALUE63=(CommonTree)match(input,GROUPING_VALUE,FOLLOW_GROUPING_VALUE_in_groupingValue423); 


            if ( _first_0==null ) _first_0 = GROUPING_VALUE63;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_groupingValue425);
            valueExpression64=valueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = valueExpression64.tree;


            // org/hibernate/hql/ast/render/QueryRenderer.g:133:37: ( COLLATE )?
            int alt25=2;
            int LA25_0 = input.LA(1);

            if ( (LA25_0==COLLATE) ) {
                alt25=1;
            }
            switch (alt25) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:133:37: COLLATE
                    {
                    _last = (CommonTree)input.LT(1);
                    COLLATE65=(CommonTree)match(input,COLLATE,FOLLOW_COLLATE_in_groupingValue427); 
                     
                    if ( _first_1==null ) _first_1 = COLLATE65;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


             delegate.groupingValue( (COLLATE65!=null?COLLATE65.getText():null) ); 

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "groupingValue"


    public static class havingClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "havingClause"
    // org/hibernate/hql/ast/render/QueryRenderer.g:136:1: havingClause : ^( HAVING searchCondition ) ;
    public final QueryRenderer.havingClause_return havingClause() throws RecognitionException {
        QueryRenderer.havingClause_return retval = new QueryRenderer.havingClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree HAVING66=null;
        QueryRenderer.searchCondition_return searchCondition67 =null;


        CommonTree HAVING66_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:137:2: ( ^( HAVING searchCondition ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:137:4: ^( HAVING searchCondition )
            {
             delegate.pushHavingStrategy(); 

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            HAVING66=(CommonTree)match(input,HAVING,FOLLOW_HAVING_in_havingClause445); 


            if ( _first_0==null ) _first_0 = HAVING66;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_searchCondition_in_havingClause447);
            searchCondition67=searchCondition();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = searchCondition67.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


             delegate.popStrategy(); 

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "havingClause"


    public static class selectFrom_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "selectFrom"
    // org/hibernate/hql/ast/render/QueryRenderer.g:140:1: selectFrom : ^( SELECT_FROM fromClause selectClause ) ;
    public final QueryRenderer.selectFrom_return selectFrom() throws RecognitionException {
        QueryRenderer.selectFrom_return retval = new QueryRenderer.selectFrom_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SELECT_FROM68=null;
        QueryRenderer.fromClause_return fromClause69 =null;

        QueryRenderer.selectClause_return selectClause70 =null;


        CommonTree SELECT_FROM68_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:141:2: ( ^( SELECT_FROM fromClause selectClause ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:141:4: ^( SELECT_FROM fromClause selectClause )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            SELECT_FROM68=(CommonTree)match(input,SELECT_FROM,FOLLOW_SELECT_FROM_in_selectFrom462); 


            if ( _first_0==null ) _first_0 = SELECT_FROM68;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_fromClause_in_selectFrom464);
            fromClause69=fromClause();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = fromClause69.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_selectClause_in_selectFrom466);
            selectClause70=selectClause();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = selectClause70.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "selectFrom"


    public static class fromClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "fromClause"
    // org/hibernate/hql/ast/render/QueryRenderer.g:144:1: fromClause : ^( FROM ( persisterSpaces )+ ) ;
    public final QueryRenderer.fromClause_return fromClause() throws RecognitionException {
        QueryRenderer.fromClause_return retval = new QueryRenderer.fromClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree FROM71=null;
        QueryRenderer.persisterSpaces_return persisterSpaces72 =null;


        CommonTree FROM71_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:145:2: ( ^( FROM ( persisterSpaces )+ ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:145:4: ^( FROM ( persisterSpaces )+ )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            FROM71=(CommonTree)match(input,FROM,FOLLOW_FROM_in_fromClause479); 


            if ( _first_0==null ) _first_0 = FROM71;
            match(input, Token.DOWN, null); 
            // org/hibernate/hql/ast/render/QueryRenderer.g:145:11: ( persisterSpaces )+
            int cnt26=0;
            loop26:
            do {
                int alt26=2;
                int LA26_0 = input.LA(1);

                if ( (LA26_0==PERSISTER_SPACE) ) {
                    alt26=1;
                }


                switch (alt26) {
            	case 1 :
            	    // org/hibernate/hql/ast/render/QueryRenderer.g:145:11: persisterSpaces
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_persisterSpaces_in_fromClause481);
            	    persisterSpaces72=persisterSpaces();

            	    state._fsp--;

            	     
            	    if ( _first_1==null ) _first_1 = persisterSpaces72.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt26 >= 1 ) break loop26;
                        EarlyExitException eee =
                            new EarlyExitException(26, input);
                        throw eee;
                }
                cnt26++;
            } while (true);


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "fromClause"


    public static class persisterSpaces_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "persisterSpaces"
    // org/hibernate/hql/ast/render/QueryRenderer.g:148:1: persisterSpaces : ^( PERSISTER_SPACE persisterSpace ) ;
    public final QueryRenderer.persisterSpaces_return persisterSpaces() throws RecognitionException {
        QueryRenderer.persisterSpaces_return retval = new QueryRenderer.persisterSpaces_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree PERSISTER_SPACE73=null;
        QueryRenderer.persisterSpace_return persisterSpace74 =null;


        CommonTree PERSISTER_SPACE73_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:149:2: ( ^( PERSISTER_SPACE persisterSpace ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:149:4: ^( PERSISTER_SPACE persisterSpace )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            PERSISTER_SPACE73=(CommonTree)match(input,PERSISTER_SPACE,FOLLOW_PERSISTER_SPACE_in_persisterSpaces495); 


            if ( _first_0==null ) _first_0 = PERSISTER_SPACE73;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_persisterSpace_in_persisterSpaces497);
            persisterSpace74=persisterSpace();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = persisterSpace74.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "persisterSpaces"


    public static class persisterSpace_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "persisterSpace"
    // org/hibernate/hql/ast/render/QueryRenderer.g:152:1: persisterSpace : persisterSpaceRoot ( joins )* ;
    public final QueryRenderer.persisterSpace_return persisterSpace() throws RecognitionException {
        QueryRenderer.persisterSpace_return retval = new QueryRenderer.persisterSpace_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        QueryRenderer.persisterSpaceRoot_return persisterSpaceRoot75 =null;

        QueryRenderer.joins_return joins76 =null;



        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:153:2: ( persisterSpaceRoot ( joins )* )
            // org/hibernate/hql/ast/render/QueryRenderer.g:153:4: persisterSpaceRoot ( joins )*
            {
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_persisterSpaceRoot_in_persisterSpace509);
            persisterSpaceRoot75=persisterSpaceRoot();

            state._fsp--;

             
            if ( _first_0==null ) _first_0 = persisterSpaceRoot75.tree;


            // org/hibernate/hql/ast/render/QueryRenderer.g:153:23: ( joins )*
            loop27:
            do {
                int alt27=2;
                int LA27_0 = input.LA(1);

                if ( (LA27_0==PERSISTER_JOIN||LA27_0==PROPERTY_JOIN) ) {
                    alt27=1;
                }


                switch (alt27) {
            	case 1 :
            	    // org/hibernate/hql/ast/render/QueryRenderer.g:153:23: joins
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_joins_in_persisterSpace511);
            	    joins76=joins();

            	    state._fsp--;

            	     
            	    if ( _first_0==null ) _first_0 = joins76.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    break loop27;
                }
            } while (true);


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "persisterSpace"


    public static class persisterSpaceRoot_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "persisterSpaceRoot"
    // org/hibernate/hql/ast/render/QueryRenderer.g:156:1: persisterSpaceRoot : ^( ENTITY_PERSISTER_REF entityName ( PROP_FETCH )? ) ;
    public final QueryRenderer.persisterSpaceRoot_return persisterSpaceRoot() throws RecognitionException {
        QueryRenderer.persisterSpaceRoot_return retval = new QueryRenderer.persisterSpaceRoot_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ENTITY_PERSISTER_REF77=null;
        CommonTree PROP_FETCH79=null;
        QueryRenderer.entityName_return entityName78 =null;


        CommonTree ENTITY_PERSISTER_REF77_tree=null;
        CommonTree PROP_FETCH79_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:157:2: ( ^( ENTITY_PERSISTER_REF entityName ( PROP_FETCH )? ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:157:4: ^( ENTITY_PERSISTER_REF entityName ( PROP_FETCH )? )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            ENTITY_PERSISTER_REF77=(CommonTree)match(input,ENTITY_PERSISTER_REF,FOLLOW_ENTITY_PERSISTER_REF_in_persisterSpaceRoot524); 


            if ( _first_0==null ) _first_0 = ENTITY_PERSISTER_REF77;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_entityName_in_persisterSpaceRoot526);
            entityName78=entityName();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = entityName78.tree;


            // org/hibernate/hql/ast/render/QueryRenderer.g:157:38: ( PROP_FETCH )?
            int alt28=2;
            int LA28_0 = input.LA(1);

            if ( (LA28_0==PROP_FETCH) ) {
                alt28=1;
            }
            switch (alt28) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:157:38: PROP_FETCH
                    {
                    _last = (CommonTree)input.LT(1);
                    PROP_FETCH79=(CommonTree)match(input,PROP_FETCH,FOLLOW_PROP_FETCH_in_persisterSpaceRoot528); 
                     
                    if ( _first_1==null ) _first_1 = PROP_FETCH79;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "persisterSpaceRoot"


    public static class joins_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "joins"
    // org/hibernate/hql/ast/render/QueryRenderer.g:160:1: joins : ( ^( PROPERTY_JOIN jt= joinType (ft= FETCH )? an= ALIAS_NAME (pf= PROP_FETCH )? ( collectionExpression | joinPropertyReference[$an] ) ( withClause )? ) | ^( PERSISTER_JOIN joinType persisterSpaceRoot ( onClause )? ) );
    public final QueryRenderer.joins_return joins() throws RecognitionException {
        QueryRenderer.joins_return retval = new QueryRenderer.joins_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ft=null;
        CommonTree an=null;
        CommonTree pf=null;
        CommonTree PROPERTY_JOIN80=null;
        CommonTree PERSISTER_JOIN84=null;
        QueryRenderer.joinType_return jt =null;

        QueryRenderer.collectionExpression_return collectionExpression81 =null;

        QueryRenderer.joinPropertyReference_return joinPropertyReference82 =null;

        QueryRenderer.withClause_return withClause83 =null;

        QueryRenderer.joinType_return joinType85 =null;

        QueryRenderer.persisterSpaceRoot_return persisterSpaceRoot86 =null;

        QueryRenderer.onClause_return onClause87 =null;


        CommonTree ft_tree=null;
        CommonTree an_tree=null;
        CommonTree pf_tree=null;
        CommonTree PROPERTY_JOIN80_tree=null;
        CommonTree PERSISTER_JOIN84_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:161:2: ( ^( PROPERTY_JOIN jt= joinType (ft= FETCH )? an= ALIAS_NAME (pf= PROP_FETCH )? ( collectionExpression | joinPropertyReference[$an] ) ( withClause )? ) | ^( PERSISTER_JOIN joinType persisterSpaceRoot ( onClause )? ) )
            int alt34=2;
            int LA34_0 = input.LA(1);

            if ( (LA34_0==PROPERTY_JOIN) ) {
                alt34=1;
            }
            else if ( (LA34_0==PERSISTER_JOIN) ) {
                alt34=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 34, 0, input);

                throw nvae;

            }
            switch (alt34) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:161:4: ^( PROPERTY_JOIN jt= joinType (ft= FETCH )? an= ALIAS_NAME (pf= PROP_FETCH )? ( collectionExpression | joinPropertyReference[$an] ) ( withClause )? )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    PROPERTY_JOIN80=(CommonTree)match(input,PROPERTY_JOIN,FOLLOW_PROPERTY_JOIN_in_joins542); 


                    if ( _first_0==null ) _first_0 = PROPERTY_JOIN80;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_joinType_in_joins546);
                    jt=joinType();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = jt.tree;


                    // org/hibernate/hql/ast/render/QueryRenderer.g:161:34: (ft= FETCH )?
                    int alt29=2;
                    int LA29_0 = input.LA(1);

                    if ( (LA29_0==FETCH) ) {
                        alt29=1;
                    }
                    switch (alt29) {
                        case 1 :
                            // org/hibernate/hql/ast/render/QueryRenderer.g:161:34: ft= FETCH
                            {
                            _last = (CommonTree)input.LT(1);
                            ft=(CommonTree)match(input,FETCH,FOLLOW_FETCH_in_joins550); 
                             
                            if ( _first_1==null ) _first_1 = ft;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    _last = (CommonTree)input.LT(1);
                    an=(CommonTree)match(input,ALIAS_NAME,FOLLOW_ALIAS_NAME_in_joins555); 
                     
                    if ( _first_1==null ) _first_1 = an;


                    // org/hibernate/hql/ast/render/QueryRenderer.g:161:58: (pf= PROP_FETCH )?
                    int alt30=2;
                    int LA30_0 = input.LA(1);

                    if ( (LA30_0==PROP_FETCH) ) {
                        alt30=1;
                    }
                    switch (alt30) {
                        case 1 :
                            // org/hibernate/hql/ast/render/QueryRenderer.g:161:58: pf= PROP_FETCH
                            {
                            _last = (CommonTree)input.LT(1);
                            pf=(CommonTree)match(input,PROP_FETCH,FOLLOW_PROP_FETCH_in_joins559); 
                             
                            if ( _first_1==null ) _first_1 = pf;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    	delegate.pushFromStrategy((jt!=null?jt.joinType:null), ft, pf, an );	

                    // org/hibernate/hql/ast/render/QueryRenderer.g:163:3: ( collectionExpression | joinPropertyReference[$an] )
                    int alt31=2;
                    int LA31_0 = input.LA(1);

                    if ( (LA31_0==ELEMENTS||LA31_0==INDICES) ) {
                        alt31=1;
                    }
                    else if ( (LA31_0==PATH) ) {
                        alt31=2;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("", 31, 0, input);

                        throw nvae;

                    }
                    switch (alt31) {
                        case 1 :
                            // org/hibernate/hql/ast/render/QueryRenderer.g:163:4: collectionExpression
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_collectionExpression_in_joins569);
                            collectionExpression81=collectionExpression();

                            state._fsp--;

                             
                            if ( _first_1==null ) _first_1 = collectionExpression81.tree;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;
                        case 2 :
                            // org/hibernate/hql/ast/render/QueryRenderer.g:163:25: joinPropertyReference[$an]
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_joinPropertyReference_in_joins571);
                            joinPropertyReference82=joinPropertyReference(an);

                            state._fsp--;

                             
                            if ( _first_1==null ) _first_1 = joinPropertyReference82.tree;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    // org/hibernate/hql/ast/render/QueryRenderer.g:163:53: ( withClause )?
                    int alt32=2;
                    int LA32_0 = input.LA(1);

                    if ( (LA32_0==WITH) ) {
                        alt32=1;
                    }
                    switch (alt32) {
                        case 1 :
                            // org/hibernate/hql/ast/render/QueryRenderer.g:163:53: withClause
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_withClause_in_joins575);
                            withClause83=withClause();

                            state._fsp--;

                             
                            if ( _first_1==null ) _first_1 = withClause83.tree;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    	delegate.popStrategy();	

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:165:4: ^( PERSISTER_JOIN joinType persisterSpaceRoot ( onClause )? )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    PERSISTER_JOIN84=(CommonTree)match(input,PERSISTER_JOIN,FOLLOW_PERSISTER_JOIN_in_joins587); 


                    if ( _first_0==null ) _first_0 = PERSISTER_JOIN84;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_joinType_in_joins589);
                    joinType85=joinType();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = joinType85.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_persisterSpaceRoot_in_joins591);
                    persisterSpaceRoot86=persisterSpaceRoot();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = persisterSpaceRoot86.tree;


                    // org/hibernate/hql/ast/render/QueryRenderer.g:165:49: ( onClause )?
                    int alt33=2;
                    int LA33_0 = input.LA(1);

                    if ( (LA33_0==ON) ) {
                        alt33=1;
                    }
                    switch (alt33) {
                        case 1 :
                            // org/hibernate/hql/ast/render/QueryRenderer.g:165:49: onClause
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_onClause_in_joins593);
                            onClause87=onClause();

                            state._fsp--;

                             
                            if ( _first_1==null ) _first_1 = onClause87.tree;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "joins"


    public static class withClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "withClause"
    // org/hibernate/hql/ast/render/QueryRenderer.g:168:1: withClause : ^( WITH searchCondition ) ;
    public final QueryRenderer.withClause_return withClause() throws RecognitionException {
        QueryRenderer.withClause_return retval = new QueryRenderer.withClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree WITH88=null;
        QueryRenderer.searchCondition_return searchCondition89 =null;


        CommonTree WITH88_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:169:2: ( ^( WITH searchCondition ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:169:4: ^( WITH searchCondition )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            WITH88=(CommonTree)match(input,WITH,FOLLOW_WITH_in_withClause607); 


            if ( _first_0==null ) _first_0 = WITH88;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_searchCondition_in_withClause609);
            searchCondition89=searchCondition();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = searchCondition89.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "withClause"


    public static class onClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "onClause"
    // org/hibernate/hql/ast/render/QueryRenderer.g:172:1: onClause : ^( ON searchCondition ) ;
    public final QueryRenderer.onClause_return onClause() throws RecognitionException {
        QueryRenderer.onClause_return retval = new QueryRenderer.onClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ON90=null;
        QueryRenderer.searchCondition_return searchCondition91 =null;


        CommonTree ON90_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:173:2: ( ^( ON searchCondition ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:173:4: ^( ON searchCondition )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            ON90=(CommonTree)match(input,ON,FOLLOW_ON_in_onClause622); 


            if ( _first_0==null ) _first_0 = ON90;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_searchCondition_in_onClause624);
            searchCondition91=searchCondition();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = searchCondition91.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "onClause"


    public static class joinType_return extends TreeRuleReturnScope {
        public JoinType joinType;
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "joinType"
    // org/hibernate/hql/ast/render/QueryRenderer.g:176:1: joinType returns [JoinType joinType] : ( CROSS | INNER | ( LEFT | RIGHT | FULL ) ( OUTER )? );
    public final QueryRenderer.joinType_return joinType() throws RecognitionException {
        QueryRenderer.joinType_return retval = new QueryRenderer.joinType_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree CROSS92=null;
        CommonTree INNER93=null;
        CommonTree LEFT94=null;
        CommonTree RIGHT95=null;
        CommonTree FULL96=null;
        CommonTree OUTER97=null;

        CommonTree CROSS92_tree=null;
        CommonTree INNER93_tree=null;
        CommonTree LEFT94_tree=null;
        CommonTree RIGHT95_tree=null;
        CommonTree FULL96_tree=null;
        CommonTree OUTER97_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:177:2: ( CROSS | INNER | ( LEFT | RIGHT | FULL ) ( OUTER )? )
            int alt37=3;
            switch ( input.LA(1) ) {
            case CROSS:
                {
                alt37=1;
                }
                break;
            case INNER:
                {
                alt37=2;
                }
                break;
            case FULL:
            case LEFT:
            case RIGHT:
                {
                alt37=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 37, 0, input);

                throw nvae;

            }

            switch (alt37) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:177:4: CROSS
                    {
                    _last = (CommonTree)input.LT(1);
                    CROSS92=(CommonTree)match(input,CROSS,FOLLOW_CROSS_in_joinType640); 
                     
                    if ( _first_0==null ) _first_0 = CROSS92;


                    	retval.joinType = JoinType.CROSS;	

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:178:4: INNER
                    {
                    _last = (CommonTree)input.LT(1);
                    INNER93=(CommonTree)match(input,INNER,FOLLOW_INNER_in_joinType647); 
                     
                    if ( _first_0==null ) _first_0 = INNER93;


                    	retval.joinType = JoinType.INNER;	

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:179:4: ( LEFT | RIGHT | FULL ) ( OUTER )?
                    {
                    // org/hibernate/hql/ast/render/QueryRenderer.g:179:4: ( LEFT | RIGHT | FULL )
                    int alt35=3;
                    switch ( input.LA(1) ) {
                    case LEFT:
                        {
                        alt35=1;
                        }
                        break;
                    case RIGHT:
                        {
                        alt35=2;
                        }
                        break;
                    case FULL:
                        {
                        alt35=3;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 35, 0, input);

                        throw nvae;

                    }

                    switch (alt35) {
                        case 1 :
                            // org/hibernate/hql/ast/render/QueryRenderer.g:179:5: LEFT
                            {
                            _last = (CommonTree)input.LT(1);
                            LEFT94=(CommonTree)match(input,LEFT,FOLLOW_LEFT_in_joinType655); 
                             
                            if ( _first_0==null ) _first_0 = LEFT94;


                            	retval.joinType = JoinType.LEFT;	

                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;
                        case 2 :
                            // org/hibernate/hql/ast/render/QueryRenderer.g:179:43: RIGHT
                            {
                            _last = (CommonTree)input.LT(1);
                            RIGHT95=(CommonTree)match(input,RIGHT,FOLLOW_RIGHT_in_joinType661); 
                             
                            if ( _first_0==null ) _first_0 = RIGHT95;


                            	retval.joinType = JoinType.RIGHT;	

                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;
                        case 3 :
                            // org/hibernate/hql/ast/render/QueryRenderer.g:179:83: FULL
                            {
                            _last = (CommonTree)input.LT(1);
                            FULL96=(CommonTree)match(input,FULL,FOLLOW_FULL_in_joinType667); 
                             
                            if ( _first_0==null ) _first_0 = FULL96;


                            	retval.joinType = JoinType.FULL;	

                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    // org/hibernate/hql/ast/render/QueryRenderer.g:179:120: ( OUTER )?
                    int alt36=2;
                    int LA36_0 = input.LA(1);

                    if ( (LA36_0==OUTER) ) {
                        alt36=1;
                    }
                    switch (alt36) {
                        case 1 :
                            // org/hibernate/hql/ast/render/QueryRenderer.g:179:120: OUTER
                            {
                            _last = (CommonTree)input.LT(1);
                            OUTER97=(CommonTree)match(input,OUTER,FOLLOW_OUTER_in_joinType672); 
                             
                            if ( _first_0==null ) _first_0 = OUTER97;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "joinType"


    public static class selectClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "selectClause"
    // org/hibernate/hql/ast/render/QueryRenderer.g:182:1: selectClause : ^( SELECT ( DISTINCT )? rootSelectExpression ) ;
    public final QueryRenderer.selectClause_return selectClause() throws RecognitionException {
        QueryRenderer.selectClause_return retval = new QueryRenderer.selectClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SELECT98=null;
        CommonTree DISTINCT99=null;
        QueryRenderer.rootSelectExpression_return rootSelectExpression100 =null;


        CommonTree SELECT98_tree=null;
        CommonTree DISTINCT99_tree=null;

        	if (state.backtracking == 0) delegate.pushSelectStrategy();	
        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:185:2: ( ^( SELECT ( DISTINCT )? rootSelectExpression ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:185:4: ^( SELECT ( DISTINCT )? rootSelectExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            SELECT98=(CommonTree)match(input,SELECT,FOLLOW_SELECT_in_selectClause695); 


            if ( _first_0==null ) _first_0 = SELECT98;
            match(input, Token.DOWN, null); 
            // org/hibernate/hql/ast/render/QueryRenderer.g:185:13: ( DISTINCT )?
            int alt38=2;
            int LA38_0 = input.LA(1);

            if ( (LA38_0==DISTINCT) ) {
                alt38=1;
            }
            switch (alt38) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:185:13: DISTINCT
                    {
                    _last = (CommonTree)input.LT(1);
                    DISTINCT99=(CommonTree)match(input,DISTINCT,FOLLOW_DISTINCT_in_selectClause697); 
                     
                    if ( _first_1==null ) _first_1 = DISTINCT99;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_rootSelectExpression_in_selectClause700);
            rootSelectExpression100=rootSelectExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = rootSelectExpression100.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

            	delegate.popStrategy();	
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "selectClause"


    public static class rootSelectExpression_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "rootSelectExpression"
    // org/hibernate/hql/ast/render/QueryRenderer.g:188:1: rootSelectExpression : ( ^( SELECT_LIST ( rootSelectExpression )+ ) | ^( SELECT_ITEM rootSelectExpression ) | ^( DYNAMIC_INSTANTIATION ( rootSelectExpression )+ ) | ^( DYNAMIC_INSTANTIATION_ARG rootSelectExpression ) | valueExpression ( ALIAS_NAME )? );
    public final QueryRenderer.rootSelectExpression_return rootSelectExpression() throws RecognitionException {
        QueryRenderer.rootSelectExpression_return retval = new QueryRenderer.rootSelectExpression_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SELECT_LIST101=null;
        CommonTree SELECT_ITEM103=null;
        CommonTree DYNAMIC_INSTANTIATION105=null;
        CommonTree DYNAMIC_INSTANTIATION_ARG107=null;
        CommonTree ALIAS_NAME110=null;
        QueryRenderer.rootSelectExpression_return rootSelectExpression102 =null;

        QueryRenderer.rootSelectExpression_return rootSelectExpression104 =null;

        QueryRenderer.rootSelectExpression_return rootSelectExpression106 =null;

        QueryRenderer.rootSelectExpression_return rootSelectExpression108 =null;

        QueryRenderer.valueExpression_return valueExpression109 =null;


        CommonTree SELECT_LIST101_tree=null;
        CommonTree SELECT_ITEM103_tree=null;
        CommonTree DYNAMIC_INSTANTIATION105_tree=null;
        CommonTree DYNAMIC_INSTANTIATION_ARG107_tree=null;
        CommonTree ALIAS_NAME110_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:189:2: ( ^( SELECT_LIST ( rootSelectExpression )+ ) | ^( SELECT_ITEM rootSelectExpression ) | ^( DYNAMIC_INSTANTIATION ( rootSelectExpression )+ ) | ^( DYNAMIC_INSTANTIATION_ARG rootSelectExpression ) | valueExpression ( ALIAS_NAME )? )
            int alt42=5;
            switch ( input.LA(1) ) {
            case SELECT_LIST:
                {
                alt42=1;
                }
                break;
            case SELECT_ITEM:
                {
                alt42=2;
                }
                break;
            case DYNAMIC_INSTANTIATION:
                {
                alt42=3;
                }
                break;
            case DYNAMIC_INSTANTIATION_ARG:
                {
                alt42=4;
                }
                break;
            case ABS:
            case ALIAS_REF:
            case ALL:
            case ANY:
            case ASTERISK:
            case AVG:
            case BIT_LENGTH:
            case CAST:
            case CHARACTER_LENGTH:
            case CHARACTER_LITERAL:
            case COALESCE:
            case CONCAT:
            case CONST_STRING_VALUE:
            case COUNT:
            case CURRENT_DATE:
            case CURRENT_TIME:
            case CURRENT_TIMESTAMP:
            case DECIMAL_LITERAL:
            case DOT_CLASS:
            case DOUBLE_PIPE:
            case ELEMENTS:
            case EXISTS:
            case EXTRACT:
            case FALSE:
            case FLOATING_POINT_LITERAL:
            case FUNCTION:
            case HEX_LITERAL:
            case INDEX:
            case INDICES:
            case INTEGER_LITERAL:
            case JAVA_CONSTANT:
            case JPA_PARAM:
            case LENGTH:
            case LOCATE:
            case LOWER:
            case MAX:
            case MAXELEMENT:
            case MAXINDEX:
            case MIN:
            case MINELEMENT:
            case MININDEX:
            case MINUS:
            case MOD:
            case NAMED_PARAM:
            case NULL:
            case NULLIF:
            case OCTAL_LITERAL:
            case OCTET_LENGTH:
            case PARAM:
            case PATH:
            case PLUS:
            case POSITION:
            case PROPERTY_REFERENCE:
            case SEARCHED_CASE:
            case SIMPLE_CASE:
            case SIZE:
            case SOLIDUS:
            case SOME:
            case SQRT:
            case STRING_LITERAL:
            case SUBSTRING:
            case SUB_QUERY:
            case SUM:
            case TRIM:
            case TRUE:
            case UNARY_MINUS:
            case UNARY_PLUS:
            case UPPER:
            case VECTOR_EXPR:
                {
                alt42=5;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 42, 0, input);

                throw nvae;

            }

            switch (alt42) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:189:4: ^( SELECT_LIST ( rootSelectExpression )+ )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    SELECT_LIST101=(CommonTree)match(input,SELECT_LIST,FOLLOW_SELECT_LIST_in_rootSelectExpression713); 


                    if ( _first_0==null ) _first_0 = SELECT_LIST101;
                    match(input, Token.DOWN, null); 
                    // org/hibernate/hql/ast/render/QueryRenderer.g:189:18: ( rootSelectExpression )+
                    int cnt39=0;
                    loop39:
                    do {
                        int alt39=2;
                        int LA39_0 = input.LA(1);

                        if ( (LA39_0==ABS||(LA39_0 >= ALIAS_REF && LA39_0 <= ALL)||LA39_0==ANY||(LA39_0 >= ASTERISK && LA39_0 <= AVG)||LA39_0==BIT_LENGTH||(LA39_0 >= CAST && LA39_0 <= CHARACTER_LITERAL)||LA39_0==COALESCE||(LA39_0 >= CONCAT && LA39_0 <= COUNT)||(LA39_0 >= CURRENT_DATE && LA39_0 <= CURRENT_TIMESTAMP)||LA39_0==DECIMAL_LITERAL||(LA39_0 >= DOT_CLASS && LA39_0 <= DYNAMIC_INSTANTIATION_ARG)||LA39_0==ELEMENTS||LA39_0==EXISTS||LA39_0==EXTRACT||LA39_0==FALSE||LA39_0==FLOATING_POINT_LITERAL||LA39_0==FUNCTION||LA39_0==HEX_LITERAL||(LA39_0 >= INDEX && LA39_0 <= INDICES)||LA39_0==INTEGER_LITERAL||LA39_0==JAVA_CONSTANT||LA39_0==JPA_PARAM||LA39_0==LENGTH||(LA39_0 >= LOCATE && LA39_0 <= LOWER)||(LA39_0 >= MAX && LA39_0 <= MAXINDEX)||(LA39_0 >= MIN && LA39_0 <= MINUS)||LA39_0==MOD||LA39_0==NAMED_PARAM||(LA39_0 >= NULL && LA39_0 <= NULLIF)||(LA39_0 >= OCTAL_LITERAL && LA39_0 <= OCTET_LENGTH)||(LA39_0 >= PARAM && LA39_0 <= PATH)||(LA39_0 >= PLUS && LA39_0 <= POSITION)||LA39_0==PROPERTY_REFERENCE||LA39_0==SEARCHED_CASE||(LA39_0 >= SELECT_ITEM && LA39_0 <= SELECT_LIST)||(LA39_0 >= SIMPLE_CASE && LA39_0 <= SOME)||(LA39_0 >= SQRT && LA39_0 <= SUM)||(LA39_0 >= TRIM && LA39_0 <= TRUE)||(LA39_0 >= UNARY_MINUS && LA39_0 <= UNARY_PLUS)||LA39_0==UPPER||LA39_0==VECTOR_EXPR) ) {
                            alt39=1;
                        }


                        switch (alt39) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/render/QueryRenderer.g:189:18: rootSelectExpression
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    pushFollow(FOLLOW_rootSelectExpression_in_rootSelectExpression715);
                    	    rootSelectExpression102=rootSelectExpression();

                    	    state._fsp--;

                    	     
                    	    if ( _first_1==null ) _first_1 = rootSelectExpression102.tree;


                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt39 >= 1 ) break loop39;
                                EarlyExitException eee =
                                    new EarlyExitException(39, input);
                                throw eee;
                        }
                        cnt39++;
                    } while (true);


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:190:4: ^( SELECT_ITEM rootSelectExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    SELECT_ITEM103=(CommonTree)match(input,SELECT_ITEM,FOLLOW_SELECT_ITEM_in_rootSelectExpression723); 


                    if ( _first_0==null ) _first_0 = SELECT_ITEM103;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rootSelectExpression_in_rootSelectExpression725);
                    rootSelectExpression104=rootSelectExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rootSelectExpression104.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:191:4: ^( DYNAMIC_INSTANTIATION ( rootSelectExpression )+ )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    DYNAMIC_INSTANTIATION105=(CommonTree)match(input,DYNAMIC_INSTANTIATION,FOLLOW_DYNAMIC_INSTANTIATION_in_rootSelectExpression732); 


                    if ( _first_0==null ) _first_0 = DYNAMIC_INSTANTIATION105;
                    match(input, Token.DOWN, null); 
                    // org/hibernate/hql/ast/render/QueryRenderer.g:191:28: ( rootSelectExpression )+
                    int cnt40=0;
                    loop40:
                    do {
                        int alt40=2;
                        int LA40_0 = input.LA(1);

                        if ( (LA40_0==ABS||(LA40_0 >= ALIAS_REF && LA40_0 <= ALL)||LA40_0==ANY||(LA40_0 >= ASTERISK && LA40_0 <= AVG)||LA40_0==BIT_LENGTH||(LA40_0 >= CAST && LA40_0 <= CHARACTER_LITERAL)||LA40_0==COALESCE||(LA40_0 >= CONCAT && LA40_0 <= COUNT)||(LA40_0 >= CURRENT_DATE && LA40_0 <= CURRENT_TIMESTAMP)||LA40_0==DECIMAL_LITERAL||(LA40_0 >= DOT_CLASS && LA40_0 <= DYNAMIC_INSTANTIATION_ARG)||LA40_0==ELEMENTS||LA40_0==EXISTS||LA40_0==EXTRACT||LA40_0==FALSE||LA40_0==FLOATING_POINT_LITERAL||LA40_0==FUNCTION||LA40_0==HEX_LITERAL||(LA40_0 >= INDEX && LA40_0 <= INDICES)||LA40_0==INTEGER_LITERAL||LA40_0==JAVA_CONSTANT||LA40_0==JPA_PARAM||LA40_0==LENGTH||(LA40_0 >= LOCATE && LA40_0 <= LOWER)||(LA40_0 >= MAX && LA40_0 <= MAXINDEX)||(LA40_0 >= MIN && LA40_0 <= MINUS)||LA40_0==MOD||LA40_0==NAMED_PARAM||(LA40_0 >= NULL && LA40_0 <= NULLIF)||(LA40_0 >= OCTAL_LITERAL && LA40_0 <= OCTET_LENGTH)||(LA40_0 >= PARAM && LA40_0 <= PATH)||(LA40_0 >= PLUS && LA40_0 <= POSITION)||LA40_0==PROPERTY_REFERENCE||LA40_0==SEARCHED_CASE||(LA40_0 >= SELECT_ITEM && LA40_0 <= SELECT_LIST)||(LA40_0 >= SIMPLE_CASE && LA40_0 <= SOME)||(LA40_0 >= SQRT && LA40_0 <= SUM)||(LA40_0 >= TRIM && LA40_0 <= TRUE)||(LA40_0 >= UNARY_MINUS && LA40_0 <= UNARY_PLUS)||LA40_0==UPPER||LA40_0==VECTOR_EXPR) ) {
                            alt40=1;
                        }


                        switch (alt40) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/render/QueryRenderer.g:191:28: rootSelectExpression
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    pushFollow(FOLLOW_rootSelectExpression_in_rootSelectExpression734);
                    	    rootSelectExpression106=rootSelectExpression();

                    	    state._fsp--;

                    	     
                    	    if ( _first_1==null ) _first_1 = rootSelectExpression106.tree;


                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt40 >= 1 ) break loop40;
                                EarlyExitException eee =
                                    new EarlyExitException(40, input);
                                throw eee;
                        }
                        cnt40++;
                    } while (true);


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:192:4: ^( DYNAMIC_INSTANTIATION_ARG rootSelectExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    DYNAMIC_INSTANTIATION_ARG107=(CommonTree)match(input,DYNAMIC_INSTANTIATION_ARG,FOLLOW_DYNAMIC_INSTANTIATION_ARG_in_rootSelectExpression742); 


                    if ( _first_0==null ) _first_0 = DYNAMIC_INSTANTIATION_ARG107;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rootSelectExpression_in_rootSelectExpression744);
                    rootSelectExpression108=rootSelectExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rootSelectExpression108.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:193:4: valueExpression ( ALIAS_NAME )?
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_rootSelectExpression750);
                    valueExpression109=valueExpression();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = valueExpression109.tree;


                    // org/hibernate/hql/ast/render/QueryRenderer.g:193:20: ( ALIAS_NAME )?
                    int alt41=2;
                    int LA41_0 = input.LA(1);

                    if ( (LA41_0==ALIAS_NAME) ) {
                        alt41=1;
                    }
                    switch (alt41) {
                        case 1 :
                            // org/hibernate/hql/ast/render/QueryRenderer.g:193:20: ALIAS_NAME
                            {
                            _last = (CommonTree)input.LT(1);
                            ALIAS_NAME110=(CommonTree)match(input,ALIAS_NAME,FOLLOW_ALIAS_NAME_in_rootSelectExpression752); 
                             
                            if ( _first_0==null ) _first_0 = ALIAS_NAME110;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "rootSelectExpression"


    public static class orderByClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "orderByClause"
    // org/hibernate/hql/ast/render/QueryRenderer.g:196:1: orderByClause : ^( ORDER_BY ( sortSpecification )+ ) ;
    public final QueryRenderer.orderByClause_return orderByClause() throws RecognitionException {
        QueryRenderer.orderByClause_return retval = new QueryRenderer.orderByClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ORDER_BY111=null;
        QueryRenderer.sortSpecification_return sortSpecification112 =null;


        CommonTree ORDER_BY111_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:197:2: ( ^( ORDER_BY ( sortSpecification )+ ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:197:4: ^( ORDER_BY ( sortSpecification )+ )
            {
             delegate.pushOrderByStrategy(); 

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            ORDER_BY111=(CommonTree)match(input,ORDER_BY,FOLLOW_ORDER_BY_in_orderByClause767); 


            if ( _first_0==null ) _first_0 = ORDER_BY111;
            match(input, Token.DOWN, null); 
            // org/hibernate/hql/ast/render/QueryRenderer.g:197:51: ( sortSpecification )+
            int cnt43=0;
            loop43:
            do {
                int alt43=2;
                int LA43_0 = input.LA(1);

                if ( (LA43_0==SORT_SPEC) ) {
                    alt43=1;
                }


                switch (alt43) {
            	case 1 :
            	    // org/hibernate/hql/ast/render/QueryRenderer.g:197:51: sortSpecification
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_sortSpecification_in_orderByClause769);
            	    sortSpecification112=sortSpecification();

            	    state._fsp--;

            	     
            	    if ( _first_1==null ) _first_1 = sortSpecification112.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt43 >= 1 ) break loop43;
                        EarlyExitException eee =
                            new EarlyExitException(43, input);
                        throw eee;
                }
                cnt43++;
            } while (true);


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


             delegate.popStrategy(); 

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "orderByClause"


    public static class sortSpecification_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "sortSpecification"
    // org/hibernate/hql/ast/render/QueryRenderer.g:200:1: sortSpecification : ^( SORT_SPEC valueExpression ( COLLATE )? ORDER_SPEC ) ;
    public final QueryRenderer.sortSpecification_return sortSpecification() throws RecognitionException {
        QueryRenderer.sortSpecification_return retval = new QueryRenderer.sortSpecification_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SORT_SPEC113=null;
        CommonTree COLLATE115=null;
        CommonTree ORDER_SPEC116=null;
        QueryRenderer.valueExpression_return valueExpression114 =null;


        CommonTree SORT_SPEC113_tree=null;
        CommonTree COLLATE115_tree=null;
        CommonTree ORDER_SPEC116_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:201:2: ( ^( SORT_SPEC valueExpression ( COLLATE )? ORDER_SPEC ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:201:4: ^( SORT_SPEC valueExpression ( COLLATE )? ORDER_SPEC )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            SORT_SPEC113=(CommonTree)match(input,SORT_SPEC,FOLLOW_SORT_SPEC_in_sortSpecification785); 


            if ( _first_0==null ) _first_0 = SORT_SPEC113;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_sortSpecification787);
            valueExpression114=valueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = valueExpression114.tree;


            // org/hibernate/hql/ast/render/QueryRenderer.g:201:32: ( COLLATE )?
            int alt44=2;
            int LA44_0 = input.LA(1);

            if ( (LA44_0==COLLATE) ) {
                alt44=1;
            }
            switch (alt44) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:201:32: COLLATE
                    {
                    _last = (CommonTree)input.LT(1);
                    COLLATE115=(CommonTree)match(input,COLLATE,FOLLOW_COLLATE_in_sortSpecification789); 
                     
                    if ( _first_1==null ) _first_1 = COLLATE115;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            _last = (CommonTree)input.LT(1);
            ORDER_SPEC116=(CommonTree)match(input,ORDER_SPEC,FOLLOW_ORDER_SPEC_in_sortSpecification792); 
             
            if ( _first_1==null ) _first_1 = ORDER_SPEC116;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


             delegate.sortSpecification( (COLLATE115!=null?COLLATE115.getText():null), (ORDER_SPEC116!=null?ORDER_SPEC116.getText():null) ); 

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "sortSpecification"


    public static class searchCondition_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "searchCondition"
    // org/hibernate/hql/ast/render/QueryRenderer.g:204:1: searchCondition : ( ^( OR searchCondition searchCondition ) | ^( AND searchCondition searchCondition ) | ^( NOT searchCondition ) | predicate );
    public final QueryRenderer.searchCondition_return searchCondition() throws RecognitionException {
        QueryRenderer.searchCondition_return retval = new QueryRenderer.searchCondition_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree OR117=null;
        CommonTree AND120=null;
        CommonTree NOT123=null;
        QueryRenderer.searchCondition_return searchCondition118 =null;

        QueryRenderer.searchCondition_return searchCondition119 =null;

        QueryRenderer.searchCondition_return searchCondition121 =null;

        QueryRenderer.searchCondition_return searchCondition122 =null;

        QueryRenderer.searchCondition_return searchCondition124 =null;

        QueryRenderer.predicate_return predicate125 =null;


        CommonTree OR117_tree=null;
        CommonTree AND120_tree=null;
        CommonTree NOT123_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:205:2: ( ^( OR searchCondition searchCondition ) | ^( AND searchCondition searchCondition ) | ^( NOT searchCondition ) | predicate )
            int alt45=4;
            switch ( input.LA(1) ) {
            case OR:
                {
                alt45=1;
                }
                break;
            case AND:
                {
                alt45=2;
                }
                break;
            case NOT:
                {
                alt45=3;
                }
                break;
            case ABS:
            case ALIAS_REF:
            case ALL:
            case ANY:
            case ASTERISK:
            case AVG:
            case BETWEEN:
            case BIT_LENGTH:
            case CAST:
            case CHARACTER_LENGTH:
            case CHARACTER_LITERAL:
            case COALESCE:
            case CONCAT:
            case CONST_STRING_VALUE:
            case COUNT:
            case CURRENT_DATE:
            case CURRENT_TIME:
            case CURRENT_TIMESTAMP:
            case DECIMAL_LITERAL:
            case DOT_CLASS:
            case DOUBLE_PIPE:
            case ELEMENTS:
            case EQUALS:
            case EXISTS:
            case EXTRACT:
            case FALSE:
            case FLOATING_POINT_LITERAL:
            case FUNCTION:
            case GREATER:
            case GREATER_EQUAL:
            case HEX_LITERAL:
            case IN:
            case INDEX:
            case INDICES:
            case INTEGER_LITERAL:
            case IS_EMPTY:
            case IS_NOT_EMPTY:
            case IS_NULL:
            case JAVA_CONSTANT:
            case JPA_PARAM:
            case LENGTH:
            case LESS:
            case LESS_EQUAL:
            case LIKE:
            case LOCATE:
            case LOWER:
            case MAX:
            case MAXELEMENT:
            case MAXINDEX:
            case MEMBER_OF:
            case MIN:
            case MINELEMENT:
            case MININDEX:
            case MINUS:
            case MOD:
            case NAMED_PARAM:
            case NOT_EQUAL:
            case NOT_MEMBER_OF:
            case NULL:
            case NULLIF:
            case OCTAL_LITERAL:
            case OCTET_LENGTH:
            case PARAM:
            case PATH:
            case PLUS:
            case POSITION:
            case PROPERTY_REFERENCE:
            case SEARCHED_CASE:
            case SIMPLE_CASE:
            case SIZE:
            case SOLIDUS:
            case SOME:
            case SQRT:
            case STRING_LITERAL:
            case SUBSTRING:
            case SUB_QUERY:
            case SUM:
            case TRIM:
            case TRUE:
            case UNARY_MINUS:
            case UNARY_PLUS:
            case UPPER:
            case VECTOR_EXPR:
                {
                alt45=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 45, 0, input);

                throw nvae;

            }

            switch (alt45) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:205:4: ^( OR searchCondition searchCondition )
                    {
                     delegate.activateOR(); 

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    OR117=(CommonTree)match(input,OR,FOLLOW_OR_in_searchCondition810); 


                    if ( _first_0==null ) _first_0 = OR117;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_searchCondition_in_searchCondition812);
                    searchCondition118=searchCondition();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = searchCondition118.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_searchCondition_in_searchCondition814);
                    searchCondition119=searchCondition();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = searchCondition119.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                     delegate.deactivateBoolean(); 

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:206:4: ^( AND searchCondition searchCondition )
                    {
                     delegate.activateAND(); 

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    AND120=(CommonTree)match(input,AND,FOLLOW_AND_in_searchCondition827); 


                    if ( _first_0==null ) _first_0 = AND120;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_searchCondition_in_searchCondition829);
                    searchCondition121=searchCondition();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = searchCondition121.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_searchCondition_in_searchCondition831);
                    searchCondition122=searchCondition();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = searchCondition122.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                     delegate.deactivateBoolean(); 

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:207:4: ^( NOT searchCondition )
                    {
                     delegate.activateNOT(); 

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    NOT123=(CommonTree)match(input,NOT,FOLLOW_NOT_in_searchCondition844); 


                    if ( _first_0==null ) _first_0 = NOT123;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_searchCondition_in_searchCondition846);
                    searchCondition124=searchCondition();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = searchCondition124.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                     delegate.deactivateBoolean(); 

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:208:4: predicate
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_predicate_in_searchCondition855);
                    predicate125=predicate();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = predicate125.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "searchCondition"


    public static class predicate_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "predicate"
    // org/hibernate/hql/ast/render/QueryRenderer.g:211:1: predicate : ( ^( EQUALS rowValueConstructor comparativePredicateValue ) | ^( NOT_EQUAL rowValueConstructor comparativePredicateValue ) | ^( LESS rowValueConstructor comparativePredicateValue ) | ^( LESS_EQUAL rowValueConstructor comparativePredicateValue ) | ^( GREATER rowValueConstructor comparativePredicateValue ) | ^( GREATER_EQUAL rowValueConstructor comparativePredicateValue ) | ^( IS_NULL rowValueConstructor ) | ^( LIKE valueExpression patternValue= valueExpression ( escapeSpecification )? ) | ^( BETWEEN rowValueConstructor betweenList ) | ^( IN rowValueConstructor inPredicateValue ) | ^( MEMBER_OF rowValueConstructor rowValueConstructor ) | ^( NOT_MEMBER_OF rowValueConstructor rowValueConstructor ) | ^( IS_EMPTY rowValueConstructor ) | ^( IS_NOT_EMPTY rowValueConstructor ) | rowValueConstructor );
    public final QueryRenderer.predicate_return predicate() throws RecognitionException {
        QueryRenderer.predicate_return retval = new QueryRenderer.predicate_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree EQUALS126=null;
        CommonTree NOT_EQUAL129=null;
        CommonTree LESS132=null;
        CommonTree LESS_EQUAL135=null;
        CommonTree GREATER138=null;
        CommonTree GREATER_EQUAL141=null;
        CommonTree IS_NULL144=null;
        CommonTree LIKE146=null;
        CommonTree BETWEEN149=null;
        CommonTree IN152=null;
        CommonTree MEMBER_OF155=null;
        CommonTree NOT_MEMBER_OF158=null;
        CommonTree IS_EMPTY161=null;
        CommonTree IS_NOT_EMPTY163=null;
        QueryRenderer.valueExpression_return patternValue =null;

        QueryRenderer.rowValueConstructor_return rowValueConstructor127 =null;

        QueryRenderer.comparativePredicateValue_return comparativePredicateValue128 =null;

        QueryRenderer.rowValueConstructor_return rowValueConstructor130 =null;

        QueryRenderer.comparativePredicateValue_return comparativePredicateValue131 =null;

        QueryRenderer.rowValueConstructor_return rowValueConstructor133 =null;

        QueryRenderer.comparativePredicateValue_return comparativePredicateValue134 =null;

        QueryRenderer.rowValueConstructor_return rowValueConstructor136 =null;

        QueryRenderer.comparativePredicateValue_return comparativePredicateValue137 =null;

        QueryRenderer.rowValueConstructor_return rowValueConstructor139 =null;

        QueryRenderer.comparativePredicateValue_return comparativePredicateValue140 =null;

        QueryRenderer.rowValueConstructor_return rowValueConstructor142 =null;

        QueryRenderer.comparativePredicateValue_return comparativePredicateValue143 =null;

        QueryRenderer.rowValueConstructor_return rowValueConstructor145 =null;

        QueryRenderer.valueExpression_return valueExpression147 =null;

        QueryRenderer.escapeSpecification_return escapeSpecification148 =null;

        QueryRenderer.rowValueConstructor_return rowValueConstructor150 =null;

        QueryRenderer.betweenList_return betweenList151 =null;

        QueryRenderer.rowValueConstructor_return rowValueConstructor153 =null;

        QueryRenderer.inPredicateValue_return inPredicateValue154 =null;

        QueryRenderer.rowValueConstructor_return rowValueConstructor156 =null;

        QueryRenderer.rowValueConstructor_return rowValueConstructor157 =null;

        QueryRenderer.rowValueConstructor_return rowValueConstructor159 =null;

        QueryRenderer.rowValueConstructor_return rowValueConstructor160 =null;

        QueryRenderer.rowValueConstructor_return rowValueConstructor162 =null;

        QueryRenderer.rowValueConstructor_return rowValueConstructor164 =null;

        QueryRenderer.rowValueConstructor_return rowValueConstructor165 =null;


        CommonTree EQUALS126_tree=null;
        CommonTree NOT_EQUAL129_tree=null;
        CommonTree LESS132_tree=null;
        CommonTree LESS_EQUAL135_tree=null;
        CommonTree GREATER138_tree=null;
        CommonTree GREATER_EQUAL141_tree=null;
        CommonTree IS_NULL144_tree=null;
        CommonTree LIKE146_tree=null;
        CommonTree BETWEEN149_tree=null;
        CommonTree IN152_tree=null;
        CommonTree MEMBER_OF155_tree=null;
        CommonTree NOT_MEMBER_OF158_tree=null;
        CommonTree IS_EMPTY161_tree=null;
        CommonTree IS_NOT_EMPTY163_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:212:2: ( ^( EQUALS rowValueConstructor comparativePredicateValue ) | ^( NOT_EQUAL rowValueConstructor comparativePredicateValue ) | ^( LESS rowValueConstructor comparativePredicateValue ) | ^( LESS_EQUAL rowValueConstructor comparativePredicateValue ) | ^( GREATER rowValueConstructor comparativePredicateValue ) | ^( GREATER_EQUAL rowValueConstructor comparativePredicateValue ) | ^( IS_NULL rowValueConstructor ) | ^( LIKE valueExpression patternValue= valueExpression ( escapeSpecification )? ) | ^( BETWEEN rowValueConstructor betweenList ) | ^( IN rowValueConstructor inPredicateValue ) | ^( MEMBER_OF rowValueConstructor rowValueConstructor ) | ^( NOT_MEMBER_OF rowValueConstructor rowValueConstructor ) | ^( IS_EMPTY rowValueConstructor ) | ^( IS_NOT_EMPTY rowValueConstructor ) | rowValueConstructor )
            int alt47=15;
            switch ( input.LA(1) ) {
            case EQUALS:
                {
                alt47=1;
                }
                break;
            case NOT_EQUAL:
                {
                alt47=2;
                }
                break;
            case LESS:
                {
                alt47=3;
                }
                break;
            case LESS_EQUAL:
                {
                alt47=4;
                }
                break;
            case GREATER:
                {
                alt47=5;
                }
                break;
            case GREATER_EQUAL:
                {
                alt47=6;
                }
                break;
            case IS_NULL:
                {
                alt47=7;
                }
                break;
            case LIKE:
                {
                alt47=8;
                }
                break;
            case BETWEEN:
                {
                alt47=9;
                }
                break;
            case IN:
                {
                alt47=10;
                }
                break;
            case MEMBER_OF:
                {
                alt47=11;
                }
                break;
            case NOT_MEMBER_OF:
                {
                alt47=12;
                }
                break;
            case IS_EMPTY:
                {
                alt47=13;
                }
                break;
            case IS_NOT_EMPTY:
                {
                alt47=14;
                }
                break;
            case ABS:
            case ALIAS_REF:
            case ALL:
            case ANY:
            case ASTERISK:
            case AVG:
            case BIT_LENGTH:
            case CAST:
            case CHARACTER_LENGTH:
            case CHARACTER_LITERAL:
            case COALESCE:
            case CONCAT:
            case CONST_STRING_VALUE:
            case COUNT:
            case CURRENT_DATE:
            case CURRENT_TIME:
            case CURRENT_TIMESTAMP:
            case DECIMAL_LITERAL:
            case DOT_CLASS:
            case DOUBLE_PIPE:
            case ELEMENTS:
            case EXISTS:
            case EXTRACT:
            case FALSE:
            case FLOATING_POINT_LITERAL:
            case FUNCTION:
            case HEX_LITERAL:
            case INDEX:
            case INDICES:
            case INTEGER_LITERAL:
            case JAVA_CONSTANT:
            case JPA_PARAM:
            case LENGTH:
            case LOCATE:
            case LOWER:
            case MAX:
            case MAXELEMENT:
            case MAXINDEX:
            case MIN:
            case MINELEMENT:
            case MININDEX:
            case MINUS:
            case MOD:
            case NAMED_PARAM:
            case NULL:
            case NULLIF:
            case OCTAL_LITERAL:
            case OCTET_LENGTH:
            case PARAM:
            case PATH:
            case PLUS:
            case POSITION:
            case PROPERTY_REFERENCE:
            case SEARCHED_CASE:
            case SIMPLE_CASE:
            case SIZE:
            case SOLIDUS:
            case SOME:
            case SQRT:
            case STRING_LITERAL:
            case SUBSTRING:
            case SUB_QUERY:
            case SUM:
            case TRIM:
            case TRUE:
            case UNARY_MINUS:
            case UNARY_PLUS:
            case UPPER:
            case VECTOR_EXPR:
                {
                alt47=15;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 47, 0, input);

                throw nvae;

            }

            switch (alt47) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:212:4: ^( EQUALS rowValueConstructor comparativePredicateValue )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    EQUALS126=(CommonTree)match(input,EQUALS,FOLLOW_EQUALS_in_predicate868); 


                    if ( _first_0==null ) _first_0 = EQUALS126;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate870);
                    rowValueConstructor127=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor127.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_comparativePredicateValue_in_predicate872);
                    comparativePredicateValue128=comparativePredicateValue();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = comparativePredicateValue128.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                     delegate.predicateEquals( (comparativePredicateValue128!=null?(input.getTokenStream().toString(input.getTreeAdaptor().getTokenStartIndex(comparativePredicateValue128.start),input.getTreeAdaptor().getTokenStopIndex(comparativePredicateValue128.start))):null)); 

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:213:4: ^( NOT_EQUAL rowValueConstructor comparativePredicateValue )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    NOT_EQUAL129=(CommonTree)match(input,NOT_EQUAL,FOLLOW_NOT_EQUAL_in_predicate883); 


                    if ( _first_0==null ) _first_0 = NOT_EQUAL129;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate885);
                    rowValueConstructor130=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor130.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_comparativePredicateValue_in_predicate887);
                    comparativePredicateValue131=comparativePredicateValue();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = comparativePredicateValue131.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                     delegate.predicateNotEquals( (comparativePredicateValue131!=null?(input.getTokenStream().toString(input.getTreeAdaptor().getTokenStartIndex(comparativePredicateValue131.start),input.getTreeAdaptor().getTokenStopIndex(comparativePredicateValue131.start))):null)); 

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:214:4: ^( LESS rowValueConstructor comparativePredicateValue )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    LESS132=(CommonTree)match(input,LESS,FOLLOW_LESS_in_predicate898); 


                    if ( _first_0==null ) _first_0 = LESS132;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate900);
                    rowValueConstructor133=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor133.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_comparativePredicateValue_in_predicate902);
                    comparativePredicateValue134=comparativePredicateValue();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = comparativePredicateValue134.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                     delegate.predicateLess( (comparativePredicateValue134!=null?(input.getTokenStream().toString(input.getTreeAdaptor().getTokenStartIndex(comparativePredicateValue134.start),input.getTreeAdaptor().getTokenStopIndex(comparativePredicateValue134.start))):null)); 

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:215:4: ^( LESS_EQUAL rowValueConstructor comparativePredicateValue )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    LESS_EQUAL135=(CommonTree)match(input,LESS_EQUAL,FOLLOW_LESS_EQUAL_in_predicate913); 


                    if ( _first_0==null ) _first_0 = LESS_EQUAL135;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate915);
                    rowValueConstructor136=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor136.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_comparativePredicateValue_in_predicate917);
                    comparativePredicateValue137=comparativePredicateValue();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = comparativePredicateValue137.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                     delegate.predicateLessOrEqual( (comparativePredicateValue137!=null?(input.getTokenStream().toString(input.getTreeAdaptor().getTokenStartIndex(comparativePredicateValue137.start),input.getTreeAdaptor().getTokenStopIndex(comparativePredicateValue137.start))):null)); 

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:216:4: ^( GREATER rowValueConstructor comparativePredicateValue )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    GREATER138=(CommonTree)match(input,GREATER,FOLLOW_GREATER_in_predicate928); 


                    if ( _first_0==null ) _first_0 = GREATER138;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate930);
                    rowValueConstructor139=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor139.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_comparativePredicateValue_in_predicate932);
                    comparativePredicateValue140=comparativePredicateValue();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = comparativePredicateValue140.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                     delegate.predicateGreater( (comparativePredicateValue140!=null?(input.getTokenStream().toString(input.getTreeAdaptor().getTokenStartIndex(comparativePredicateValue140.start),input.getTreeAdaptor().getTokenStopIndex(comparativePredicateValue140.start))):null)); 

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 6 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:217:4: ^( GREATER_EQUAL rowValueConstructor comparativePredicateValue )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    GREATER_EQUAL141=(CommonTree)match(input,GREATER_EQUAL,FOLLOW_GREATER_EQUAL_in_predicate943); 


                    if ( _first_0==null ) _first_0 = GREATER_EQUAL141;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate945);
                    rowValueConstructor142=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor142.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_comparativePredicateValue_in_predicate947);
                    comparativePredicateValue143=comparativePredicateValue();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = comparativePredicateValue143.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                     delegate.predicateGreaterOrEqual( (comparativePredicateValue143!=null?(input.getTokenStream().toString(input.getTreeAdaptor().getTokenStartIndex(comparativePredicateValue143.start),input.getTreeAdaptor().getTokenStopIndex(comparativePredicateValue143.start))):null)); 

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 7 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:218:4: ^( IS_NULL rowValueConstructor )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    IS_NULL144=(CommonTree)match(input,IS_NULL,FOLLOW_IS_NULL_in_predicate958); 


                    if ( _first_0==null ) _first_0 = IS_NULL144;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate960);
                    rowValueConstructor145=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor145.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                     delegate.predicateIsNull(); 

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 8 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:219:4: ^( LIKE valueExpression patternValue= valueExpression ( escapeSpecification )? )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    LIKE146=(CommonTree)match(input,LIKE,FOLLOW_LIKE_in_predicate971); 


                    if ( _first_0==null ) _first_0 = LIKE146;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_predicate973);
                    valueExpression147=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression147.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_predicate977);
                    patternValue=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = patternValue.tree;


                    // org/hibernate/hql/ast/render/QueryRenderer.g:219:57: ( escapeSpecification )?
                    int alt46=2;
                    int LA46_0 = input.LA(1);

                    if ( (LA46_0==ESCAPE) ) {
                        alt46=1;
                    }
                    switch (alt46) {
                        case 1 :
                            // org/hibernate/hql/ast/render/QueryRenderer.g:219:57: escapeSpecification
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_escapeSpecification_in_predicate979);
                            escapeSpecification148=escapeSpecification();

                            state._fsp--;

                             
                            if ( _first_1==null ) _first_1 = escapeSpecification148.tree;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                     delegate.predicateLike( (patternValue!=null?(input.getTokenStream().toString(input.getTreeAdaptor().getTokenStartIndex(patternValue.start),input.getTreeAdaptor().getTokenStopIndex(patternValue.start))):null), (escapeSpecification148!=null?escapeSpecification148.escapeCharacter:null) ); 

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 9 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:220:4: ^( BETWEEN rowValueConstructor betweenList )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    BETWEEN149=(CommonTree)match(input,BETWEEN,FOLLOW_BETWEEN_in_predicate991); 


                    if ( _first_0==null ) _first_0 = BETWEEN149;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate993);
                    rowValueConstructor150=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor150.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_betweenList_in_predicate995);
                    betweenList151=betweenList();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = betweenList151.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 10 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:221:4: ^( IN rowValueConstructor inPredicateValue )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    IN152=(CommonTree)match(input,IN,FOLLOW_IN_in_predicate1004); 


                    if ( _first_0==null ) _first_0 = IN152;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate1006);
                    rowValueConstructor153=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor153.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_inPredicateValue_in_predicate1008);
                    inPredicateValue154=inPredicateValue();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = inPredicateValue154.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                     delegate.predicateIn( (inPredicateValue154!=null?inPredicateValue154.elements:null) ); 

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 11 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:222:4: ^( MEMBER_OF rowValueConstructor rowValueConstructor )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    MEMBER_OF155=(CommonTree)match(input,MEMBER_OF,FOLLOW_MEMBER_OF_in_predicate1019); 


                    if ( _first_0==null ) _first_0 = MEMBER_OF155;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate1021);
                    rowValueConstructor156=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor156.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate1023);
                    rowValueConstructor157=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor157.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 12 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:223:4: ^( NOT_MEMBER_OF rowValueConstructor rowValueConstructor )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    NOT_MEMBER_OF158=(CommonTree)match(input,NOT_MEMBER_OF,FOLLOW_NOT_MEMBER_OF_in_predicate1032); 


                    if ( _first_0==null ) _first_0 = NOT_MEMBER_OF158;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate1034);
                    rowValueConstructor159=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor159.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate1036);
                    rowValueConstructor160=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor160.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 13 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:224:4: ^( IS_EMPTY rowValueConstructor )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    IS_EMPTY161=(CommonTree)match(input,IS_EMPTY,FOLLOW_IS_EMPTY_in_predicate1046); 


                    if ( _first_0==null ) _first_0 = IS_EMPTY161;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate1048);
                    rowValueConstructor162=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor162.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 14 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:225:4: ^( IS_NOT_EMPTY rowValueConstructor )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    IS_NOT_EMPTY163=(CommonTree)match(input,IS_NOT_EMPTY,FOLLOW_IS_NOT_EMPTY_in_predicate1057); 


                    if ( _first_0==null ) _first_0 = IS_NOT_EMPTY163;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate1059);
                    rowValueConstructor164=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor164.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 15 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:226:4: rowValueConstructor
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate1066);
                    rowValueConstructor165=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = rowValueConstructor165.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "predicate"


    public static class betweenList_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "betweenList"
    // org/hibernate/hql/ast/render/QueryRenderer.g:229:1: betweenList : ^( BETWEEN_LIST lower= rowValueConstructor upper= rowValueConstructor ) ;
    public final QueryRenderer.betweenList_return betweenList() throws RecognitionException {
        QueryRenderer.betweenList_return retval = new QueryRenderer.betweenList_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree BETWEEN_LIST166=null;
        QueryRenderer.rowValueConstructor_return lower =null;

        QueryRenderer.rowValueConstructor_return upper =null;


        CommonTree BETWEEN_LIST166_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:230:2: ( ^( BETWEEN_LIST lower= rowValueConstructor upper= rowValueConstructor ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:230:4: ^( BETWEEN_LIST lower= rowValueConstructor upper= rowValueConstructor )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            BETWEEN_LIST166=(CommonTree)match(input,BETWEEN_LIST,FOLLOW_BETWEEN_LIST_in_betweenList1079); 


            if ( _first_0==null ) _first_0 = BETWEEN_LIST166;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_rowValueConstructor_in_betweenList1083);
            lower=rowValueConstructor();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = lower.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_rowValueConstructor_in_betweenList1087);
            upper=rowValueConstructor();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = upper.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


             delegate.predicateBetween( (lower!=null?(input.getTokenStream().toString(input.getTreeAdaptor().getTokenStartIndex(lower.start),input.getTreeAdaptor().getTokenStopIndex(lower.start))):null), (upper!=null?(input.getTokenStream().toString(input.getTreeAdaptor().getTokenStartIndex(upper.start),input.getTreeAdaptor().getTokenStopIndex(upper.start))):null) ); 

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "betweenList"


    public static class comparativePredicateValue_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "comparativePredicateValue"
    // org/hibernate/hql/ast/render/QueryRenderer.g:233:1: comparativePredicateValue : rowValueConstructor ;
    public final QueryRenderer.comparativePredicateValue_return comparativePredicateValue() throws RecognitionException {
        QueryRenderer.comparativePredicateValue_return retval = new QueryRenderer.comparativePredicateValue_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        QueryRenderer.rowValueConstructor_return rowValueConstructor167 =null;



        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:234:2: ( rowValueConstructor )
            // org/hibernate/hql/ast/render/QueryRenderer.g:234:4: rowValueConstructor
            {
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_rowValueConstructor_in_comparativePredicateValue1102);
            rowValueConstructor167=rowValueConstructor();

            state._fsp--;

             
            if ( _first_0==null ) _first_0 = rowValueConstructor167.tree;


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "comparativePredicateValue"


    public static class rowValueConstructor_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "rowValueConstructor"
    // org/hibernate/hql/ast/render/QueryRenderer.g:237:1: rowValueConstructor : valueExpression ;
    public final QueryRenderer.rowValueConstructor_return rowValueConstructor() throws RecognitionException {
        QueryRenderer.rowValueConstructor_return retval = new QueryRenderer.rowValueConstructor_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        QueryRenderer.valueExpression_return valueExpression168 =null;



        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:238:2: ( valueExpression )
            // org/hibernate/hql/ast/render/QueryRenderer.g:238:4: valueExpression
            {
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_rowValueConstructor1113);
            valueExpression168=valueExpression();

            state._fsp--;

             
            if ( _first_0==null ) _first_0 = valueExpression168.tree;


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "rowValueConstructor"


    public static class escapeSpecification_return extends TreeRuleReturnScope {
        public Character escapeCharacter;
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "escapeSpecification"
    // org/hibernate/hql/ast/render/QueryRenderer.g:241:1: escapeSpecification returns [Character escapeCharacter] : ^( ESCAPE characterValueExpression ) ;
    public final QueryRenderer.escapeSpecification_return escapeSpecification() throws RecognitionException {
        QueryRenderer.escapeSpecification_return retval = new QueryRenderer.escapeSpecification_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ESCAPE169=null;
        QueryRenderer.characterValueExpression_return characterValueExpression170 =null;


        CommonTree ESCAPE169_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:242:2: ( ^( ESCAPE characterValueExpression ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:242:4: ^( ESCAPE characterValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            ESCAPE169=(CommonTree)match(input,ESCAPE,FOLLOW_ESCAPE_in_escapeSpecification1129); 


            if ( _first_0==null ) _first_0 = ESCAPE169;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_escapeSpecification1131);
            characterValueExpression170=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression170.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


             retval.escapeCharacter = (characterValueExpression170!=null?(input.getTokenStream().toString(input.getTreeAdaptor().getTokenStartIndex(characterValueExpression170.start),input.getTreeAdaptor().getTokenStopIndex(characterValueExpression170.start))):null).charAt( 0 ); 

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "escapeSpecification"


    public static class inPredicateValue_return extends TreeRuleReturnScope {
        public List<String> elements;
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "inPredicateValue"
    // org/hibernate/hql/ast/render/QueryRenderer.g:245:1: inPredicateValue returns [List<String> elements] : ^( IN_LIST ( valueExpression )+ ) ;
    public final QueryRenderer.inPredicateValue_return inPredicateValue() throws RecognitionException {
        QueryRenderer.inPredicateValue_return retval = new QueryRenderer.inPredicateValue_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree IN_LIST171=null;
        QueryRenderer.valueExpression_return valueExpression172 =null;


        CommonTree IN_LIST171_tree=null;

         retval.elements = new ArrayList<String>(); 
        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:247:2: ( ^( IN_LIST ( valueExpression )+ ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:247:4: ^( IN_LIST ( valueExpression )+ )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            IN_LIST171=(CommonTree)match(input,IN_LIST,FOLLOW_IN_LIST_in_inPredicateValue1155); 


            if ( _first_0==null ) _first_0 = IN_LIST171;
            match(input, Token.DOWN, null); 
            // org/hibernate/hql/ast/render/QueryRenderer.g:247:14: ( valueExpression )+
            int cnt48=0;
            loop48:
            do {
                int alt48=2;
                int LA48_0 = input.LA(1);

                if ( (LA48_0==ABS||(LA48_0 >= ALIAS_REF && LA48_0 <= ALL)||LA48_0==ANY||(LA48_0 >= ASTERISK && LA48_0 <= AVG)||LA48_0==BIT_LENGTH||(LA48_0 >= CAST && LA48_0 <= CHARACTER_LITERAL)||LA48_0==COALESCE||(LA48_0 >= CONCAT && LA48_0 <= COUNT)||(LA48_0 >= CURRENT_DATE && LA48_0 <= CURRENT_TIMESTAMP)||LA48_0==DECIMAL_LITERAL||(LA48_0 >= DOT_CLASS && LA48_0 <= DOUBLE_PIPE)||LA48_0==ELEMENTS||LA48_0==EXISTS||LA48_0==EXTRACT||LA48_0==FALSE||LA48_0==FLOATING_POINT_LITERAL||LA48_0==FUNCTION||LA48_0==HEX_LITERAL||(LA48_0 >= INDEX && LA48_0 <= INDICES)||LA48_0==INTEGER_LITERAL||LA48_0==JAVA_CONSTANT||LA48_0==JPA_PARAM||LA48_0==LENGTH||(LA48_0 >= LOCATE && LA48_0 <= LOWER)||(LA48_0 >= MAX && LA48_0 <= MAXINDEX)||(LA48_0 >= MIN && LA48_0 <= MINUS)||LA48_0==MOD||LA48_0==NAMED_PARAM||(LA48_0 >= NULL && LA48_0 <= NULLIF)||(LA48_0 >= OCTAL_LITERAL && LA48_0 <= OCTET_LENGTH)||(LA48_0 >= PARAM && LA48_0 <= PATH)||(LA48_0 >= PLUS && LA48_0 <= POSITION)||LA48_0==PROPERTY_REFERENCE||LA48_0==SEARCHED_CASE||(LA48_0 >= SIMPLE_CASE && LA48_0 <= SOME)||(LA48_0 >= SQRT && LA48_0 <= SUM)||(LA48_0 >= TRIM && LA48_0 <= TRUE)||(LA48_0 >= UNARY_MINUS && LA48_0 <= UNARY_PLUS)||LA48_0==UPPER||LA48_0==VECTOR_EXPR) ) {
                    alt48=1;
                }


                switch (alt48) {
            	case 1 :
            	    // org/hibernate/hql/ast/render/QueryRenderer.g:247:15: valueExpression
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_valueExpression_in_inPredicateValue1158);
            	    valueExpression172=valueExpression();

            	    state._fsp--;

            	     
            	    if ( _first_1==null ) _first_1 = valueExpression172.tree;


            	     retval.elements.add((valueExpression172!=null?(input.getTokenStream().toString(input.getTreeAdaptor().getTokenStartIndex(valueExpression172.start),input.getTreeAdaptor().getTokenStopIndex(valueExpression172.start))):null)); 

            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt48 >= 1 ) break loop48;
                        EarlyExitException eee =
                            new EarlyExitException(48, input);
                        throw eee;
                }
                cnt48++;
            } while (true);


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "inPredicateValue"


    public static class numericValueExpression_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "numericValueExpression"
    // org/hibernate/hql/ast/render/QueryRenderer.g:250:1: numericValueExpression : valueExpression ;
    public final QueryRenderer.numericValueExpression_return numericValueExpression() throws RecognitionException {
        QueryRenderer.numericValueExpression_return retval = new QueryRenderer.numericValueExpression_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        QueryRenderer.valueExpression_return valueExpression173 =null;



        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:251:2: ( valueExpression )
            // org/hibernate/hql/ast/render/QueryRenderer.g:251:4: valueExpression
            {
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_numericValueExpression1174);
            valueExpression173=valueExpression();

            state._fsp--;

             
            if ( _first_0==null ) _first_0 = valueExpression173.tree;


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "numericValueExpression"


    public static class characterValueExpression_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "characterValueExpression"
    // org/hibernate/hql/ast/render/QueryRenderer.g:254:1: characterValueExpression : valueExpression ;
    public final QueryRenderer.characterValueExpression_return characterValueExpression() throws RecognitionException {
        QueryRenderer.characterValueExpression_return retval = new QueryRenderer.characterValueExpression_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        QueryRenderer.valueExpression_return valueExpression174 =null;



        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:255:2: ( valueExpression )
            // org/hibernate/hql/ast/render/QueryRenderer.g:255:4: valueExpression
            {
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_characterValueExpression1185);
            valueExpression174=valueExpression();

            state._fsp--;

             
            if ( _first_0==null ) _first_0 = valueExpression174.tree;


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "characterValueExpression"


    public static class datetimeValueExpression_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "datetimeValueExpression"
    // org/hibernate/hql/ast/render/QueryRenderer.g:258:1: datetimeValueExpression : valueExpression ;
    public final QueryRenderer.datetimeValueExpression_return datetimeValueExpression() throws RecognitionException {
        QueryRenderer.datetimeValueExpression_return retval = new QueryRenderer.datetimeValueExpression_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        QueryRenderer.valueExpression_return valueExpression175 =null;



        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:259:2: ( valueExpression )
            // org/hibernate/hql/ast/render/QueryRenderer.g:259:4: valueExpression
            {
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_datetimeValueExpression1196);
            valueExpression175=valueExpression();

            state._fsp--;

             
            if ( _first_0==null ) _first_0 = valueExpression175.tree;


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "datetimeValueExpression"


    public static class valueExpression_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "valueExpression"
    // org/hibernate/hql/ast/render/QueryRenderer.g:262:1: valueExpression : ( ^( DOUBLE_PIPE ( characterValueExpression )+ ) | ^( UNARY_MINUS numericValueExpression ) | ^( UNARY_PLUS numericValueExpression ) | ^( PLUS valueExpression valueExpression ) | ^( MINUS valueExpression valueExpression ) | ^( ASTERISK numericValueExpression numericValueExpression ) | ^( SOLIDUS numericValueExpression numericValueExpression ) | ^( EXISTS rowValueConstructor ) | ^( SOME valueExpression ) | ^( ALL valueExpression ) | ^( ANY valueExpression ) | ^( VECTOR_EXPR ( valueExpression )+ ) | valueExpressionPrimary );
    public final QueryRenderer.valueExpression_return valueExpression() throws RecognitionException {
        QueryRenderer.valueExpression_return retval = new QueryRenderer.valueExpression_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree DOUBLE_PIPE176=null;
        CommonTree UNARY_MINUS178=null;
        CommonTree UNARY_PLUS180=null;
        CommonTree PLUS182=null;
        CommonTree MINUS185=null;
        CommonTree ASTERISK188=null;
        CommonTree SOLIDUS191=null;
        CommonTree EXISTS194=null;
        CommonTree SOME196=null;
        CommonTree ALL198=null;
        CommonTree ANY200=null;
        CommonTree VECTOR_EXPR202=null;
        QueryRenderer.characterValueExpression_return characterValueExpression177 =null;

        QueryRenderer.numericValueExpression_return numericValueExpression179 =null;

        QueryRenderer.numericValueExpression_return numericValueExpression181 =null;

        QueryRenderer.valueExpression_return valueExpression183 =null;

        QueryRenderer.valueExpression_return valueExpression184 =null;

        QueryRenderer.valueExpression_return valueExpression186 =null;

        QueryRenderer.valueExpression_return valueExpression187 =null;

        QueryRenderer.numericValueExpression_return numericValueExpression189 =null;

        QueryRenderer.numericValueExpression_return numericValueExpression190 =null;

        QueryRenderer.numericValueExpression_return numericValueExpression192 =null;

        QueryRenderer.numericValueExpression_return numericValueExpression193 =null;

        QueryRenderer.rowValueConstructor_return rowValueConstructor195 =null;

        QueryRenderer.valueExpression_return valueExpression197 =null;

        QueryRenderer.valueExpression_return valueExpression199 =null;

        QueryRenderer.valueExpression_return valueExpression201 =null;

        QueryRenderer.valueExpression_return valueExpression203 =null;

        QueryRenderer.valueExpressionPrimary_return valueExpressionPrimary204 =null;


        CommonTree DOUBLE_PIPE176_tree=null;
        CommonTree UNARY_MINUS178_tree=null;
        CommonTree UNARY_PLUS180_tree=null;
        CommonTree PLUS182_tree=null;
        CommonTree MINUS185_tree=null;
        CommonTree ASTERISK188_tree=null;
        CommonTree SOLIDUS191_tree=null;
        CommonTree EXISTS194_tree=null;
        CommonTree SOME196_tree=null;
        CommonTree ALL198_tree=null;
        CommonTree ANY200_tree=null;
        CommonTree VECTOR_EXPR202_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:263:2: ( ^( DOUBLE_PIPE ( characterValueExpression )+ ) | ^( UNARY_MINUS numericValueExpression ) | ^( UNARY_PLUS numericValueExpression ) | ^( PLUS valueExpression valueExpression ) | ^( MINUS valueExpression valueExpression ) | ^( ASTERISK numericValueExpression numericValueExpression ) | ^( SOLIDUS numericValueExpression numericValueExpression ) | ^( EXISTS rowValueConstructor ) | ^( SOME valueExpression ) | ^( ALL valueExpression ) | ^( ANY valueExpression ) | ^( VECTOR_EXPR ( valueExpression )+ ) | valueExpressionPrimary )
            int alt51=13;
            switch ( input.LA(1) ) {
            case DOUBLE_PIPE:
                {
                alt51=1;
                }
                break;
            case UNARY_MINUS:
                {
                alt51=2;
                }
                break;
            case UNARY_PLUS:
                {
                alt51=3;
                }
                break;
            case PLUS:
                {
                alt51=4;
                }
                break;
            case MINUS:
                {
                alt51=5;
                }
                break;
            case ASTERISK:
                {
                alt51=6;
                }
                break;
            case SOLIDUS:
                {
                alt51=7;
                }
                break;
            case EXISTS:
                {
                alt51=8;
                }
                break;
            case SOME:
                {
                alt51=9;
                }
                break;
            case ALL:
                {
                alt51=10;
                }
                break;
            case ANY:
                {
                alt51=11;
                }
                break;
            case VECTOR_EXPR:
                {
                alt51=12;
                }
                break;
            case ABS:
            case ALIAS_REF:
            case AVG:
            case BIT_LENGTH:
            case CAST:
            case CHARACTER_LENGTH:
            case CHARACTER_LITERAL:
            case COALESCE:
            case CONCAT:
            case CONST_STRING_VALUE:
            case COUNT:
            case CURRENT_DATE:
            case CURRENT_TIME:
            case CURRENT_TIMESTAMP:
            case DECIMAL_LITERAL:
            case DOT_CLASS:
            case ELEMENTS:
            case EXTRACT:
            case FALSE:
            case FLOATING_POINT_LITERAL:
            case FUNCTION:
            case HEX_LITERAL:
            case INDEX:
            case INDICES:
            case INTEGER_LITERAL:
            case JAVA_CONSTANT:
            case JPA_PARAM:
            case LENGTH:
            case LOCATE:
            case LOWER:
            case MAX:
            case MAXELEMENT:
            case MAXINDEX:
            case MIN:
            case MINELEMENT:
            case MININDEX:
            case MOD:
            case NAMED_PARAM:
            case NULL:
            case NULLIF:
            case OCTAL_LITERAL:
            case OCTET_LENGTH:
            case PARAM:
            case PATH:
            case POSITION:
            case PROPERTY_REFERENCE:
            case SEARCHED_CASE:
            case SIMPLE_CASE:
            case SIZE:
            case SQRT:
            case STRING_LITERAL:
            case SUBSTRING:
            case SUB_QUERY:
            case SUM:
            case TRIM:
            case TRUE:
            case UPPER:
                {
                alt51=13;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 51, 0, input);

                throw nvae;

            }

            switch (alt51) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:263:4: ^( DOUBLE_PIPE ( characterValueExpression )+ )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    DOUBLE_PIPE176=(CommonTree)match(input,DOUBLE_PIPE,FOLLOW_DOUBLE_PIPE_in_valueExpression1209); 


                    if ( _first_0==null ) _first_0 = DOUBLE_PIPE176;
                    match(input, Token.DOWN, null); 
                    // org/hibernate/hql/ast/render/QueryRenderer.g:263:19: ( characterValueExpression )+
                    int cnt49=0;
                    loop49:
                    do {
                        int alt49=2;
                        int LA49_0 = input.LA(1);

                        if ( (LA49_0==ABS||(LA49_0 >= ALIAS_REF && LA49_0 <= ALL)||LA49_0==ANY||(LA49_0 >= ASTERISK && LA49_0 <= AVG)||LA49_0==BIT_LENGTH||(LA49_0 >= CAST && LA49_0 <= CHARACTER_LITERAL)||LA49_0==COALESCE||(LA49_0 >= CONCAT && LA49_0 <= COUNT)||(LA49_0 >= CURRENT_DATE && LA49_0 <= CURRENT_TIMESTAMP)||LA49_0==DECIMAL_LITERAL||(LA49_0 >= DOT_CLASS && LA49_0 <= DOUBLE_PIPE)||LA49_0==ELEMENTS||LA49_0==EXISTS||LA49_0==EXTRACT||LA49_0==FALSE||LA49_0==FLOATING_POINT_LITERAL||LA49_0==FUNCTION||LA49_0==HEX_LITERAL||(LA49_0 >= INDEX && LA49_0 <= INDICES)||LA49_0==INTEGER_LITERAL||LA49_0==JAVA_CONSTANT||LA49_0==JPA_PARAM||LA49_0==LENGTH||(LA49_0 >= LOCATE && LA49_0 <= LOWER)||(LA49_0 >= MAX && LA49_0 <= MAXINDEX)||(LA49_0 >= MIN && LA49_0 <= MINUS)||LA49_0==MOD||LA49_0==NAMED_PARAM||(LA49_0 >= NULL && LA49_0 <= NULLIF)||(LA49_0 >= OCTAL_LITERAL && LA49_0 <= OCTET_LENGTH)||(LA49_0 >= PARAM && LA49_0 <= PATH)||(LA49_0 >= PLUS && LA49_0 <= POSITION)||LA49_0==PROPERTY_REFERENCE||LA49_0==SEARCHED_CASE||(LA49_0 >= SIMPLE_CASE && LA49_0 <= SOME)||(LA49_0 >= SQRT && LA49_0 <= SUM)||(LA49_0 >= TRIM && LA49_0 <= TRUE)||(LA49_0 >= UNARY_MINUS && LA49_0 <= UNARY_PLUS)||LA49_0==UPPER||LA49_0==VECTOR_EXPR) ) {
                            alt49=1;
                        }


                        switch (alt49) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/render/QueryRenderer.g:263:19: characterValueExpression
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    pushFollow(FOLLOW_characterValueExpression_in_valueExpression1211);
                    	    characterValueExpression177=characterValueExpression();

                    	    state._fsp--;

                    	     
                    	    if ( _first_1==null ) _first_1 = characterValueExpression177.tree;


                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt49 >= 1 ) break loop49;
                                EarlyExitException eee =
                                    new EarlyExitException(49, input);
                                throw eee;
                        }
                        cnt49++;
                    } while (true);


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:264:4: ^( UNARY_MINUS numericValueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    UNARY_MINUS178=(CommonTree)match(input,UNARY_MINUS,FOLLOW_UNARY_MINUS_in_valueExpression1221); 


                    if ( _first_0==null ) _first_0 = UNARY_MINUS178;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_valueExpression1223);
                    numericValueExpression179=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression179.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:265:4: ^( UNARY_PLUS numericValueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    UNARY_PLUS180=(CommonTree)match(input,UNARY_PLUS,FOLLOW_UNARY_PLUS_in_valueExpression1232); 


                    if ( _first_0==null ) _first_0 = UNARY_PLUS180;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_valueExpression1234);
                    numericValueExpression181=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression181.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:266:4: ^( PLUS valueExpression valueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    PLUS182=(CommonTree)match(input,PLUS,FOLLOW_PLUS_in_valueExpression1243); 


                    if ( _first_0==null ) _first_0 = PLUS182;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_valueExpression1245);
                    valueExpression183=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression183.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_valueExpression1247);
                    valueExpression184=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression184.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:267:4: ^( MINUS valueExpression valueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    MINUS185=(CommonTree)match(input,MINUS,FOLLOW_MINUS_in_valueExpression1256); 


                    if ( _first_0==null ) _first_0 = MINUS185;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_valueExpression1258);
                    valueExpression186=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression186.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_valueExpression1260);
                    valueExpression187=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression187.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 6 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:268:4: ^( ASTERISK numericValueExpression numericValueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    ASTERISK188=(CommonTree)match(input,ASTERISK,FOLLOW_ASTERISK_in_valueExpression1269); 


                    if ( _first_0==null ) _first_0 = ASTERISK188;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_valueExpression1271);
                    numericValueExpression189=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression189.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_valueExpression1273);
                    numericValueExpression190=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression190.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 7 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:269:4: ^( SOLIDUS numericValueExpression numericValueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    SOLIDUS191=(CommonTree)match(input,SOLIDUS,FOLLOW_SOLIDUS_in_valueExpression1282); 


                    if ( _first_0==null ) _first_0 = SOLIDUS191;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_valueExpression1284);
                    numericValueExpression192=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression192.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_valueExpression1286);
                    numericValueExpression193=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression193.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 8 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:270:4: ^( EXISTS rowValueConstructor )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    EXISTS194=(CommonTree)match(input,EXISTS,FOLLOW_EXISTS_in_valueExpression1295); 


                    if ( _first_0==null ) _first_0 = EXISTS194;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_valueExpression1297);
                    rowValueConstructor195=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor195.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 9 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:271:4: ^( SOME valueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    SOME196=(CommonTree)match(input,SOME,FOLLOW_SOME_in_valueExpression1305); 


                    if ( _first_0==null ) _first_0 = SOME196;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_valueExpression1307);
                    valueExpression197=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression197.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 10 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:272:4: ^( ALL valueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    ALL198=(CommonTree)match(input,ALL,FOLLOW_ALL_in_valueExpression1316); 


                    if ( _first_0==null ) _first_0 = ALL198;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_valueExpression1318);
                    valueExpression199=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression199.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 11 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:273:4: ^( ANY valueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    ANY200=(CommonTree)match(input,ANY,FOLLOW_ANY_in_valueExpression1327); 


                    if ( _first_0==null ) _first_0 = ANY200;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_valueExpression1329);
                    valueExpression201=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression201.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 12 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:274:4: ^( VECTOR_EXPR ( valueExpression )+ )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    VECTOR_EXPR202=(CommonTree)match(input,VECTOR_EXPR,FOLLOW_VECTOR_EXPR_in_valueExpression1338); 


                    if ( _first_0==null ) _first_0 = VECTOR_EXPR202;
                    match(input, Token.DOWN, null); 
                    // org/hibernate/hql/ast/render/QueryRenderer.g:274:19: ( valueExpression )+
                    int cnt50=0;
                    loop50:
                    do {
                        int alt50=2;
                        int LA50_0 = input.LA(1);

                        if ( (LA50_0==ABS||(LA50_0 >= ALIAS_REF && LA50_0 <= ALL)||LA50_0==ANY||(LA50_0 >= ASTERISK && LA50_0 <= AVG)||LA50_0==BIT_LENGTH||(LA50_0 >= CAST && LA50_0 <= CHARACTER_LITERAL)||LA50_0==COALESCE||(LA50_0 >= CONCAT && LA50_0 <= COUNT)||(LA50_0 >= CURRENT_DATE && LA50_0 <= CURRENT_TIMESTAMP)||LA50_0==DECIMAL_LITERAL||(LA50_0 >= DOT_CLASS && LA50_0 <= DOUBLE_PIPE)||LA50_0==ELEMENTS||LA50_0==EXISTS||LA50_0==EXTRACT||LA50_0==FALSE||LA50_0==FLOATING_POINT_LITERAL||LA50_0==FUNCTION||LA50_0==HEX_LITERAL||(LA50_0 >= INDEX && LA50_0 <= INDICES)||LA50_0==INTEGER_LITERAL||LA50_0==JAVA_CONSTANT||LA50_0==JPA_PARAM||LA50_0==LENGTH||(LA50_0 >= LOCATE && LA50_0 <= LOWER)||(LA50_0 >= MAX && LA50_0 <= MAXINDEX)||(LA50_0 >= MIN && LA50_0 <= MINUS)||LA50_0==MOD||LA50_0==NAMED_PARAM||(LA50_0 >= NULL && LA50_0 <= NULLIF)||(LA50_0 >= OCTAL_LITERAL && LA50_0 <= OCTET_LENGTH)||(LA50_0 >= PARAM && LA50_0 <= PATH)||(LA50_0 >= PLUS && LA50_0 <= POSITION)||LA50_0==PROPERTY_REFERENCE||LA50_0==SEARCHED_CASE||(LA50_0 >= SIMPLE_CASE && LA50_0 <= SOME)||(LA50_0 >= SQRT && LA50_0 <= SUM)||(LA50_0 >= TRIM && LA50_0 <= TRUE)||(LA50_0 >= UNARY_MINUS && LA50_0 <= UNARY_PLUS)||LA50_0==UPPER||LA50_0==VECTOR_EXPR) ) {
                            alt50=1;
                        }


                        switch (alt50) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/render/QueryRenderer.g:274:19: valueExpression
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    pushFollow(FOLLOW_valueExpression_in_valueExpression1340);
                    	    valueExpression203=valueExpression();

                    	    state._fsp--;

                    	     
                    	    if ( _first_1==null ) _first_1 = valueExpression203.tree;


                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt50 >= 1 ) break loop50;
                                EarlyExitException eee =
                                    new EarlyExitException(50, input);
                                throw eee;
                        }
                        cnt50++;
                    } while (true);


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 13 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:275:4: valueExpressionPrimary
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpressionPrimary_in_valueExpression1348);
                    valueExpressionPrimary204=valueExpressionPrimary();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = valueExpressionPrimary204.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "valueExpression"


    public static class valueExpressionPrimary_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "valueExpressionPrimary"
    // org/hibernate/hql/ast/render/QueryRenderer.g:278:1: valueExpressionPrimary : ( caseExpression | function | collectionFunction | collectionExpression | constant | parameter | propertyReference | ^( SUB_QUERY queryStatementSet ) | ALIAS_REF | ^( DOT_CLASS path ) | ^( JAVA_CONSTANT path ) | ^( PATH propertyReferencePath ) );
    public final QueryRenderer.valueExpressionPrimary_return valueExpressionPrimary() throws RecognitionException {
        QueryRenderer.valueExpressionPrimary_return retval = new QueryRenderer.valueExpressionPrimary_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SUB_QUERY212=null;
        CommonTree ALIAS_REF214=null;
        CommonTree DOT_CLASS215=null;
        CommonTree JAVA_CONSTANT217=null;
        CommonTree PATH219=null;
        QueryRenderer.caseExpression_return caseExpression205 =null;

        QueryRenderer.function_return function206 =null;

        QueryRenderer.collectionFunction_return collectionFunction207 =null;

        QueryRenderer.collectionExpression_return collectionExpression208 =null;

        QueryRenderer.constant_return constant209 =null;

        QueryRenderer.parameter_return parameter210 =null;

        QueryRenderer.propertyReference_return propertyReference211 =null;

        QueryRenderer.queryStatementSet_return queryStatementSet213 =null;

        QueryRenderer.path_return path216 =null;

        QueryRenderer.path_return path218 =null;

        QueryRenderer.propertyReferencePath_return propertyReferencePath220 =null;


        CommonTree SUB_QUERY212_tree=null;
        CommonTree ALIAS_REF214_tree=null;
        CommonTree DOT_CLASS215_tree=null;
        CommonTree JAVA_CONSTANT217_tree=null;
        CommonTree PATH219_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:279:2: ( caseExpression | function | collectionFunction | collectionExpression | constant | parameter | propertyReference | ^( SUB_QUERY queryStatementSet ) | ALIAS_REF | ^( DOT_CLASS path ) | ^( JAVA_CONSTANT path ) | ^( PATH propertyReferencePath ) )
            int alt52=12;
            switch ( input.LA(1) ) {
            case COALESCE:
            case NULLIF:
            case SEARCHED_CASE:
            case SIMPLE_CASE:
                {
                alt52=1;
                }
                break;
            case ABS:
            case AVG:
            case BIT_LENGTH:
            case CAST:
            case CHARACTER_LENGTH:
            case CONCAT:
            case COUNT:
            case CURRENT_DATE:
            case CURRENT_TIME:
            case CURRENT_TIMESTAMP:
            case EXTRACT:
            case FUNCTION:
            case INDEX:
            case LENGTH:
            case LOCATE:
            case LOWER:
            case MAX:
            case MIN:
            case MOD:
            case OCTET_LENGTH:
            case POSITION:
            case SIZE:
            case SQRT:
            case SUBSTRING:
            case SUM:
            case TRIM:
            case UPPER:
                {
                alt52=2;
                }
                break;
            case MAXELEMENT:
            case MAXINDEX:
            case MINELEMENT:
            case MININDEX:
                {
                alt52=3;
                }
                break;
            case ELEMENTS:
            case INDICES:
                {
                alt52=4;
                }
                break;
            case CHARACTER_LITERAL:
            case CONST_STRING_VALUE:
            case DECIMAL_LITERAL:
            case FALSE:
            case FLOATING_POINT_LITERAL:
            case HEX_LITERAL:
            case INTEGER_LITERAL:
            case NULL:
            case OCTAL_LITERAL:
            case STRING_LITERAL:
            case TRUE:
                {
                alt52=5;
                }
                break;
            case JPA_PARAM:
            case NAMED_PARAM:
            case PARAM:
                {
                alt52=6;
                }
                break;
            case PROPERTY_REFERENCE:
                {
                alt52=7;
                }
                break;
            case SUB_QUERY:
                {
                alt52=8;
                }
                break;
            case ALIAS_REF:
                {
                alt52=9;
                }
                break;
            case DOT_CLASS:
                {
                alt52=10;
                }
                break;
            case JAVA_CONSTANT:
                {
                alt52=11;
                }
                break;
            case PATH:
                {
                alt52=12;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 52, 0, input);

                throw nvae;

            }

            switch (alt52) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:279:4: caseExpression
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_caseExpression_in_valueExpressionPrimary1359);
                    caseExpression205=caseExpression();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = caseExpression205.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:280:4: function
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_function_in_valueExpressionPrimary1364);
                    function206=function();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = function206.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:281:4: collectionFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_collectionFunction_in_valueExpressionPrimary1369);
                    collectionFunction207=collectionFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = collectionFunction207.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:282:4: collectionExpression
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_collectionExpression_in_valueExpressionPrimary1374);
                    collectionExpression208=collectionExpression();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = collectionExpression208.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:283:4: constant
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_constant_in_valueExpressionPrimary1379);
                    constant209=constant();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = constant209.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 6 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:284:4: parameter
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_parameter_in_valueExpressionPrimary1384);
                    parameter210=parameter();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = parameter210.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 7 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:285:4: propertyReference
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_propertyReference_in_valueExpressionPrimary1389);
                    propertyReference211=propertyReference();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = propertyReference211.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 8 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:286:4: ^( SUB_QUERY queryStatementSet )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    SUB_QUERY212=(CommonTree)match(input,SUB_QUERY,FOLLOW_SUB_QUERY_in_valueExpressionPrimary1395); 


                    if ( _first_0==null ) _first_0 = SUB_QUERY212;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_queryStatementSet_in_valueExpressionPrimary1397);
                    queryStatementSet213=queryStatementSet();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = queryStatementSet213.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 9 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:287:4: ALIAS_REF
                    {
                    _last = (CommonTree)input.LT(1);
                    ALIAS_REF214=(CommonTree)match(input,ALIAS_REF,FOLLOW_ALIAS_REF_in_valueExpressionPrimary1403); 
                     
                    if ( _first_0==null ) _first_0 = ALIAS_REF214;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 10 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:288:4: ^( DOT_CLASS path )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    DOT_CLASS215=(CommonTree)match(input,DOT_CLASS,FOLLOW_DOT_CLASS_in_valueExpressionPrimary1410); 


                    if ( _first_0==null ) _first_0 = DOT_CLASS215;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_path_in_valueExpressionPrimary1412);
                    path216=path();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = path216.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 11 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:289:4: ^( JAVA_CONSTANT path )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    JAVA_CONSTANT217=(CommonTree)match(input,JAVA_CONSTANT,FOLLOW_JAVA_CONSTANT_in_valueExpressionPrimary1420); 


                    if ( _first_0==null ) _first_0 = JAVA_CONSTANT217;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_path_in_valueExpressionPrimary1422);
                    path218=path();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = path218.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 12 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:290:4: ^( PATH propertyReferencePath )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    PATH219=(CommonTree)match(input,PATH,FOLLOW_PATH_in_valueExpressionPrimary1430); 


                    if ( _first_0==null ) _first_0 = PATH219;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_propertyReferencePath_in_valueExpressionPrimary1432);
                    propertyReferencePath220=propertyReferencePath();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = propertyReferencePath220.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                     delegate.setPropertyReferencePath( ( (PropertyPathTree)PATH219 ).getPropertyPath() ); 

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "valueExpressionPrimary"


    public static class caseExpression_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "caseExpression"
    // org/hibernate/hql/ast/render/QueryRenderer.g:293:1: caseExpression : ( ^( NULLIF valueExpression valueExpression ) | ^( COALESCE valueExpression ( valueExpression )* ) | ^( SIMPLE_CASE valueExpression ( simpleCaseWhenClause )+ ( elseClause )? ) | ^( SEARCHED_CASE ( searchedWhenClause )+ ( elseClause )? ) );
    public final QueryRenderer.caseExpression_return caseExpression() throws RecognitionException {
        QueryRenderer.caseExpression_return retval = new QueryRenderer.caseExpression_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree NULLIF221=null;
        CommonTree COALESCE224=null;
        CommonTree SIMPLE_CASE227=null;
        CommonTree SEARCHED_CASE231=null;
        QueryRenderer.valueExpression_return valueExpression222 =null;

        QueryRenderer.valueExpression_return valueExpression223 =null;

        QueryRenderer.valueExpression_return valueExpression225 =null;

        QueryRenderer.valueExpression_return valueExpression226 =null;

        QueryRenderer.valueExpression_return valueExpression228 =null;

        QueryRenderer.simpleCaseWhenClause_return simpleCaseWhenClause229 =null;

        QueryRenderer.elseClause_return elseClause230 =null;

        QueryRenderer.searchedWhenClause_return searchedWhenClause232 =null;

        QueryRenderer.elseClause_return elseClause233 =null;


        CommonTree NULLIF221_tree=null;
        CommonTree COALESCE224_tree=null;
        CommonTree SIMPLE_CASE227_tree=null;
        CommonTree SEARCHED_CASE231_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:294:2: ( ^( NULLIF valueExpression valueExpression ) | ^( COALESCE valueExpression ( valueExpression )* ) | ^( SIMPLE_CASE valueExpression ( simpleCaseWhenClause )+ ( elseClause )? ) | ^( SEARCHED_CASE ( searchedWhenClause )+ ( elseClause )? ) )
            int alt58=4;
            switch ( input.LA(1) ) {
            case NULLIF:
                {
                alt58=1;
                }
                break;
            case COALESCE:
                {
                alt58=2;
                }
                break;
            case SIMPLE_CASE:
                {
                alt58=3;
                }
                break;
            case SEARCHED_CASE:
                {
                alt58=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 58, 0, input);

                throw nvae;

            }

            switch (alt58) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:294:4: ^( NULLIF valueExpression valueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    NULLIF221=(CommonTree)match(input,NULLIF,FOLLOW_NULLIF_in_caseExpression1447); 


                    if ( _first_0==null ) _first_0 = NULLIF221;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_caseExpression1449);
                    valueExpression222=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression222.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_caseExpression1451);
                    valueExpression223=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression223.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:295:4: ^( COALESCE valueExpression ( valueExpression )* )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    COALESCE224=(CommonTree)match(input,COALESCE,FOLLOW_COALESCE_in_caseExpression1458); 


                    if ( _first_0==null ) _first_0 = COALESCE224;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_caseExpression1460);
                    valueExpression225=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression225.tree;


                    // org/hibernate/hql/ast/render/QueryRenderer.g:295:31: ( valueExpression )*
                    loop53:
                    do {
                        int alt53=2;
                        int LA53_0 = input.LA(1);

                        if ( (LA53_0==ABS||(LA53_0 >= ALIAS_REF && LA53_0 <= ALL)||LA53_0==ANY||(LA53_0 >= ASTERISK && LA53_0 <= AVG)||LA53_0==BIT_LENGTH||(LA53_0 >= CAST && LA53_0 <= CHARACTER_LITERAL)||LA53_0==COALESCE||(LA53_0 >= CONCAT && LA53_0 <= COUNT)||(LA53_0 >= CURRENT_DATE && LA53_0 <= CURRENT_TIMESTAMP)||LA53_0==DECIMAL_LITERAL||(LA53_0 >= DOT_CLASS && LA53_0 <= DOUBLE_PIPE)||LA53_0==ELEMENTS||LA53_0==EXISTS||LA53_0==EXTRACT||LA53_0==FALSE||LA53_0==FLOATING_POINT_LITERAL||LA53_0==FUNCTION||LA53_0==HEX_LITERAL||(LA53_0 >= INDEX && LA53_0 <= INDICES)||LA53_0==INTEGER_LITERAL||LA53_0==JAVA_CONSTANT||LA53_0==JPA_PARAM||LA53_0==LENGTH||(LA53_0 >= LOCATE && LA53_0 <= LOWER)||(LA53_0 >= MAX && LA53_0 <= MAXINDEX)||(LA53_0 >= MIN && LA53_0 <= MINUS)||LA53_0==MOD||LA53_0==NAMED_PARAM||(LA53_0 >= NULL && LA53_0 <= NULLIF)||(LA53_0 >= OCTAL_LITERAL && LA53_0 <= OCTET_LENGTH)||(LA53_0 >= PARAM && LA53_0 <= PATH)||(LA53_0 >= PLUS && LA53_0 <= POSITION)||LA53_0==PROPERTY_REFERENCE||LA53_0==SEARCHED_CASE||(LA53_0 >= SIMPLE_CASE && LA53_0 <= SOME)||(LA53_0 >= SQRT && LA53_0 <= SUM)||(LA53_0 >= TRIM && LA53_0 <= TRUE)||(LA53_0 >= UNARY_MINUS && LA53_0 <= UNARY_PLUS)||LA53_0==UPPER||LA53_0==VECTOR_EXPR) ) {
                            alt53=1;
                        }


                        switch (alt53) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/render/QueryRenderer.g:295:31: valueExpression
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    pushFollow(FOLLOW_valueExpression_in_caseExpression1462);
                    	    valueExpression226=valueExpression();

                    	    state._fsp--;

                    	     
                    	    if ( _first_1==null ) _first_1 = valueExpression226.tree;


                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    	    }
                    	    break;

                    	default :
                    	    break loop53;
                        }
                    } while (true);


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:296:4: ^( SIMPLE_CASE valueExpression ( simpleCaseWhenClause )+ ( elseClause )? )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    SIMPLE_CASE227=(CommonTree)match(input,SIMPLE_CASE,FOLLOW_SIMPLE_CASE_in_caseExpression1470); 


                    if ( _first_0==null ) _first_0 = SIMPLE_CASE227;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_caseExpression1472);
                    valueExpression228=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression228.tree;


                    // org/hibernate/hql/ast/render/QueryRenderer.g:296:34: ( simpleCaseWhenClause )+
                    int cnt54=0;
                    loop54:
                    do {
                        int alt54=2;
                        int LA54_0 = input.LA(1);

                        if ( (LA54_0==WHEN) ) {
                            alt54=1;
                        }


                        switch (alt54) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/render/QueryRenderer.g:296:34: simpleCaseWhenClause
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    pushFollow(FOLLOW_simpleCaseWhenClause_in_caseExpression1474);
                    	    simpleCaseWhenClause229=simpleCaseWhenClause();

                    	    state._fsp--;

                    	     
                    	    if ( _first_1==null ) _first_1 = simpleCaseWhenClause229.tree;


                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt54 >= 1 ) break loop54;
                                EarlyExitException eee =
                                    new EarlyExitException(54, input);
                                throw eee;
                        }
                        cnt54++;
                    } while (true);


                    // org/hibernate/hql/ast/render/QueryRenderer.g:296:56: ( elseClause )?
                    int alt55=2;
                    int LA55_0 = input.LA(1);

                    if ( (LA55_0==ELSE) ) {
                        alt55=1;
                    }
                    switch (alt55) {
                        case 1 :
                            // org/hibernate/hql/ast/render/QueryRenderer.g:296:56: elseClause
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_elseClause_in_caseExpression1477);
                            elseClause230=elseClause();

                            state._fsp--;

                             
                            if ( _first_1==null ) _first_1 = elseClause230.tree;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:297:4: ^( SEARCHED_CASE ( searchedWhenClause )+ ( elseClause )? )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    SEARCHED_CASE231=(CommonTree)match(input,SEARCHED_CASE,FOLLOW_SEARCHED_CASE_in_caseExpression1485); 


                    if ( _first_0==null ) _first_0 = SEARCHED_CASE231;
                    match(input, Token.DOWN, null); 
                    // org/hibernate/hql/ast/render/QueryRenderer.g:297:20: ( searchedWhenClause )+
                    int cnt56=0;
                    loop56:
                    do {
                        int alt56=2;
                        int LA56_0 = input.LA(1);

                        if ( (LA56_0==WHEN) ) {
                            alt56=1;
                        }


                        switch (alt56) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/render/QueryRenderer.g:297:20: searchedWhenClause
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    pushFollow(FOLLOW_searchedWhenClause_in_caseExpression1487);
                    	    searchedWhenClause232=searchedWhenClause();

                    	    state._fsp--;

                    	     
                    	    if ( _first_1==null ) _first_1 = searchedWhenClause232.tree;


                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt56 >= 1 ) break loop56;
                                EarlyExitException eee =
                                    new EarlyExitException(56, input);
                                throw eee;
                        }
                        cnt56++;
                    } while (true);


                    // org/hibernate/hql/ast/render/QueryRenderer.g:297:40: ( elseClause )?
                    int alt57=2;
                    int LA57_0 = input.LA(1);

                    if ( (LA57_0==ELSE) ) {
                        alt57=1;
                    }
                    switch (alt57) {
                        case 1 :
                            // org/hibernate/hql/ast/render/QueryRenderer.g:297:40: elseClause
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_elseClause_in_caseExpression1490);
                            elseClause233=elseClause();

                            state._fsp--;

                             
                            if ( _first_1==null ) _first_1 = elseClause233.tree;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "caseExpression"


    public static class simpleCaseWhenClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "simpleCaseWhenClause"
    // org/hibernate/hql/ast/render/QueryRenderer.g:300:1: simpleCaseWhenClause : ^( WHEN valueExpression valueExpression ) ;
    public final QueryRenderer.simpleCaseWhenClause_return simpleCaseWhenClause() throws RecognitionException {
        QueryRenderer.simpleCaseWhenClause_return retval = new QueryRenderer.simpleCaseWhenClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree WHEN234=null;
        QueryRenderer.valueExpression_return valueExpression235 =null;

        QueryRenderer.valueExpression_return valueExpression236 =null;


        CommonTree WHEN234_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:301:2: ( ^( WHEN valueExpression valueExpression ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:301:4: ^( WHEN valueExpression valueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            WHEN234=(CommonTree)match(input,WHEN,FOLLOW_WHEN_in_simpleCaseWhenClause1504); 


            if ( _first_0==null ) _first_0 = WHEN234;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_simpleCaseWhenClause1506);
            valueExpression235=valueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = valueExpression235.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_simpleCaseWhenClause1508);
            valueExpression236=valueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = valueExpression236.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "simpleCaseWhenClause"


    public static class searchedWhenClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "searchedWhenClause"
    // org/hibernate/hql/ast/render/QueryRenderer.g:304:1: searchedWhenClause : ^( WHEN searchCondition valueExpression ) ;
    public final QueryRenderer.searchedWhenClause_return searchedWhenClause() throws RecognitionException {
        QueryRenderer.searchedWhenClause_return retval = new QueryRenderer.searchedWhenClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree WHEN237=null;
        QueryRenderer.searchCondition_return searchCondition238 =null;

        QueryRenderer.valueExpression_return valueExpression239 =null;


        CommonTree WHEN237_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:305:2: ( ^( WHEN searchCondition valueExpression ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:305:4: ^( WHEN searchCondition valueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            WHEN237=(CommonTree)match(input,WHEN,FOLLOW_WHEN_in_searchedWhenClause1521); 


            if ( _first_0==null ) _first_0 = WHEN237;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_searchCondition_in_searchedWhenClause1523);
            searchCondition238=searchCondition();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = searchCondition238.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_searchedWhenClause1525);
            valueExpression239=valueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = valueExpression239.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "searchedWhenClause"


    public static class elseClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "elseClause"
    // org/hibernate/hql/ast/render/QueryRenderer.g:308:1: elseClause : ^( ELSE valueExpression ) ;
    public final QueryRenderer.elseClause_return elseClause() throws RecognitionException {
        QueryRenderer.elseClause_return retval = new QueryRenderer.elseClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ELSE240=null;
        QueryRenderer.valueExpression_return valueExpression241 =null;


        CommonTree ELSE240_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:309:2: ( ^( ELSE valueExpression ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:309:4: ^( ELSE valueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            ELSE240=(CommonTree)match(input,ELSE,FOLLOW_ELSE_in_elseClause1538); 


            if ( _first_0==null ) _first_0 = ELSE240;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_elseClause1540);
            valueExpression241=valueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = valueExpression241.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "elseClause"


    public static class function_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "function"
    // org/hibernate/hql/ast/render/QueryRenderer.g:312:1: function : ( setFunction | standardFunction );
    public final QueryRenderer.function_return function() throws RecognitionException {
        QueryRenderer.function_return retval = new QueryRenderer.function_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        QueryRenderer.setFunction_return setFunction242 =null;

        QueryRenderer.standardFunction_return standardFunction243 =null;



        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:313:2: ( setFunction | standardFunction )
            int alt59=2;
            int LA59_0 = input.LA(1);

            if ( (LA59_0==AVG||LA59_0==COUNT||LA59_0==MAX||LA59_0==MIN||LA59_0==SUM) ) {
                alt59=1;
            }
            else if ( (LA59_0==ABS||LA59_0==BIT_LENGTH||(LA59_0 >= CAST && LA59_0 <= CHARACTER_LENGTH)||LA59_0==CONCAT||(LA59_0 >= CURRENT_DATE && LA59_0 <= CURRENT_TIMESTAMP)||LA59_0==EXTRACT||LA59_0==FUNCTION||LA59_0==INDEX||LA59_0==LENGTH||(LA59_0 >= LOCATE && LA59_0 <= LOWER)||LA59_0==MOD||LA59_0==OCTET_LENGTH||LA59_0==POSITION||LA59_0==SIZE||LA59_0==SQRT||LA59_0==SUBSTRING||LA59_0==TRIM||LA59_0==UPPER) ) {
                alt59=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 59, 0, input);

                throw nvae;

            }
            switch (alt59) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:313:4: setFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_setFunction_in_function1552);
                    setFunction242=setFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = setFunction242.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:314:4: standardFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_standardFunction_in_function1557);
                    standardFunction243=standardFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = standardFunction243.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "function"


    public static class setFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "setFunction"
    // org/hibernate/hql/ast/render/QueryRenderer.g:317:1: setFunction : ( ^( SUM numericValueExpression ) | ^( AVG numericValueExpression ) | ^( MAX numericValueExpression ) | ^( MIN numericValueExpression ) | ^( COUNT ( ASTERISK | ( DISTINCT | ALL ) countFunctionArguments ) ) );
    public final QueryRenderer.setFunction_return setFunction() throws RecognitionException {
        QueryRenderer.setFunction_return retval = new QueryRenderer.setFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SUM244=null;
        CommonTree AVG246=null;
        CommonTree MAX248=null;
        CommonTree MIN250=null;
        CommonTree COUNT252=null;
        CommonTree ASTERISK253=null;
        CommonTree DISTINCT254=null;
        CommonTree ALL255=null;
        QueryRenderer.numericValueExpression_return numericValueExpression245 =null;

        QueryRenderer.numericValueExpression_return numericValueExpression247 =null;

        QueryRenderer.numericValueExpression_return numericValueExpression249 =null;

        QueryRenderer.numericValueExpression_return numericValueExpression251 =null;

        QueryRenderer.countFunctionArguments_return countFunctionArguments256 =null;


        CommonTree SUM244_tree=null;
        CommonTree AVG246_tree=null;
        CommonTree MAX248_tree=null;
        CommonTree MIN250_tree=null;
        CommonTree COUNT252_tree=null;
        CommonTree ASTERISK253_tree=null;
        CommonTree DISTINCT254_tree=null;
        CommonTree ALL255_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:319:2: ( ^( SUM numericValueExpression ) | ^( AVG numericValueExpression ) | ^( MAX numericValueExpression ) | ^( MIN numericValueExpression ) | ^( COUNT ( ASTERISK | ( DISTINCT | ALL ) countFunctionArguments ) ) )
            int alt62=5;
            switch ( input.LA(1) ) {
            case SUM:
                {
                alt62=1;
                }
                break;
            case AVG:
                {
                alt62=2;
                }
                break;
            case MAX:
                {
                alt62=3;
                }
                break;
            case MIN:
                {
                alt62=4;
                }
                break;
            case COUNT:
                {
                alt62=5;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 62, 0, input);

                throw nvae;

            }

            switch (alt62) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:319:4: ^( SUM numericValueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    SUM244=(CommonTree)match(input,SUM,FOLLOW_SUM_in_setFunction1574); 


                    if ( _first_0==null ) _first_0 = SUM244;
                     delegate.activateAggregation(AggregationPropertyPath.Type.SUM); 

                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_setFunction1578);
                    numericValueExpression245=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression245.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:320:4: ^( AVG numericValueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    AVG246=(CommonTree)match(input,AVG,FOLLOW_AVG_in_setFunction1585); 


                    if ( _first_0==null ) _first_0 = AVG246;
                     delegate.activateAggregation(AggregationPropertyPath.Type.AVG); 

                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_setFunction1589);
                    numericValueExpression247=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression247.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:321:4: ^( MAX numericValueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    MAX248=(CommonTree)match(input,MAX,FOLLOW_MAX_in_setFunction1596); 


                    if ( _first_0==null ) _first_0 = MAX248;
                     delegate.activateAggregation(AggregationPropertyPath.Type.MAX); 

                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_setFunction1600);
                    numericValueExpression249=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression249.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:322:4: ^( MIN numericValueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    MIN250=(CommonTree)match(input,MIN,FOLLOW_MIN_in_setFunction1607); 


                    if ( _first_0==null ) _first_0 = MIN250;
                     delegate.activateAggregation(AggregationPropertyPath.Type.MIN); 

                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_setFunction1611);
                    numericValueExpression251=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression251.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:323:4: ^( COUNT ( ASTERISK | ( DISTINCT | ALL ) countFunctionArguments ) )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    COUNT252=(CommonTree)match(input,COUNT,FOLLOW_COUNT_in_setFunction1618); 


                    if ( _first_0==null ) _first_0 = COUNT252;
                    match(input, Token.DOWN, null); 
                    // org/hibernate/hql/ast/render/QueryRenderer.g:323:12: ( ASTERISK | ( DISTINCT | ALL ) countFunctionArguments )
                    int alt61=2;
                    int LA61_0 = input.LA(1);

                    if ( (LA61_0==ASTERISK) ) {
                        alt61=1;
                    }
                    else if ( (LA61_0==ALL||LA61_0==DISTINCT) ) {
                        alt61=2;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("", 61, 0, input);

                        throw nvae;

                    }
                    switch (alt61) {
                        case 1 :
                            // org/hibernate/hql/ast/render/QueryRenderer.g:323:13: ASTERISK
                            {
                            _last = (CommonTree)input.LT(1);
                            ASTERISK253=(CommonTree)match(input,ASTERISK,FOLLOW_ASTERISK_in_setFunction1621); 
                             
                            if ( _first_1==null ) _first_1 = ASTERISK253;


                             delegate.activateAggregation( AggregationPropertyPath.Type.COUNT ); 

                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;
                        case 2 :
                            // org/hibernate/hql/ast/render/QueryRenderer.g:323:96: ( DISTINCT | ALL ) countFunctionArguments
                            {
                            // org/hibernate/hql/ast/render/QueryRenderer.g:323:96: ( DISTINCT | ALL )
                            int alt60=2;
                            int LA60_0 = input.LA(1);

                            if ( (LA60_0==DISTINCT) ) {
                                alt60=1;
                            }
                            else if ( (LA60_0==ALL) ) {
                                alt60=2;
                            }
                            else {
                                NoViableAltException nvae =
                                    new NoViableAltException("", 60, 0, input);

                                throw nvae;

                            }
                            switch (alt60) {
                                case 1 :
                                    // org/hibernate/hql/ast/render/QueryRenderer.g:323:97: DISTINCT
                                    {
                                    _last = (CommonTree)input.LT(1);
                                    DISTINCT254=(CommonTree)match(input,DISTINCT,FOLLOW_DISTINCT_in_setFunction1628); 
                                     
                                    if ( _first_1==null ) _first_1 = DISTINCT254;


                                     delegate.activateAggregation( AggregationPropertyPath.Type.COUNT_DISTINCT ); 

                                    retval.tree = (CommonTree)_first_0;
                                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                                    }
                                    break;
                                case 2 :
                                    // org/hibernate/hql/ast/render/QueryRenderer.g:323:189: ALL
                                    {
                                    _last = (CommonTree)input.LT(1);
                                    ALL255=(CommonTree)match(input,ALL,FOLLOW_ALL_in_setFunction1634); 
                                     
                                    if ( _first_1==null ) _first_1 = ALL255;


                                     delegate.activateAggregation( AggregationPropertyPath.Type.COUNT ); 

                                    retval.tree = (CommonTree)_first_0;
                                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                                    }
                                    break;

                            }


                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_countFunctionArguments_in_setFunction1639);
                            countFunctionArguments256=countFunctionArguments();

                            state._fsp--;

                             
                            if ( _first_1==null ) _first_1 = countFunctionArguments256.tree;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
             delegate.deactivateAggregation(); 
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "setFunction"


    public static class standardFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "standardFunction"
    // org/hibernate/hql/ast/render/QueryRenderer.g:326:1: standardFunction : ( functionFunction | castFunction | concatFunction | substringFunction | trimFunction | upperFunction | lowerFunction | lengthFunction | locateFunction | absFunction | sqrtFunction | modFunction | sizeFunction | indexFunction | currentDateFunction | currentTimeFunction | currentTimestampFunction | extractFunction | positionFunction | charLengthFunction | octetLengthFunction | bitLengthFunction );
    public final QueryRenderer.standardFunction_return standardFunction() throws RecognitionException {
        QueryRenderer.standardFunction_return retval = new QueryRenderer.standardFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        QueryRenderer.functionFunction_return functionFunction257 =null;

        QueryRenderer.castFunction_return castFunction258 =null;

        QueryRenderer.concatFunction_return concatFunction259 =null;

        QueryRenderer.substringFunction_return substringFunction260 =null;

        QueryRenderer.trimFunction_return trimFunction261 =null;

        QueryRenderer.upperFunction_return upperFunction262 =null;

        QueryRenderer.lowerFunction_return lowerFunction263 =null;

        QueryRenderer.lengthFunction_return lengthFunction264 =null;

        QueryRenderer.locateFunction_return locateFunction265 =null;

        QueryRenderer.absFunction_return absFunction266 =null;

        QueryRenderer.sqrtFunction_return sqrtFunction267 =null;

        QueryRenderer.modFunction_return modFunction268 =null;

        QueryRenderer.sizeFunction_return sizeFunction269 =null;

        QueryRenderer.indexFunction_return indexFunction270 =null;

        QueryRenderer.currentDateFunction_return currentDateFunction271 =null;

        QueryRenderer.currentTimeFunction_return currentTimeFunction272 =null;

        QueryRenderer.currentTimestampFunction_return currentTimestampFunction273 =null;

        QueryRenderer.extractFunction_return extractFunction274 =null;

        QueryRenderer.positionFunction_return positionFunction275 =null;

        QueryRenderer.charLengthFunction_return charLengthFunction276 =null;

        QueryRenderer.octetLengthFunction_return octetLengthFunction277 =null;

        QueryRenderer.bitLengthFunction_return bitLengthFunction278 =null;



        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:327:2: ( functionFunction | castFunction | concatFunction | substringFunction | trimFunction | upperFunction | lowerFunction | lengthFunction | locateFunction | absFunction | sqrtFunction | modFunction | sizeFunction | indexFunction | currentDateFunction | currentTimeFunction | currentTimestampFunction | extractFunction | positionFunction | charLengthFunction | octetLengthFunction | bitLengthFunction )
            int alt63=22;
            switch ( input.LA(1) ) {
            case FUNCTION:
                {
                alt63=1;
                }
                break;
            case CAST:
                {
                alt63=2;
                }
                break;
            case CONCAT:
                {
                alt63=3;
                }
                break;
            case SUBSTRING:
                {
                alt63=4;
                }
                break;
            case TRIM:
                {
                alt63=5;
                }
                break;
            case UPPER:
                {
                alt63=6;
                }
                break;
            case LOWER:
                {
                alt63=7;
                }
                break;
            case LENGTH:
                {
                alt63=8;
                }
                break;
            case LOCATE:
                {
                alt63=9;
                }
                break;
            case ABS:
                {
                alt63=10;
                }
                break;
            case SQRT:
                {
                alt63=11;
                }
                break;
            case MOD:
                {
                alt63=12;
                }
                break;
            case SIZE:
                {
                alt63=13;
                }
                break;
            case INDEX:
                {
                alt63=14;
                }
                break;
            case CURRENT_DATE:
                {
                alt63=15;
                }
                break;
            case CURRENT_TIME:
                {
                alt63=16;
                }
                break;
            case CURRENT_TIMESTAMP:
                {
                alt63=17;
                }
                break;
            case EXTRACT:
                {
                alt63=18;
                }
                break;
            case POSITION:
                {
                alt63=19;
                }
                break;
            case CHARACTER_LENGTH:
                {
                alt63=20;
                }
                break;
            case OCTET_LENGTH:
                {
                alt63=21;
                }
                break;
            case BIT_LENGTH:
                {
                alt63=22;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 63, 0, input);

                throw nvae;

            }

            switch (alt63) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:327:4: functionFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_functionFunction_in_standardFunction1652);
                    functionFunction257=functionFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = functionFunction257.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:328:4: castFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_castFunction_in_standardFunction1657);
                    castFunction258=castFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = castFunction258.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:329:4: concatFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_concatFunction_in_standardFunction1662);
                    concatFunction259=concatFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = concatFunction259.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:330:4: substringFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_substringFunction_in_standardFunction1667);
                    substringFunction260=substringFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = substringFunction260.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:331:4: trimFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_trimFunction_in_standardFunction1672);
                    trimFunction261=trimFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = trimFunction261.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 6 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:332:4: upperFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_upperFunction_in_standardFunction1677);
                    upperFunction262=upperFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = upperFunction262.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 7 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:333:4: lowerFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_lowerFunction_in_standardFunction1682);
                    lowerFunction263=lowerFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = lowerFunction263.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 8 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:334:4: lengthFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_lengthFunction_in_standardFunction1687);
                    lengthFunction264=lengthFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = lengthFunction264.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 9 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:335:4: locateFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_locateFunction_in_standardFunction1692);
                    locateFunction265=locateFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = locateFunction265.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 10 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:336:4: absFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_absFunction_in_standardFunction1697);
                    absFunction266=absFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = absFunction266.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 11 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:337:4: sqrtFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_sqrtFunction_in_standardFunction1702);
                    sqrtFunction267=sqrtFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = sqrtFunction267.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 12 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:338:4: modFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_modFunction_in_standardFunction1707);
                    modFunction268=modFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = modFunction268.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 13 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:339:4: sizeFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_sizeFunction_in_standardFunction1712);
                    sizeFunction269=sizeFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = sizeFunction269.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 14 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:340:4: indexFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_indexFunction_in_standardFunction1717);
                    indexFunction270=indexFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = indexFunction270.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 15 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:341:4: currentDateFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_currentDateFunction_in_standardFunction1722);
                    currentDateFunction271=currentDateFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = currentDateFunction271.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 16 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:342:4: currentTimeFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_currentTimeFunction_in_standardFunction1727);
                    currentTimeFunction272=currentTimeFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = currentTimeFunction272.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 17 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:343:4: currentTimestampFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_currentTimestampFunction_in_standardFunction1732);
                    currentTimestampFunction273=currentTimestampFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = currentTimestampFunction273.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 18 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:344:4: extractFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_extractFunction_in_standardFunction1737);
                    extractFunction274=extractFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = extractFunction274.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 19 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:345:4: positionFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_positionFunction_in_standardFunction1742);
                    positionFunction275=positionFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = positionFunction275.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 20 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:346:4: charLengthFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_charLengthFunction_in_standardFunction1747);
                    charLengthFunction276=charLengthFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = charLengthFunction276.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 21 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:347:4: octetLengthFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_octetLengthFunction_in_standardFunction1752);
                    octetLengthFunction277=octetLengthFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = octetLengthFunction277.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 22 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:348:4: bitLengthFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_bitLengthFunction_in_standardFunction1757);
                    bitLengthFunction278=bitLengthFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = bitLengthFunction278.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "standardFunction"


    public static class functionFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "functionFunction"
    // org/hibernate/hql/ast/render/QueryRenderer.g:351:1: functionFunction : ^( FUNCTION ( valueExpression )* ) ;
    public final QueryRenderer.functionFunction_return functionFunction() throws RecognitionException {
        QueryRenderer.functionFunction_return retval = new QueryRenderer.functionFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree FUNCTION279=null;
        QueryRenderer.valueExpression_return valueExpression280 =null;


        CommonTree FUNCTION279_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:352:2: ( ^( FUNCTION ( valueExpression )* ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:352:4: ^( FUNCTION ( valueExpression )* )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            FUNCTION279=(CommonTree)match(input,FUNCTION,FOLLOW_FUNCTION_in_functionFunction1770); 


            if ( _first_0==null ) _first_0 = FUNCTION279;
            if ( input.LA(1)==Token.DOWN ) {
                match(input, Token.DOWN, null); 
                // org/hibernate/hql/ast/render/QueryRenderer.g:352:16: ( valueExpression )*
                loop64:
                do {
                    int alt64=2;
                    int LA64_0 = input.LA(1);

                    if ( (LA64_0==ABS||(LA64_0 >= ALIAS_REF && LA64_0 <= ALL)||LA64_0==ANY||(LA64_0 >= ASTERISK && LA64_0 <= AVG)||LA64_0==BIT_LENGTH||(LA64_0 >= CAST && LA64_0 <= CHARACTER_LITERAL)||LA64_0==COALESCE||(LA64_0 >= CONCAT && LA64_0 <= COUNT)||(LA64_0 >= CURRENT_DATE && LA64_0 <= CURRENT_TIMESTAMP)||LA64_0==DECIMAL_LITERAL||(LA64_0 >= DOT_CLASS && LA64_0 <= DOUBLE_PIPE)||LA64_0==ELEMENTS||LA64_0==EXISTS||LA64_0==EXTRACT||LA64_0==FALSE||LA64_0==FLOATING_POINT_LITERAL||LA64_0==FUNCTION||LA64_0==HEX_LITERAL||(LA64_0 >= INDEX && LA64_0 <= INDICES)||LA64_0==INTEGER_LITERAL||LA64_0==JAVA_CONSTANT||LA64_0==JPA_PARAM||LA64_0==LENGTH||(LA64_0 >= LOCATE && LA64_0 <= LOWER)||(LA64_0 >= MAX && LA64_0 <= MAXINDEX)||(LA64_0 >= MIN && LA64_0 <= MINUS)||LA64_0==MOD||LA64_0==NAMED_PARAM||(LA64_0 >= NULL && LA64_0 <= NULLIF)||(LA64_0 >= OCTAL_LITERAL && LA64_0 <= OCTET_LENGTH)||(LA64_0 >= PARAM && LA64_0 <= PATH)||(LA64_0 >= PLUS && LA64_0 <= POSITION)||LA64_0==PROPERTY_REFERENCE||LA64_0==SEARCHED_CASE||(LA64_0 >= SIMPLE_CASE && LA64_0 <= SOME)||(LA64_0 >= SQRT && LA64_0 <= SUM)||(LA64_0 >= TRIM && LA64_0 <= TRUE)||(LA64_0 >= UNARY_MINUS && LA64_0 <= UNARY_PLUS)||LA64_0==UPPER||LA64_0==VECTOR_EXPR) ) {
                        alt64=1;
                    }


                    switch (alt64) {
                	case 1 :
                	    // org/hibernate/hql/ast/render/QueryRenderer.g:352:16: valueExpression
                	    {
                	    _last = (CommonTree)input.LT(1);
                	    pushFollow(FOLLOW_valueExpression_in_functionFunction1772);
                	    valueExpression280=valueExpression();

                	    state._fsp--;

                	     
                	    if ( _first_1==null ) _first_1 = valueExpression280.tree;


                	    retval.tree = (CommonTree)_first_0;
                	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                	    }
                	    break;

                	default :
                	    break loop64;
                    }
                } while (true);


                match(input, Token.UP, null); 
            }
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "functionFunction"


    public static class castFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "castFunction"
    // org/hibernate/hql/ast/render/QueryRenderer.g:355:1: castFunction : ^( CAST valueExpression IDENTIFIER ) ;
    public final QueryRenderer.castFunction_return castFunction() throws RecognitionException {
        QueryRenderer.castFunction_return retval = new QueryRenderer.castFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree CAST281=null;
        CommonTree IDENTIFIER283=null;
        QueryRenderer.valueExpression_return valueExpression282 =null;


        CommonTree CAST281_tree=null;
        CommonTree IDENTIFIER283_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:356:2: ( ^( CAST valueExpression IDENTIFIER ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:356:4: ^( CAST valueExpression IDENTIFIER )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            CAST281=(CommonTree)match(input,CAST,FOLLOW_CAST_in_castFunction1787); 


            if ( _first_0==null ) _first_0 = CAST281;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_castFunction1789);
            valueExpression282=valueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = valueExpression282.tree;


            _last = (CommonTree)input.LT(1);
            IDENTIFIER283=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_castFunction1791); 
             
            if ( _first_1==null ) _first_1 = IDENTIFIER283;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "castFunction"


    public static class concatFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "concatFunction"
    // org/hibernate/hql/ast/render/QueryRenderer.g:360:1: concatFunction : ^( CONCAT ( valueExpression )+ ) ;
    public final QueryRenderer.concatFunction_return concatFunction() throws RecognitionException {
        QueryRenderer.concatFunction_return retval = new QueryRenderer.concatFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree CONCAT284=null;
        QueryRenderer.valueExpression_return valueExpression285 =null;


        CommonTree CONCAT284_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:361:2: ( ^( CONCAT ( valueExpression )+ ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:361:4: ^( CONCAT ( valueExpression )+ )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            CONCAT284=(CommonTree)match(input,CONCAT,FOLLOW_CONCAT_in_concatFunction1806); 


            if ( _first_0==null ) _first_0 = CONCAT284;
            match(input, Token.DOWN, null); 
            // org/hibernate/hql/ast/render/QueryRenderer.g:361:13: ( valueExpression )+
            int cnt65=0;
            loop65:
            do {
                int alt65=2;
                int LA65_0 = input.LA(1);

                if ( (LA65_0==ABS||(LA65_0 >= ALIAS_REF && LA65_0 <= ALL)||LA65_0==ANY||(LA65_0 >= ASTERISK && LA65_0 <= AVG)||LA65_0==BIT_LENGTH||(LA65_0 >= CAST && LA65_0 <= CHARACTER_LITERAL)||LA65_0==COALESCE||(LA65_0 >= CONCAT && LA65_0 <= COUNT)||(LA65_0 >= CURRENT_DATE && LA65_0 <= CURRENT_TIMESTAMP)||LA65_0==DECIMAL_LITERAL||(LA65_0 >= DOT_CLASS && LA65_0 <= DOUBLE_PIPE)||LA65_0==ELEMENTS||LA65_0==EXISTS||LA65_0==EXTRACT||LA65_0==FALSE||LA65_0==FLOATING_POINT_LITERAL||LA65_0==FUNCTION||LA65_0==HEX_LITERAL||(LA65_0 >= INDEX && LA65_0 <= INDICES)||LA65_0==INTEGER_LITERAL||LA65_0==JAVA_CONSTANT||LA65_0==JPA_PARAM||LA65_0==LENGTH||(LA65_0 >= LOCATE && LA65_0 <= LOWER)||(LA65_0 >= MAX && LA65_0 <= MAXINDEX)||(LA65_0 >= MIN && LA65_0 <= MINUS)||LA65_0==MOD||LA65_0==NAMED_PARAM||(LA65_0 >= NULL && LA65_0 <= NULLIF)||(LA65_0 >= OCTAL_LITERAL && LA65_0 <= OCTET_LENGTH)||(LA65_0 >= PARAM && LA65_0 <= PATH)||(LA65_0 >= PLUS && LA65_0 <= POSITION)||LA65_0==PROPERTY_REFERENCE||LA65_0==SEARCHED_CASE||(LA65_0 >= SIMPLE_CASE && LA65_0 <= SOME)||(LA65_0 >= SQRT && LA65_0 <= SUM)||(LA65_0 >= TRIM && LA65_0 <= TRUE)||(LA65_0 >= UNARY_MINUS && LA65_0 <= UNARY_PLUS)||LA65_0==UPPER||LA65_0==VECTOR_EXPR) ) {
                    alt65=1;
                }


                switch (alt65) {
            	case 1 :
            	    // org/hibernate/hql/ast/render/QueryRenderer.g:361:13: valueExpression
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_valueExpression_in_concatFunction1808);
            	    valueExpression285=valueExpression();

            	    state._fsp--;

            	     
            	    if ( _first_1==null ) _first_1 = valueExpression285.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt65 >= 1 ) break loop65;
                        EarlyExitException eee =
                            new EarlyExitException(65, input);
                        throw eee;
                }
                cnt65++;
            } while (true);


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "concatFunction"


    public static class substringFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "substringFunction"
    // org/hibernate/hql/ast/render/QueryRenderer.g:364:1: substringFunction : ^( SUBSTRING characterValueExpression numericValueExpression ( numericValueExpression )? ) ;
    public final QueryRenderer.substringFunction_return substringFunction() throws RecognitionException {
        QueryRenderer.substringFunction_return retval = new QueryRenderer.substringFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SUBSTRING286=null;
        QueryRenderer.characterValueExpression_return characterValueExpression287 =null;

        QueryRenderer.numericValueExpression_return numericValueExpression288 =null;

        QueryRenderer.numericValueExpression_return numericValueExpression289 =null;


        CommonTree SUBSTRING286_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:365:2: ( ^( SUBSTRING characterValueExpression numericValueExpression ( numericValueExpression )? ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:365:4: ^( SUBSTRING characterValueExpression numericValueExpression ( numericValueExpression )? )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            SUBSTRING286=(CommonTree)match(input,SUBSTRING,FOLLOW_SUBSTRING_in_substringFunction1822); 


            if ( _first_0==null ) _first_0 = SUBSTRING286;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_substringFunction1824);
            characterValueExpression287=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression287.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_numericValueExpression_in_substringFunction1826);
            numericValueExpression288=numericValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = numericValueExpression288.tree;


            // org/hibernate/hql/ast/render/QueryRenderer.g:365:64: ( numericValueExpression )?
            int alt66=2;
            int LA66_0 = input.LA(1);

            if ( (LA66_0==ABS||(LA66_0 >= ALIAS_REF && LA66_0 <= ALL)||LA66_0==ANY||(LA66_0 >= ASTERISK && LA66_0 <= AVG)||LA66_0==BIT_LENGTH||(LA66_0 >= CAST && LA66_0 <= CHARACTER_LITERAL)||LA66_0==COALESCE||(LA66_0 >= CONCAT && LA66_0 <= COUNT)||(LA66_0 >= CURRENT_DATE && LA66_0 <= CURRENT_TIMESTAMP)||LA66_0==DECIMAL_LITERAL||(LA66_0 >= DOT_CLASS && LA66_0 <= DOUBLE_PIPE)||LA66_0==ELEMENTS||LA66_0==EXISTS||LA66_0==EXTRACT||LA66_0==FALSE||LA66_0==FLOATING_POINT_LITERAL||LA66_0==FUNCTION||LA66_0==HEX_LITERAL||(LA66_0 >= INDEX && LA66_0 <= INDICES)||LA66_0==INTEGER_LITERAL||LA66_0==JAVA_CONSTANT||LA66_0==JPA_PARAM||LA66_0==LENGTH||(LA66_0 >= LOCATE && LA66_0 <= LOWER)||(LA66_0 >= MAX && LA66_0 <= MAXINDEX)||(LA66_0 >= MIN && LA66_0 <= MINUS)||LA66_0==MOD||LA66_0==NAMED_PARAM||(LA66_0 >= NULL && LA66_0 <= NULLIF)||(LA66_0 >= OCTAL_LITERAL && LA66_0 <= OCTET_LENGTH)||(LA66_0 >= PARAM && LA66_0 <= PATH)||(LA66_0 >= PLUS && LA66_0 <= POSITION)||LA66_0==PROPERTY_REFERENCE||LA66_0==SEARCHED_CASE||(LA66_0 >= SIMPLE_CASE && LA66_0 <= SOME)||(LA66_0 >= SQRT && LA66_0 <= SUM)||(LA66_0 >= TRIM && LA66_0 <= TRUE)||(LA66_0 >= UNARY_MINUS && LA66_0 <= UNARY_PLUS)||LA66_0==UPPER||LA66_0==VECTOR_EXPR) ) {
                alt66=1;
            }
            switch (alt66) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:365:64: numericValueExpression
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_substringFunction1828);
                    numericValueExpression289=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression289.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "substringFunction"


    public static class trimFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "trimFunction"
    // org/hibernate/hql/ast/render/QueryRenderer.g:368:1: trimFunction : ^( TRIM trimOperands ) ;
    public final QueryRenderer.trimFunction_return trimFunction() throws RecognitionException {
        QueryRenderer.trimFunction_return retval = new QueryRenderer.trimFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree TRIM290=null;
        QueryRenderer.trimOperands_return trimOperands291 =null;


        CommonTree TRIM290_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:369:2: ( ^( TRIM trimOperands ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:369:4: ^( TRIM trimOperands )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            TRIM290=(CommonTree)match(input,TRIM,FOLLOW_TRIM_in_trimFunction1842); 


            if ( _first_0==null ) _first_0 = TRIM290;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_trimOperands_in_trimFunction1844);
            trimOperands291=trimOperands();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = trimOperands291.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "trimFunction"


    public static class trimOperands_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "trimOperands"
    // org/hibernate/hql/ast/render/QueryRenderer.g:372:1: trimOperands : ^( ( LEADING | TRAILING | BOTH ) characterValueExpression characterValueExpression ) ;
    public final QueryRenderer.trimOperands_return trimOperands() throws RecognitionException {
        QueryRenderer.trimOperands_return retval = new QueryRenderer.trimOperands_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set292=null;
        QueryRenderer.characterValueExpression_return characterValueExpression293 =null;

        QueryRenderer.characterValueExpression_return characterValueExpression294 =null;


        CommonTree set292_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:373:2: ( ^( ( LEADING | TRAILING | BOTH ) characterValueExpression characterValueExpression ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:373:4: ^( ( LEADING | TRAILING | BOTH ) characterValueExpression characterValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            set292=(CommonTree)input.LT(1);

            if ( input.LA(1)==BOTH||input.LA(1)==LEADING||input.LA(1)==TRAILING ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            if ( _first_0==null ) _first_0 = set292;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_trimOperands1865);
            characterValueExpression293=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression293.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_trimOperands1867);
            characterValueExpression294=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression294.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "trimOperands"


    public static class upperFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "upperFunction"
    // org/hibernate/hql/ast/render/QueryRenderer.g:376:1: upperFunction : ^( UPPER characterValueExpression ) ;
    public final QueryRenderer.upperFunction_return upperFunction() throws RecognitionException {
        QueryRenderer.upperFunction_return retval = new QueryRenderer.upperFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree UPPER295=null;
        QueryRenderer.characterValueExpression_return characterValueExpression296 =null;


        CommonTree UPPER295_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:377:2: ( ^( UPPER characterValueExpression ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:377:4: ^( UPPER characterValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            UPPER295=(CommonTree)match(input,UPPER,FOLLOW_UPPER_in_upperFunction1880); 


            if ( _first_0==null ) _first_0 = UPPER295;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_upperFunction1882);
            characterValueExpression296=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression296.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "upperFunction"


    public static class lowerFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "lowerFunction"
    // org/hibernate/hql/ast/render/QueryRenderer.g:380:1: lowerFunction : ^( LOWER characterValueExpression ) ;
    public final QueryRenderer.lowerFunction_return lowerFunction() throws RecognitionException {
        QueryRenderer.lowerFunction_return retval = new QueryRenderer.lowerFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree LOWER297=null;
        QueryRenderer.characterValueExpression_return characterValueExpression298 =null;


        CommonTree LOWER297_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:381:2: ( ^( LOWER characterValueExpression ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:381:4: ^( LOWER characterValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            LOWER297=(CommonTree)match(input,LOWER,FOLLOW_LOWER_in_lowerFunction1895); 


            if ( _first_0==null ) _first_0 = LOWER297;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_lowerFunction1897);
            characterValueExpression298=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression298.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "lowerFunction"


    public static class lengthFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "lengthFunction"
    // org/hibernate/hql/ast/render/QueryRenderer.g:384:1: lengthFunction : ^( LENGTH characterValueExpression ) ;
    public final QueryRenderer.lengthFunction_return lengthFunction() throws RecognitionException {
        QueryRenderer.lengthFunction_return retval = new QueryRenderer.lengthFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree LENGTH299=null;
        QueryRenderer.characterValueExpression_return characterValueExpression300 =null;


        CommonTree LENGTH299_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:385:2: ( ^( LENGTH characterValueExpression ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:385:4: ^( LENGTH characterValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            LENGTH299=(CommonTree)match(input,LENGTH,FOLLOW_LENGTH_in_lengthFunction1910); 


            if ( _first_0==null ) _first_0 = LENGTH299;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_lengthFunction1912);
            characterValueExpression300=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression300.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "lengthFunction"


    public static class locateFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "locateFunction"
    // org/hibernate/hql/ast/render/QueryRenderer.g:388:1: locateFunction : ^( LOCATE characterValueExpression characterValueExpression ( numericValueExpression )? ) ;
    public final QueryRenderer.locateFunction_return locateFunction() throws RecognitionException {
        QueryRenderer.locateFunction_return retval = new QueryRenderer.locateFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree LOCATE301=null;
        QueryRenderer.characterValueExpression_return characterValueExpression302 =null;

        QueryRenderer.characterValueExpression_return characterValueExpression303 =null;

        QueryRenderer.numericValueExpression_return numericValueExpression304 =null;


        CommonTree LOCATE301_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:389:2: ( ^( LOCATE characterValueExpression characterValueExpression ( numericValueExpression )? ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:389:4: ^( LOCATE characterValueExpression characterValueExpression ( numericValueExpression )? )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            LOCATE301=(CommonTree)match(input,LOCATE,FOLLOW_LOCATE_in_locateFunction1925); 


            if ( _first_0==null ) _first_0 = LOCATE301;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_locateFunction1927);
            characterValueExpression302=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression302.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_locateFunction1929);
            characterValueExpression303=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression303.tree;


            // org/hibernate/hql/ast/render/QueryRenderer.g:389:63: ( numericValueExpression )?
            int alt67=2;
            int LA67_0 = input.LA(1);

            if ( (LA67_0==ABS||(LA67_0 >= ALIAS_REF && LA67_0 <= ALL)||LA67_0==ANY||(LA67_0 >= ASTERISK && LA67_0 <= AVG)||LA67_0==BIT_LENGTH||(LA67_0 >= CAST && LA67_0 <= CHARACTER_LITERAL)||LA67_0==COALESCE||(LA67_0 >= CONCAT && LA67_0 <= COUNT)||(LA67_0 >= CURRENT_DATE && LA67_0 <= CURRENT_TIMESTAMP)||LA67_0==DECIMAL_LITERAL||(LA67_0 >= DOT_CLASS && LA67_0 <= DOUBLE_PIPE)||LA67_0==ELEMENTS||LA67_0==EXISTS||LA67_0==EXTRACT||LA67_0==FALSE||LA67_0==FLOATING_POINT_LITERAL||LA67_0==FUNCTION||LA67_0==HEX_LITERAL||(LA67_0 >= INDEX && LA67_0 <= INDICES)||LA67_0==INTEGER_LITERAL||LA67_0==JAVA_CONSTANT||LA67_0==JPA_PARAM||LA67_0==LENGTH||(LA67_0 >= LOCATE && LA67_0 <= LOWER)||(LA67_0 >= MAX && LA67_0 <= MAXINDEX)||(LA67_0 >= MIN && LA67_0 <= MINUS)||LA67_0==MOD||LA67_0==NAMED_PARAM||(LA67_0 >= NULL && LA67_0 <= NULLIF)||(LA67_0 >= OCTAL_LITERAL && LA67_0 <= OCTET_LENGTH)||(LA67_0 >= PARAM && LA67_0 <= PATH)||(LA67_0 >= PLUS && LA67_0 <= POSITION)||LA67_0==PROPERTY_REFERENCE||LA67_0==SEARCHED_CASE||(LA67_0 >= SIMPLE_CASE && LA67_0 <= SOME)||(LA67_0 >= SQRT && LA67_0 <= SUM)||(LA67_0 >= TRIM && LA67_0 <= TRUE)||(LA67_0 >= UNARY_MINUS && LA67_0 <= UNARY_PLUS)||LA67_0==UPPER||LA67_0==VECTOR_EXPR) ) {
                alt67=1;
            }
            switch (alt67) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:389:63: numericValueExpression
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_locateFunction1931);
                    numericValueExpression304=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression304.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "locateFunction"


    public static class absFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "absFunction"
    // org/hibernate/hql/ast/render/QueryRenderer.g:392:1: absFunction : ^( ABS numericValueExpression ) ;
    public final QueryRenderer.absFunction_return absFunction() throws RecognitionException {
        QueryRenderer.absFunction_return retval = new QueryRenderer.absFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ABS305=null;
        QueryRenderer.numericValueExpression_return numericValueExpression306 =null;


        CommonTree ABS305_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:393:2: ( ^( ABS numericValueExpression ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:393:4: ^( ABS numericValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            ABS305=(CommonTree)match(input,ABS,FOLLOW_ABS_in_absFunction1945); 


            if ( _first_0==null ) _first_0 = ABS305;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_numericValueExpression_in_absFunction1947);
            numericValueExpression306=numericValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = numericValueExpression306.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "absFunction"


    public static class sqrtFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "sqrtFunction"
    // org/hibernate/hql/ast/render/QueryRenderer.g:396:1: sqrtFunction : ^( SQRT numericValueExpression ) ;
    public final QueryRenderer.sqrtFunction_return sqrtFunction() throws RecognitionException {
        QueryRenderer.sqrtFunction_return retval = new QueryRenderer.sqrtFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SQRT307=null;
        QueryRenderer.numericValueExpression_return numericValueExpression308 =null;


        CommonTree SQRT307_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:397:2: ( ^( SQRT numericValueExpression ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:397:4: ^( SQRT numericValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            SQRT307=(CommonTree)match(input,SQRT,FOLLOW_SQRT_in_sqrtFunction1960); 


            if ( _first_0==null ) _first_0 = SQRT307;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_numericValueExpression_in_sqrtFunction1962);
            numericValueExpression308=numericValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = numericValueExpression308.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "sqrtFunction"


    public static class modFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "modFunction"
    // org/hibernate/hql/ast/render/QueryRenderer.g:400:1: modFunction : ^( MOD numericValueExpression numericValueExpression ) ;
    public final QueryRenderer.modFunction_return modFunction() throws RecognitionException {
        QueryRenderer.modFunction_return retval = new QueryRenderer.modFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree MOD309=null;
        QueryRenderer.numericValueExpression_return numericValueExpression310 =null;

        QueryRenderer.numericValueExpression_return numericValueExpression311 =null;


        CommonTree MOD309_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:401:2: ( ^( MOD numericValueExpression numericValueExpression ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:401:4: ^( MOD numericValueExpression numericValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            MOD309=(CommonTree)match(input,MOD,FOLLOW_MOD_in_modFunction1975); 


            if ( _first_0==null ) _first_0 = MOD309;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_numericValueExpression_in_modFunction1977);
            numericValueExpression310=numericValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = numericValueExpression310.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_numericValueExpression_in_modFunction1979);
            numericValueExpression311=numericValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = numericValueExpression311.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "modFunction"


    public static class sizeFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "sizeFunction"
    // org/hibernate/hql/ast/render/QueryRenderer.g:404:1: sizeFunction : ^( SIZE propertyReference ) ;
    public final QueryRenderer.sizeFunction_return sizeFunction() throws RecognitionException {
        QueryRenderer.sizeFunction_return retval = new QueryRenderer.sizeFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SIZE312=null;
        QueryRenderer.propertyReference_return propertyReference313 =null;


        CommonTree SIZE312_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:405:2: ( ^( SIZE propertyReference ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:405:4: ^( SIZE propertyReference )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            SIZE312=(CommonTree)match(input,SIZE,FOLLOW_SIZE_in_sizeFunction1992); 


            if ( _first_0==null ) _first_0 = SIZE312;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_propertyReference_in_sizeFunction1994);
            propertyReference313=propertyReference();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = propertyReference313.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "sizeFunction"


    public static class indexFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indexFunction"
    // org/hibernate/hql/ast/render/QueryRenderer.g:408:1: indexFunction : ^( INDEX ALIAS_REF ) ;
    public final QueryRenderer.indexFunction_return indexFunction() throws RecognitionException {
        QueryRenderer.indexFunction_return retval = new QueryRenderer.indexFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree INDEX314=null;
        CommonTree ALIAS_REF315=null;

        CommonTree INDEX314_tree=null;
        CommonTree ALIAS_REF315_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:409:2: ( ^( INDEX ALIAS_REF ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:409:4: ^( INDEX ALIAS_REF )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            INDEX314=(CommonTree)match(input,INDEX,FOLLOW_INDEX_in_indexFunction2007); 


            if ( _first_0==null ) _first_0 = INDEX314;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            ALIAS_REF315=(CommonTree)match(input,ALIAS_REF,FOLLOW_ALIAS_REF_in_indexFunction2009); 
             
            if ( _first_1==null ) _first_1 = ALIAS_REF315;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indexFunction"


    public static class currentDateFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "currentDateFunction"
    // org/hibernate/hql/ast/render/QueryRenderer.g:412:1: currentDateFunction : CURRENT_DATE ;
    public final QueryRenderer.currentDateFunction_return currentDateFunction() throws RecognitionException {
        QueryRenderer.currentDateFunction_return retval = new QueryRenderer.currentDateFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree CURRENT_DATE316=null;

        CommonTree CURRENT_DATE316_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:413:2: ( CURRENT_DATE )
            // org/hibernate/hql/ast/render/QueryRenderer.g:413:4: CURRENT_DATE
            {
            _last = (CommonTree)input.LT(1);
            CURRENT_DATE316=(CommonTree)match(input,CURRENT_DATE,FOLLOW_CURRENT_DATE_in_currentDateFunction2021); 
             
            if ( _first_0==null ) _first_0 = CURRENT_DATE316;


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "currentDateFunction"


    public static class currentTimeFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "currentTimeFunction"
    // org/hibernate/hql/ast/render/QueryRenderer.g:416:1: currentTimeFunction : CURRENT_TIME ;
    public final QueryRenderer.currentTimeFunction_return currentTimeFunction() throws RecognitionException {
        QueryRenderer.currentTimeFunction_return retval = new QueryRenderer.currentTimeFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree CURRENT_TIME317=null;

        CommonTree CURRENT_TIME317_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:417:2: ( CURRENT_TIME )
            // org/hibernate/hql/ast/render/QueryRenderer.g:417:4: CURRENT_TIME
            {
            _last = (CommonTree)input.LT(1);
            CURRENT_TIME317=(CommonTree)match(input,CURRENT_TIME,FOLLOW_CURRENT_TIME_in_currentTimeFunction2032); 
             
            if ( _first_0==null ) _first_0 = CURRENT_TIME317;


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "currentTimeFunction"


    public static class currentTimestampFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "currentTimestampFunction"
    // org/hibernate/hql/ast/render/QueryRenderer.g:420:1: currentTimestampFunction : CURRENT_TIMESTAMP ;
    public final QueryRenderer.currentTimestampFunction_return currentTimestampFunction() throws RecognitionException {
        QueryRenderer.currentTimestampFunction_return retval = new QueryRenderer.currentTimestampFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree CURRENT_TIMESTAMP318=null;

        CommonTree CURRENT_TIMESTAMP318_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:421:2: ( CURRENT_TIMESTAMP )
            // org/hibernate/hql/ast/render/QueryRenderer.g:421:4: CURRENT_TIMESTAMP
            {
            _last = (CommonTree)input.LT(1);
            CURRENT_TIMESTAMP318=(CommonTree)match(input,CURRENT_TIMESTAMP,FOLLOW_CURRENT_TIMESTAMP_in_currentTimestampFunction2043); 
             
            if ( _first_0==null ) _first_0 = CURRENT_TIMESTAMP318;


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "currentTimestampFunction"


    public static class extractFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "extractFunction"
    // org/hibernate/hql/ast/render/QueryRenderer.g:424:1: extractFunction : ^( EXTRACT extractField datetimeValueExpression ) ;
    public final QueryRenderer.extractFunction_return extractFunction() throws RecognitionException {
        QueryRenderer.extractFunction_return retval = new QueryRenderer.extractFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree EXTRACT319=null;
        QueryRenderer.extractField_return extractField320 =null;

        QueryRenderer.datetimeValueExpression_return datetimeValueExpression321 =null;


        CommonTree EXTRACT319_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:425:2: ( ^( EXTRACT extractField datetimeValueExpression ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:425:4: ^( EXTRACT extractField datetimeValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            EXTRACT319=(CommonTree)match(input,EXTRACT,FOLLOW_EXTRACT_in_extractFunction2055); 


            if ( _first_0==null ) _first_0 = EXTRACT319;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_extractField_in_extractFunction2057);
            extractField320=extractField();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = extractField320.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_datetimeValueExpression_in_extractFunction2059);
            datetimeValueExpression321=datetimeValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = datetimeValueExpression321.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "extractFunction"


    public static class extractField_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "extractField"
    // org/hibernate/hql/ast/render/QueryRenderer.g:428:1: extractField : ( datetimeField | timeZoneField );
    public final QueryRenderer.extractField_return extractField() throws RecognitionException {
        QueryRenderer.extractField_return retval = new QueryRenderer.extractField_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        QueryRenderer.datetimeField_return datetimeField322 =null;

        QueryRenderer.timeZoneField_return timeZoneField323 =null;



        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:429:2: ( datetimeField | timeZoneField )
            int alt68=2;
            int LA68_0 = input.LA(1);

            if ( (LA68_0==DAY||LA68_0==HOUR||LA68_0==MINUTE||LA68_0==MONTH||LA68_0==SECOND||LA68_0==YEAR) ) {
                alt68=1;
            }
            else if ( ((LA68_0 >= TIMEZONE_HOUR && LA68_0 <= TIMEZONE_MINUTE)) ) {
                alt68=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 68, 0, input);

                throw nvae;

            }
            switch (alt68) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:429:4: datetimeField
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_datetimeField_in_extractField2071);
                    datetimeField322=datetimeField();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = datetimeField322.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:430:4: timeZoneField
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_timeZoneField_in_extractField2076);
                    timeZoneField323=timeZoneField();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = timeZoneField323.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "extractField"


    public static class datetimeField_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "datetimeField"
    // org/hibernate/hql/ast/render/QueryRenderer.g:433:1: datetimeField : ( YEAR | MONTH | DAY | HOUR | MINUTE | SECOND );
    public final QueryRenderer.datetimeField_return datetimeField() throws RecognitionException {
        QueryRenderer.datetimeField_return retval = new QueryRenderer.datetimeField_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set324=null;

        CommonTree set324_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:434:2: ( YEAR | MONTH | DAY | HOUR | MINUTE | SECOND )
            // org/hibernate/hql/ast/render/QueryRenderer.g:
            {
            _last = (CommonTree)input.LT(1);
            set324=(CommonTree)input.LT(1);

            if ( input.LA(1)==DAY||input.LA(1)==HOUR||input.LA(1)==MINUTE||input.LA(1)==MONTH||input.LA(1)==SECOND||input.LA(1)==YEAR ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);
             

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "datetimeField"


    public static class timeZoneField_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "timeZoneField"
    // org/hibernate/hql/ast/render/QueryRenderer.g:442:1: timeZoneField : ( TIMEZONE_HOUR | TIMEZONE_MINUTE );
    public final QueryRenderer.timeZoneField_return timeZoneField() throws RecognitionException {
        QueryRenderer.timeZoneField_return retval = new QueryRenderer.timeZoneField_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set325=null;

        CommonTree set325_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:443:2: ( TIMEZONE_HOUR | TIMEZONE_MINUTE )
            // org/hibernate/hql/ast/render/QueryRenderer.g:
            {
            _last = (CommonTree)input.LT(1);
            set325=(CommonTree)input.LT(1);

            if ( (input.LA(1) >= TIMEZONE_HOUR && input.LA(1) <= TIMEZONE_MINUTE) ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);
             

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "timeZoneField"


    public static class positionFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "positionFunction"
    // org/hibernate/hql/ast/render/QueryRenderer.g:447:1: positionFunction : ^( POSITION characterValueExpression characterValueExpression ) ;
    public final QueryRenderer.positionFunction_return positionFunction() throws RecognitionException {
        QueryRenderer.positionFunction_return retval = new QueryRenderer.positionFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree POSITION326=null;
        QueryRenderer.characterValueExpression_return characterValueExpression327 =null;

        QueryRenderer.characterValueExpression_return characterValueExpression328 =null;


        CommonTree POSITION326_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:448:2: ( ^( POSITION characterValueExpression characterValueExpression ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:448:4: ^( POSITION characterValueExpression characterValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            POSITION326=(CommonTree)match(input,POSITION,FOLLOW_POSITION_in_positionFunction2140); 


            if ( _first_0==null ) _first_0 = POSITION326;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_positionFunction2142);
            characterValueExpression327=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression327.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_positionFunction2144);
            characterValueExpression328=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression328.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "positionFunction"


    public static class charLengthFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "charLengthFunction"
    // org/hibernate/hql/ast/render/QueryRenderer.g:451:1: charLengthFunction : ^( CHARACTER_LENGTH characterValueExpression ) ;
    public final QueryRenderer.charLengthFunction_return charLengthFunction() throws RecognitionException {
        QueryRenderer.charLengthFunction_return retval = new QueryRenderer.charLengthFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree CHARACTER_LENGTH329=null;
        QueryRenderer.characterValueExpression_return characterValueExpression330 =null;


        CommonTree CHARACTER_LENGTH329_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:452:2: ( ^( CHARACTER_LENGTH characterValueExpression ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:452:4: ^( CHARACTER_LENGTH characterValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            CHARACTER_LENGTH329=(CommonTree)match(input,CHARACTER_LENGTH,FOLLOW_CHARACTER_LENGTH_in_charLengthFunction2157); 


            if ( _first_0==null ) _first_0 = CHARACTER_LENGTH329;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_charLengthFunction2159);
            characterValueExpression330=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression330.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "charLengthFunction"


    public static class octetLengthFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "octetLengthFunction"
    // org/hibernate/hql/ast/render/QueryRenderer.g:455:1: octetLengthFunction : ^( OCTET_LENGTH characterValueExpression ) ;
    public final QueryRenderer.octetLengthFunction_return octetLengthFunction() throws RecognitionException {
        QueryRenderer.octetLengthFunction_return retval = new QueryRenderer.octetLengthFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree OCTET_LENGTH331=null;
        QueryRenderer.characterValueExpression_return characterValueExpression332 =null;


        CommonTree OCTET_LENGTH331_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:456:2: ( ^( OCTET_LENGTH characterValueExpression ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:456:4: ^( OCTET_LENGTH characterValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            OCTET_LENGTH331=(CommonTree)match(input,OCTET_LENGTH,FOLLOW_OCTET_LENGTH_in_octetLengthFunction2172); 


            if ( _first_0==null ) _first_0 = OCTET_LENGTH331;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_octetLengthFunction2174);
            characterValueExpression332=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression332.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "octetLengthFunction"


    public static class bitLengthFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "bitLengthFunction"
    // org/hibernate/hql/ast/render/QueryRenderer.g:459:1: bitLengthFunction : ^( BIT_LENGTH characterValueExpression ) ;
    public final QueryRenderer.bitLengthFunction_return bitLengthFunction() throws RecognitionException {
        QueryRenderer.bitLengthFunction_return retval = new QueryRenderer.bitLengthFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree BIT_LENGTH333=null;
        QueryRenderer.characterValueExpression_return characterValueExpression334 =null;


        CommonTree BIT_LENGTH333_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:460:2: ( ^( BIT_LENGTH characterValueExpression ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:460:4: ^( BIT_LENGTH characterValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            BIT_LENGTH333=(CommonTree)match(input,BIT_LENGTH,FOLLOW_BIT_LENGTH_in_bitLengthFunction2187); 


            if ( _first_0==null ) _first_0 = BIT_LENGTH333;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_bitLengthFunction2189);
            characterValueExpression334=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression334.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "bitLengthFunction"


    public static class countFunctionArguments_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "countFunctionArguments"
    // org/hibernate/hql/ast/render/QueryRenderer.g:464:1: countFunctionArguments : ( collectionExpression | propertyReference | numeric_literal );
    public final QueryRenderer.countFunctionArguments_return countFunctionArguments() throws RecognitionException {
        QueryRenderer.countFunctionArguments_return retval = new QueryRenderer.countFunctionArguments_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        QueryRenderer.collectionExpression_return collectionExpression335 =null;

        QueryRenderer.propertyReference_return propertyReference336 =null;

        QueryRenderer.numeric_literal_return numeric_literal337 =null;



        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:465:2: ( collectionExpression | propertyReference | numeric_literal )
            int alt69=3;
            switch ( input.LA(1) ) {
            case ELEMENTS:
            case INDICES:
                {
                alt69=1;
                }
                break;
            case PROPERTY_REFERENCE:
                {
                alt69=2;
                }
                break;
            case DECIMAL_LITERAL:
            case FLOATING_POINT_LITERAL:
            case INTEGER_LITERAL:
                {
                alt69=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 69, 0, input);

                throw nvae;

            }

            switch (alt69) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:465:4: collectionExpression
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_collectionExpression_in_countFunctionArguments2202);
                    collectionExpression335=collectionExpression();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = collectionExpression335.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:466:4: propertyReference
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_propertyReference_in_countFunctionArguments2207);
                    propertyReference336=propertyReference();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = propertyReference336.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:467:4: numeric_literal
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numeric_literal_in_countFunctionArguments2212);
                    numeric_literal337=numeric_literal();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = numeric_literal337.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "countFunctionArguments"


    public static class collectionFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "collectionFunction"
    // org/hibernate/hql/ast/render/QueryRenderer.g:470:1: collectionFunction : ^( ( MAXELEMENT | MAXINDEX | MINELEMENT | MININDEX ) collectionPropertyReference ) ;
    public final QueryRenderer.collectionFunction_return collectionFunction() throws RecognitionException {
        QueryRenderer.collectionFunction_return retval = new QueryRenderer.collectionFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set338=null;
        QueryRenderer.collectionPropertyReference_return collectionPropertyReference339 =null;


        CommonTree set338_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:471:2: ( ^( ( MAXELEMENT | MAXINDEX | MINELEMENT | MININDEX ) collectionPropertyReference ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:471:4: ^( ( MAXELEMENT | MAXINDEX | MINELEMENT | MININDEX ) collectionPropertyReference )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            set338=(CommonTree)input.LT(1);

            if ( (input.LA(1) >= MAXELEMENT && input.LA(1) <= MAXINDEX)||(input.LA(1) >= MINELEMENT && input.LA(1) <= MININDEX) ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            if ( _first_0==null ) _first_0 = set338;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_collectionPropertyReference_in_collectionFunction2234);
            collectionPropertyReference339=collectionPropertyReference();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = collectionPropertyReference339.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "collectionFunction"


    public static class collectionPropertyReference_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "collectionPropertyReference"
    // org/hibernate/hql/ast/render/QueryRenderer.g:475:1: collectionPropertyReference : propertyReference ;
    public final QueryRenderer.collectionPropertyReference_return collectionPropertyReference() throws RecognitionException {
        QueryRenderer.collectionPropertyReference_return retval = new QueryRenderer.collectionPropertyReference_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        QueryRenderer.propertyReference_return propertyReference340 =null;



        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:476:2: ( propertyReference )
            // org/hibernate/hql/ast/render/QueryRenderer.g:476:4: propertyReference
            {
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_propertyReference_in_collectionPropertyReference2249);
            propertyReference340=propertyReference();

            state._fsp--;

             
            if ( _first_0==null ) _first_0 = propertyReference340.tree;


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "collectionPropertyReference"


    public static class collectionExpression_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "collectionExpression"
    // org/hibernate/hql/ast/render/QueryRenderer.g:479:1: collectionExpression : ( ^( ELEMENTS propertyReference ) | ^( INDICES propertyReference ) );
    public final QueryRenderer.collectionExpression_return collectionExpression() throws RecognitionException {
        QueryRenderer.collectionExpression_return retval = new QueryRenderer.collectionExpression_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ELEMENTS341=null;
        CommonTree INDICES343=null;
        QueryRenderer.propertyReference_return propertyReference342 =null;

        QueryRenderer.propertyReference_return propertyReference344 =null;


        CommonTree ELEMENTS341_tree=null;
        CommonTree INDICES343_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:480:2: ( ^( ELEMENTS propertyReference ) | ^( INDICES propertyReference ) )
            int alt70=2;
            int LA70_0 = input.LA(1);

            if ( (LA70_0==ELEMENTS) ) {
                alt70=1;
            }
            else if ( (LA70_0==INDICES) ) {
                alt70=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 70, 0, input);

                throw nvae;

            }
            switch (alt70) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:480:4: ^( ELEMENTS propertyReference )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    ELEMENTS341=(CommonTree)match(input,ELEMENTS,FOLLOW_ELEMENTS_in_collectionExpression2261); 


                    if ( _first_0==null ) _first_0 = ELEMENTS341;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_propertyReference_in_collectionExpression2263);
                    propertyReference342=propertyReference();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = propertyReference342.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:481:4: ^( INDICES propertyReference )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    INDICES343=(CommonTree)match(input,INDICES,FOLLOW_INDICES_in_collectionExpression2271); 


                    if ( _first_0==null ) _first_0 = INDICES343;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_propertyReference_in_collectionExpression2273);
                    propertyReference344=propertyReference();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = propertyReference344.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "collectionExpression"


    public static class parameter_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "parameter"
    // org/hibernate/hql/ast/render/QueryRenderer.g:484:1: parameter : ( NAMED_PARAM | JPA_PARAM | PARAM );
    public final QueryRenderer.parameter_return parameter() throws RecognitionException {
        QueryRenderer.parameter_return retval = new QueryRenderer.parameter_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set345=null;

        CommonTree set345_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:485:2: ( NAMED_PARAM | JPA_PARAM | PARAM )
            // org/hibernate/hql/ast/render/QueryRenderer.g:
            {
            _last = (CommonTree)input.LT(1);
            set345=(CommonTree)input.LT(1);

            if ( input.LA(1)==JPA_PARAM||input.LA(1)==NAMED_PARAM||input.LA(1)==PARAM ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);
             

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "parameter"


    public static class constant_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "constant"
    // org/hibernate/hql/ast/render/QueryRenderer.g:490:1: constant : ( literal | NULL | TRUE | FALSE );
    public final QueryRenderer.constant_return constant() throws RecognitionException {
        QueryRenderer.constant_return retval = new QueryRenderer.constant_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree NULL347=null;
        CommonTree TRUE348=null;
        CommonTree FALSE349=null;
        QueryRenderer.literal_return literal346 =null;


        CommonTree NULL347_tree=null;
        CommonTree TRUE348_tree=null;
        CommonTree FALSE349_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:491:2: ( literal | NULL | TRUE | FALSE )
            int alt71=4;
            switch ( input.LA(1) ) {
            case CHARACTER_LITERAL:
            case CONST_STRING_VALUE:
            case DECIMAL_LITERAL:
            case FLOATING_POINT_LITERAL:
            case HEX_LITERAL:
            case INTEGER_LITERAL:
            case OCTAL_LITERAL:
            case STRING_LITERAL:
                {
                alt71=1;
                }
                break;
            case NULL:
                {
                alt71=2;
                }
                break;
            case TRUE:
                {
                alt71=3;
                }
                break;
            case FALSE:
                {
                alt71=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 71, 0, input);

                throw nvae;

            }

            switch (alt71) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:491:4: literal
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_literal_in_constant2306);
                    literal346=literal();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = literal346.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:492:4: NULL
                    {
                    _last = (CommonTree)input.LT(1);
                    NULL347=(CommonTree)match(input,NULL,FOLLOW_NULL_in_constant2311); 
                     
                    if ( _first_0==null ) _first_0 = NULL347;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:493:4: TRUE
                    {
                    _last = (CommonTree)input.LT(1);
                    TRUE348=(CommonTree)match(input,TRUE,FOLLOW_TRUE_in_constant2316); 
                     
                    if ( _first_0==null ) _first_0 = TRUE348;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:494:4: FALSE
                    {
                    _last = (CommonTree)input.LT(1);
                    FALSE349=(CommonTree)match(input,FALSE,FOLLOW_FALSE_in_constant2321); 
                     
                    if ( _first_0==null ) _first_0 = FALSE349;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "constant"


    public static class literal_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "literal"
    // org/hibernate/hql/ast/render/QueryRenderer.g:497:1: literal : ( numeric_literal | HEX_LITERAL | OCTAL_LITERAL | CHARACTER_LITERAL | STRING_LITERAL | ^( CONST_STRING_VALUE CHARACTER_LITERAL ) | ^( CONST_STRING_VALUE STRING_LITERAL ) );
    public final QueryRenderer.literal_return literal() throws RecognitionException {
        QueryRenderer.literal_return retval = new QueryRenderer.literal_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree HEX_LITERAL351=null;
        CommonTree OCTAL_LITERAL352=null;
        CommonTree CHARACTER_LITERAL353=null;
        CommonTree STRING_LITERAL354=null;
        CommonTree CONST_STRING_VALUE355=null;
        CommonTree CHARACTER_LITERAL356=null;
        CommonTree CONST_STRING_VALUE357=null;
        CommonTree STRING_LITERAL358=null;
        QueryRenderer.numeric_literal_return numeric_literal350 =null;


        CommonTree HEX_LITERAL351_tree=null;
        CommonTree OCTAL_LITERAL352_tree=null;
        CommonTree CHARACTER_LITERAL353_tree=null;
        CommonTree STRING_LITERAL354_tree=null;
        CommonTree CONST_STRING_VALUE355_tree=null;
        CommonTree CHARACTER_LITERAL356_tree=null;
        CommonTree CONST_STRING_VALUE357_tree=null;
        CommonTree STRING_LITERAL358_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:498:2: ( numeric_literal | HEX_LITERAL | OCTAL_LITERAL | CHARACTER_LITERAL | STRING_LITERAL | ^( CONST_STRING_VALUE CHARACTER_LITERAL ) | ^( CONST_STRING_VALUE STRING_LITERAL ) )
            int alt72=7;
            switch ( input.LA(1) ) {
            case DECIMAL_LITERAL:
            case FLOATING_POINT_LITERAL:
            case INTEGER_LITERAL:
                {
                alt72=1;
                }
                break;
            case HEX_LITERAL:
                {
                alt72=2;
                }
                break;
            case OCTAL_LITERAL:
                {
                alt72=3;
                }
                break;
            case CHARACTER_LITERAL:
                {
                alt72=4;
                }
                break;
            case STRING_LITERAL:
                {
                alt72=5;
                }
                break;
            case CONST_STRING_VALUE:
                {
                int LA72_6 = input.LA(2);

                if ( (LA72_6==DOWN) ) {
                    int LA72_7 = input.LA(3);

                    if ( (LA72_7==CHARACTER_LITERAL) ) {
                        alt72=6;
                    }
                    else if ( (LA72_7==STRING_LITERAL) ) {
                        alt72=7;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("", 72, 7, input);

                        throw nvae;

                    }
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 72, 6, input);

                    throw nvae;

                }
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 72, 0, input);

                throw nvae;

            }

            switch (alt72) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:498:4: numeric_literal
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numeric_literal_in_literal2332);
                    numeric_literal350=numeric_literal();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = numeric_literal350.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:499:4: HEX_LITERAL
                    {
                    _last = (CommonTree)input.LT(1);
                    HEX_LITERAL351=(CommonTree)match(input,HEX_LITERAL,FOLLOW_HEX_LITERAL_in_literal2337); 
                     
                    if ( _first_0==null ) _first_0 = HEX_LITERAL351;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:500:4: OCTAL_LITERAL
                    {
                    _last = (CommonTree)input.LT(1);
                    OCTAL_LITERAL352=(CommonTree)match(input,OCTAL_LITERAL,FOLLOW_OCTAL_LITERAL_in_literal2342); 
                     
                    if ( _first_0==null ) _first_0 = OCTAL_LITERAL352;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:501:4: CHARACTER_LITERAL
                    {
                    _last = (CommonTree)input.LT(1);
                    CHARACTER_LITERAL353=(CommonTree)match(input,CHARACTER_LITERAL,FOLLOW_CHARACTER_LITERAL_in_literal2347); 
                     
                    if ( _first_0==null ) _first_0 = CHARACTER_LITERAL353;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:502:4: STRING_LITERAL
                    {
                    _last = (CommonTree)input.LT(1);
                    STRING_LITERAL354=(CommonTree)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_literal2352); 
                     
                    if ( _first_0==null ) _first_0 = STRING_LITERAL354;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 6 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:503:4: ^( CONST_STRING_VALUE CHARACTER_LITERAL )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    CONST_STRING_VALUE355=(CommonTree)match(input,CONST_STRING_VALUE,FOLLOW_CONST_STRING_VALUE_in_literal2358); 


                    if ( _first_0==null ) _first_0 = CONST_STRING_VALUE355;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    CHARACTER_LITERAL356=(CommonTree)match(input,CHARACTER_LITERAL,FOLLOW_CHARACTER_LITERAL_in_literal2360); 
                     
                    if ( _first_1==null ) _first_1 = CHARACTER_LITERAL356;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 7 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:504:4: ^( CONST_STRING_VALUE STRING_LITERAL )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    CONST_STRING_VALUE357=(CommonTree)match(input,CONST_STRING_VALUE,FOLLOW_CONST_STRING_VALUE_in_literal2367); 


                    if ( _first_0==null ) _first_0 = CONST_STRING_VALUE357;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    STRING_LITERAL358=(CommonTree)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_literal2369); 
                     
                    if ( _first_1==null ) _first_1 = STRING_LITERAL358;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "literal"


    public static class numeric_literal_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "numeric_literal"
    // org/hibernate/hql/ast/render/QueryRenderer.g:507:1: numeric_literal : ( INTEGER_LITERAL | DECIMAL_LITERAL | FLOATING_POINT_LITERAL );
    public final QueryRenderer.numeric_literal_return numeric_literal() throws RecognitionException {
        QueryRenderer.numeric_literal_return retval = new QueryRenderer.numeric_literal_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set359=null;

        CommonTree set359_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:508:2: ( INTEGER_LITERAL | DECIMAL_LITERAL | FLOATING_POINT_LITERAL )
            // org/hibernate/hql/ast/render/QueryRenderer.g:
            {
            _last = (CommonTree)input.LT(1);
            set359=(CommonTree)input.LT(1);

            if ( input.LA(1)==DECIMAL_LITERAL||input.LA(1)==FLOATING_POINT_LITERAL||input.LA(1)==INTEGER_LITERAL ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);
             

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "numeric_literal"


    public static class entityName_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "entityName"
    // org/hibernate/hql/ast/render/QueryRenderer.g:513:1: entityName : ENTITY_NAME ALIAS_NAME ;
    public final QueryRenderer.entityName_return entityName() throws RecognitionException {
        QueryRenderer.entityName_return retval = new QueryRenderer.entityName_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ENTITY_NAME360=null;
        CommonTree ALIAS_NAME361=null;

        CommonTree ENTITY_NAME360_tree=null;
        CommonTree ALIAS_NAME361_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:514:2: ( ENTITY_NAME ALIAS_NAME )
            // org/hibernate/hql/ast/render/QueryRenderer.g:514:4: ENTITY_NAME ALIAS_NAME
            {
            _last = (CommonTree)input.LT(1);
            ENTITY_NAME360=(CommonTree)match(input,ENTITY_NAME,FOLLOW_ENTITY_NAME_in_entityName2402); 
             
            if ( _first_0==null ) _first_0 = ENTITY_NAME360;


            _last = (CommonTree)input.LT(1);
            ALIAS_NAME361=(CommonTree)match(input,ALIAS_NAME,FOLLOW_ALIAS_NAME_in_entityName2404); 
             
            if ( _first_0==null ) _first_0 = ALIAS_NAME361;


            	delegate.registerPersisterSpace(ENTITY_NAME360, ALIAS_NAME361);	

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "entityName"


    public static class propertyReference_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "propertyReference"
    // org/hibernate/hql/ast/render/QueryRenderer.g:518:1: propertyReference : ^( PROPERTY_REFERENCE propertyReferencePath ) ;
    public final QueryRenderer.propertyReference_return propertyReference() throws RecognitionException {
        QueryRenderer.propertyReference_return retval = new QueryRenderer.propertyReference_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree PROPERTY_REFERENCE362=null;
        QueryRenderer.propertyReferencePath_return propertyReferencePath363 =null;


        CommonTree PROPERTY_REFERENCE362_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:519:2: ( ^( PROPERTY_REFERENCE propertyReferencePath ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:519:4: ^( PROPERTY_REFERENCE propertyReferencePath )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            PROPERTY_REFERENCE362=(CommonTree)match(input,PROPERTY_REFERENCE,FOLLOW_PROPERTY_REFERENCE_in_propertyReference2419); 


            if ( _first_0==null ) _first_0 = PROPERTY_REFERENCE362;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_propertyReferencePath_in_propertyReference2421);
            propertyReferencePath363=propertyReferencePath();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = propertyReferencePath363.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


             delegate.setPropertyReferencePath( ( (PropertyPathTree)PROPERTY_REFERENCE362 ).getPropertyPath() ); 

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "propertyReference"


    public static class joinPropertyReference_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "joinPropertyReference"
    // org/hibernate/hql/ast/render/QueryRenderer.g:522:1: joinPropertyReference[Tree alias] : ^( PATH propertyReferencePath ) ;
    public final QueryRenderer.joinPropertyReference_return joinPropertyReference(Tree alias) throws RecognitionException {
        QueryRenderer.joinPropertyReference_return retval = new QueryRenderer.joinPropertyReference_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree PATH364=null;
        QueryRenderer.propertyReferencePath_return propertyReferencePath365 =null;


        CommonTree PATH364_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:523:2: ( ^( PATH propertyReferencePath ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:523:4: ^( PATH propertyReferencePath )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            PATH364=(CommonTree)match(input,PATH,FOLLOW_PATH_in_joinPropertyReference2437); 


            if ( _first_0==null ) _first_0 = PATH364;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_propertyReferencePath_in_joinPropertyReference2439);
            propertyReferencePath365=propertyReferencePath();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = propertyReferencePath365.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


             delegate.registerJoinAlias( alias, ( (PropertyPathTree) PATH364 ).getPropertyPath() ); 

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "joinPropertyReference"


    public static class propertyReferencePath_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "propertyReferencePath"
    // org/hibernate/hql/ast/render/QueryRenderer.g:526:1: propertyReferencePath : ({...}? unqualifiedPropertyReference | pathedPropertyReference | terminalIndexOperation );
    public final QueryRenderer.propertyReferencePath_return propertyReferencePath() throws RecognitionException {
        QueryRenderer.propertyReferencePath_return retval = new QueryRenderer.propertyReferencePath_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        QueryRenderer.unqualifiedPropertyReference_return unqualifiedPropertyReference366 =null;

        QueryRenderer.pathedPropertyReference_return pathedPropertyReference367 =null;

        QueryRenderer.terminalIndexOperation_return terminalIndexOperation368 =null;



        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:527:2: ({...}? unqualifiedPropertyReference | pathedPropertyReference | terminalIndexOperation )
            int alt73=3;
            switch ( input.LA(1) ) {
            case IDENTIFIER:
                {
                alt73=1;
                }
                break;
            case DOT:
                {
                alt73=2;
                }
                break;
            case LEFT_SQUARE:
                {
                alt73=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 73, 0, input);

                throw nvae;

            }

            switch (alt73) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:527:4: {...}? unqualifiedPropertyReference
                    {
                    if ( !((delegate.isUnqualifiedPropertyReference())) ) {
                        throw new FailedPredicateException(input, "propertyReferencePath", "delegate.isUnqualifiedPropertyReference()");
                    }

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_unqualifiedPropertyReference_in_propertyReferencePath2455);
                    unqualifiedPropertyReference366=unqualifiedPropertyReference();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = unqualifiedPropertyReference366.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:528:4: pathedPropertyReference
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_pathedPropertyReference_in_propertyReferencePath2460);
                    pathedPropertyReference367=pathedPropertyReference();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = pathedPropertyReference367.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:529:4: terminalIndexOperation
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_terminalIndexOperation_in_propertyReferencePath2465);
                    terminalIndexOperation368=terminalIndexOperation();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = terminalIndexOperation368.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "propertyReferencePath"


    public static class unqualifiedPropertyReference_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "unqualifiedPropertyReference"
    // org/hibernate/hql/ast/render/QueryRenderer.g:532:1: unqualifiedPropertyReference : IDENTIFIER ;
    public final QueryRenderer.unqualifiedPropertyReference_return unqualifiedPropertyReference() throws RecognitionException {
        QueryRenderer.unqualifiedPropertyReference_return retval = new QueryRenderer.unqualifiedPropertyReference_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree IDENTIFIER369=null;

        CommonTree IDENTIFIER369_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:533:2: ( IDENTIFIER )
            // org/hibernate/hql/ast/render/QueryRenderer.g:533:4: IDENTIFIER
            {
            _last = (CommonTree)input.LT(1);
            IDENTIFIER369=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_unqualifiedPropertyReference2476); 
             
            if ( _first_0==null ) _first_0 = IDENTIFIER369;


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "unqualifiedPropertyReference"


    public static class pathedPropertyReference_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "pathedPropertyReference"
    // org/hibernate/hql/ast/render/QueryRenderer.g:536:1: pathedPropertyReference : ^( DOT pathedPropertyReferenceSource IDENTIFIER ) ;
    public final QueryRenderer.pathedPropertyReference_return pathedPropertyReference() throws RecognitionException {
        QueryRenderer.pathedPropertyReference_return retval = new QueryRenderer.pathedPropertyReference_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree DOT370=null;
        CommonTree IDENTIFIER372=null;
        QueryRenderer.pathedPropertyReferenceSource_return pathedPropertyReferenceSource371 =null;


        CommonTree DOT370_tree=null;
        CommonTree IDENTIFIER372_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:537:2: ( ^( DOT pathedPropertyReferenceSource IDENTIFIER ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:537:4: ^( DOT pathedPropertyReferenceSource IDENTIFIER )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            DOT370=(CommonTree)match(input,DOT,FOLLOW_DOT_in_pathedPropertyReference2488); 


            if ( _first_0==null ) _first_0 = DOT370;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_pathedPropertyReferenceSource_in_pathedPropertyReference2490);
            pathedPropertyReferenceSource371=pathedPropertyReferenceSource();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = pathedPropertyReferenceSource371.tree;


            _last = (CommonTree)input.LT(1);
            IDENTIFIER372=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_pathedPropertyReference2492); 
             
            if ( _first_1==null ) _first_1 = IDENTIFIER372;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "pathedPropertyReference"


    public static class pathedPropertyReferenceSource_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "pathedPropertyReferenceSource"
    // org/hibernate/hql/ast/render/QueryRenderer.g:540:1: pathedPropertyReferenceSource : ({...}? => IDENTIFIER |{...}? => IDENTIFIER | intermediatePathedPropertyReference | intermediateIndexOperation );
    public final QueryRenderer.pathedPropertyReferenceSource_return pathedPropertyReferenceSource() throws RecognitionException {
        QueryRenderer.pathedPropertyReferenceSource_return retval = new QueryRenderer.pathedPropertyReferenceSource_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree IDENTIFIER373=null;
        CommonTree IDENTIFIER374=null;
        QueryRenderer.intermediatePathedPropertyReference_return intermediatePathedPropertyReference375 =null;

        QueryRenderer.intermediateIndexOperation_return intermediateIndexOperation376 =null;


        CommonTree IDENTIFIER373_tree=null;
        CommonTree IDENTIFIER374_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:541:2: ({...}? => IDENTIFIER |{...}? => IDENTIFIER | intermediatePathedPropertyReference | intermediateIndexOperation )
            int alt74=4;
            int LA74_0 = input.LA(1);

            if ( (LA74_0==IDENTIFIER) && ((((delegate.isPersisterReferenceAlias()))||((delegate.isUnqualifiedPropertyReference()))))) {
                int LA74_1 = input.LA(2);

                if ( (((delegate.isPersisterReferenceAlias()))) ) {
                    alt74=1;
                }
                else if ( (((delegate.isUnqualifiedPropertyReference()))) ) {
                    alt74=2;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 74, 1, input);

                    throw nvae;

                }
            }
            else if ( (LA74_0==DOT) ) {
                alt74=3;
            }
            else if ( (LA74_0==LEFT_SQUARE) ) {
                alt74=4;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 74, 0, input);

                throw nvae;

            }
            switch (alt74) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:541:4: {...}? => IDENTIFIER
                    {
                    if ( !(((delegate.isPersisterReferenceAlias()))) ) {
                        throw new FailedPredicateException(input, "pathedPropertyReferenceSource", "(delegate.isPersisterReferenceAlias())");
                    }

                    _last = (CommonTree)input.LT(1);
                    IDENTIFIER373=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_pathedPropertyReferenceSource2507); 
                     
                    if ( _first_0==null ) _first_0 = IDENTIFIER373;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:542:4: {...}? => IDENTIFIER
                    {
                    if ( !(((delegate.isUnqualifiedPropertyReference()))) ) {
                        throw new FailedPredicateException(input, "pathedPropertyReferenceSource", "(delegate.isUnqualifiedPropertyReference())");
                    }

                    _last = (CommonTree)input.LT(1);
                    IDENTIFIER374=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_pathedPropertyReferenceSource2515); 
                     
                    if ( _first_0==null ) _first_0 = IDENTIFIER374;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:543:4: intermediatePathedPropertyReference
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_intermediatePathedPropertyReference_in_pathedPropertyReferenceSource2520);
                    intermediatePathedPropertyReference375=intermediatePathedPropertyReference();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = intermediatePathedPropertyReference375.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:544:4: intermediateIndexOperation
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_intermediateIndexOperation_in_pathedPropertyReferenceSource2525);
                    intermediateIndexOperation376=intermediateIndexOperation();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = intermediateIndexOperation376.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "pathedPropertyReferenceSource"


    public static class intermediatePathedPropertyReference_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "intermediatePathedPropertyReference"
    // org/hibernate/hql/ast/render/QueryRenderer.g:547:1: intermediatePathedPropertyReference : ^( DOT source= pathedPropertyReferenceSource IDENTIFIER ) ;
    public final QueryRenderer.intermediatePathedPropertyReference_return intermediatePathedPropertyReference() throws RecognitionException {
        QueryRenderer.intermediatePathedPropertyReference_return retval = new QueryRenderer.intermediatePathedPropertyReference_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree DOT377=null;
        CommonTree IDENTIFIER378=null;
        QueryRenderer.pathedPropertyReferenceSource_return source =null;


        CommonTree DOT377_tree=null;
        CommonTree IDENTIFIER378_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:548:2: ( ^( DOT source= pathedPropertyReferenceSource IDENTIFIER ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:548:4: ^( DOT source= pathedPropertyReferenceSource IDENTIFIER )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            DOT377=(CommonTree)match(input,DOT,FOLLOW_DOT_in_intermediatePathedPropertyReference2537); 


            if ( _first_0==null ) _first_0 = DOT377;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_pathedPropertyReferenceSource_in_intermediatePathedPropertyReference2541);
            source=pathedPropertyReferenceSource();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = source.tree;


            _last = (CommonTree)input.LT(1);
            IDENTIFIER378=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_intermediatePathedPropertyReference2543); 
             
            if ( _first_1==null ) _first_1 = IDENTIFIER378;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "intermediatePathedPropertyReference"


    public static class intermediateIndexOperation_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "intermediateIndexOperation"
    // org/hibernate/hql/ast/render/QueryRenderer.g:551:1: intermediateIndexOperation : ^( LEFT_SQUARE indexOperationSource indexSelector ) ;
    public final QueryRenderer.intermediateIndexOperation_return intermediateIndexOperation() throws RecognitionException {
        QueryRenderer.intermediateIndexOperation_return retval = new QueryRenderer.intermediateIndexOperation_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree LEFT_SQUARE379=null;
        QueryRenderer.indexOperationSource_return indexOperationSource380 =null;

        QueryRenderer.indexSelector_return indexSelector381 =null;


        CommonTree LEFT_SQUARE379_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:552:2: ( ^( LEFT_SQUARE indexOperationSource indexSelector ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:552:4: ^( LEFT_SQUARE indexOperationSource indexSelector )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            LEFT_SQUARE379=(CommonTree)match(input,LEFT_SQUARE,FOLLOW_LEFT_SQUARE_in_intermediateIndexOperation2558); 


            if ( _first_0==null ) _first_0 = LEFT_SQUARE379;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_indexOperationSource_in_intermediateIndexOperation2560);
            indexOperationSource380=indexOperationSource();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = indexOperationSource380.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_indexSelector_in_intermediateIndexOperation2562);
            indexSelector381=indexSelector();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = indexSelector381.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "intermediateIndexOperation"


    public static class terminalIndexOperation_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "terminalIndexOperation"
    // org/hibernate/hql/ast/render/QueryRenderer.g:555:1: terminalIndexOperation : ^( LEFT_SQUARE indexOperationSource indexSelector ) ;
    public final QueryRenderer.terminalIndexOperation_return terminalIndexOperation() throws RecognitionException {
        QueryRenderer.terminalIndexOperation_return retval = new QueryRenderer.terminalIndexOperation_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree LEFT_SQUARE382=null;
        QueryRenderer.indexOperationSource_return indexOperationSource383 =null;

        QueryRenderer.indexSelector_return indexSelector384 =null;


        CommonTree LEFT_SQUARE382_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:556:2: ( ^( LEFT_SQUARE indexOperationSource indexSelector ) )
            // org/hibernate/hql/ast/render/QueryRenderer.g:556:4: ^( LEFT_SQUARE indexOperationSource indexSelector )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            LEFT_SQUARE382=(CommonTree)match(input,LEFT_SQUARE,FOLLOW_LEFT_SQUARE_in_terminalIndexOperation2577); 


            if ( _first_0==null ) _first_0 = LEFT_SQUARE382;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_indexOperationSource_in_terminalIndexOperation2579);
            indexOperationSource383=indexOperationSource();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = indexOperationSource383.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_indexSelector_in_terminalIndexOperation2581);
            indexSelector384=indexSelector();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = indexSelector384.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "terminalIndexOperation"


    public static class indexOperationSource_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indexOperationSource"
    // org/hibernate/hql/ast/render/QueryRenderer.g:559:1: indexOperationSource : ( ^( DOT pathedPropertyReferenceSource IDENTIFIER ) |{...}? => IDENTIFIER );
    public final QueryRenderer.indexOperationSource_return indexOperationSource() throws RecognitionException {
        QueryRenderer.indexOperationSource_return retval = new QueryRenderer.indexOperationSource_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree DOT385=null;
        CommonTree IDENTIFIER387=null;
        CommonTree IDENTIFIER388=null;
        QueryRenderer.pathedPropertyReferenceSource_return pathedPropertyReferenceSource386 =null;


        CommonTree DOT385_tree=null;
        CommonTree IDENTIFIER387_tree=null;
        CommonTree IDENTIFIER388_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:560:2: ( ^( DOT pathedPropertyReferenceSource IDENTIFIER ) |{...}? => IDENTIFIER )
            int alt75=2;
            int LA75_0 = input.LA(1);

            if ( (LA75_0==DOT) ) {
                alt75=1;
            }
            else if ( (LA75_0==IDENTIFIER) && (((delegate.isUnqualifiedPropertyReference())))) {
                alt75=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 75, 0, input);

                throw nvae;

            }
            switch (alt75) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:560:4: ^( DOT pathedPropertyReferenceSource IDENTIFIER )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    DOT385=(CommonTree)match(input,DOT,FOLLOW_DOT_in_indexOperationSource2595); 


                    if ( _first_0==null ) _first_0 = DOT385;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_pathedPropertyReferenceSource_in_indexOperationSource2597);
                    pathedPropertyReferenceSource386=pathedPropertyReferenceSource();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = pathedPropertyReferenceSource386.tree;


                    _last = (CommonTree)input.LT(1);
                    IDENTIFIER387=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_indexOperationSource2599); 
                     
                    if ( _first_1==null ) _first_1 = IDENTIFIER387;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:561:4: {...}? => IDENTIFIER
                    {
                    if ( !(((delegate.isUnqualifiedPropertyReference()))) ) {
                        throw new FailedPredicateException(input, "indexOperationSource", "(delegate.isUnqualifiedPropertyReference())");
                    }

                    _last = (CommonTree)input.LT(1);
                    IDENTIFIER388=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_indexOperationSource2609); 
                     
                    if ( _first_0==null ) _first_0 = IDENTIFIER388;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indexOperationSource"


    public static class indexSelector_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indexSelector"
    // org/hibernate/hql/ast/render/QueryRenderer.g:564:1: indexSelector : valueExpression ;
    public final QueryRenderer.indexSelector_return indexSelector() throws RecognitionException {
        QueryRenderer.indexSelector_return retval = new QueryRenderer.indexSelector_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        QueryRenderer.valueExpression_return valueExpression389 =null;



        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:565:2: ( valueExpression )
            // org/hibernate/hql/ast/render/QueryRenderer.g:565:4: valueExpression
            {
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_indexSelector2620);
            valueExpression389=valueExpression();

            state._fsp--;

             
            if ( _first_0==null ) _first_0 = valueExpression389.tree;


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indexSelector"


    public static class path_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "path"
    // org/hibernate/hql/ast/render/QueryRenderer.g:568:1: path : ( IDENTIFIER | ^( DOT path path ) | ^( LEFT_SQUARE path ( valueExpression )* ) | ^( LEFT_PAREN path ( valueExpression )* ) );
    public final QueryRenderer.path_return path() throws RecognitionException {
        QueryRenderer.path_return retval = new QueryRenderer.path_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree IDENTIFIER390=null;
        CommonTree DOT391=null;
        CommonTree LEFT_SQUARE394=null;
        CommonTree LEFT_PAREN397=null;
        QueryRenderer.path_return path392 =null;

        QueryRenderer.path_return path393 =null;

        QueryRenderer.path_return path395 =null;

        QueryRenderer.valueExpression_return valueExpression396 =null;

        QueryRenderer.path_return path398 =null;

        QueryRenderer.valueExpression_return valueExpression399 =null;


        CommonTree IDENTIFIER390_tree=null;
        CommonTree DOT391_tree=null;
        CommonTree LEFT_SQUARE394_tree=null;
        CommonTree LEFT_PAREN397_tree=null;

        try {
            // org/hibernate/hql/ast/render/QueryRenderer.g:569:2: ( IDENTIFIER | ^( DOT path path ) | ^( LEFT_SQUARE path ( valueExpression )* ) | ^( LEFT_PAREN path ( valueExpression )* ) )
            int alt78=4;
            switch ( input.LA(1) ) {
            case IDENTIFIER:
                {
                alt78=1;
                }
                break;
            case DOT:
                {
                alt78=2;
                }
                break;
            case LEFT_SQUARE:
                {
                alt78=3;
                }
                break;
            case LEFT_PAREN:
                {
                alt78=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 78, 0, input);

                throw nvae;

            }

            switch (alt78) {
                case 1 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:569:5: IDENTIFIER
                    {
                    _last = (CommonTree)input.LT(1);
                    IDENTIFIER390=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_path2632); 
                     
                    if ( _first_0==null ) _first_0 = IDENTIFIER390;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:570:4: ^( DOT path path )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    DOT391=(CommonTree)match(input,DOT,FOLLOW_DOT_in_path2638); 


                    if ( _first_0==null ) _first_0 = DOT391;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_path_in_path2640);
                    path392=path();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = path392.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_path_in_path2642);
                    path393=path();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = path393.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:571:4: ^( LEFT_SQUARE path ( valueExpression )* )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    LEFT_SQUARE394=(CommonTree)match(input,LEFT_SQUARE,FOLLOW_LEFT_SQUARE_in_path2650); 


                    if ( _first_0==null ) _first_0 = LEFT_SQUARE394;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_path_in_path2652);
                    path395=path();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = path395.tree;


                    // org/hibernate/hql/ast/render/QueryRenderer.g:571:23: ( valueExpression )*
                    loop76:
                    do {
                        int alt76=2;
                        int LA76_0 = input.LA(1);

                        if ( (LA76_0==ABS||(LA76_0 >= ALIAS_REF && LA76_0 <= ALL)||LA76_0==ANY||(LA76_0 >= ASTERISK && LA76_0 <= AVG)||LA76_0==BIT_LENGTH||(LA76_0 >= CAST && LA76_0 <= CHARACTER_LITERAL)||LA76_0==COALESCE||(LA76_0 >= CONCAT && LA76_0 <= COUNT)||(LA76_0 >= CURRENT_DATE && LA76_0 <= CURRENT_TIMESTAMP)||LA76_0==DECIMAL_LITERAL||(LA76_0 >= DOT_CLASS && LA76_0 <= DOUBLE_PIPE)||LA76_0==ELEMENTS||LA76_0==EXISTS||LA76_0==EXTRACT||LA76_0==FALSE||LA76_0==FLOATING_POINT_LITERAL||LA76_0==FUNCTION||LA76_0==HEX_LITERAL||(LA76_0 >= INDEX && LA76_0 <= INDICES)||LA76_0==INTEGER_LITERAL||LA76_0==JAVA_CONSTANT||LA76_0==JPA_PARAM||LA76_0==LENGTH||(LA76_0 >= LOCATE && LA76_0 <= LOWER)||(LA76_0 >= MAX && LA76_0 <= MAXINDEX)||(LA76_0 >= MIN && LA76_0 <= MINUS)||LA76_0==MOD||LA76_0==NAMED_PARAM||(LA76_0 >= NULL && LA76_0 <= NULLIF)||(LA76_0 >= OCTAL_LITERAL && LA76_0 <= OCTET_LENGTH)||(LA76_0 >= PARAM && LA76_0 <= PATH)||(LA76_0 >= PLUS && LA76_0 <= POSITION)||LA76_0==PROPERTY_REFERENCE||LA76_0==SEARCHED_CASE||(LA76_0 >= SIMPLE_CASE && LA76_0 <= SOME)||(LA76_0 >= SQRT && LA76_0 <= SUM)||(LA76_0 >= TRIM && LA76_0 <= TRUE)||(LA76_0 >= UNARY_MINUS && LA76_0 <= UNARY_PLUS)||LA76_0==UPPER||LA76_0==VECTOR_EXPR) ) {
                            alt76=1;
                        }


                        switch (alt76) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/render/QueryRenderer.g:571:23: valueExpression
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    pushFollow(FOLLOW_valueExpression_in_path2654);
                    	    valueExpression396=valueExpression();

                    	    state._fsp--;

                    	     
                    	    if ( _first_1==null ) _first_1 = valueExpression396.tree;


                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    	    }
                    	    break;

                    	default :
                    	    break loop76;
                        }
                    } while (true);


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/render/QueryRenderer.g:572:4: ^( LEFT_PAREN path ( valueExpression )* )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    LEFT_PAREN397=(CommonTree)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_path2663); 


                    if ( _first_0==null ) _first_0 = LEFT_PAREN397;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_path_in_path2665);
                    path398=path();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = path398.tree;


                    // org/hibernate/hql/ast/render/QueryRenderer.g:572:22: ( valueExpression )*
                    loop77:
                    do {
                        int alt77=2;
                        int LA77_0 = input.LA(1);

                        if ( (LA77_0==ABS||(LA77_0 >= ALIAS_REF && LA77_0 <= ALL)||LA77_0==ANY||(LA77_0 >= ASTERISK && LA77_0 <= AVG)||LA77_0==BIT_LENGTH||(LA77_0 >= CAST && LA77_0 <= CHARACTER_LITERAL)||LA77_0==COALESCE||(LA77_0 >= CONCAT && LA77_0 <= COUNT)||(LA77_0 >= CURRENT_DATE && LA77_0 <= CURRENT_TIMESTAMP)||LA77_0==DECIMAL_LITERAL||(LA77_0 >= DOT_CLASS && LA77_0 <= DOUBLE_PIPE)||LA77_0==ELEMENTS||LA77_0==EXISTS||LA77_0==EXTRACT||LA77_0==FALSE||LA77_0==FLOATING_POINT_LITERAL||LA77_0==FUNCTION||LA77_0==HEX_LITERAL||(LA77_0 >= INDEX && LA77_0 <= INDICES)||LA77_0==INTEGER_LITERAL||LA77_0==JAVA_CONSTANT||LA77_0==JPA_PARAM||LA77_0==LENGTH||(LA77_0 >= LOCATE && LA77_0 <= LOWER)||(LA77_0 >= MAX && LA77_0 <= MAXINDEX)||(LA77_0 >= MIN && LA77_0 <= MINUS)||LA77_0==MOD||LA77_0==NAMED_PARAM||(LA77_0 >= NULL && LA77_0 <= NULLIF)||(LA77_0 >= OCTAL_LITERAL && LA77_0 <= OCTET_LENGTH)||(LA77_0 >= PARAM && LA77_0 <= PATH)||(LA77_0 >= PLUS && LA77_0 <= POSITION)||LA77_0==PROPERTY_REFERENCE||LA77_0==SEARCHED_CASE||(LA77_0 >= SIMPLE_CASE && LA77_0 <= SOME)||(LA77_0 >= SQRT && LA77_0 <= SUM)||(LA77_0 >= TRIM && LA77_0 <= TRUE)||(LA77_0 >= UNARY_MINUS && LA77_0 <= UNARY_PLUS)||LA77_0==UPPER||LA77_0==VECTOR_EXPR) ) {
                            alt77=1;
                        }


                        switch (alt77) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/render/QueryRenderer.g:572:22: valueExpression
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    pushFollow(FOLLOW_valueExpression_in_path2667);
                    	    valueExpression399=valueExpression();

                    	    state._fsp--;

                    	     
                    	    if ( _first_1==null ) _first_1 = valueExpression399.tree;


                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    	    }
                    	    break;

                    	default :
                    	    break loop77;
                        }
                    } while (true);


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "path"

    // Delegated rules


 

    public static final BitSet FOLLOW_QUERY_in_filterStatement62 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_QUERY_SPEC_in_filterStatement65 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_FILTER_in_filterStatement67 = new BitSet(new long[]{0x0000000000000008L,0x0000000000002000L,0x0000400000040000L,0x0000000000080000L});
    public static final BitSet FOLLOW_selectClause_in_filterStatement73 = new BitSet(new long[]{0x0000000000000008L,0x0000000000002000L,0x0000000000040000L,0x0000000000080000L});
    public static final BitSet FOLLOW_whereClause_in_filterStatement76 = new BitSet(new long[]{0x0000000000000008L,0x0000000000002000L,0x0000000000040000L});
    public static final BitSet FOLLOW_groupByClause_in_filterStatement81 = new BitSet(new long[]{0x0000000000000008L,0x0000000000008000L,0x0000000000040000L});
    public static final BitSet FOLLOW_havingClause_in_filterStatement83 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000040000L});
    public static final BitSet FOLLOW_orderByClause_in_filterStatement88 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_updateStatementSet_in_statement102 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_deleteStatementSet_in_statement107 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_insertStatementSet_in_statement112 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_queryStatementSet_in_statement117 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_updateStatement_in_updateStatementSet128 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_UPDATE_in_updateStatement141 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_entityName_in_updateStatement143 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0008000000000000L});
    public static final BitSet FOLLOW_SET_in_updateStatement146 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_assignment_in_updateStatement148 = new BitSet(new long[]{0x0200000000000008L});
    public static final BitSet FOLLOW_whereClause_in_updateStatement152 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_EQUALS_in_assignment166 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_propertyReference_in_assignment168 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_valueExpression_in_assignment170 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_EQUALS_in_assignment177 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_VERSIONED_VALUE_in_assignment179 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0400000000000000L});
    public static final BitSet FOLLOW_STRING_LITERAL_in_assignment181 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_deleteStatement_in_deleteStatementSet193 = new BitSet(new long[]{0x0000080000000002L});
    public static final BitSet FOLLOW_DELETE_in_deleteStatement206 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_entityName_in_deleteStatement208 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x0000000000080000L});
    public static final BitSet FOLLOW_whereClause_in_deleteStatement210 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_insertStatement_in_insertStatementSet223 = new BitSet(new long[]{0x0000000000000002L,0x0000000002000000L});
    public static final BitSet FOLLOW_INSERT_in_insertStatement236 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_intoClause_in_insertStatement238 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000001000000000L});
    public static final BitSet FOLLOW_queryStatementSet_in_insertStatement240 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_INTO_in_intoClause253 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_entityName_in_intoClause255 = new BitSet(new long[]{0x0000000000000000L,0x0000000004000000L});
    public static final BitSet FOLLOW_INSERTABILITY_SPEC_in_intoClause258 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_propertyReference_in_intoClause260 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000100000000L});
    public static final BitSet FOLLOW_queryStatement_in_queryStatementSet276 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000001000000000L});
    public static final BitSet FOLLOW_QUERY_in_queryStatement289 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_queryExpression_in_queryStatement291 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000040000L});
    public static final BitSet FOLLOW_orderByClause_in_queryStatement293 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_UNION_in_queryExpression307 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ALL_in_queryExpression309 = new BitSet(new long[]{0x1000000000000000L,0x0000000020000000L,0x0000002000000000L,0x0000000000000400L});
    public static final BitSet FOLLOW_queryExpression_in_queryExpression312 = new BitSet(new long[]{0x1000000000000000L,0x0000000020000000L,0x0000002000000000L,0x0000000000000400L});
    public static final BitSet FOLLOW_queryExpression_in_queryExpression314 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_INTERSECT_in_queryExpression321 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ALL_in_queryExpression323 = new BitSet(new long[]{0x1000000000000000L,0x0000000020000000L,0x0000002000000000L,0x0000000000000400L});
    public static final BitSet FOLLOW_queryExpression_in_queryExpression326 = new BitSet(new long[]{0x1000000000000000L,0x0000000020000000L,0x0000002000000000L,0x0000000000000400L});
    public static final BitSet FOLLOW_queryExpression_in_queryExpression328 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_EXCEPT_in_queryExpression335 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ALL_in_queryExpression337 = new BitSet(new long[]{0x1000000000000000L,0x0000000020000000L,0x0000002000000000L,0x0000000000000400L});
    public static final BitSet FOLLOW_queryExpression_in_queryExpression340 = new BitSet(new long[]{0x1000000000000000L,0x0000000020000000L,0x0000002000000000L,0x0000000000000400L});
    public static final BitSet FOLLOW_queryExpression_in_queryExpression342 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_querySpec_in_queryExpression348 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_QUERY_SPEC_in_querySpec360 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_selectFrom_in_querySpec362 = new BitSet(new long[]{0x0000000000000008L,0x000000000000A000L,0x0000000000000000L,0x0000000000080000L});
    public static final BitSet FOLLOW_whereClause_in_querySpec364 = new BitSet(new long[]{0x0000000000000008L,0x000000000000A000L});
    public static final BitSet FOLLOW_groupByClause_in_querySpec367 = new BitSet(new long[]{0x0000000000000008L,0x0000000000008000L});
    public static final BitSet FOLLOW_havingClause_in_querySpec370 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_WHERE_in_whereClause386 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_searchCondition_in_whereClause388 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_GROUP_BY_in_groupByClause405 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_groupingValue_in_groupByClause407 = new BitSet(new long[]{0x0000000000000008L,0x0000000000001000L});
    public static final BitSet FOLLOW_GROUPING_VALUE_in_groupingValue423 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_groupingValue425 = new BitSet(new long[]{0x0000000008000008L});
    public static final BitSet FOLLOW_COLLATE_in_groupingValue427 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_HAVING_in_havingClause445 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_searchCondition_in_havingClause447 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_SELECT_FROM_in_selectFrom462 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_fromClause_in_selectFrom464 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000400000000000L});
    public static final BitSet FOLLOW_selectClause_in_selectFrom466 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_FROM_in_fromClause479 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_persisterSpaces_in_fromClause481 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000004000000L});
    public static final BitSet FOLLOW_PERSISTER_SPACE_in_persisterSpaces495 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_persisterSpace_in_persisterSpaces497 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_persisterSpaceRoot_in_persisterSpace509 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000082000000L});
    public static final BitSet FOLLOW_joins_in_persisterSpace511 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000082000000L});
    public static final BitSet FOLLOW_ENTITY_PERSISTER_REF_in_persisterSpaceRoot524 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_entityName_in_persisterSpaceRoot526 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000200000000L});
    public static final BitSet FOLLOW_PROP_FETCH_in_persisterSpaceRoot528 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_PROPERTY_JOIN_in_joins542 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_joinType_in_joins546 = new BitSet(new long[]{0x0000000000000040L,0x0000000000000004L});
    public static final BitSet FOLLOW_FETCH_in_joins550 = new BitSet(new long[]{0x0000000000000040L});
    public static final BitSet FOLLOW_ALIAS_NAME_in_joins555 = new BitSet(new long[]{0x0008000000000000L,0x0000000000800000L,0x0000000200800000L});
    public static final BitSet FOLLOW_PROP_FETCH_in_joins559 = new BitSet(new long[]{0x0008000000000000L,0x0000000000800000L,0x0000000000800000L});
    public static final BitSet FOLLOW_collectionExpression_in_joins569 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x0000000000100000L});
    public static final BitSet FOLLOW_joinPropertyReference_in_joins571 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x0000000000100000L});
    public static final BitSet FOLLOW_withClause_in_joins575 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_PERSISTER_JOIN_in_joins587 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_joinType_in_joins589 = new BitSet(new long[]{0x0080000000000000L});
    public static final BitSet FOLLOW_persisterSpaceRoot_in_joins591 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000010000L});
    public static final BitSet FOLLOW_onClause_in_joins593 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_WITH_in_withClause607 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_searchCondition_in_withClause609 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ON_in_onClause622 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_searchCondition_in_onClause624 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_CROSS_in_joinType640 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INNER_in_joinType647 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LEFT_in_joinType655 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000100000L});
    public static final BitSet FOLLOW_RIGHT_in_joinType661 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000100000L});
    public static final BitSet FOLLOW_FULL_in_joinType667 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000100000L});
    public static final BitSet FOLLOW_OUTER_in_joinType672 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_SELECT_in_selectClause695 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_DISTINCT_in_selectClause697 = new BitSet(new long[]{0xA00BC4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF3100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_rootSelectExpression_in_selectClause700 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_SELECT_LIST_in_rootSelectExpression713 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rootSelectExpression_in_rootSelectExpression715 = new BitSet(new long[]{0xA00BC4EE05C8C9A8L,0xBDD8814008C20112L,0x3EF3100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_SELECT_ITEM_in_rootSelectExpression723 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rootSelectExpression_in_rootSelectExpression725 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_DYNAMIC_INSTANTIATION_in_rootSelectExpression732 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rootSelectExpression_in_rootSelectExpression734 = new BitSet(new long[]{0xA00BC4EE05C8C9A8L,0xBDD8814008C20112L,0x3EF3100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_DYNAMIC_INSTANTIATION_ARG_in_rootSelectExpression742 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rootSelectExpression_in_rootSelectExpression744 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_valueExpression_in_rootSelectExpression750 = new BitSet(new long[]{0x0000000000000042L});
    public static final BitSet FOLLOW_ALIAS_NAME_in_rootSelectExpression752 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ORDER_BY_in_orderByClause767 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_sortSpecification_in_orderByClause769 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0100000000000000L});
    public static final BitSet FOLLOW_SORT_SPEC_in_sortSpecification785 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_sortSpecification787 = new BitSet(new long[]{0x0000000008000000L,0x0000000000000000L,0x0000000000080000L});
    public static final BitSet FOLLOW_COLLATE_in_sortSpecification789 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000080000L});
    public static final BitSet FOLLOW_ORDER_SPEC_in_sortSpecification792 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_OR_in_searchCondition810 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_searchCondition_in_searchCondition812 = new BitSet(new long[]{0xA208C4EE05CACDA0L,0xBFDF815608E20D12L,0x3EF0100130C2CE54L,0x00000000000051B0L});
    public static final BitSet FOLLOW_searchCondition_in_searchCondition814 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_AND_in_searchCondition827 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_searchCondition_in_searchCondition829 = new BitSet(new long[]{0xA208C4EE05CACDA0L,0xBFDF815608E20D12L,0x3EF0100130C2CE54L,0x00000000000051B0L});
    public static final BitSet FOLLOW_searchCondition_in_searchCondition831 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_NOT_in_searchCondition844 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_searchCondition_in_searchCondition846 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_predicate_in_searchCondition855 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_EQUALS_in_predicate868 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate870 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_comparativePredicateValue_in_predicate872 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_NOT_EQUAL_in_predicate883 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate885 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_comparativePredicateValue_in_predicate887 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LESS_in_predicate898 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate900 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_comparativePredicateValue_in_predicate902 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LESS_EQUAL_in_predicate913 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate915 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_comparativePredicateValue_in_predicate917 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_GREATER_in_predicate928 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate930 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_comparativePredicateValue_in_predicate932 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_GREATER_EQUAL_in_predicate943 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate945 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_comparativePredicateValue_in_predicate947 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IS_NULL_in_predicate958 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate960 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LIKE_in_predicate971 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_predicate973 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_valueExpression_in_predicate977 = new BitSet(new long[]{0x0400000000000008L});
    public static final BitSet FOLLOW_escapeSpecification_in_predicate979 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_BETWEEN_in_predicate991 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate993 = new BitSet(new long[]{0x0000000000040000L});
    public static final BitSet FOLLOW_betweenList_in_predicate995 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IN_in_predicate1004 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate1006 = new BitSet(new long[]{0x0000000000000000L,0x0000000080000000L});
    public static final BitSet FOLLOW_inPredicateValue_in_predicate1008 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_MEMBER_OF_in_predicate1019 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate1021 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate1023 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_NOT_MEMBER_OF_in_predicate1032 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate1034 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate1036 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IS_EMPTY_in_predicate1046 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate1048 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IS_NOT_EMPTY_in_predicate1057 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate1059 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate1066 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_BETWEEN_LIST_in_betweenList1079 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_betweenList1083 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_rowValueConstructor_in_betweenList1087 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_rowValueConstructor_in_comparativePredicateValue1102 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_valueExpression_in_rowValueConstructor1113 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ESCAPE_in_escapeSpecification1129 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_escapeSpecification1131 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IN_LIST_in_inPredicateValue1155 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_inPredicateValue1158 = new BitSet(new long[]{0xA008C4EE05C8C9A8L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_valueExpression_in_numericValueExpression1174 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_valueExpression_in_characterValueExpression1185 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_valueExpression_in_datetimeValueExpression1196 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DOUBLE_PIPE_in_valueExpression1209 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_valueExpression1211 = new BitSet(new long[]{0xA008C4EE05C8C9A8L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_UNARY_MINUS_in_valueExpression1221 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_valueExpression1223 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_UNARY_PLUS_in_valueExpression1232 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_valueExpression1234 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_PLUS_in_valueExpression1243 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_valueExpression1245 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_valueExpression_in_valueExpression1247 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_MINUS_in_valueExpression1256 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_valueExpression1258 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_valueExpression_in_valueExpression1260 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ASTERISK_in_valueExpression1269 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_valueExpression1271 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_numericValueExpression_in_valueExpression1273 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_SOLIDUS_in_valueExpression1282 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_valueExpression1284 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_numericValueExpression_in_valueExpression1286 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_EXISTS_in_valueExpression1295 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_valueExpression1297 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_SOME_in_valueExpression1305 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_valueExpression1307 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ALL_in_valueExpression1316 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_valueExpression1318 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ANY_in_valueExpression1327 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_valueExpression1329 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_VECTOR_EXPR_in_valueExpression1338 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_valueExpression1340 = new BitSet(new long[]{0xA008C4EE05C8C9A8L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_valueExpressionPrimary_in_valueExpression1348 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_caseExpression_in_valueExpressionPrimary1359 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_function_in_valueExpressionPrimary1364 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_collectionFunction_in_valueExpressionPrimary1369 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_collectionExpression_in_valueExpressionPrimary1374 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_constant_in_valueExpressionPrimary1379 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_parameter_in_valueExpressionPrimary1384 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_propertyReference_in_valueExpressionPrimary1389 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_SUB_QUERY_in_valueExpressionPrimary1395 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_queryStatementSet_in_valueExpressionPrimary1397 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ALIAS_REF_in_valueExpressionPrimary1403 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DOT_CLASS_in_valueExpressionPrimary1410 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_path_in_valueExpressionPrimary1412 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_JAVA_CONSTANT_in_valueExpressionPrimary1420 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_path_in_valueExpressionPrimary1422 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_PATH_in_valueExpressionPrimary1430 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_propertyReferencePath_in_valueExpressionPrimary1432 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_NULLIF_in_caseExpression1447 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_caseExpression1449 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_valueExpression_in_caseExpression1451 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_COALESCE_in_caseExpression1458 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_caseExpression1460 = new BitSet(new long[]{0xA008C4EE05C8C9A8L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_valueExpression_in_caseExpression1462 = new BitSet(new long[]{0xA008C4EE05C8C9A8L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_SIMPLE_CASE_in_caseExpression1470 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_caseExpression1472 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
    public static final BitSet FOLLOW_simpleCaseWhenClause_in_caseExpression1474 = new BitSet(new long[]{0x0010000000000008L,0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
    public static final BitSet FOLLOW_elseClause_in_caseExpression1477 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_SEARCHED_CASE_in_caseExpression1485 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_searchedWhenClause_in_caseExpression1487 = new BitSet(new long[]{0x0010000000000008L,0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
    public static final BitSet FOLLOW_elseClause_in_caseExpression1490 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_WHEN_in_simpleCaseWhenClause1504 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_simpleCaseWhenClause1506 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_valueExpression_in_simpleCaseWhenClause1508 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_WHEN_in_searchedWhenClause1521 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_searchCondition_in_searchedWhenClause1523 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_valueExpression_in_searchedWhenClause1525 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ELSE_in_elseClause1538 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_elseClause1540 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_setFunction_in_function1552 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_standardFunction_in_function1557 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_SUM_in_setFunction1574 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_setFunction1578 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_AVG_in_setFunction1585 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_setFunction1589 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_MAX_in_setFunction1596 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_setFunction1600 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_MIN_in_setFunction1607 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_setFunction1611 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_COUNT_in_setFunction1618 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ASTERISK_in_setFunction1621 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_DISTINCT_in_setFunction1628 = new BitSet(new long[]{0x0008040000000000L,0x0000000008800010L,0x0000000100000000L});
    public static final BitSet FOLLOW_ALL_in_setFunction1634 = new BitSet(new long[]{0x0008040000000000L,0x0000000008800010L,0x0000000100000000L});
    public static final BitSet FOLLOW_countFunctionArguments_in_setFunction1639 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_functionFunction_in_standardFunction1652 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_castFunction_in_standardFunction1657 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_concatFunction_in_standardFunction1662 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_substringFunction_in_standardFunction1667 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_trimFunction_in_standardFunction1672 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_upperFunction_in_standardFunction1677 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_lowerFunction_in_standardFunction1682 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_lengthFunction_in_standardFunction1687 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_locateFunction_in_standardFunction1692 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_absFunction_in_standardFunction1697 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_sqrtFunction_in_standardFunction1702 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_modFunction_in_standardFunction1707 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_sizeFunction_in_standardFunction1712 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_indexFunction_in_standardFunction1717 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_currentDateFunction_in_standardFunction1722 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_currentTimeFunction_in_standardFunction1727 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_currentTimestampFunction_in_standardFunction1732 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_extractFunction_in_standardFunction1737 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_positionFunction_in_standardFunction1742 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_charLengthFunction_in_standardFunction1747 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_octetLengthFunction_in_standardFunction1752 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_bitLengthFunction_in_standardFunction1757 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FUNCTION_in_functionFunction1770 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_functionFunction1772 = new BitSet(new long[]{0xA008C4EE05C8C9A8L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_CAST_in_castFunction1787 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_castFunction1789 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L});
    public static final BitSet FOLLOW_IDENTIFIER_in_castFunction1791 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_CONCAT_in_concatFunction1806 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_concatFunction1808 = new BitSet(new long[]{0xA008C4EE05C8C9A8L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_SUBSTRING_in_substringFunction1822 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_substringFunction1824 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_numericValueExpression_in_substringFunction1826 = new BitSet(new long[]{0xA008C4EE05C8C9A8L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_numericValueExpression_in_substringFunction1828 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_TRIM_in_trimFunction1842 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_trimOperands_in_trimFunction1844 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_set_in_trimOperands1857 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_trimOperands1865 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_characterValueExpression_in_trimOperands1867 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_UPPER_in_upperFunction1880 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_upperFunction1882 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LOWER_in_lowerFunction1895 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_lowerFunction1897 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LENGTH_in_lengthFunction1910 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_lengthFunction1912 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LOCATE_in_locateFunction1925 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_locateFunction1927 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_characterValueExpression_in_locateFunction1929 = new BitSet(new long[]{0xA008C4EE05C8C9A8L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_numericValueExpression_in_locateFunction1931 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ABS_in_absFunction1945 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_absFunction1947 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_SQRT_in_sqrtFunction1960 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_sqrtFunction1962 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_MOD_in_modFunction1975 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_modFunction1977 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_numericValueExpression_in_modFunction1979 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_SIZE_in_sizeFunction1992 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_propertyReference_in_sizeFunction1994 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_INDEX_in_indexFunction2007 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ALIAS_REF_in_indexFunction2009 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_CURRENT_DATE_in_currentDateFunction2021 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CURRENT_TIME_in_currentTimeFunction2032 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CURRENT_TIMESTAMP_in_currentTimestampFunction2043 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_EXTRACT_in_extractFunction2055 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_extractField_in_extractFunction2057 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_datetimeValueExpression_in_extractFunction2059 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_datetimeField_in_extractField2071 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_timeZoneField_in_extractField2076 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_POSITION_in_positionFunction2140 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_positionFunction2142 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_characterValueExpression_in_positionFunction2144 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_CHARACTER_LENGTH_in_charLengthFunction2157 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_charLengthFunction2159 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_OCTET_LENGTH_in_octetLengthFunction2172 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_octetLengthFunction2174 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_BIT_LENGTH_in_bitLengthFunction2187 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_bitLengthFunction2189 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_collectionExpression_in_countFunctionArguments2202 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_propertyReference_in_countFunctionArguments2207 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_numeric_literal_in_countFunctionArguments2212 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_collectionFunction2224 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_collectionPropertyReference_in_collectionFunction2234 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_propertyReference_in_collectionPropertyReference2249 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ELEMENTS_in_collectionExpression2261 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_propertyReference_in_collectionExpression2263 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_INDICES_in_collectionExpression2271 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_propertyReference_in_collectionExpression2273 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_literal_in_constant2306 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NULL_in_constant2311 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_TRUE_in_constant2316 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FALSE_in_constant2321 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_numeric_literal_in_literal2332 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_HEX_LITERAL_in_literal2337 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_OCTAL_LITERAL_in_literal2342 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CHARACTER_LITERAL_in_literal2347 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRING_LITERAL_in_literal2352 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CONST_STRING_VALUE_in_literal2358 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_CHARACTER_LITERAL_in_literal2360 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_CONST_STRING_VALUE_in_literal2367 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_STRING_LITERAL_in_literal2369 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ENTITY_NAME_in_entityName2402 = new BitSet(new long[]{0x0000000000000040L});
    public static final BitSet FOLLOW_ALIAS_NAME_in_entityName2404 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_PROPERTY_REFERENCE_in_propertyReference2419 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_propertyReferencePath_in_propertyReference2421 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_PATH_in_joinPropertyReference2437 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_propertyReferencePath_in_joinPropertyReference2439 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_unqualifiedPropertyReference_in_propertyReferencePath2455 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_pathedPropertyReference_in_propertyReferencePath2460 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_terminalIndexOperation_in_propertyReferencePath2465 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_unqualifiedPropertyReference2476 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DOT_in_pathedPropertyReference2488 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_pathedPropertyReferenceSource_in_pathedPropertyReference2490 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L});
    public static final BitSet FOLLOW_IDENTIFIER_in_pathedPropertyReference2492 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IDENTIFIER_in_pathedPropertyReferenceSource2507 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_pathedPropertyReferenceSource2515 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_intermediatePathedPropertyReference_in_pathedPropertyReferenceSource2520 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_intermediateIndexOperation_in_pathedPropertyReferenceSource2525 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DOT_in_intermediatePathedPropertyReference2537 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_pathedPropertyReferenceSource_in_intermediatePathedPropertyReference2541 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L});
    public static final BitSet FOLLOW_IDENTIFIER_in_intermediatePathedPropertyReference2543 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LEFT_SQUARE_in_intermediateIndexOperation2558 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_indexOperationSource_in_intermediateIndexOperation2560 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_indexSelector_in_intermediateIndexOperation2562 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LEFT_SQUARE_in_terminalIndexOperation2577 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_indexOperationSource_in_terminalIndexOperation2579 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_indexSelector_in_terminalIndexOperation2581 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_DOT_in_indexOperationSource2595 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_pathedPropertyReferenceSource_in_indexOperationSource2597 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L});
    public static final BitSet FOLLOW_IDENTIFIER_in_indexOperationSource2599 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IDENTIFIER_in_indexOperationSource2609 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_valueExpression_in_indexSelector2620 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_path2632 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DOT_in_path2638 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_path_in_path2640 = new BitSet(new long[]{0x0000200000000000L,0x0000600000100000L});
    public static final BitSet FOLLOW_path_in_path2642 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LEFT_SQUARE_in_path2650 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_path_in_path2652 = new BitSet(new long[]{0xA008C4EE05C8C9A8L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_valueExpression_in_path2654 = new BitSet(new long[]{0xA008C4EE05C8C9A8L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_LEFT_PAREN_in_path2663 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_path_in_path2665 = new BitSet(new long[]{0xA008C4EE05C8C9A8L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_valueExpression_in_path2667 = new BitSet(new long[]{0xA008C4EE05C8C9A8L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});

}