/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.testing.internal.parser;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.Parser;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RuleReturnScope;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.hibernate.hql.testing.internal.model.GrammarRuleTestDescriptor;
import org.hibernate.hql.testing.internal.model.GrammarRuleTestGroupDescriptor;
import org.hibernate.hql.testing.internal.model.GrammarTestDescriptor;
import org.hibernate.hql.testing.internal.model.ParsingResult;
import org.hibernate.hql.testing.internal.model.RuleType;

public class GrammarRuleTestRunner {
    private final GrammarTestDescriptor grammarTest;
    private final GrammarRuleTestGroupDescriptor grammarRuleTestGroup;
    private final GrammarRuleTestDescriptor grammarRuleTest;

    public GrammarRuleTestRunner(GrammarTestDescriptor grammarTest, GrammarRuleTestGroupDescriptor grammarRuleTestGroup, GrammarRuleTestDescriptor grammarRuleTest) {
        this.grammarTest = grammarTest;
        this.grammarRuleTestGroup = grammarRuleTestGroup;
        this.grammarRuleTest = grammarRuleTest;
    }

    public ParsingResult run() throws Throwable {
        ParsingResult parsingResult;
        Lexer lexer = this.getLexer();
        if (this.grammarRuleTestGroup.getRuleType() == RuleType.LEXER) {
            Method rule = lexer.getClass().getMethod("m" + this.grammarRuleTestGroup.getName(), new Class[0]);
            parsingResult = this.invokeRule(lexer, rule);
        } else {
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            Parser parser = this.getParser(tokens);
            Method rule = parser.getClass().getMethod(this.grammarRuleTestGroup.getName(), new Class[0]);
            parsingResult = this.invokeRule(parser, rule);
            String unconsumedTokens = this.getUnconsumedTokens(tokens);
            if (unconsumedTokens != null) {
                parsingResult = ParsingResult.fail("Found unconsumed tokens: \"" + unconsumedTokens + "\".");
            }
        }
        return parsingResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParsingResult invokeRule(Object target, Method rule) throws Throwable {
        PrintStream originalErrorStream = System.err;
        try {
            ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
            System.setErr(new PrintStream(errorStream));
            Object result = rule.invoke(target, new Object[0]);
            String ast = this.getAst(result);
            ParsingResult parsingResult = this.getParsingResult(errorStream, ast);
            return parsingResult;
        }
        catch (InvocationTargetException ite) {
            try {
                if (ite.getCause() != null) {
                    throw ite.getCause();
                }
                throw ite;
            }
            catch (RecognitionException re) {
                ParsingResult parsingResult = ParsingResult.fail(re.getMessage());
                return parsingResult;
            }
        }
        finally {
            System.setErr(originalErrorStream);
        }
    }

    private ParsingResult getParsingResult(OutputStream errorStream, String ast) {
        return errorStream.toString().isEmpty() ? ParsingResult.ok(ast) : ParsingResult.fail(errorStream.toString(), ast);
    }

    private String getAst(Object result) {
        if (result instanceof RuleReturnScope) {
            return ((CommonTree)((RuleReturnScope)result).getTree()).toStringTree();
        }
        return null;
    }

    private Lexer getLexer() throws Exception {
        return this.grammarTest.getLexerClass().getConstructor(CharStream.class).newInstance(new ANTLRStringStream(this.grammarRuleTest.getExpression()));
    }

    private Parser getParser(CommonTokenStream tokens) throws Exception {
        return this.grammarTest.getParserClass().getConstructor(TokenStream.class).newInstance(tokens);
    }

    private String getUnconsumedTokens(CommonTokenStream tokens) {
        tokens.fill();
        if (tokens.index() == tokens.size() - 1) {
            return null;
        }
        StringBuilder nonEofEndingTokens = new StringBuilder();
        for (Token endToken : tokens.getTokens(tokens.index(), tokens.size() - 1)) {
            if (endToken.getType() == -1) continue;
            nonEofEndingTokens.append(endToken.getText());
        }
        return nonEofEndingTokens.length() > 0 ? nonEofEndingTokens.toString() : null;
    }
}

