/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.infra.develocity.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.shared.artifact.filter.PatternExcludesArtifactFilter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.hibernate.infra.develocity.Log;

public final class MavenMojoExecutionConfig {
    private final MojoExecution mojoExecution;

    public MavenMojoExecutionConfig(MojoExecution mojoExecution) {
        this.mojoExecution = mojoExecution;
    }

    public Boolean getBoolean(String key) {
        return Boolean.parseBoolean(this.getString(key));
    }

    public String getString(String key) {
        Xpp3Dom configElement = this.mojoExecution.getConfiguration().getChild(key);
        if (configElement == null) {
            return null;
        }
        String value = configElement.getValue();
        if (value == null) {
            return null;
        }
        return value.trim();
    }

    public List<String> getStringList(String key) {
        Xpp3Dom configElement = this.mojoExecution.getConfiguration().getChild(key);
        if (configElement == null) {
            return List.of();
        }
        ArrayList<String> children = new ArrayList<String>();
        for (Xpp3Dom configElementChild : configElement.getChildren()) {
            String value = configElementChild.getValue();
            if (value == null) continue;
            children.add(value);
        }
        return children;
    }

    public Map<String, String> getStringMap(String key) {
        Xpp3Dom configElement = this.mojoExecution.getConfiguration().getChild(key);
        if (configElement == null) {
            return Map.of();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Xpp3Dom configElementChild : configElement.getChildren()) {
            result.put(configElementChild.getName(), configElementChild.getValue());
        }
        return result;
    }

    public String getFailsafeSystemProperty(String key) {
        Xpp3Dom systemPropertyVariables = this.mojoExecution.getConfiguration().getChild("systemPropertyVariables");
        if (systemPropertyVariables == null) {
            return null;
        }
        Xpp3Dom child = systemPropertyVariables.getChild(key);
        if (child == null) {
            return null;
        }
        return child.getValue();
    }

    public ArtifactFilter getFailsafeClasspathFilter() {
        ArrayList<Object> filters = new ArrayList<Object>();
        try {
            String classpathDependencyScopeExclude = this.getString("classpathDependencyScopeExclude");
            List<String> classpathDependencyExcludes = this.getStringList("classpathDependencyExcludes");
            if (classpathDependencyScopeExclude != null && !classpathDependencyScopeExclude.isEmpty()) {
                ScopeArtifactFilter scopeIncludeFilter = new ScopeArtifactFilter(classpathDependencyScopeExclude);
                filters.add(artifact -> !scopeIncludeFilter.include(artifact));
            }
            if (classpathDependencyScopeExclude != null && !classpathDependencyScopeExclude.isEmpty()) {
                filters.add(new PatternExcludesArtifactFilter(classpathDependencyExcludes));
            }
        }
        catch (RuntimeException e) {
            Log.warn("Could not interpret Failsafe classpath filters: %s", e.getMessage());
        }
        if (filters.isEmpty()) {
            return ignored -> true;
        }
        return new AndArtifactFilter(filters);
    }
}

