/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.infra.develocity.plugins;

import com.gradle.develocity.agent.maven.api.cache.MojoMetadataProvider;
import java.util.Map;
import java.util.regex.Pattern;
import org.hibernate.infra.develocity.GoalMetadataProvider;
import org.hibernate.infra.develocity.SimpleConfiguredPlugin;
import org.hibernate.infra.develocity.scan.BuildScanMetadata;
import org.hibernate.infra.develocity.util.JavaVersions;

public class SurefireConfiguredPlugin
extends SimpleConfiguredPlugin {
    private static final String SUREFIRE_ENVIRONMENT_VARIABLES = "environmentVariables";
    private static final Pattern TEST_INDEXES_PATTERN = Pattern.compile("(^|/)test-indexes($|/)");

    @Override
    protected String getPluginName() {
        return "maven-surefire-plugin";
    }

    @Override
    protected Map<String, GoalMetadataProvider> getGoalMetadataProviders() {
        return Map.of("test", this::configureTest);
    }

    protected void configureTest(GoalMetadataProvider.Context context) {
        MojoMetadataProvider.Context metadata = context.metadata();
        metadata.inputs(inputs -> SurefireConfiguredPlugin.dependsOnConfigurableJavaExecutable(inputs, context, "jvm", this.isSkipped(context), JavaVersions::forJavaExecutable));
        this.configureEnvironmentVariables(context);
        if (!this.isSkipped(context)) {
            BuildScanMetadata.addSurefireMetadata(context);
        }
    }

    private void configureEnvironmentVariables(GoalMetadataProvider.Context context) {
        context.metadata().inputs(inputs -> {
            inputs.property(SUREFIRE_ENVIRONMENT_VARIABLES, (Object)"IGNORED");
            for (Map.Entry<String, String> envVariable : context.configuration().getStringMap(SUREFIRE_ENVIRONMENT_VARIABLES).entrySet()) {
                String key = envVariable.getKey();
                String keyForDevelocity = "environmentVariables." + key;
                String value = envVariable.getValue();
                if (value == null) {
                    value = "";
                }
                if (value.startsWith(context.metadata().getSession().getExecutionRootDirectory())) {
                    if (TEST_INDEXES_PATTERN.matcher(value).find()) {
                        inputs.ignore(new String[]{keyForDevelocity});
                        continue;
                    }
                    inputs.fileSet(keyForDevelocity, (Object)value, fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH));
                    continue;
                }
                inputs.property(keyForDevelocity, (Object)value);
            }
        });
    }

    protected boolean isSkipped(GoalMetadataProvider.Context context) {
        return context.configuration().getBoolean("skip") != false || context.properties().getBoolean("maven.test.skip") != false || context.configuration().getBoolean("skipTests") != false || context.properties().getBoolean("skipTests") != false || context.configuration().getBoolean("skipExec") != false || context.properties().getBoolean("maven.test.skip.exec") != false;
    }
}

