/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.infra.develocity.plugins;

import com.gradle.develocity.agent.maven.api.cache.MojoMetadataProvider;
import java.io.File;
import java.util.Map;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.hibernate.infra.develocity.GoalMetadataProvider;
import org.hibernate.infra.develocity.SimpleConfiguredPlugin;

public class ForbiddenApisConfiguredPlugin
extends SimpleConfiguredPlugin {
    @Override
    protected String getPluginName() {
        return "forbiddenapis";
    }

    @Override
    protected Map<String, GoalMetadataProvider> getGoalMetadataProviders() {
        return Map.of("check", ForbiddenApisConfiguredPlugin::configureCheck, "testCheck", ForbiddenApisConfiguredPlugin::configureTestCheck);
    }

    private static void configureCheck(GoalMetadataProvider.Context context) {
        MojoMetadataProvider.Context metadata = context.metadata();
        metadata.inputs(inputs -> {
            ForbiddenApisConfiguredPlugin.dependsOnGav(inputs, context);
            inputs.properties(new String[]{"signatures", "bundledSignatures", "failOnUnsupportedJava", "failOnMissingClasses", "failOnUnresolvableSignatures", "ignoreSignaturesOfMissingClasses", "failOnViolation", "disableClassloadingCache", "targetVersion", "releaseVersion", "includes", "excludes", "suppressAnnotations", "skip", "packaging"});
            inputs.fileSet("signaturesFiles", fs -> fs.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH));
            inputs.fileSet("classpathElements", fs -> fs.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.COMPILE_CLASSPATH));
            inputs.fileSet("classesDirectory", fs -> fs.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.COMPILE_CLASSPATH));
            File buildConfigArtifactFile = ForbiddenApisConfiguredPlugin.resolveBuildConfigArtifact(context);
            inputs.fileSet("buildConfigArtifact", (Object)buildConfigArtifactFile, fs -> fs.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.CLASSPATH));
            inputs.ignore(new String[]{"signaturesArtifacts", "projectRepos", "repoSession"});
        });
        metadata.outputs(outputs -> outputs.cacheable("If the inputs and signatures are identical, we should have the same output"));
    }

    private static void configureTestCheck(GoalMetadataProvider.Context context) {
        MojoMetadataProvider.Context metadata = context.metadata();
        ForbiddenApisConfiguredPlugin.configureCheck(context);
        metadata.inputs(inputs -> inputs.properties(new String[]{"testTargetVersion", "testReleaseVersion"}));
    }

    private static File resolveBuildConfigArtifact(GoalMetadataProvider.Context context) {
        String groupId = context.metadata().getProject().getModel().getGroupId();
        if ("org.hibernate.search".equals(groupId)) {
            return ForbiddenApisConfiguredPlugin.resolveBuildConfigArtifact("org.hibernate.search", "hibernate-search-build-config", context);
        }
        if ("org.hibernate.validator".equals(groupId)) {
            return ForbiddenApisConfiguredPlugin.resolveBuildConfigArtifact("org.hibernate.validator", "hibernate-validator-build-config", context);
        }
        throw new IllegalArgumentException("This project is not supported by the extension: %s:%s".formatted(groupId, context.metadata().getProject().getArtifactId()));
    }

    private static File resolveBuildConfigArtifact(String groupId, String artifactId, GoalMetadataProvider.Context context) {
        DefaultArtifact hibernateSearchBuildConfigArtifact = new DefaultArtifact(groupId, artifactId, "jar", context.metadata().getProject().getVersion());
        File hibernateSearchBuildConfigArtifactFile = context.metadata().getSession().getRepositorySession().getWorkspaceReader().findArtifact((Artifact)hibernateSearchBuildConfigArtifact);
        if (hibernateSearchBuildConfigArtifactFile == null) {
            hibernateSearchBuildConfigArtifactFile = new File(context.metadata().getSession().getRepositorySession().getLocalRepositoryManager().getPathForLocalArtifact((Artifact)hibernateSearchBuildConfigArtifact));
        }
        return hibernateSearchBuildConfigArtifactFile;
    }
}

