/*
 * Decompiled with CFR 0.152.
 */
package javax.persistence.spi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolver;

public class PersistenceProviderResolverHolder {
    private static final PersistenceProviderResolver DEFAULT_RESOLVER = new PersistenceProviderResolverPerClassLoader();
    private static volatile PersistenceProviderResolver RESOLVER;

    public static PersistenceProviderResolver getPersistenceProviderResolver() {
        return RESOLVER == null ? DEFAULT_RESOLVER : RESOLVER;
    }

    public static void setPersistenceProviderResolver(PersistenceProviderResolver resolver) {
        RESOLVER = resolver;
    }

    private static class PersistenceProviderResolverPerClassLoader
    implements PersistenceProviderResolver {
        private final WeakHashMap<ClassLoader, PersistenceProviderResolver> resolvers = new WeakHashMap();
        private volatile short barrier = 1;

        private PersistenceProviderResolverPerClassLoader() {
        }

        @Override
        public List<PersistenceProvider> getPersistenceProviders() {
            PersistenceProviderResolver currentResolver;
            ClassLoader cl = PersistenceProviderResolverPerClassLoader.getContextualClassLoader();
            if (this.barrier == 1) {
                // empty if block
            }
            if ((currentResolver = this.resolvers.get(cl)) == null) {
                currentResolver = new CachingPersistenceProviderResolver(cl);
                this.resolvers.put(cl, currentResolver);
                this.barrier = 1;
            }
            return currentResolver.getPersistenceProviders();
        }

        @Override
        public void clearCachedProviders() {
            PersistenceProviderResolver currentResolver;
            ClassLoader cl = PersistenceProviderResolverPerClassLoader.getContextualClassLoader();
            if (this.barrier == 1) {
                // empty if block
            }
            if ((currentResolver = this.resolvers.get(cl)) != null) {
                currentResolver.clearCachedProviders();
            }
        }

        private static ClassLoader getContextualClassLoader() {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = PersistenceProviderResolverPerClassLoader.class.getClassLoader();
            }
            return cl;
        }

        private static class CachingPersistenceProviderResolver
        implements PersistenceProviderResolver {
            private final List<WeakReference<Class<? extends PersistenceProvider>>> resolverClasses = new ArrayList<WeakReference<Class<? extends PersistenceProvider>>>();
            private static final Pattern nonCommentPattern = Pattern.compile("^([^#]+)");

            public CachingPersistenceProviderResolver(ClassLoader cl) {
                this.loadResolverClasses(cl);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void loadResolverClasses(ClassLoader cl) {
                List<WeakReference<Class<? extends PersistenceProvider>>> list = this.resolverClasses;
                synchronized (list) {
                    try {
                        Enumeration<URL> resources = cl.getResources("META-INF/services/" + PersistenceProvider.class.getName());
                        HashSet<String> names = new HashSet<String>();
                        while (resources.hasMoreElements()) {
                            URL url = resources.nextElement();
                            try (InputStream is = url.openStream();){
                                names.addAll(CachingPersistenceProviderResolver.providerNamesFromReader(new BufferedReader(new InputStreamReader(is))));
                            }
                        }
                        for (String s : names) {
                            Class<?> providerClass = cl.loadClass(s);
                            WeakReference reference = new WeakReference(providerClass);
                            if (s.endsWith("HibernatePersistence") && this.resolverClasses.size() > 0) {
                                WeakReference<Class<? extends PersistenceProvider>> movedReference = this.resolverClasses.get(0);
                                this.resolverClasses.add(0, reference);
                                this.resolverClasses.add(movedReference);
                                continue;
                            }
                            this.resolverClasses.add(reference);
                        }
                    }
                    catch (IOException e) {
                        throw new PersistenceException(e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new PersistenceException(e);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<PersistenceProvider> getPersistenceProviders() {
                List<WeakReference<Class<? extends PersistenceProvider>>> list = this.resolverClasses;
                synchronized (list) {
                    ArrayList<PersistenceProvider> providers = new ArrayList<PersistenceProvider>(this.resolverClasses.size());
                    try {
                        for (WeakReference<Class<? extends PersistenceProvider>> providerClass : this.resolverClasses) {
                            providers.add((PersistenceProvider)((Class)providerClass.get()).newInstance());
                        }
                    }
                    catch (InstantiationException e) {
                        throw new PersistenceException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new PersistenceException(e);
                    }
                    return providers;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void clearCachedProviders() {
                List<WeakReference<Class<? extends PersistenceProvider>>> list = this.resolverClasses;
                synchronized (list) {
                    this.resolverClasses.clear();
                    this.loadResolverClasses(PersistenceProviderResolverPerClassLoader.getContextualClassLoader());
                }
            }

            private static Set<String> providerNamesFromReader(BufferedReader reader) throws IOException {
                String line;
                HashSet<String> names = new HashSet<String>();
                while ((line = reader.readLine()) != null) {
                    Matcher m = nonCommentPattern.matcher(line = line.trim());
                    if (!m.find()) continue;
                    names.add(m.group().trim());
                }
                return names;
            }
        }
    }
}

