/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.origin.hql.resolve;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeNodeStream;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.query.dsl.impl.ConnectedQueryContextBuilder;
import org.hibernate.sql.ast.common.JoinType;
import org.hibernate.sql.ast.origin.hql.resolve.EntityNamesResolver;
import org.hibernate.sql.ast.origin.hql.resolve.GeneratedHQLResolver;
import org.hibernate.sql.ast.origin.hql.resolve.path.PathedPropertyReference;
import org.hibernate.sql.ast.origin.hql.resolve.path.PathedPropertyReferenceSource;

public class LuceneJPQLWalker
extends GeneratedHQLResolver {
    private final Map<String, String> aliasToEntityType = new HashMap<String, String>();
    private boolean definingSelectStrategy;
    private final SearchFactoryImplementor searchFactory;
    private final ConnectedQueryContextBuilder queryBuildContext;
    private final EntityNamesResolver entityNames;
    private Class targetType = null;
    private BooleanQuery booleanQuery;
    private Stack<BooleanQuery> booleanQueryStack = new Stack();
    private Stack<BooleanClause.Occur> booleanQueryModeStack = new Stack();
    private BooleanClause.Occur booleanMode;
    private String propertyName;
    private Query rootQuery = new MatchAllDocsQuery();
    private final Map<String, Object> namedParameters;

    public LuceneJPQLWalker(TreeNodeStream input, SearchFactoryImplementor searchFactory, EntityNamesResolver entityNames) {
        this(input, searchFactory, entityNames, Collections.EMPTY_MAP);
    }

    public LuceneJPQLWalker(TreeNodeStream input, SearchFactoryImplementor searchFactory, EntityNamesResolver entityNames, Map<String, Object> namedParameters) {
        super(input);
        this.searchFactory = searchFactory;
        this.entityNames = entityNames;
        this.namedParameters = namedParameters;
        this.queryBuildContext = new ConnectedQueryContextBuilder(searchFactory);
    }

    @Override
    protected void registerPersisterSpace(Tree entityName, Tree alias) {
        String put = this.aliasToEntityType.put(alias.getText(), entityName.getText());
        if (put != null && !put.equalsIgnoreCase(entityName.getText())) {
            throw new UnsupportedOperationException("Alias reuse currently not supported: alias " + alias.getText() + " already assigned to type " + put);
        }
        Class targetedType = this.entityNames.getClassFromName(entityName.getText());
        if (targetedType == null) {
            throw new IllegalStateException("Unknown entity name " + entityName.getText());
        }
        if (this.targetType != null) {
            throw new IllegalStateException("Can't target multiple types: " + this.targetType + " already selected before " + targetedType);
        }
        this.targetType = targetedType;
    }

    @Override
    protected boolean isUnqualifiedPropertyReference() {
        return true;
    }

    @Override
    protected PathedPropertyReferenceSource normalizeUnqualifiedPropertyReference(Tree property) {
        this.propertyName = property.getText();
        return null;
    }

    @Override
    protected boolean isPersisterReferenceAlias() {
        if (this.aliasToEntityType.size() == 1) {
            return true;
        }
        throw new UnsupportedOperationException("Unexpected use case: not implemented yet?");
    }

    @Override
    protected PathedPropertyReferenceSource normalizeUnqualifiedRoot(Tree identifier382) {
        throw new UnsupportedOperationException("must be overridden!");
    }

    @Override
    protected PathedPropertyReferenceSource normalizeQualifiedRoot(Tree identifier381) {
        return new PathedPropertyReference(identifier381.getText(), this.aliasToEntityType);
    }

    @Override
    protected PathedPropertyReferenceSource normalizePropertyPathIntermediary(PathedPropertyReferenceSource source, Tree propertyName) {
        throw new UnsupportedOperationException("must be overridden!");
    }

    @Override
    protected PathedPropertyReferenceSource normalizeIntermediateIndexOperation(PathedPropertyReferenceSource propertyReferenceSource, Tree collectionProperty, Tree selector) {
        throw new UnsupportedOperationException("must be overridden!");
    }

    @Override
    protected void normalizeTerminalIndexOperation(PathedPropertyReferenceSource propertyReferenceSource, Tree collectionProperty, Tree selector) {
        throw new UnsupportedOperationException("must be overridden!");
    }

    @Override
    protected PathedPropertyReferenceSource normalizeUnqualifiedPropertyReferenceSource(Tree identifier394) {
        throw new UnsupportedOperationException("must be overridden!");
    }

    @Override
    protected Tree normalizePropertyPathTerminus(PathedPropertyReferenceSource source, Tree propertyNameNode) {
        this.propertyName = propertyNameNode.toString();
        return null;
    }

    @Override
    protected void pushFromStrategy(JoinType joinType, Tree assosiationFetchTree, Tree propertyFetchTree, Tree alias) {
        throw new UnsupportedOperationException("must be overridden!");
    }

    @Override
    protected void pushSelectStrategy() {
        this.definingSelectStrategy = true;
    }

    @Override
    protected void popStrategy() {
        this.definingSelectStrategy = false;
    }

    public Class getTargetEntity() {
        return this.targetType;
    }

    @Override
    protected void activateOR() {
        this.activateBoolean();
        this.booleanQuery = new BooleanQuery();
        this.booleanMode = BooleanClause.Occur.SHOULD;
    }

    @Override
    protected void activateAND() {
        this.activateBoolean();
        this.booleanQuery = new BooleanQuery();
        this.booleanMode = BooleanClause.Occur.MUST;
    }

    @Override
    protected void activateNOT() {
        this.activateBoolean();
        this.booleanQuery = new BooleanQuery();
        this.booleanMode = BooleanClause.Occur.MUST_NOT;
    }

    @Override
    protected void predicateEquals(String comparativePredicate) {
        Object comparison = this.fromNamedQuery(comparativePredicate);
        String comparisonTerm = this.valueToString(comparison);
        TermQuery predicate = new TermQuery(new Term(this.propertyName, comparisonTerm));
        if (this.booleanQuery != null) {
            this.booleanQuery.add((Query)predicate, this.booleanMode);
        } else {
            this.rootQuery = predicate;
        }
    }

    private String valueToString(Object comparison) {
        return comparison.toString();
    }

    private Object fromNamedQuery(String comparativePredicate) {
        if (comparativePredicate.startsWith(":")) {
            return this.namedParameters.get(comparativePredicate.substring(1));
        }
        return comparativePredicate;
    }

    private void activateBoolean() {
        this.booleanQueryStack.push(this.booleanQuery);
        this.booleanQueryModeStack.push(this.booleanMode);
    }

    @Override
    protected void deactivateBoolean() {
        BooleanQuery currentBoolean = this.booleanQuery;
        this.booleanQuery = this.booleanQueryStack.pop();
        this.booleanMode = this.booleanQueryModeStack.pop();
        if (this.booleanQuery == null) {
            this.rootQuery = currentBoolean;
        } else {
            this.booleanQuery.add((Query)currentBoolean, this.booleanMode);
        }
    }

    public String toString() {
        return this.rootQuery.toString();
    }

    public Query getLuceneQuery() {
        return this.rootQuery;
    }
}

