/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.jandex.internal;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hibernate.models.internal.ClassDetailsSupport;
import org.hibernate.models.internal.ModelsClassLogging;
import org.hibernate.models.internal.util.CollectionHelper;
import org.hibernate.models.jandex.internal.AbstractAnnotationTarget;
import org.hibernate.models.jandex.internal.JandexBuilders;
import org.hibernate.models.jandex.internal.JandexFieldDetails;
import org.hibernate.models.jandex.internal.JandexRecordComponentDetails;
import org.hibernate.models.jandex.internal.JandexTypeSwitchStandard;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.RecordComponentDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableDetails;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.RecordComponentInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;

public class JandexClassDetails
extends AbstractAnnotationTarget
implements ClassDetailsSupport {
    private final ClassInfo classInfo;
    private final ClassDetails superClass;
    private TypeDetails genericSuperType;
    private List<TypeDetails> implementedInterfaces;
    private List<TypeVariableDetails> typeParameters;
    private List<FieldDetails> fields;
    private List<MethodDetails> methods;
    private List<RecordComponentDetails> recordComponents;
    private Class<?> javaClass;

    public JandexClassDetails(ClassInfo classInfo, SourceModelBuildingContext modelContext) {
        super(modelContext);
        this.classInfo = classInfo;
        this.superClass = JandexClassDetails.determineSuperType(classInfo, modelContext);
    }

    @Override
    protected AnnotationTarget getJandexAnnotationTarget() {
        return this.classInfo;
    }

    public String getName() {
        return this.getClassName();
    }

    public String getClassName() {
        return this.classInfo.name().toString();
    }

    public boolean isResolved() {
        return false;
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.classInfo.flags());
    }

    public boolean isInterface() {
        return this.classInfo.isInterface();
    }

    public boolean isEnum() {
        return this.classInfo.isEnum();
    }

    public boolean isRecord() {
        return this.classInfo.isRecord();
    }

    public ClassDetails getSuperClass() {
        return this.superClass;
    }

    public TypeDetails getGenericSuperType() {
        if (this.genericSuperType == null && this.classInfo.superClassType() != null) {
            this.genericSuperType = JandexClassDetails.determineGenericSuperType(this.classInfo, this.getModelContext());
        }
        return this.genericSuperType;
    }

    public List<TypeDetails> getImplementedInterfaces() {
        if (this.implementedInterfaces == null) {
            this.implementedInterfaces = JandexClassDetails.determineInterfaces(this.classInfo, this.getModelContext());
        }
        return this.implementedInterfaces;
    }

    public List<TypeVariableDetails> getTypeParameters() {
        if (this.typeParameters == null) {
            this.typeParameters = JandexClassDetails.determineTypeParameters(this.classInfo, this, this.getModelContext());
        }
        return this.typeParameters;
    }

    public boolean isImplementor(Class<?> checkType) {
        if (this.getClassName().equals(checkType.getName())) {
            return true;
        }
        if (this.superClass != null && this.superClass.isImplementor(checkType)) {
            return true;
        }
        for (TypeDetails intf : this.getImplementedInterfaces()) {
            if (!intf.isImplementor(checkType)) continue;
            return true;
        }
        return false;
    }

    public List<FieldDetails> getFields() {
        if (this.fields == null) {
            this.fields = this.resolveFields();
        }
        return this.fields;
    }

    private List<FieldDetails> resolveFields() {
        List fieldsInfoList = this.classInfo.fields();
        ArrayList<FieldDetails> result = new ArrayList<FieldDetails>(fieldsInfoList.size());
        for (FieldInfo fieldInfo : fieldsInfoList) {
            result.add(new JandexFieldDetails(fieldInfo, (ClassDetails)this, this.getModelContext()));
        }
        return result;
    }

    public void addField(FieldDetails fieldDetails) {
        this.getFields().add(fieldDetails);
    }

    public List<RecordComponentDetails> getRecordComponents() {
        if (this.recordComponents == null) {
            this.recordComponents = this.resolveRecordComponents();
        }
        return this.recordComponents;
    }

    private List<RecordComponentDetails> resolveRecordComponents() {
        List componentInfoList = this.classInfo.recordComponents();
        ArrayList result = CollectionHelper.arrayList((int)componentInfoList.size());
        for (RecordComponentInfo componentInfo : componentInfoList) {
            result.add(new JandexRecordComponentDetails(componentInfo, (ClassDetails)this, this.getModelContext()));
        }
        return result;
    }

    public List<MethodDetails> getMethods() {
        if (this.methods == null) {
            this.methods = this.resolveMethods();
        }
        return this.methods;
    }

    private List<MethodDetails> resolveMethods() {
        List methodInfoList = this.classInfo.methods();
        ArrayList<MethodDetails> result = new ArrayList<MethodDetails>(methodInfoList.size());
        for (MethodInfo methodInfo : methodInfoList) {
            if (methodInfo.isConstructor() || "<clinit>".equals(methodInfo.name())) continue;
            result.add(JandexBuilders.buildMethodDetails(methodInfo, (ClassDetails)this, this.getModelContext()));
        }
        return result;
    }

    public void addMethod(MethodDetails methodDetails) {
        this.getMethods().add(methodDetails);
    }

    public <X> Class<X> toJavaClass() {
        if (this.javaClass == null) {
            if (this.getClassName() == null) {
                throw new UnsupportedOperationException("Not supported");
            }
            ModelsClassLogging.MODELS_CLASS_LOGGER.debugf("Loading `%s` on to classloader from Jandex ClassDetails", (Object)this.getClassName());
            this.javaClass = this.getModelContext().getClassLoading().classForName(this.getClassName());
        }
        return this.javaClass;
    }

    public String toString() {
        return "JandexClassDetails(" + this.classInfo.name().toString() + ")";
    }

    private static ClassDetails determineSuperType(ClassInfo classInfo, SourceModelBuildingContext buildingContext) {
        if (classInfo.superClassType() == null) {
            return null;
        }
        return buildingContext.getClassDetailsRegistry().resolveClassDetails(classInfo.superClassType().name().toString());
    }

    private static TypeDetails determineGenericSuperType(ClassInfo classInfo, SourceModelBuildingContext buildingContext) {
        if (classInfo.superClassType() == null) {
            return null;
        }
        return JandexTypeSwitchStandard.switchType(classInfo.superClassType(), buildingContext);
    }

    private static List<TypeDetails> determineInterfaces(ClassInfo classInfo, SourceModelBuildingContext buildingContext) {
        List interfaceTypes = classInfo.interfaceTypes();
        if (CollectionHelper.isEmpty((Collection)interfaceTypes)) {
            return Collections.emptyList();
        }
        ArrayList result = CollectionHelper.arrayList((int)interfaceTypes.size());
        for (Type interfaceType : interfaceTypes) {
            TypeDetails switchedType = JandexTypeSwitchStandard.switchType(interfaceType, buildingContext);
            result.add(switchedType);
        }
        return result;
    }

    private static List<TypeVariableDetails> determineTypeParameters(ClassInfo classInfo, JandexClassDetails current, SourceModelBuildingContext buildingContext) {
        List jandexTypeVariables = classInfo.typeParameters();
        if (CollectionHelper.isEmpty((Collection)jandexTypeVariables)) {
            return Collections.emptyList();
        }
        ArrayList result = CollectionHelper.arrayList((int)jandexTypeVariables.size());
        for (TypeVariable jandexTypeVariable : jandexTypeVariables) {
            result.add((TypeVariableDetails)JandexTypeSwitchStandard.switchType((Type)jandexTypeVariable, (ClassDetails)current, buildingContext));
        }
        return result;
    }
}

