/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.jandex.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.Collection;
import java.util.Map;
import org.hibernate.models.IllegalCastException;
import org.hibernate.models.jandex.internal.AbstractAnnotationTarget;
import org.hibernate.models.jandex.internal.JandexTypeSwitchStandard;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;
import org.hibernate.models.spi.RecordComponentDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.TypeDetails;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.RecordComponentInfo;
import org.jboss.jandex.Type;

public class JandexRecordComponentDetails
extends AbstractAnnotationTarget
implements RecordComponentDetails,
MutableMemberDetails {
    private final RecordComponentInfo recordComponentInfo;
    private final TypeDetails type;
    private final ClassDetails declaringType;
    private final boolean isArray;
    private final boolean isPlural;

    public JandexRecordComponentDetails(RecordComponentInfo recordComponentInfo, ClassDetails declaringType, SourceModelBuildingContext buildingContext) {
        super(buildingContext);
        this.recordComponentInfo = recordComponentInfo;
        this.declaringType = declaringType;
        this.type = JandexTypeSwitchStandard.switchType(recordComponentInfo.type(), declaringType, buildingContext);
        this.isArray = recordComponentInfo.type().kind() == Type.Kind.ARRAY;
        this.isPlural = this.isArray || this.type.isImplementor(Collection.class) || this.type.isImplementor(Map.class);
    }

    @Override
    protected AnnotationTarget getJandexAnnotationTarget() {
        return this.recordComponentInfo;
    }

    public String getName() {
        return this.recordComponentInfo.name();
    }

    public TypeDetails getType() {
        return this.type;
    }

    public ClassDetails getDeclaringType() {
        return this.declaringType;
    }

    public boolean isPlural() {
        return this.isPlural;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public int getModifiers() {
        return this.recordComponentInfo.accessor().flags();
    }

    public Member toJavaMember() {
        return null;
    }

    public String toString() {
        return "JandexFieldDetails(" + this.getName() + ")";
    }

    public RecordComponentDetails asRecordComponentDetails() {
        return this;
    }

    public MutableMemberDetails asMemberDetails() {
        return this;
    }

    public FieldDetails asFieldDetails() {
        throw new IllegalCastException("RecordComponentDetails cannot be cast as FieldDetails");
    }

    public MethodDetails asMethodDetails() {
        throw new IllegalCastException("RecordComponentDetails cannot be cast as FieldDetails");
    }

    public <A extends Annotation> AnnotationDescriptor<A> asAnnotationDescriptor() {
        throw new IllegalCastException("RecordComponentDetails cannot be cast to an AnnotationDescriptor");
    }

    public MutableClassDetails asClassDetails() {
        throw new IllegalCastException("RecordComponentDetails cannot be cast to a ClassDetails");
    }
}

