/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.jandex.spi;

import java.util.Map;
import org.hibernate.models.internal.BasicModelBuildingContextImpl;
import org.hibernate.models.jandex.internal.JandexModelBuildingContextImpl;
import org.hibernate.models.spi.ClassLoading;
import org.hibernate.models.spi.RegistryPrimer;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.SourceModelBuildingContextProvider;
import org.jboss.jandex.IndexView;

public class JandexBuildingContextProvider
implements SourceModelBuildingContextProvider {
    public static final String INDEX_PARAM = "hibernate.models.jandex.index";

    public SourceModelBuildingContext produceContext(ClassLoading classLoading, RegistryPrimer registryPrimer, Map<Object, Object> configProperties) {
        IndexView jandexIndex = this.resolveJandexIndex(configProperties);
        if (jandexIndex != null) {
            return new JandexModelBuildingContextImpl(jandexIndex, classLoading, registryPrimer);
        }
        return new BasicModelBuildingContextImpl(classLoading, registryPrimer);
    }

    private IndexView resolveJandexIndex(Map<Object, Object> configProperties) {
        return (IndexView)configProperties.get(INDEX_PARAM);
    }
}

