/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.jandex.internal;

import java.util.function.BiConsumer;
import org.hibernate.models.internal.ArrayTypeDescriptor;
import org.hibernate.models.internal.jdk.JdkBuilders;
import org.hibernate.models.internal.util.PrimitiveTypeHelper;
import org.hibernate.models.internal.util.StringHelper;
import org.hibernate.models.jandex.internal.JandexClassDetails;
import org.hibernate.models.jandex.internal.JandexMethodDetails;
import org.hibernate.models.jandex.internal.JandexTypeSwitchStandard;
import org.hibernate.models.jandex.internal.values.ArrayValueConverter;
import org.hibernate.models.jandex.internal.values.ArrayValueExtractor;
import org.hibernate.models.jandex.internal.values.BooleanValueConverter;
import org.hibernate.models.jandex.internal.values.BooleanValueExtractor;
import org.hibernate.models.jandex.internal.values.ByteValueConverter;
import org.hibernate.models.jandex.internal.values.ByteValueExtractor;
import org.hibernate.models.jandex.internal.values.CharacterValueConverter;
import org.hibernate.models.jandex.internal.values.CharacterValueExtractor;
import org.hibernate.models.jandex.internal.values.ClassValueConverter;
import org.hibernate.models.jandex.internal.values.ClassValueExtractor;
import org.hibernate.models.jandex.internal.values.DoubleValueConverter;
import org.hibernate.models.jandex.internal.values.DoubleValueExtractor;
import org.hibernate.models.jandex.internal.values.EnumValueConverter;
import org.hibernate.models.jandex.internal.values.EnumValueExtractor;
import org.hibernate.models.jandex.internal.values.FloatValueConverter;
import org.hibernate.models.jandex.internal.values.FloatValueExtractor;
import org.hibernate.models.jandex.internal.values.IntegerValueConverter;
import org.hibernate.models.jandex.internal.values.IntegerValueExtractor;
import org.hibernate.models.jandex.internal.values.JandexNestedValueConverter;
import org.hibernate.models.jandex.internal.values.JandexNestedValueExtractor;
import org.hibernate.models.jandex.internal.values.LongValueConverter;
import org.hibernate.models.jandex.internal.values.LongValueExtractor;
import org.hibernate.models.jandex.internal.values.ShortValueConverter;
import org.hibernate.models.jandex.internal.values.ShortValueExtractor;
import org.hibernate.models.jandex.internal.values.StringValueConverter;
import org.hibernate.models.jandex.internal.values.StringValueExtractor;
import org.hibernate.models.jandex.spi.JandexValueConverter;
import org.hibernate.models.jandex.spi.JandexValueExtractor;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.models.spi.ValueTypeDescriptor;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class JandexBuilders {
    public static ClassDetails buildDetailsFromIndex(String name, IndexView jandexIndex, ModelsContext modelsContext) {
        ClassInfo classInfo;
        if (StringHelper.isEmpty((String)name)) {
            return null;
        }
        if ("void".equals(name)) {
            name = Void.class.getName();
        }
        if ((classInfo = jandexIndex.getClassByName(name)) != null) {
            return new JandexClassDetails(classInfo, modelsContext);
        }
        Class primitiveClass = PrimitiveTypeHelper.resolvePrimitiveClass((String)name);
        if (primitiveClass != null) {
            return JdkBuilders.buildClassDetailsStatic((Class)primitiveClass, (ModelsContext)modelsContext);
        }
        ClassInfo packageInfo = jandexIndex.getClassByName(name + ".package-info");
        if (packageInfo != null) {
            return JdkBuilders.buildClassDetailsStatic((String)(name + ".package-info"), (ModelsContext)modelsContext);
        }
        return null;
    }

    public static JandexMethodDetails buildMethodDetails(MethodInfo method, ClassDetails declaringType, ModelsContext modelsContext) {
        Type returnType;
        if (method.parametersCount() == 0 && (returnType = method.returnType()).kind() != Type.Kind.VOID) {
            String methodName = method.name();
            if (methodName.startsWith("get")) {
                return new JandexMethodDetails(method, MethodDetails.MethodKind.GETTER, JandexTypeSwitchStandard.switchType(returnType, declaringType, modelsContext), declaringType, modelsContext);
            }
            if (JandexBuilders.isBoolean(returnType) && (methodName.startsWith("is") || methodName.startsWith("has") || methodName.startsWith("was"))) {
                return new JandexMethodDetails(method, MethodDetails.MethodKind.GETTER, JandexTypeSwitchStandard.switchType(returnType, declaringType, modelsContext), declaringType, modelsContext);
            }
        }
        if (method.parametersCount() == 1 && method.returnType().kind() == Type.Kind.VOID && method.name().startsWith("set")) {
            return new JandexMethodDetails(method, MethodDetails.MethodKind.SETTER, JandexTypeSwitchStandard.switchType(method.parameterType(0), declaringType, modelsContext), declaringType, modelsContext);
        }
        return new JandexMethodDetails(method, MethodDetails.MethodKind.OTHER, null, declaringType, modelsContext);
    }

    private static boolean isBoolean(Type type) {
        if (type.kind() == Type.Kind.PRIMITIVE) {
            return type.name().toString().equals("boolean");
        }
        return type.name().toString().equals("java.lang.Boolean");
    }

    public static <V> JandexValueConverter<V> buildValueHandlersReturnConverter(ValueTypeDescriptor<V> valueTypeDescriptor, BiConsumer<ValueTypeDescriptor<V>, JandexValueConverter<V>> converterCollector, BiConsumer<ValueTypeDescriptor<V>, JandexValueExtractor<V>> extractorCollector, ModelsContext modelsContext) {
        if (valueTypeDescriptor.getValueType().isArray()) {
            ValueTypeDescriptor elementTypeDescriptor = ((ArrayTypeDescriptor)valueTypeDescriptor).getElementTypeDescriptor();
            ArrayValueConverter valueConverter = new ArrayValueConverter(elementTypeDescriptor);
            ArrayValueExtractor valueExtractor = new ArrayValueExtractor(valueConverter);
            converterCollector.accept(valueTypeDescriptor, valueConverter);
            extractorCollector.accept(valueTypeDescriptor, valueExtractor);
            return valueConverter;
        }
        if (JandexBuilders.isBoolean(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, BooleanValueConverter.JANDEX_BOOLEAN_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, BooleanValueExtractor.JANDEX_BOOLEAN_EXTRACTOR);
            return BooleanValueConverter.JANDEX_BOOLEAN_VALUE_WRAPPER;
        }
        if (JandexBuilders.isByte(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, ByteValueConverter.JANDEX_BYTE_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, ByteValueExtractor.JANDEX_BYTE_EXTRACTOR);
            return ByteValueConverter.JANDEX_BYTE_VALUE_WRAPPER;
        }
        if (JandexBuilders.isChar(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, CharacterValueConverter.JANDEX_CHARACTER_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, CharacterValueExtractor.JANDEX_CHARACTER_EXTRACTOR);
            return CharacterValueConverter.JANDEX_CHARACTER_VALUE_WRAPPER;
        }
        if (JandexBuilders.isDouble(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, DoubleValueConverter.JANDEX_DOUBLE_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, DoubleValueExtractor.JANDEX_DOUBLE_EXTRACTOR);
            return DoubleValueConverter.JANDEX_DOUBLE_VALUE_WRAPPER;
        }
        if (JandexBuilders.isFloat(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, FloatValueConverter.JANDEX_FLOAT_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, FloatValueExtractor.JANDEX_FLOAT_EXTRACTOR);
            return FloatValueConverter.JANDEX_FLOAT_VALUE_WRAPPER;
        }
        if (JandexBuilders.isInt(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, IntegerValueConverter.JANDEX_INTEGER_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, IntegerValueExtractor.JANDEX_INTEGER_EXTRACTOR);
            return IntegerValueConverter.JANDEX_INTEGER_VALUE_WRAPPER;
        }
        if (JandexBuilders.isLong(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, LongValueConverter.JANDEX_LONG_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, LongValueExtractor.JANDEX_LONG_EXTRACTOR);
            return LongValueConverter.JANDEX_LONG_VALUE_WRAPPER;
        }
        if (JandexBuilders.isShort(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, ShortValueConverter.JANDEX_SHORT_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, ShortValueExtractor.JANDEX_SHORT_EXTRACTOR);
            return ShortValueConverter.JANDEX_SHORT_VALUE_WRAPPER;
        }
        if (valueTypeDescriptor.getValueType() == String.class) {
            converterCollector.accept(valueTypeDescriptor, StringValueConverter.JANDEX_STRING_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, StringValueExtractor.JANDEX_STRING_EXTRACTOR);
            return StringValueConverter.JANDEX_STRING_VALUE_WRAPPER;
        }
        if (valueTypeDescriptor.getValueType().isAnnotation()) {
            AnnotationDescriptor annotationDescriptor = modelsContext.getAnnotationDescriptorRegistry().getDescriptor(valueTypeDescriptor.getValueType());
            JandexNestedValueConverter jandexNestedValueConverter = new JandexNestedValueConverter(annotationDescriptor);
            JandexNestedValueExtractor jandexNestedValueExtractor = new JandexNestedValueExtractor(jandexNestedValueConverter);
            converterCollector.accept(valueTypeDescriptor, jandexNestedValueConverter);
            extractorCollector.accept(valueTypeDescriptor, jandexNestedValueExtractor);
            return jandexNestedValueConverter;
        }
        if (valueTypeDescriptor.getValueType().isEnum()) {
            EnumValueConverter converter = new EnumValueConverter(valueTypeDescriptor.getValueType());
            converterCollector.accept(valueTypeDescriptor, converter);
            extractorCollector.accept(valueTypeDescriptor, new EnumValueExtractor(converter));
            return converter;
        }
        if (valueTypeDescriptor.getValueType() == Class.class) {
            converterCollector.accept(valueTypeDescriptor, ClassValueConverter.JANDEX_CLASS_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, ClassValueExtractor.JANDEX_CLASS_EXTRACTOR);
            return ClassValueConverter.JANDEX_CLASS_VALUE_WRAPPER;
        }
        throw new UnsupportedOperationException("Unhandled value type : " + String.valueOf(valueTypeDescriptor));
    }

    public static <V> JandexValueExtractor<V> buildValueHandlersReturnExtractor(ValueTypeDescriptor<V> valueTypeDescriptor, BiConsumer<ValueTypeDescriptor<V>, JandexValueConverter<V>> converterCollector, BiConsumer<ValueTypeDescriptor<V>, JandexValueExtractor<V>> extractorCollector, ModelsContext modelsContext) {
        if (valueTypeDescriptor.getValueType().isArray()) {
            ValueTypeDescriptor elementTypeDescriptor = ((ArrayTypeDescriptor)valueTypeDescriptor).getElementTypeDescriptor();
            ArrayValueConverter valueConverter = new ArrayValueConverter(elementTypeDescriptor);
            ArrayValueExtractor valueExtractor = new ArrayValueExtractor(valueConverter);
            converterCollector.accept(valueTypeDescriptor, valueConverter);
            extractorCollector.accept(valueTypeDescriptor, valueExtractor);
            return valueExtractor;
        }
        if (JandexBuilders.isBoolean(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, BooleanValueConverter.JANDEX_BOOLEAN_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, BooleanValueExtractor.JANDEX_BOOLEAN_EXTRACTOR);
            return BooleanValueExtractor.JANDEX_BOOLEAN_EXTRACTOR;
        }
        if (JandexBuilders.isByte(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, ByteValueConverter.JANDEX_BYTE_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, ByteValueExtractor.JANDEX_BYTE_EXTRACTOR);
            return ByteValueExtractor.JANDEX_BYTE_EXTRACTOR;
        }
        if (JandexBuilders.isChar(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, CharacterValueConverter.JANDEX_CHARACTER_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, CharacterValueExtractor.JANDEX_CHARACTER_EXTRACTOR);
            return CharacterValueExtractor.JANDEX_CHARACTER_EXTRACTOR;
        }
        if (JandexBuilders.isDouble(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, DoubleValueConverter.JANDEX_DOUBLE_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, DoubleValueExtractor.JANDEX_DOUBLE_EXTRACTOR);
            return DoubleValueExtractor.JANDEX_DOUBLE_EXTRACTOR;
        }
        if (JandexBuilders.isFloat(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, FloatValueConverter.JANDEX_FLOAT_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, FloatValueExtractor.JANDEX_FLOAT_EXTRACTOR);
            return FloatValueExtractor.JANDEX_FLOAT_EXTRACTOR;
        }
        if (JandexBuilders.isInt(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, IntegerValueConverter.JANDEX_INTEGER_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, IntegerValueExtractor.JANDEX_INTEGER_EXTRACTOR);
            return IntegerValueExtractor.JANDEX_INTEGER_EXTRACTOR;
        }
        if (JandexBuilders.isLong(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, LongValueConverter.JANDEX_LONG_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, LongValueExtractor.JANDEX_LONG_EXTRACTOR);
            return LongValueExtractor.JANDEX_LONG_EXTRACTOR;
        }
        if (JandexBuilders.isShort(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, ShortValueConverter.JANDEX_SHORT_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, ShortValueExtractor.JANDEX_SHORT_EXTRACTOR);
            return ShortValueExtractor.JANDEX_SHORT_EXTRACTOR;
        }
        if (valueTypeDescriptor.getValueType() == String.class) {
            converterCollector.accept(valueTypeDescriptor, StringValueConverter.JANDEX_STRING_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, StringValueExtractor.JANDEX_STRING_EXTRACTOR);
            return StringValueExtractor.JANDEX_STRING_EXTRACTOR;
        }
        if (valueTypeDescriptor.getValueType().isAnnotation()) {
            AnnotationDescriptor annotationDescriptor = modelsContext.getAnnotationDescriptorRegistry().getDescriptor(valueTypeDescriptor.getValueType());
            JandexNestedValueConverter jandexNestedValueConverter = new JandexNestedValueConverter(annotationDescriptor);
            JandexNestedValueExtractor jandexNestedValueExtractor = new JandexNestedValueExtractor(jandexNestedValueConverter);
            converterCollector.accept(valueTypeDescriptor, jandexNestedValueConverter);
            extractorCollector.accept(valueTypeDescriptor, jandexNestedValueExtractor);
            return jandexNestedValueExtractor;
        }
        if (valueTypeDescriptor.getValueType().isEnum()) {
            EnumValueConverter converter = new EnumValueConverter(valueTypeDescriptor.getValueType());
            EnumValueExtractor extractor = new EnumValueExtractor(converter);
            converterCollector.accept(valueTypeDescriptor, converter);
            extractorCollector.accept(valueTypeDescriptor, extractor);
            return extractor;
        }
        if (valueTypeDescriptor.getValueType() == Class.class) {
            converterCollector.accept(valueTypeDescriptor, ClassValueConverter.JANDEX_CLASS_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, ClassValueExtractor.JANDEX_CLASS_EXTRACTOR);
            return ClassValueExtractor.JANDEX_CLASS_EXTRACTOR;
        }
        throw new UnsupportedOperationException("Unhandled value type : " + String.valueOf(valueTypeDescriptor));
    }

    private static <V> boolean isBoolean(ValueTypeDescriptor<V> valueTypeDescriptor) {
        return valueTypeDescriptor.getValueType() == Boolean.TYPE || valueTypeDescriptor.getValueType() == Boolean.class;
    }

    private static <V> boolean isByte(ValueTypeDescriptor<V> valueTypeDescriptor) {
        return valueTypeDescriptor.getValueType() == Byte.TYPE || valueTypeDescriptor.getValueType() == Byte.class;
    }

    private static <V> boolean isChar(ValueTypeDescriptor<V> valueTypeDescriptor) {
        return valueTypeDescriptor.getValueType() == Character.TYPE || valueTypeDescriptor.getValueType() == Character.class;
    }

    private static <V> boolean isDouble(ValueTypeDescriptor<V> valueTypeDescriptor) {
        return valueTypeDescriptor.getValueType() == Double.TYPE || valueTypeDescriptor.getValueType() == Double.class;
    }

    private static <V> boolean isFloat(ValueTypeDescriptor<V> valueTypeDescriptor) {
        return valueTypeDescriptor.getValueType() == Float.TYPE || valueTypeDescriptor.getValueType() == Float.class;
    }

    private static <V> boolean isShort(ValueTypeDescriptor<V> valueTypeDescriptor) {
        return valueTypeDescriptor.getValueType() == Short.TYPE || valueTypeDescriptor.getValueType() == Short.class;
    }

    private static <V> boolean isInt(ValueTypeDescriptor<V> valueTypeDescriptor) {
        return valueTypeDescriptor.getValueType() == Integer.TYPE || valueTypeDescriptor.getValueType() == Integer.class;
    }

    private static <V> boolean isLong(ValueTypeDescriptor<V> valueTypeDescriptor) {
        return valueTypeDescriptor.getValueType() == Long.TYPE || valueTypeDescriptor.getValueType() == Long.class;
    }
}

