/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.jandex.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import org.hibernate.models.IllegalCastException;
import org.hibernate.models.ModelsException;
import org.hibernate.models.internal.AnnotationTargetSupport;
import org.hibernate.models.jandex.internal.AbstractAnnotationTarget;
import org.hibernate.models.jandex.internal.JandexTypeSwitchStandard;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassLoading;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;
import org.hibernate.models.spi.RecordComponentDetails;
import org.hibernate.models.spi.TypeDetails;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Type;

public class JandexFieldDetails
extends AbstractAnnotationTarget
implements FieldDetails,
MutableMemberDetails,
AnnotationTargetSupport {
    private final FieldInfo fieldInfo;
    private final TypeDetails type;
    private final ClassDetails declaringType;
    private final boolean isArray;
    private final boolean isPlural;
    private Field underlyingMember;

    public JandexFieldDetails(FieldInfo fieldInfo, ClassDetails declaringType, ModelsContext modelsContext) {
        super(modelsContext);
        this.fieldInfo = fieldInfo;
        this.declaringType = declaringType;
        this.type = JandexTypeSwitchStandard.switchType(fieldInfo.type(), declaringType, modelsContext);
        this.isArray = fieldInfo.type().kind() == Type.Kind.ARRAY;
        this.isPlural = this.isArray || this.type.isImplementor(Collection.class) || this.type.isImplementor(Map.class);
    }

    @Override
    protected AnnotationTarget getJandexAnnotationTarget() {
        return this.fieldInfo;
    }

    public String getName() {
        return this.fieldInfo.name();
    }

    public TypeDetails getType() {
        return this.type;
    }

    public ClassDetails getDeclaringType() {
        return this.declaringType;
    }

    public boolean isPlural() {
        return this.isPlural;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public int getModifiers() {
        return this.fieldInfo.flags();
    }

    public Field toJavaMember() {
        if (this.underlyingMember == null) {
            Class declaringJavaClass = this.declaringType.toJavaClass();
            this.underlyingMember = this.resolveJavaMember(declaringJavaClass);
        }
        return this.underlyingMember;
    }

    public Field toJavaMember(Class<?> declaringClass, ClassLoading classLoading, ModelsContext modelContext) {
        this.type.determineRawClass().toJavaClass(classLoading, modelContext);
        return this.resolveJavaMember(declaringClass);
    }

    private Field resolveJavaMember(Class<?> declaringJavaClass) {
        try {
            return declaringJavaClass.getField(this.fieldInfo.name());
        }
        catch (NoSuchFieldException e) {
            throw new ModelsException(String.format("Unable to locate field `%s` on %s", this.declaringType.getName(), this.fieldInfo.name()), (Throwable)e);
        }
    }

    public String toString() {
        return "JandexFieldDetails(" + this.getName() + ")";
    }

    public FieldDetails asFieldDetails() {
        return this;
    }

    public MutableMemberDetails asMemberDetails() {
        return this;
    }

    public MethodDetails asMethodDetails() {
        throw new IllegalCastException("FieldDetails cannot be cast as MethodDetails");
    }

    public RecordComponentDetails asRecordComponentDetails() {
        throw new IllegalCastException("FieldDetails cannot be cast as RecordComponentDetails");
    }

    public <A extends Annotation> AnnotationDescriptor<A> asAnnotationDescriptor() {
        throw new IllegalCastException("FieldDetails cannot be cast to an AnnotationDescriptor");
    }

    public MutableClassDetails asClassDetails() {
        throw new IllegalCastException("FieldDetails cannot be cast to a ClassDetails");
    }
}

