/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.jandex.internal;

import java.util.Map;
import org.hibernate.models.internal.BasicModelsContextImpl;
import org.hibernate.models.jandex.internal.JandexModelsContextImpl;
import org.hibernate.models.spi.ClassLoading;
import org.hibernate.models.spi.ModelsConfiguration;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.models.spi.ModelsContextProvider;
import org.hibernate.models.spi.RegistryPrimer;
import org.jboss.jandex.IndexView;

public class JandexModelsContextProvider
implements ModelsContextProvider {
    public static final JandexModelsContextProvider JANDEX_PROVIDER = new JandexModelsContextProvider();

    public ModelsContext produceContext(ClassLoading classLoading, RegistryPrimer registryPrimer, Map<Object, Object> configProperties) {
        IndexView jandexIndex = this.resolveJandexIndex(configProperties);
        boolean trackImplementors = ModelsConfiguration.shouldTrackImplementors(configProperties);
        if (jandexIndex != null) {
            return new JandexModelsContextImpl(jandexIndex, trackImplementors, classLoading, registryPrimer);
        }
        return new BasicModelsContextImpl(classLoading, trackImplementors, registryPrimer);
    }

    private IndexView resolveJandexIndex(Map<Object, Object> configProperties) {
        return (IndexView)configProperties.get("hibernate.models.jandex.index");
    }
}

