/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsBuilder;
import org.hibernate.models.spi.ClassDetailsRegistry;

public abstract class AbstractClassDetailsRegistry
implements ClassDetailsRegistry {
    protected final Map<String, ClassDetails> classDetailsMap;
    protected final Map<String, List<ClassDetails>> subTypeClassDetailsMap;

    protected AbstractClassDetailsRegistry() {
        this(new ConcurrentHashMap<String, ClassDetails>(), new ConcurrentHashMap<String, List<ClassDetails>>());
    }

    protected AbstractClassDetailsRegistry(Map<String, ClassDetails> classDetailsMap, Map<String, List<ClassDetails>> subTypeClassDetailsMap) {
        this.classDetailsMap = classDetailsMap;
        this.subTypeClassDetailsMap = subTypeClassDetailsMap;
    }

    @Override
    public List<ClassDetails> getDirectSubTypes(String superTypeName) {
        return this.subTypeClassDetailsMap.get(superTypeName);
    }

    @Override
    public void forEachDirectSubType(String superTypeName, ClassDetailsRegistry.ClassDetailsConsumer consumer) {
        List<ClassDetails> directSubTypes = this.getDirectSubTypes(superTypeName);
        if (directSubTypes == null) {
            return;
        }
        for (int i = 0; i < directSubTypes.size(); ++i) {
            consumer.consume(directSubTypes.get(i));
        }
    }

    @Override
    public ClassDetails findClassDetails(String name) {
        return this.classDetailsMap.get(name);
    }

    @Override
    public void forEachClassDetails(ClassDetailsRegistry.ClassDetailsConsumer consumer) {
        for (Map.Entry<String, ClassDetails> entry : this.classDetailsMap.entrySet()) {
            consumer.consume(entry.getValue());
        }
    }

    @Override
    public ClassDetails resolveClassDetails(String name, ClassDetailsBuilder creator) {
        if (name == null) {
            throw new IllegalArgumentException("`name` cannot be null");
        }
        ClassDetails existing = this.classDetailsMap.get(name);
        if (existing != null) {
            return existing;
        }
        return this.createClassDetails(name, creator);
    }

    protected abstract ClassDetails createClassDetails(String var1, ClassDetailsBuilder var2);

    @Override
    public ClassDetails resolveClassDetails(String name, ClassDetailsRegistry.ClassDetailsCreator creator) {
        if (name == null) {
            throw new IllegalArgumentException("`name` cannot be null");
        }
        if ("void".equals(name)) {
            return null;
        }
        ClassDetails existing = this.classDetailsMap.get(name);
        if (existing != null) {
            return existing;
        }
        return this.createClassDetails(name, creator);
    }

    protected abstract ClassDetails createClassDetails(String var1, ClassDetailsRegistry.ClassDetailsCreator var2);
}

