/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.annotation.Target;
import java.util.EnumSet;
import org.hibernate.models.internal.jdk.AnnotationDescriptorOrmImpl;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationTarget;

public class AnnotationHelper {
    private AnnotationHelper() {
    }

    public static <A extends Annotation> boolean isInherited(Class<A> annotationType) {
        return annotationType.isAnnotationPresent(Inherited.class);
    }

    public static <A extends Annotation> EnumSet<AnnotationTarget.Kind> extractTargets(Class<A> annotationType) {
        return AnnotationTarget.Kind.from(annotationType.getAnnotation(Target.class));
    }

    public static <A extends Annotation> AnnotationDescriptor<A> createOrmDescriptor(Class<A> javaType) {
        return AnnotationHelper.createOrmDescriptor(javaType, null);
    }

    public static <A extends Annotation> AnnotationDescriptor<A> createOrmDescriptor(Class<A> javaType, AnnotationDescriptor<?> repeatableContainer) {
        assert (javaType != null);
        return new AnnotationDescriptorOrmImpl<A>(javaType, repeatableContainer);
    }
}

