/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.models.internal.AnnotationUsageHelper;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationDescriptorRegistry;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.MutableAnnotationTarget;
import org.hibernate.models.spi.SourceModelBuildingContext;

public interface AnnotationTargetSupport
extends MutableAnnotationTarget {
    public SourceModelBuildingContext getBuildingContext();

    public Map<Class<? extends Annotation>, AnnotationUsage<? extends Annotation>> getUsageMap();

    @Override
    default public Collection<AnnotationUsage<?>> getAllAnnotationUsages() {
        return this.getUsageMap().values();
    }

    @Override
    default public <A extends Annotation> boolean hasAnnotationUsage(Class<A> type) {
        return this.getUsageMap().containsKey(type);
    }

    @Override
    default public <A extends Annotation> boolean hasRepeatableAnnotationUsage(Class<A> type) {
        boolean containsDirectly = this.getUsageMap().containsKey(type);
        if (containsDirectly) {
            return true;
        }
        AnnotationDescriptorRegistry descriptorRegistry = this.getBuildingContext().getAnnotationDescriptorRegistry();
        AnnotationDescriptor<A> descriptor = descriptorRegistry.getDescriptor(type);
        if (descriptor.isRepeatable()) {
            return this.getUsageMap().containsKey(descriptor.getRepeatableContainer().getAnnotationType());
        }
        return false;
    }

    @Override
    default public <A extends Annotation> AnnotationUsage<A> getAnnotationUsage(AnnotationDescriptor<A> descriptor) {
        return AnnotationUsageHelper.getUsage(descriptor, this.getUsageMap());
    }

    @Override
    default public <A extends Annotation> AnnotationUsage<A> getAnnotationUsage(Class<A> annotationType) {
        return this.getAnnotationUsage(this.getBuildingContext().getAnnotationDescriptorRegistry().getDescriptor(annotationType));
    }

    @Override
    default public <A extends Annotation> AnnotationUsage<A> locateAnnotationUsage(Class<A> annotationType) {
        AnnotationUsage<A> localUsage = this.getAnnotationUsage(annotationType);
        if (localUsage != null) {
            return localUsage;
        }
        Map<Class<? extends Annotation>, AnnotationUsage<? extends Annotation>> localUsageMap = this.getUsageMap();
        for (Map.Entry<Class<? extends Annotation>, AnnotationUsage<? extends Annotation>> usageEntry : localUsageMap.entrySet()) {
            AnnotationUsage<A> metaAnnotation;
            AnnotationUsage<? extends Annotation> usage = usageEntry.getValue();
            if (annotationType.equals(usage.getAnnotationType()) || (metaAnnotation = usage.getAnnotationDescriptor().getAnnotationUsage(annotationType)) == null) continue;
            return metaAnnotation;
        }
        return null;
    }

    @Override
    default public <A extends Annotation> List<AnnotationUsage<A>> getRepeatedAnnotationUsages(AnnotationDescriptor<A> type) {
        return AnnotationUsageHelper.getRepeatedUsages(type, this.getUsageMap());
    }

    @Override
    default public <A extends Annotation> List<AnnotationUsage<A>> getRepeatedAnnotationUsages(Class<A> type) {
        return this.getRepeatedAnnotationUsages(this.getBuildingContext().getAnnotationDescriptorRegistry().getDescriptor(type));
    }

    @Override
    default public <X extends Annotation> void forEachAnnotationUsage(Class<X> type, Consumer<AnnotationUsage<X>> consumer) {
        this.forEachAnnotationUsage(this.getBuildingContext().getAnnotationDescriptorRegistry().getDescriptor(type), consumer);
    }

    @Override
    default public <A extends Annotation> List<AnnotationUsage<? extends Annotation>> getMetaAnnotated(Class<A> metaAnnotationType) {
        ArrayList<AnnotationUsage<? extends Annotation>> usages = new ArrayList<AnnotationUsage<? extends Annotation>>();
        this.forAllAnnotationUsages(usage -> {
            Object metaUsage = usage.getAnnotationType().getAnnotation(metaAnnotationType);
            if (metaUsage != null) {
                usages.add((AnnotationUsage<? extends Annotation>)usage);
            }
        });
        return usages;
    }

    @Override
    default public <X extends Annotation> AnnotationUsage<X> getNamedAnnotationUsage(Class<X> type, String matchName) {
        return this.getNamedAnnotationUsage(this.getBuildingContext().getAnnotationDescriptorRegistry().getDescriptor(type), matchName);
    }

    @Override
    default public <X extends Annotation> AnnotationUsage<X> getNamedAnnotationUsage(AnnotationDescriptor<X> type, String matchName, String attributeToMatch) {
        return AnnotationUsageHelper.getNamedUsage(type, matchName, attributeToMatch, this.getUsageMap());
    }

    @Override
    default public <X extends Annotation> AnnotationUsage<X> getNamedAnnotationUsage(Class<X> type, String matchName, String attributeToMatch) {
        return this.getNamedAnnotationUsage(this.getBuildingContext().getAnnotationDescriptorRegistry().getDescriptor(type), matchName, attributeToMatch);
    }
}

