/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.util.ArrayList;
import org.hibernate.models.UnknownClassException;
import org.hibernate.models.internal.AbstractClassDetailsRegistry;
import org.hibernate.models.internal.ClassDetailsRegistryImmutable;
import org.hibernate.models.internal.ModelsClassLogging;
import org.hibernate.models.internal.jandex.JandexBuilders;
import org.hibernate.models.internal.jdk.JdkBuilders;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsBuilder;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.IndexView;

public class ClassDetailsRegistryStandard
extends AbstractClassDetailsRegistry {
    private final StandardClassDetailsBuilder standardClassDetailsBuilder;
    private final SourceModelBuildingContext context;

    public ClassDetailsRegistryStandard(SourceModelBuildingContext context) {
        this.context = context;
        this.standardClassDetailsBuilder = new StandardClassDetailsBuilder(JdkBuilders.DEFAULT_BUILDER, context.getJandexIndex());
        this.classDetailsMap.put(ClassDetails.VOID_CLASS_DETAILS.getClassName(), ClassDetails.VOID_CLASS_DETAILS);
        this.classDetailsMap.put(ClassDetails.VOID_OBJECT_CLASS_DETAILS.getClassName(), ClassDetails.VOID_OBJECT_CLASS_DETAILS);
        this.classDetailsMap.put(ClassDetails.OBJECT_CLASS_DETAILS.getClassName(), ClassDetails.OBJECT_CLASS_DETAILS);
    }

    @Override
    public void addClassDetails(ClassDetails classDetails) {
        this.addClassDetails(classDetails.getClassName(), classDetails);
    }

    @Override
    public void addClassDetails(String name, ClassDetails classDetails) {
        this.classDetailsMap.put(name, classDetails);
        if (classDetails.getSuperClass() != null) {
            ArrayList<ClassDetails> subTypes = (ArrayList<ClassDetails>)this.subTypeClassDetailsMap.get(classDetails.getSuperClass().getName());
            if (subTypes == null) {
                subTypes = new ArrayList<ClassDetails>();
                this.subTypeClassDetailsMap.put(classDetails.getSuperClass().getName(), subTypes);
            }
            subTypes.add(classDetails);
        }
    }

    @Override
    public ClassDetails resolveClassDetails(String name) {
        return this.resolveClassDetails(name, this.standardClassDetailsBuilder);
    }

    @Override
    protected ClassDetails createClassDetails(String name, ClassDetailsBuilder creator) {
        try {
            ClassDetails created = creator.buildClassDetails(name, this.context);
            this.addClassDetails(name, created);
            return created;
        }
        catch (UnknownClassException e) {
            try {
                return creator.buildClassDetails(name + ".package-info", this.context);
            }
            catch (UnknownClassException noPackage) {
                throw e;
            }
        }
    }

    @Override
    protected ClassDetails createClassDetails(String name, ClassDetailsRegistry.ClassDetailsCreator creator) {
        try {
            ClassDetails created = creator.createClassDetails(name);
            this.addClassDetails(name, created);
            return created;
        }
        catch (UnknownClassException e) {
            try {
                return creator.createClassDetails(name + ".package-info");
            }
            catch (UnknownClassException noPackage) {
                throw e;
            }
        }
    }

    @Override
    public ClassDetailsRegistry makeImmutableCopy() {
        return new ClassDetailsRegistryImmutable(this.classDetailsMap, this.subTypeClassDetailsMap);
    }

    private static class StandardClassDetailsBuilder
    implements ClassDetailsBuilder {
        private final boolean tryJandex;
        private final ClassDetailsBuilder fallbackClassDetailsBuilder;

        public StandardClassDetailsBuilder(ClassDetailsBuilder fallbackClassDetailsBuilder, IndexView jandexIndex) {
            this.fallbackClassDetailsBuilder = fallbackClassDetailsBuilder;
            boolean bl = this.tryJandex = jandexIndex != null;
            if (this.tryJandex) {
                ModelsClassLogging.MODELS_CLASS_LOGGER.debug((Object)"Starting StandardClassDetailsBuilder with Jandex support");
            } else {
                ModelsClassLogging.MODELS_CLASS_LOGGER.debug((Object)"Starting StandardClassDetailsBuilder without Jandex support");
            }
        }

        @Override
        public ClassDetails buildClassDetails(String name, SourceModelBuildingContext buildingContext) {
            ModelsClassLogging.MODELS_CLASS_LOGGER.tracef("Building ClassDetails - %s", (Object)name);
            if (this.tryJandex) {
                try {
                    return JandexBuilders.buildClassDetailsStatic(name, buildingContext);
                }
                catch (UnknownClassException unknownClassException) {
                    // empty catch block
                }
            }
            return this.fallbackClassDetailsBuilder.buildClassDetails(name, buildingContext);
        }
    }
}

