/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.util.List;
import org.hibernate.models.internal.IsBoundTypeSwitch;
import org.hibernate.models.spi.ArrayTypeDetails;
import org.hibernate.models.spi.ClassTypeDetails;
import org.hibernate.models.spi.ParameterizedTypeDetails;
import org.hibernate.models.spi.PrimitiveTypeDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeDetailsSwitch;
import org.hibernate.models.spi.TypeVariableDetails;
import org.hibernate.models.spi.TypeVariableReferenceDetails;
import org.hibernate.models.spi.VoidTypeDetails;
import org.hibernate.models.spi.WildcardTypeDetails;

public class IsResolvedTypeSwitch
implements TypeDetailsSwitch<Boolean> {
    public static final IsResolvedTypeSwitch IS_RESOLVED_SWITCH = new IsResolvedTypeSwitch();

    private static boolean isBound(TypeDetails typeDetails, SourceModelBuildingContext buildingContext) {
        return TypeDetailsSwitch.switchType(typeDetails, IsBoundTypeSwitch.IS_BOUND_SWITCH, buildingContext);
    }

    @Override
    public Boolean caseClass(ClassTypeDetails classType, SourceModelBuildingContext buildingContext) {
        return true;
    }

    @Override
    public Boolean casePrimitive(PrimitiveTypeDetails primitiveType, SourceModelBuildingContext buildingContext) {
        return true;
    }

    @Override
    public Boolean caseVoid(VoidTypeDetails voidType, SourceModelBuildingContext buildingContext) {
        return true;
    }

    @Override
    public Boolean caseArrayType(ArrayTypeDetails arrayType, SourceModelBuildingContext buildingContext) {
        return IsResolvedTypeSwitch.isBound(arrayType.getConstituentType(), buildingContext);
    }

    @Override
    public Boolean caseParameterizedType(ParameterizedTypeDetails parameterizedType, SourceModelBuildingContext buildingContext) {
        List<TypeDetails> typeArgs = parameterizedType.getArguments();
        for (TypeDetails arg : typeArgs) {
            if (arg.isResolved()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean caseWildcardType(WildcardTypeDetails wildcardType, SourceModelBuildingContext buildingContext) {
        TypeDetails bound = wildcardType.getBound();
        return bound != null && (bound.getTypeKind() == TypeDetails.Kind.CLASS || IsResolvedTypeSwitch.isBound(bound, buildingContext));
    }

    @Override
    public Boolean caseTypeVariable(TypeVariableDetails typeVariable, SourceModelBuildingContext buildingContext) {
        for (TypeDetails bound : typeVariable.getBounds()) {
            if (IsResolvedTypeSwitch.isBound(bound, buildingContext)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean caseTypeVariableReference(TypeVariableReferenceDetails typeVariableReference, SourceModelBuildingContext buildingContext) {
        return true;
    }

    @Override
    public Boolean defaultCase(TypeDetails type, SourceModelBuildingContext buildingContext) {
        throw new UnsupportedOperationException("Unexpected attribute type - " + type);
    }
}

