/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.lang.annotation.Annotation;
import java.util.Locale;
import org.hibernate.models.internal.AbstractTypeDescriptor;
import org.hibernate.models.internal.jandex.NestedValueExtractor;
import org.hibernate.models.internal.jandex.NestedValueWrapper;
import org.hibernate.models.internal.jdk.AnnotationDescriptorImpl;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.ValueExtractor;
import org.hibernate.models.spi.ValueWrapper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class NestedTypeDescriptor<A extends Annotation>
extends AbstractTypeDescriptor<AnnotationUsage<A>> {
    private final Class<A> annotationType;
    private AnnotationDescriptor<A> descriptor;
    private NestedValueWrapper<A> jandexWrapper;
    private NestedValueExtractor<A> jandexExtractor;
    private org.hibernate.models.internal.jdk.NestedValueWrapper<A> jdkWrapper;
    private org.hibernate.models.internal.jdk.NestedValueExtractor<A> jdkExtractor;

    public NestedTypeDescriptor(Class<A> annotationType) {
        this.annotationType = annotationType;
    }

    @Override
    public Class<AnnotationUsage<A>> getWrappedValueType() {
        return AnnotationUsage.class;
    }

    private AnnotationDescriptor<A> resolveDescriptor(SourceModelBuildingContext context) {
        if (this.descriptor == null) {
            this.descriptor = context.getAnnotationDescriptorRegistry().resolveDescriptor(this.annotationType, t -> new AnnotationDescriptorImpl<A>(this.annotationType, context));
        }
        return this.descriptor;
    }

    @Override
    public ValueWrapper<AnnotationUsage<A>, AnnotationValue> createJandexWrapper(SourceModelBuildingContext buildingContext) {
        return this.resolveJandexWrapper(buildingContext);
    }

    public NestedValueWrapper<A> resolveJandexWrapper(SourceModelBuildingContext buildingContext) {
        if (this.jandexWrapper == null) {
            this.jandexWrapper = new NestedValueWrapper<A>(this.resolveDescriptor(buildingContext));
        }
        return this.jandexWrapper;
    }

    @Override
    public ValueExtractor<AnnotationInstance, AnnotationUsage<A>> createJandexExtractor(SourceModelBuildingContext buildingContext) {
        return this.resolveJandexExtractor(buildingContext);
    }

    public NestedValueExtractor<A> resolveJandexExtractor(SourceModelBuildingContext buildingContext) {
        if (this.jandexExtractor == null) {
            this.jandexExtractor = new NestedValueExtractor<A>(this.resolveJandexWrapper(buildingContext));
        }
        return this.jandexExtractor;
    }

    @Override
    public ValueWrapper<AnnotationUsage<A>, ?> createJdkWrapper(SourceModelBuildingContext buildingContext) {
        return this.resolveJdkWrapper(buildingContext);
    }

    public org.hibernate.models.internal.jdk.NestedValueWrapper<A> resolveJdkWrapper(SourceModelBuildingContext buildingContext) {
        if (this.jdkWrapper == null) {
            this.jdkWrapper = new org.hibernate.models.internal.jdk.NestedValueWrapper<A>(this.resolveDescriptor(buildingContext));
        }
        return this.jdkWrapper;
    }

    @Override
    public ValueExtractor<Annotation, AnnotationUsage<A>> createJdkExtractor(SourceModelBuildingContext buildingContext) {
        return this.resolveJdkExtractor(buildingContext);
    }

    @Override
    public Object unwrap(AnnotationUsage<A> value) {
        return value.toAnnotation();
    }

    public ValueExtractor<Annotation, AnnotationUsage<A>> resolveJdkExtractor(SourceModelBuildingContext buildingContext) {
        if (this.jdkExtractor == null) {
            this.jdkExtractor = new org.hibernate.models.internal.jdk.NestedValueExtractor(this.resolveJdkWrapper(buildingContext));
        }
        return this.jdkExtractor;
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "AttributeTypeDescriptor(%s)", this.descriptor.getAnnotationType().getName());
    }
}

