/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.dynamic;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.models.AnnotationAccessException;
import org.hibernate.models.internal.AnnotationProxy;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.AttributeDescriptor;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.SourceModelContext;

public class DynamicAnnotationUsage<A extends Annotation>
implements MutableAnnotationUsage<A> {
    private final AnnotationDescriptor<A> annotationDescriptor;
    private final AnnotationTarget target;
    private Map<String, Object> values;

    public DynamicAnnotationUsage(AnnotationDescriptor<A> annotationDescriptor, SourceModelContext context) {
        this(annotationDescriptor, null, context);
    }

    public DynamicAnnotationUsage(AnnotationDescriptor<A> annotationDescriptor, AnnotationTarget target, SourceModelContext context) {
        this(annotationDescriptor, target, DynamicAnnotationUsage.extractBaselineValues(annotationDescriptor, target, context));
    }

    private DynamicAnnotationUsage(AnnotationDescriptor<A> annotationDescriptor, AnnotationTarget target, Map<String, Object> values) {
        this.annotationDescriptor = annotationDescriptor;
        this.target = target;
        this.values = values;
    }

    @Override
    public AnnotationDescriptor<A> getAnnotationDescriptor() {
        return this.annotationDescriptor;
    }

    @Override
    public AnnotationTarget getAnnotationTarget() {
        return this.target;
    }

    @Override
    public A toAnnotation() {
        return AnnotationProxy.makeProxy(this.annotationDescriptor, this.values);
    }

    @Override
    public <V> V findAttributeValue(String name) {
        if (this.values != null) {
            return (V)this.values.get(name);
        }
        return null;
    }

    @Override
    public <V> V getAttributeValue(String name) {
        AttributeDescriptor attribute = this.annotationDescriptor.getAttribute(name);
        return this.findAttributeValue(attribute.getName());
    }

    @Override
    public <V> V setAttributeValue(String name, V value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Null value not allowed for attribute `%s` of annotation `%s`", name, this.getAnnotationType().getName()));
        }
        AttributeDescriptor attribute = this.annotationDescriptor.getAttribute(name);
        if (this.values == null) {
            this.values = new HashMap<String, Object>();
        }
        return (V)this.values.put(attribute.getName(), value);
    }

    private static <A extends Annotation> Map<String, Object> extractBaselineValues(AnnotationDescriptor<A> annotationDescriptor, AnnotationTarget target, SourceModelContext context) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (AttributeDescriptor<?> attribute : annotationDescriptor.getAttributes()) {
            values.put(attribute.getName(), DynamicAnnotationUsage.extractDefaultValue(attribute.getAttributeMethod().getDefaultValue(), target, context));
        }
        return values;
    }

    private static Object extractDefaultValue(Object value, AnnotationTarget target, SourceModelContext context) {
        if (value != null) {
            if (value.getClass().isArray()) {
                return DynamicAnnotationUsage.extractList(value, target, context);
            }
            if (value instanceof Class) {
                Class clazz = (Class)value;
                return context.getClassDetailsRegistry().resolveClassDetails(clazz.getName());
            }
            if (value instanceof Annotation) {
                Annotation annotation = (Annotation)value;
                try {
                    return DynamicAnnotationUsage.extractAnnotation(annotation, target, context);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new AnnotationAccessException("Error accessing default annotation-typed attribute", e);
                }
            }
        }
        return value;
    }

    private static <E> List<Object> extractList(Object value, AnnotationTarget target, SourceModelContext context) {
        Object[] array;
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object element : array = (Object[])value) {
            result.add(DynamicAnnotationUsage.extractDefaultValue(element, target, context));
        }
        return result;
    }

    private static DynamicAnnotationUsage<?> extractAnnotation(Annotation annotation, AnnotationTarget target, SourceModelContext context) throws InvocationTargetException, IllegalAccessException {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        AnnotationDescriptor<? extends Annotation> descriptor = context.getAnnotationDescriptorRegistry().getDescriptor(annotationType);
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (AttributeDescriptor<?> attribute : descriptor.getAttributes()) {
            values.put(attribute.getName(), DynamicAnnotationUsage.extractDefaultValue(attribute.getAttributeMethod().invoke((Object)annotation, new Object[0]), target, context));
        }
        return new DynamicAnnotationUsage<Annotation>(descriptor, target, values);
    }
}

