/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.jandex;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.hibernate.models.internal.jandex.JandexAnnotationUsage;
import org.hibernate.models.internal.util.CollectionHelper;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationDescriptorRegistry;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.AttributeDescriptor;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.ValueExtractor;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;

public class AnnotationUsageBuilder {
    public static final DotName REPEATABLE = DotName.createSimple(Repeatable.class);
    public static final DotName TARGET = DotName.createSimple(Target.class);
    public static final DotName RETENTION = DotName.createSimple(Retention.class);
    public static final DotName DOCUMENTED = DotName.createSimple(Documented.class);

    public static Map<Class<? extends Annotation>, AnnotationUsage<?>> collectUsages(org.jboss.jandex.AnnotationTarget jandexAnnotationTarget, AnnotationTarget target, SourceModelBuildingContext buildingContext) {
        if (jandexAnnotationTarget == null) {
            return Collections.emptyMap();
        }
        HashMap result = new HashMap();
        AnnotationUsageBuilder.processAnnotations(jandexAnnotationTarget.declaredAnnotations(), target, result::put, buildingContext);
        return result;
    }

    public static void processAnnotations(Collection<AnnotationInstance> annotations, AnnotationTarget target, BiConsumer<Class<? extends Annotation>, AnnotationUsage<?>> consumer, SourceModelBuildingContext buildingContext) {
        AnnotationDescriptorRegistry annotationDescriptorRegistry = buildingContext.getAnnotationDescriptorRegistry();
        for (AnnotationInstance annotation : annotations) {
            if (annotation.name().equals((Object)DOCUMENTED) || annotation.name().equals((Object)REPEATABLE) || annotation.name().equals((Object)RETENTION) || annotation.name().equals((Object)TARGET)) continue;
            Class annotationType = buildingContext.getClassLoading().classForName(annotation.name().toString());
            AnnotationDescriptor annotationDescriptor = annotationDescriptorRegistry.getDescriptor(annotationType);
            AnnotationUsage usage = AnnotationUsageBuilder.makeUsage(annotation, annotationDescriptor, target, buildingContext);
            consumer.accept(annotationType, usage);
        }
    }

    public static <A extends Annotation> AnnotationUsage<A> makeUsage(AnnotationInstance annotation, AnnotationDescriptor<A> annotationDescriptor, AnnotationTarget target, SourceModelBuildingContext buildingContext) {
        return new JandexAnnotationUsage<A>(annotation, annotationDescriptor, target, buildingContext);
    }

    public static <A extends Annotation> Map<String, ?> extractAttributeValues(AnnotationInstance annotationInstance, AnnotationDescriptor<A> annotationDescriptor, AnnotationTarget target, SourceModelBuildingContext buildingContext) {
        if (CollectionHelper.isEmpty(annotationDescriptor.getAttributes())) {
            return Collections.emptyMap();
        }
        ConcurrentHashMap valueMap = new ConcurrentHashMap();
        for (int i = 0; i < annotationDescriptor.getAttributes().size(); ++i) {
            AttributeDescriptor<?> attributeDescriptor = annotationDescriptor.getAttributes().get(i);
            ValueExtractor<AnnotationInstance, ?> extractor = attributeDescriptor.getTypeDescriptor().createJandexExtractor(buildingContext);
            Object attributeValue = extractor.extractValue(annotationInstance, attributeDescriptor, target, buildingContext);
            valueMap.put(attributeDescriptor.getName(), attributeValue);
        }
        return valueMap;
    }

    private AnnotationUsageBuilder() {
    }
}

