/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.jandex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.ValueWrapper;
import org.jboss.jandex.AnnotationValue;

public class ArrayValueWrapper<V>
implements ValueWrapper<List<V>, AnnotationValue> {
    private final ValueWrapper<V, AnnotationValue> elementWrapper;

    public ArrayValueWrapper(ValueWrapper<V, AnnotationValue> elementWrapper) {
        this.elementWrapper = elementWrapper;
    }

    @Override
    public List<V> wrap(AnnotationValue rawValue, AnnotationTarget target, SourceModelBuildingContext buildingContext) {
        assert (rawValue != null);
        List values = rawValue.asArrayList();
        assert (values != null);
        if (values.isEmpty()) {
            return Collections.emptyList();
        }
        if (values.size() == 1) {
            return Collections.singletonList(this.elementWrapper.wrap((AnnotationValue)values.get(0), target, buildingContext));
        }
        ArrayList results = new ArrayList(values.size());
        values.forEach(value -> results.add(this.elementWrapper.wrap((AnnotationValue)value, target, buildingContext)));
        return results;
    }
}

