/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.jdk;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.models.internal.AnnotationTargetSupport;
import org.hibernate.models.internal.jdk.AnnotationUsageBuilder;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.SourceModelBuildingContext;

public abstract class AbstractAnnotationTarget
implements AnnotationTargetSupport {
    private final Supplier<Annotation[]> annotationSupplier;
    private final SourceModelBuildingContext buildingContext;
    private Map<Class<? extends Annotation>, AnnotationUsage<?>> usagesMap;

    public AbstractAnnotationTarget(Supplier<Annotation[]> annotationSupplier, SourceModelBuildingContext buildingContext) {
        this.annotationSupplier = annotationSupplier;
        this.buildingContext = buildingContext;
    }

    @Override
    public SourceModelBuildingContext getBuildingContext() {
        return this.buildingContext;
    }

    @Override
    public Map<Class<? extends Annotation>, AnnotationUsage<? extends Annotation>> getUsageMap() {
        if (this.usagesMap == null) {
            this.usagesMap = this.buildUsagesMap();
        }
        return this.usagesMap;
    }

    private Map<Class<? extends Annotation>, AnnotationUsage<?>> buildUsagesMap() {
        HashMap result = new HashMap();
        AnnotationUsageBuilder.processAnnotations(this.annotationSupplier.get(), this, result::put, this.buildingContext);
        return result;
    }

    @Override
    public void clearAnnotationUsages() {
        this.getUsageMap().clear();
    }

    @Override
    public <X extends Annotation> void addAnnotationUsage(AnnotationUsage<X> annotationUsage) {
        this.getUsageMap().put(annotationUsage.getAnnotationType(), annotationUsage);
    }
}

