/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.jdk;

import java.lang.annotation.Annotation;
import java.util.EnumSet;
import java.util.List;
import org.hibernate.models.internal.AnnotationHelper;
import org.hibernate.models.internal.jdk.AbstractAnnotationTarget;
import org.hibernate.models.internal.jdk.JdkBuilders;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.AttributeDescriptor;
import org.hibernate.models.spi.SourceModelBuildingContext;

public class AnnotationDescriptorImpl<A extends Annotation>
extends AbstractAnnotationTarget
implements AnnotationDescriptor<A> {
    private final Class<A> annotationType;
    private final EnumSet<AnnotationTarget.Kind> allowableTargets;
    private final boolean inherited;
    private final AnnotationDescriptor<?> repeatableContainer;
    private final List<AttributeDescriptor<?>> attributeDescriptors;

    public AnnotationDescriptorImpl(Class<A> annotationType, SourceModelBuildingContext context) {
        this(annotationType, null, context);
    }

    public AnnotationDescriptorImpl(Class<A> annotationType, AnnotationDescriptor<?> repeatableContainer, SourceModelBuildingContext context) {
        super(annotationType::getAnnotations, context);
        this.annotationType = annotationType;
        this.repeatableContainer = repeatableContainer;
        this.inherited = AnnotationHelper.isInherited(annotationType);
        this.allowableTargets = AnnotationHelper.extractTargets(annotationType);
        this.attributeDescriptors = JdkBuilders.extractAttributeDescriptors(this, annotationType);
    }

    @Override
    public Class<A> getAnnotationType() {
        return this.annotationType;
    }

    @Override
    public EnumSet<AnnotationTarget.Kind> getAllowableTargets() {
        return this.allowableTargets;
    }

    @Override
    public boolean isInherited() {
        return this.inherited;
    }

    @Override
    public AnnotationDescriptor<?> getRepeatableContainer() {
        return this.repeatableContainer;
    }

    @Override
    public List<AttributeDescriptor<?>> getAttributes() {
        return this.attributeDescriptors;
    }

    @Override
    public String getName() {
        return this.annotationType.getName();
    }
}

