/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.jdk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.models.internal.util.CollectionHelper;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.ValueWrapper;

public class ArrayValueWrapper<V, R>
implements ValueWrapper<List<V>, R[]> {
    private final ValueWrapper<V, R> elementWrapper;

    public ArrayValueWrapper(ValueWrapper<V, R> elementWrapper) {
        this.elementWrapper = elementWrapper;
    }

    @Override
    public List<V> wrap(R[] rawValues, AnnotationTarget target, SourceModelBuildingContext buildingContext) {
        if (CollectionHelper.isEmpty(rawValues)) {
            return Collections.emptyList();
        }
        if (rawValues.length == 1) {
            return Collections.singletonList(this.elementWrapper.wrap(rawValues[0], target, buildingContext));
        }
        ArrayList<V> result = new ArrayList<V>(rawValues.length);
        for (int i = 0; i < rawValues.length; ++i) {
            result.add(this.elementWrapper.wrap(rawValues[i], target, buildingContext));
        }
        return result;
    }
}

