/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.jdk;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.models.internal.jdk.AnnotationUsageBuilder;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.SourceModelBuildingContext;

public class JdkAnnotationUsage<A extends Annotation>
implements MutableAnnotationUsage<A> {
    private final A annotation;
    private final AnnotationDescriptor<A> annotationDescriptor;
    private final AnnotationTarget location;
    private final Map<String, ?> valueMap;

    public JdkAnnotationUsage(A annotation, AnnotationDescriptor<A> annotationDescriptor, AnnotationTarget location, SourceModelBuildingContext buildingContext) {
        this.annotation = annotation;
        this.annotationDescriptor = annotationDescriptor;
        this.location = location;
        this.valueMap = AnnotationUsageBuilder.extractAttributeValues(annotation, annotationDescriptor, location, buildingContext);
    }

    @Override
    public AnnotationDescriptor<A> getAnnotationDescriptor() {
        return this.annotationDescriptor;
    }

    @Override
    public AnnotationTarget getAnnotationTarget() {
        return this.location;
    }

    @Override
    public A toAnnotation() {
        return this.annotation;
    }

    @Override
    public <W> W findAttributeValue(String name) {
        return (W)this.valueMap.get(name);
    }

    @Override
    public <V> V setAttributeValue(String name, V value) {
        this.annotationDescriptor.getAttribute(name);
        return (V)this.valueMap.put(name, value);
    }

    public String toString() {
        return "JdkAnnotationUsage(" + this.annotationDescriptor.getAnnotationType().getName() + ")";
    }
}

