/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.jdk;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.models.internal.ClassDetailsSupport;
import org.hibernate.models.internal.jdk.AbstractAnnotationTarget;
import org.hibernate.models.internal.jdk.JdkBuilders;
import org.hibernate.models.internal.jdk.JdkFieldDetails;
import org.hibernate.models.internal.jdk.JdkRecordComponentDetails;
import org.hibernate.models.internal.jdk.JdkTrackingTypeSwitcher;
import org.hibernate.models.internal.util.CollectionHelper;
import org.hibernate.models.internal.util.TypeHelper;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.RecordComponentDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableDetails;

public class JdkClassDetails
extends AbstractAnnotationTarget
implements ClassDetailsSupport {
    private final String name;
    private final Class<?> managedClass;
    private final ClassDetails superClass;
    private TypeDetails genericSuperType;
    private List<TypeDetails> interfaces;
    private List<TypeVariableDetails> typeParameters;
    private List<FieldDetails> fields;
    private List<MethodDetails> methods;
    private List<RecordComponentDetails> recordComponents;

    public JdkClassDetails(Class<?> managedClass, SourceModelBuildingContext buildingContext) {
        this(managedClass.getName(), managedClass, buildingContext);
    }

    public JdkClassDetails(String name, Class<?> managedClass, SourceModelBuildingContext buildingContext) {
        super(managedClass::getAnnotations, buildingContext);
        this.name = name;
        this.managedClass = managedClass;
        ClassDetailsRegistry classDetailsRegistry = buildingContext.getClassDetailsRegistry();
        Class<?> superclass = managedClass.getSuperclass();
        this.superClass = superclass == null ? null : classDetailsRegistry.resolveClassDetails(superclass.getName(), n -> JdkBuilders.buildClassDetailsStatic(superclass, buildingContext));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getClassName() {
        return this.managedClass.getName();
    }

    @Override
    public boolean isResolved() {
        return TypeHelper.isResolved(this.managedClass);
    }

    @Override
    public <X> Class<X> toJavaClass() {
        return this.managedClass;
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.managedClass.getModifiers());
    }

    @Override
    public boolean isRecord() {
        return this.managedClass.isRecord();
    }

    @Override
    public ClassDetails getSuperClass() {
        return this.superClass;
    }

    @Override
    public TypeDetails getGenericSuperType() {
        if (this.genericSuperType == null && this.managedClass.getGenericSuperclass() != null) {
            this.genericSuperType = new JdkTrackingTypeSwitcher(this.getBuildingContext()).switchType(this.managedClass.getGenericSuperclass());
        }
        return this.genericSuperType;
    }

    @Override
    public List<TypeDetails> getImplementedInterfaces() {
        if (this.interfaces == null) {
            this.interfaces = this.collectInterfaces();
        }
        return this.interfaces;
    }

    private List<TypeDetails> collectInterfaces() {
        Object[] jdkInterfaces = this.managedClass.getGenericInterfaces();
        if (CollectionHelper.isEmpty(jdkInterfaces)) {
            return Collections.emptyList();
        }
        ArrayList<TypeDetails> result = CollectionHelper.arrayList(jdkInterfaces.length);
        JdkTrackingTypeSwitcher typeSwitcher = new JdkTrackingTypeSwitcher(this.getBuildingContext());
        for (Object jdkInterface : jdkInterfaces) {
            TypeDetails switchedInterfaceType = typeSwitcher.switchType((Type)jdkInterface);
            result.add(switchedInterfaceType);
        }
        return result;
    }

    @Override
    public List<TypeVariableDetails> getTypeParameters() {
        if (this.typeParameters == null) {
            this.typeParameters = this.collectTypeParameters();
        }
        return this.typeParameters;
    }

    private List<TypeVariableDetails> collectTypeParameters() {
        Object[] jdkTypeParameters = this.managedClass.getTypeParameters();
        if (CollectionHelper.isEmpty(jdkTypeParameters)) {
            return Collections.emptyList();
        }
        ArrayList<TypeVariableDetails> result = CollectionHelper.arrayList(jdkTypeParameters.length);
        JdkTrackingTypeSwitcher typeSwitcher = new JdkTrackingTypeSwitcher(this.getBuildingContext());
        for (Object jdkTypeParameter : jdkTypeParameters) {
            result.add((TypeVariableDetails)typeSwitcher.switchType((Type)jdkTypeParameter));
        }
        return result;
    }

    @Override
    public boolean isImplementor(Class<?> checkType) {
        return checkType.isAssignableFrom(this.managedClass);
    }

    @Override
    public List<FieldDetails> getFields() {
        if (this.fields == null) {
            Field[] reflectionFields = this.managedClass.getDeclaredFields();
            this.fields = CollectionHelper.arrayList(reflectionFields.length);
            for (int i = 0; i < reflectionFields.length; ++i) {
                Field reflectionField = reflectionFields[i];
                this.fields.add(new JdkFieldDetails(reflectionField, this, this.getBuildingContext()));
            }
        }
        return this.fields;
    }

    @Override
    public void addField(FieldDetails fieldDetails) {
        this.getFields().add(fieldDetails);
    }

    @Override
    public List<MethodDetails> getMethods() {
        if (this.methods == null) {
            Method[] reflectionMethods = this.managedClass.getDeclaredMethods();
            this.methods = CollectionHelper.arrayList(reflectionMethods.length);
            for (int i = 0; i < reflectionMethods.length; ++i) {
                this.methods.add(JdkBuilders.buildMethodDetails(reflectionMethods[i], this, this.getBuildingContext()));
            }
        }
        return this.methods;
    }

    @Override
    public void addMethod(MethodDetails methodDetails) {
        this.getMethods().add(methodDetails);
    }

    @Override
    public List<RecordComponentDetails> getRecordComponents() {
        if (!this.isRecord()) {
            return Collections.emptyList();
        }
        if (this.recordComponents == null) {
            RecordComponent[] jdkRecordComponents = this.managedClass.getRecordComponents();
            this.recordComponents = CollectionHelper.arrayList(jdkRecordComponents.length);
            for (int i = 0; i < jdkRecordComponents.length; ++i) {
                this.recordComponents.add(new JdkRecordComponentDetails(jdkRecordComponents[i], this, this.getBuildingContext()));
            }
        }
        return this.recordComponents;
    }

    public String toString() {
        return "JdkClassDetails(" + this.name + ")";
    }
}

