/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.util;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

public class TypeHelper {
    public static boolean isResolved(Type type) {
        if (type instanceof Class) {
            return true;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return TypeHelper.isResolved(genericArrayType.getGenericComponentType());
        }
        if (type instanceof ParameterizedType) {
            Type[] typeArgs;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            for (Type arg : typeArgs = parameterizedType.getActualTypeArguments()) {
                if (TypeHelper.isResolved(arg)) continue;
                return false;
            }
            return TypeHelper.isResolved(parameterizedType.getRawType());
        }
        if (type instanceof TypeVariable) {
            return false;
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return TypeHelper.areResolved(wildcardType.getUpperBounds()) != false && TypeHelper.areResolved(wildcardType.getLowerBounds()) != false;
        }
        return false;
    }

    private static Boolean areResolved(Type[] types) {
        for (Type t : types) {
            if (TypeHelper.isResolved(t)) continue;
            return false;
        }
        return true;
    }
}

