/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.spi;

import java.lang.annotation.Annotation;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.models.UnknownAnnotationAttributeException;
import org.hibernate.models.internal.dynamic.DynamicAnnotationUsage;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.AttributeDescriptor;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.SourceModelBuildingContext;

public interface AnnotationDescriptor<A extends Annotation>
extends AnnotationTarget {
    @Override
    default public AnnotationTarget.Kind getKind() {
        return AnnotationTarget.Kind.ANNOTATION;
    }

    public Class<A> getAnnotationType();

    public EnumSet<AnnotationTarget.Kind> getAllowableTargets();

    public boolean isInherited();

    default public boolean isRepeatable() {
        return this.getRepeatableContainer() != null;
    }

    public AnnotationDescriptor<?> getRepeatableContainer();

    public List<AttributeDescriptor<?>> getAttributes();

    default public <V> AttributeDescriptor<V> findAttribute(String name) {
        List<AttributeDescriptor<?>> attributeDescriptors = this.getAttributes();
        for (AttributeDescriptor<?> attributeDescriptor : attributeDescriptors) {
            if (!attributeDescriptor.getName().equals(name)) continue;
            return attributeDescriptor;
        }
        return null;
    }

    default public <V> AttributeDescriptor<V> getAttribute(String name) {
        AttributeDescriptor<V> attribute = this.findAttribute(name);
        if (attribute != null) {
            return attribute;
        }
        throw new UnknownAnnotationAttributeException(this.getAnnotationType(), name);
    }

    default public MutableAnnotationUsage<A> createUsage(AnnotationTarget target, SourceModelBuildingContext context) {
        return this.createUsage(target, null, context);
    }

    default public MutableAnnotationUsage<A> createUsage(AnnotationTarget target, Consumer<MutableAnnotationUsage<A>> adjuster, SourceModelBuildingContext context) {
        DynamicAnnotationUsage usage = new DynamicAnnotationUsage(this, target, context);
        this.getAttributes().forEach(attr -> {
            Object value = attr.getTypeDescriptor().createValue((AttributeDescriptor<?>)attr, target, context);
            if (value != null) {
                usage.setAttributeValue(attr.getName(), value);
            }
        });
        if (adjuster != null) {
            adjuster.accept(usage);
        }
        return usage;
    }
}

