/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.spi;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.models.AnnotationAccessException;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationUsage;

public interface AnnotationTarget {
    public Kind getKind();

    public String getName();

    public Collection<AnnotationUsage<?>> getAllAnnotationUsages();

    default public void forAllAnnotationUsages(Consumer<AnnotationUsage<?>> consumer) {
        this.getAllAnnotationUsages().forEach(consumer);
    }

    public <A extends Annotation> boolean hasAnnotationUsage(Class<A> var1);

    public <A extends Annotation> boolean hasRepeatableAnnotationUsage(Class<A> var1);

    public <A extends Annotation> AnnotationUsage<A> getAnnotationUsage(AnnotationDescriptor<A> var1);

    public <A extends Annotation> AnnotationUsage<A> getAnnotationUsage(Class<A> var1);

    default public <A extends Annotation> AnnotationUsage<A> getSingleAnnotationUsage(AnnotationDescriptor<A> descriptor) {
        try {
            return this.getAnnotationUsage(descriptor);
        }
        catch (AnnotationAccessException ignore) {
            return null;
        }
    }

    default public <A extends Annotation> AnnotationUsage<A> getSingleAnnotationUsage(Class<A> type) {
        try {
            return this.getAnnotationUsage(type);
        }
        catch (AnnotationAccessException ignore) {
            return null;
        }
    }

    public <A extends Annotation> AnnotationUsage<A> locateAnnotationUsage(Class<A> var1);

    public <A extends Annotation> List<AnnotationUsage<A>> getRepeatedAnnotationUsages(AnnotationDescriptor<A> var1);

    public <A extends Annotation> List<AnnotationUsage<A>> getRepeatedAnnotationUsages(Class<A> var1);

    default public <X extends Annotation> void forEachAnnotationUsage(AnnotationDescriptor<X> type, Consumer<AnnotationUsage<X>> consumer) {
        List<AnnotationUsage<X>> annotations = this.getRepeatedAnnotationUsages(type);
        if (annotations == null) {
            return;
        }
        annotations.forEach(consumer);
    }

    public <X extends Annotation> void forEachAnnotationUsage(Class<X> var1, Consumer<AnnotationUsage<X>> var2);

    public <A extends Annotation> List<AnnotationUsage<? extends Annotation>> getMetaAnnotated(Class<A> var1);

    default public <X extends Annotation> AnnotationUsage<X> getNamedAnnotationUsage(AnnotationDescriptor<X> type, String matchName) {
        return this.getNamedAnnotationUsage(type, matchName, "name");
    }

    default public <X extends Annotation> AnnotationUsage<X> getNamedAnnotationUsage(Class<X> type, String matchName) {
        return this.getNamedAnnotationUsage(type, matchName, "name");
    }

    public <X extends Annotation> AnnotationUsage<X> getNamedAnnotationUsage(AnnotationDescriptor<X> var1, String var2, String var3);

    public <X extends Annotation> AnnotationUsage<X> getNamedAnnotationUsage(Class<X> var1, String var2, String var3);

    default public <T, A extends Annotation> T fromAnnotations(Class<A> annotationType, AnnotationUsageProcessor<T> processor) {
        List<AnnotationUsage<A>> annotationUsages = this.getRepeatedAnnotationUsages(annotationType);
        for (AnnotationUsage<A> annotationUsage : annotationUsages) {
            T result = processor.process(annotationUsage);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @FunctionalInterface
    public static interface AnnotationUsageProcessor<T> {
        public T process(AnnotationUsage<? extends Annotation> var1);
    }

    public static enum Kind {
        ANNOTATION(ElementType.ANNOTATION_TYPE),
        CLASS(ElementType.TYPE),
        FIELD(ElementType.FIELD),
        METHOD(ElementType.METHOD),
        RECORD_COMPONENT(ElementType.RECORD_COMPONENT),
        PACKAGE(ElementType.PACKAGE);

        private final ElementType elementType;

        private Kind(ElementType elementType) {
            this.elementType = elementType;
        }

        public ElementType getCorrespondingElementType() {
            return this.elementType;
        }

        public static EnumSet<Kind> from(Target target) {
            if (target == null) {
                return EnumSet.allOf(Kind.class);
            }
            return Kind.from(target.value());
        }

        public static EnumSet<Kind> from(ElementType[] elementTypes) {
            EnumSet<Kind> kinds = EnumSet.noneOf(Kind.class);
            Kind[] values = Kind.values();
            for (int i = 0; i < elementTypes.length; ++i) {
                for (int v = 0; v < values.length; ++v) {
                    if (!values[v].getCorrespondingElementType().equals((Object)elementTypes[i])) continue;
                    kinds.add(values[v]);
                }
            }
            return kinds;
        }

        public static Kind from(ElementType elementType) {
            Kind[] values = Kind.values();
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].getCorrespondingElementType().equals((Object)elementType)) continue;
                return values[i];
            }
            return null;
        }
    }
}

