/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.spi;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.AttributeDescriptor;
import org.hibernate.models.spi.ClassDetails;

public interface AnnotationUsage<A extends Annotation> {
    public AnnotationDescriptor<A> getAnnotationDescriptor();

    default public Class<A> getAnnotationType() {
        return this.getAnnotationDescriptor().getAnnotationType();
    }

    public AnnotationTarget getAnnotationTarget();

    public A toAnnotation();

    public <V> V findAttributeValue(String var1);

    default public <V> V getAttributeValue(String name) {
        V value = this.findAttributeValue(name);
        if (value == null) {
            this.getAnnotationDescriptor().getAttribute(name);
        }
        return value;
    }

    default public <V> V getAttributeValue(String name, V defaultValue) {
        V attributeValue = this.getAttributeValue(name);
        if (attributeValue == null) {
            return defaultValue;
        }
        return attributeValue;
    }

    default public <V> V getAttributeValue(String name, Supplier<V> defaultValueSupplier) {
        V attributeValue = this.getAttributeValue(name);
        if (attributeValue == null) {
            return defaultValueSupplier.get();
        }
        return attributeValue;
    }

    default public <V> V getAttributeValue(AttributeDescriptor<V> attributeDescriptor) {
        return this.getAttributeValue(attributeDescriptor.getName());
    }

    default public String getString(String name) {
        return (String)this.getAttributeValue(name);
    }

    default public String getString(String name, String defaultValue) {
        return this.getAttributeValue(name, defaultValue);
    }

    default public String getString(String name, Supplier<String> defaultValueSupplier) {
        return this.getAttributeValue(name, defaultValueSupplier);
    }

    default public Boolean getBoolean(String name) {
        return (Boolean)this.getAttributeValue(name);
    }

    default public Boolean getBoolean(String name, boolean defaultValue) {
        return this.getAttributeValue(name, defaultValue);
    }

    default public Boolean getBoolean(String name, Supplier<Boolean> defaultValueSupplier) {
        return this.getAttributeValue(name, defaultValueSupplier);
    }

    default public Byte getByte(String name) {
        return (Byte)this.getAttributeValue(name);
    }

    default public Byte getByte(String name, Byte defaultValue) {
        return this.getAttributeValue(name, defaultValue);
    }

    default public Byte getByte(String name, Supplier<Byte> defaultValueSupplier) {
        return this.getAttributeValue(name, defaultValueSupplier);
    }

    default public Short getShort(String name) {
        return (Short)this.getAttributeValue(name);
    }

    default public Short getShort(String name, Short defaultValue) {
        return this.getAttributeValue(name, defaultValue);
    }

    default public Short getShort(String name, Supplier<Short> defaultValueSupplier) {
        return this.getAttributeValue(name, defaultValueSupplier);
    }

    default public Integer getInteger(String name) {
        return (Integer)this.getAttributeValue(name);
    }

    default public Integer getInteger(String name, Integer defaultValue) {
        return this.getAttributeValue(name, defaultValue);
    }

    default public Integer getInteger(String name, Supplier<Integer> defaultValueSupplier) {
        return this.getAttributeValue(name, defaultValueSupplier);
    }

    default public Long getLong(String name) {
        return (Long)this.getAttributeValue(name);
    }

    default public Long getLong(String name, Long defaultValue) {
        return this.getAttributeValue(name, defaultValue);
    }

    default public Long getLong(String name, Supplier<Long> defaultValueSupplier) {
        return this.getAttributeValue(name, defaultValueSupplier);
    }

    default public Float getFloat(String name) {
        return (Float)this.getAttributeValue(name);
    }

    default public Float getFloat(String name, Float defaultValue) {
        return this.getAttributeValue(name, defaultValue);
    }

    default public Float getFloat(String name, Supplier<Float> defaultValueSupplier) {
        return this.getAttributeValue(name, defaultValueSupplier);
    }

    default public Double getDouble(String name) {
        return (Double)this.getAttributeValue(name);
    }

    default public Double getDouble(String name, Double defaultValue) {
        return this.getAttributeValue(name, defaultValue);
    }

    default public Double getDouble(String name, Supplier<Double> defaultValueSupplier) {
        return this.getAttributeValue(name, defaultValueSupplier);
    }

    default public <E extends Enum<E>> E getEnum(String name) {
        return (E)((Enum)this.getAttributeValue(name));
    }

    default public <E extends Enum<E>> E getEnum(String name, Class<E> type) {
        return (E)((Enum)this.getAttributeValue(name));
    }

    default public <E extends Enum<E>> E getEnum(String name, E defaultValue) {
        return this.getAttributeValue(name, defaultValue);
    }

    default public <E extends Enum<E>> E getEnum(String name, Supplier<E> defaultValueSupplier) {
        return (E)((Enum)this.getAttributeValue(name, defaultValueSupplier));
    }

    default public <E extends Enum<E>> E getEnum(String name, E defaultValue, Class<E> type) {
        return this.getAttributeValue(name, defaultValue);
    }

    default public <E extends Enum<E>> E getEnum(String name, Supplier<E> defaultValueSupplier, Class<E> type) {
        return (E)((Enum)this.getAttributeValue(name, defaultValueSupplier));
    }

    default public ClassDetails getClassDetails(String name) {
        return (ClassDetails)this.getAttributeValue(name);
    }

    default public ClassDetails getClassDetails(String name, ClassDetails defaultValue) {
        return this.getAttributeValue(name, defaultValue);
    }

    default public ClassDetails getClassDetails(String name, Supplier<ClassDetails> defaultValue) {
        return this.getAttributeValue(name, defaultValue);
    }

    default public <X extends Annotation> AnnotationUsage<X> getNestedUsage(String name) {
        return (AnnotationUsage)this.getAttributeValue(name);
    }

    default public <X extends Annotation> AnnotationUsage<X> getNestedUsage(String name, AnnotationUsage<X> defaultValue) {
        return this.getAttributeValue(name, defaultValue);
    }

    default public <X extends Annotation> AnnotationUsage<X> getNestedUsage(String name, Supplier<AnnotationUsage<X>> defaultValueSupplier) {
        return this.getAttributeValue(name, defaultValueSupplier);
    }

    default public <E> List<E> getList(String name) {
        return (List)this.getAttributeValue(name);
    }

    default public <E> List<E> getList(String name, List<E> defaultValue) {
        return this.getAttributeValue(name, defaultValue);
    }

    default public <E> List<E> getList(String name, Supplier<List<E>> defaultValueSupplier) {
        return this.getAttributeValue(name, defaultValueSupplier);
    }
}

